/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView;

import java.util.Hashtable;
import javax.swing.JFrame;
import oracle.dss.dataView.Dataview;
import oracle.dss.dataView.Footnote;
import oracle.dss.dataView.Subtitle;
import oracle.dss.dataView.Title;
import oracle.dss.dataView.ViewPrinter;
import oracle.dss.gridView.GridView;
import oracle.dss.gridView.GridViewTable;
import oracle.dss.util.EdgeOutOfRangeException;

public abstract class GridViewPrinter
extends ViewPrinter {
    protected GridViewTable gridViewTable = null;
    protected GridView gridView = null;
    protected JFrame tempFrame;
    protected boolean repeatHeaders = true;
    protected Hashtable hashTable = null;
    protected Hashtable m_rowHeightsCache = null;
    protected Hashtable m_colWidthsCache = null;
    protected int[] m_rowHeights = null;
    protected int[] m_colWidths = null;
    protected boolean[] m_dirtyRowHeights = null;
    protected boolean[] m_dirtyColWidths = null;
    protected boolean m_bUpdateRowHeightsCache = false;
    protected boolean m_bUpdateColWidthsCache = false;

    public GridViewPrinter(GridView gv) {
        super((Dataview)gv);
        this.gridView = gv;
        this.gridViewTable = gv.getGridViewTable();
    }

    public boolean setLogicalPage(int[] hPos) {
        if (!super.setLogicalPage(hPos)) {
            return false;
        }
        this.initCache();
        return true;
    }

    public void setScaleFontSize(int mask) {
    }

    public int getScaleFontSize() {
        return 0;
    }

    protected void setDataview(Dataview dv) {
        super.setDataview(dv);
        if (dv instanceof GridView) {
            this.title = (Title)this.dataView.getDataviewTitle();
            this.subtitle = (Subtitle)this.dataView.getDataviewSubtitle();
            this.footnote = (Footnote)this.dataView.getDataviewFootnote();
        }
    }

    protected void updateCache() {
        if (this.m_bPreviewMode && this.m_bUpdateRowHeightsCache) {
            this.m_rowHeightsCache.put(new Integer(this.viewLogPageNum), this.m_rowHeights);
            this.m_bUpdateRowHeightsCache = false;
        }
        if (this.m_bPreviewMode && this.m_bUpdateColWidthsCache) {
            this.m_colWidthsCache.put(new Integer(this.viewLogPageNum), this.m_colWidths);
            this.m_bUpdateColWidthsCache = false;
        }
    }

    protected void initCache() {
        if (this.m_bPreviewMode) {
            this.initRowHeightsCache(this.viewLogPageNum);
            this.initColumnWidthsCache(this.viewLogPageNum);
        } else {
            int numRows = 0;
            try {
                numRows = this.gridView.getModel().getDataAccess().getEdgeExtent(1);
            }
            catch (EdgeOutOfRangeException eoore) {
                this.gridView.getErrorHandler().error((Throwable)eoore, ((Object)((Object)this)).getClass().getName(), "initCache");
            }
            this.m_rowHeights = new int[numRows];
            this.m_dirtyRowHeights = new boolean[numRows];
            for (int i = 0; i < numRows; ++i) {
                this.m_rowHeights[i] = -1;
                this.m_dirtyRowHeights[i] = true;
            }
            int numCols = 0;
            try {
                numCols = this.gridView.getModel().getDataAccess().getEdgeExtent(0);
            }
            catch (EdgeOutOfRangeException eoore) {
                this.gridView.getErrorHandler().error((Throwable)eoore, ((Object)((Object)this)).getClass().getName(), "initCache");
            }
            this.m_colWidths = new int[numCols];
            this.m_dirtyColWidths = new boolean[numCols];
            for (int i = 0; i < numCols; ++i) {
                this.m_colWidths[i] = -1;
                this.m_dirtyColWidths[i] = true;
            }
        }
    }

    protected void initRowHeightsCache(int logPageNum) {
        int i;
        Integer page = new Integer(logPageNum);
        if (this.m_rowHeightsCache == null) {
            this.m_rowHeightsCache = new Hashtable();
        }
        int numRows = 0;
        try {
            numRows = this.gridView.getModel().getDataAccess().getEdgeExtent(1);
        }
        catch (EdgeOutOfRangeException eoore) {
            this.gridView.getErrorHandler().error((Throwable)eoore, ((Object)((Object)this)).getClass().getName(), "initRowHeightsCache");
        }
        this.m_dirtyRowHeights = new boolean[numRows];
        for (i = 0; i < numRows; ++i) {
            this.m_dirtyRowHeights[i] = true;
        }
        if (this.m_rowHeightsCache.containsKey(page)) {
            this.m_rowHeights = (int[])this.m_rowHeightsCache.get(page);
        } else {
            this.m_rowHeights = new int[numRows];
            for (i = 0; i < numRows; ++i) {
                this.m_rowHeights[i] = -1;
            }
            this.m_bUpdateRowHeightsCache = true;
        }
    }

    protected void initColumnWidthsCache(int logPageNum) {
        int i;
        Integer page = new Integer(logPageNum);
        if (this.m_colWidthsCache == null) {
            this.m_colWidthsCache = new Hashtable();
        }
        int numCols = 0;
        try {
            numCols = this.gridView.getModel().getDataAccess().getEdgeExtent(0);
        }
        catch (EdgeOutOfRangeException eoore) {
            this.gridView.getErrorHandler().error((Throwable)eoore, ((Object)((Object)this)).getClass().getName(), "initColumnWidthsCache");
        }
        this.m_dirtyColWidths = new boolean[numCols];
        for (i = 0; i < numCols; ++i) {
            this.m_dirtyColWidths[i] = true;
        }
        if (this.m_colWidthsCache.containsKey(page)) {
            this.m_colWidths = (int[])this.m_colWidthsCache.get(page);
        } else {
            this.m_colWidths = new int[numCols];
            for (i = 0; i < numCols; ++i) {
                this.m_colWidths[i] = -1;
            }
            this.m_bUpdateColWidthsCache = true;
        }
    }

    protected int getLastRowToFetch(int firstRowOnPage, int lastRowOnPage) {
        int firstRowToFetch = firstRowOnPage;
        int numRowsOnPage = lastRowOnPage - (firstRowOnPage - 1);
        int numRowsToFetch = Math.max((int)((double)numRowsOnPage * 1.5), numRowsOnPage + 5);
        try {
            int rowCount = this.gridView.getModel().getDataAccess().getEdgeExtent(1);
            if (firstRowOnPage + numRowsToFetch > rowCount) {
                numRowsToFetch = rowCount - firstRowOnPage;
            }
        }
        catch (EdgeOutOfRangeException eoore) {
            this.gridView.getErrorHandler().error((Throwable)eoore, ((Object)((Object)this)).getClass().getName(), "fetchRowsOnPage");
            return -1;
        }
        int lastRowToFetch = firstRowOnPage + numRowsToFetch - 1;
        return lastRowToFetch;
    }

    protected void resetCurrentLogicalPage() {
        int i;
        this.resizeGridView();
        this.gridView.validate();
        for (i = 0; i < this.m_dirtyRowHeights.length; ++i) {
            this.m_dirtyRowHeights[i] = true;
        }
        for (i = 0; i < this.m_dirtyColWidths.length; ++i) {
            this.m_dirtyColWidths[i] = true;
        }
        this.fetchRowBlock(this.record.firstRow, this.record.lastRow);
        this.resizeColumnWidths(0, this.record.lastColumn, -1, -1);
        this.resizeRowHeights(-1, -1, 0, this.record.lastRow);
    }

    protected abstract void resizeGridView();

    protected abstract boolean resizeRowHeights(int var1, int var2, int var3, int var4);

    protected abstract boolean resizeColumnWidths(int var1, int var2, int var3, int var4);
}

