/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.dss.gridView.GridView;
import oracle.dss.gridView.GridViewAppearanceMgr;

public class GridViewDatabodyInputHandler
extends CellInputHandler {
    private GridView _gridView = null;
    private Cursor gridCursor = null;
    private static final String m_method_mousepressed = "mousePressed(MouseEvent e, Grid grid, int column, int row)";
    private static final String m_method_mousemoved = "mouseMoved(MouseEvent e, Grid grid, int column, int row)";

    public GridViewDatabodyInputHandler(GridView gv) {
        this._gridView = gv;
    }

    public void mousePressed(MouseEvent e, Grid grid, int column, int row) {
        TwoDSelection selection;
        if (column < 0) {
            this._gridView.getErrorHandler().log("invalid column index", ((Object)((Object)this)).getClass().getName(), m_method_mousepressed);
            return;
        }
        if (row < 0) {
            this._gridView.getErrorHandler().log("invalid row index", ((Object)((Object)this)).getClass().getName(), m_method_mousepressed);
            return;
        }
        if (SwingUtilities.isLeftMouseButton(e)) {
            int imageIndex;
            int type;
            if (this._gridView.getDatabody().isDrillOut(column, row, e.getX(), e.getY())) {
                type = 1;
                imageIndex = ((GridViewAppearanceMgr)grid.getAppearanceManager()).getCellAppearance(column, row).getGraphicImageIndex();
                this._gridView.getGridViewModel().getGridViewControllerActions().databodyDrillOutGestureHappened(this._gridView, column, row, type, imageIndex);
            } else if (this._gridView.getDatabody().isAnnotation(column, row, e.getX(), e.getY())) {
                type = 2;
                imageIndex = -1;
                this._gridView.getGridViewModel().getGridViewControllerActions().databodyDrillOutGestureHappened(this._gridView, column, row, type, imageIndex);
            }
        }
        if (SwingUtilities.isRightMouseButton(e) && !(selection = grid.getSelection()).containsCell(column, row)) {
            grid.requestFocus();
            try {
                grid.deselectAll();
                TwoDSelection sel = new TwoDSelection(column, row);
                grid.setSelection(sel);
                grid.setFocusCell(new Cell(column, row));
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        super.mousePressed(e, grid, column, row);
    }

    public void mouseMoved(MouseEvent e, Grid grid, int column, int row) {
        if (column < 0) {
            this._gridView.getErrorHandler().log("invalid column index", ((Object)((Object)this)).getClass().getName(), m_method_mousemoved);
            return;
        }
        if (row < 0) {
            this._gridView.getErrorHandler().log("invalid row index", ((Object)((Object)this)).getClass().getName(), m_method_mousemoved);
            return;
        }
        Cursor drillCursor = this._gridView.getGridViewController().getCursorType(13);
        Cursor defaultCursor = this._gridView.getGridViewController().getCursorType(0);
        if (this._gridView.getDatabody().isDrillOut(column, row, e.getX(), e.getY()) || this._gridView.getDatabody().isAnnotation(column, row, e.getX(), e.getY())) {
            if (grid.getCursor() != drillCursor) {
                this.gridCursor = grid.getCursor();
                grid.setCursor(drillCursor);
            }
        } else if (grid.getCursor() == drillCursor) {
            if (this.gridCursor != null) {
                grid.setCursor(this.gridCursor);
            } else {
                grid.setCursor(defaultCursor);
            }
        }
        super.mouseMoved(e, grid, column, row);
    }
}

