/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.DataviewTitles;
import oracle.dss.dataView.FontAttribute;
import oracle.dss.dataView.GraphAttribute;
import oracle.dss.dataView.GridViewAttribute;
import oracle.dss.dataView.UIView;
import oracle.dss.dataView.gui.DataviewTool;
import oracle.dss.dataView.gui.DataviewToolbarRollover;
import oracle.dss.dataView.gui.ToolBar;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.formattedTextArea.UIFormattedTextView;
import oracle.dss.pagingControl.PageItemComponentHandle;

public class FontSizeTool
extends JToolBar
implements DataviewToolbarRollover,
DataviewTool,
ActionListener {
    public static final String PROPERTY_FONT_SIZE = "FontSize";
    protected Object m_selectedObject = null;
    protected boolean m_flag = true;
    protected ComponentHandle m_selectedComponentHandle = null;
    protected UIView m_currentDataview = null;
    protected ToolBar m_toolBar = null;
    JComboBox m_fontSize = null;
    private static final Insets insets0 = new Insets(0, 0, 0, 0);
    private Object[] _SIZES = new Object[]{new Integer(8), new Integer(9), new Integer(10), new Integer(11), new Integer(12), new Integer(14), new Integer(16), new Integer(18), new Integer(20), new Integer(22), new Integer(24), new Integer(26), new Integer(28), new Integer(36), new Integer(48), new Integer(72)};
    private ResourceBundle rBundle = null;
    private boolean m_bSuperCalled = true;
    private NumberEditor ne;
    protected boolean m_bRolloverIconEnabled = false;

    public FontSizeTool() {
        this.m_fontSize = new JComboBox();
        this.ne = new NumberEditor();
        this.ne.setMaximum(512);
        this.m_fontSize.setEditor(this.ne);
        for (int i = 0; i < 16; ++i) {
            this.m_fontSize.addItem(this._SIZES[i]);
        }
        this.m_fontSize.setEnabled(false);
        this.m_fontSize.setEditable(true);
        int height = this.m_fontSize.getPreferredSize().height;
        this.m_fontSize.setMinimumSize(new Dimension(45, height));
        this.m_fontSize.setMaximumSize(new Dimension(45, height));
        this.m_fontSize.setPreferredSize(new Dimension(45, height));
        this.m_fontSize.addActionListener(this);
        this.setMinimumSize(new Dimension(50, height));
        this.setMaximumSize(new Dimension(50, height));
        this.setPreferredSize(new Dimension(50, height));
        this.add(this.m_fontSize);
        this.setBorder(null);
        this.updateResourceBundle(Locale.getDefault());
        this.m_fontSize.setToolTipText(this.rBundle.getString(PROPERTY_FONT_SIZE));
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle(loc);
        this.m_fontSize.setToolTipText(this.rBundle.getString(PROPERTY_FONT_SIZE));
    }

    public void setDefaultSize(int size) {
        this.m_fontSize.setSelectedItem(new Integer(size));
    }

    @Override
    public void selectedAction(ControllerEvent e, UIView currentDataView, ToolBar toolBar) {
        if (currentDataView == null) {
            return;
        }
        this.m_currentDataview = currentDataView;
        this.m_toolBar = toolBar;
        if (e == null) {
            return;
        }
        if (e.getComponentHandle() == null || this.m_currentDataview instanceof GraphAttribute && e.getComponentHandle().getComponent() == null) {
            this.m_selectedObject = null;
            this.m_selectedComponentHandle = e.getComponentHandle();
            this.m_fontSize.setEnabled(false);
            return;
        }
        this.m_flag = false;
        Object selectedObject = e.getComponentHandle().getComponent();
        if (this.isEnabled(e.getComponentHandle())) {
            this.m_selectedObject = selectedObject;
            this.m_selectedComponentHandle = e.getComponentHandle();
            this.m_fontSize.setEnabled(true);
            int size = this.getFontSize();
            this.m_fontSize.setSelectedItem(new Integer(size));
        } else {
            this.m_fontSize.setEnabled(false);
            this.m_selectedObject = null;
            this.m_selectedComponentHandle = null;
        }
        this.m_flag = true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object selected;
        if (!this.m_flag) {
            return;
        }
        if (e == null) {
            return;
        }
        if (e.getSource() == this.m_fontSize && (selected = this.m_fontSize.getSelectedItem()) instanceof Number) {
            this.setFontSize(((Number)selected).intValue());
        }
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
    }

    @Override
    public void update() {
    }

    @Override
    public void cleanUp() {
        this.m_fontSize.removeAllItems();
        this.m_fontSize = null;
        this.ne = null;
    }

    @Override
    public void setRolloverIconEnabled(boolean bEnabled) {
        this.m_bRolloverIconEnabled = bEnabled;
    }

    @Override
    public boolean isRolloverIconEnabled() {
        return this.m_bRolloverIconEnabled;
    }

    private boolean isEnabled(ComponentHandle selectedComponentHandle) {
        if (this.m_currentDataview instanceof GridViewAttribute && ((GridViewAttribute)this.m_currentDataview).getComponentViewStyle(selectedComponentHandle) != null) {
            return true;
        }
        if (this.m_currentDataview instanceof GraphAttribute && selectedComponentHandle instanceof PageItemComponentHandle && ((GraphAttribute)this.m_currentDataview).getComponentViewStyle(selectedComponentHandle) != null) {
            return true;
        }
        if (selectedComponentHandle.getComponent() instanceof FontAttribute) {
            return true;
        }
        if (selectedComponentHandle.getComponent() instanceof UIFormattedTextView) {
            return ((UIFormattedTextView)selectedComponentHandle.getComponent()).isEditable();
        }
        return false;
    }

    private int getFontSize() {
        ViewStyle viewStyle;
        UIFormattedTextView view;
        if (this.m_selectedObject instanceof UIFormattedTextView && (view = (UIFormattedTextView)this.m_selectedObject).isEditable() && !view.isCurrentAttributeChanging()) {
            return view.getFontSize();
        }
        if (this.m_selectedComponentHandle != null && (this.m_selectedComponentHandle.getID() == 6 || this.m_selectedComponentHandle.getID() == 7 || this.m_selectedComponentHandle.getID() == 8)) {
            return ((DataviewTitles)this.m_selectedObject).getFont().getSize();
        }
        if (this.m_currentDataview instanceof GridViewAttribute) {
            viewStyle = ((GridViewAttribute)this.m_currentDataview).getComponentViewStyle(this.m_selectedComponentHandle);
            return viewStyle.getFontSize();
        }
        if (this.m_currentDataview instanceof GraphAttribute && this.m_selectedComponentHandle instanceof PageItemComponentHandle && ((GraphAttribute)this.m_currentDataview).getComponentViewStyle(this.m_selectedComponentHandle) != null) {
            viewStyle = ((GraphAttribute)this.m_currentDataview).getComponentViewStyle(this.m_selectedComponentHandle);
            return viewStyle.getFontSize();
        }
        if (this.m_selectedObject instanceof FontAttribute) {
            return ((FontAttribute)this.m_selectedObject).getFont().getSize();
        }
        return 0;
    }

    private void setFontSize(int size) {
        int oldSize = this.getFontSize();
        if (this.m_selectedComponentHandle != null && (this.m_selectedComponentHandle.getID() == 6 || this.m_selectedComponentHandle.getID() == 7 || this.m_selectedComponentHandle.getID() == 8)) {
            Font f = ((DataviewTitles)this.m_selectedObject).getFont();
            ((DataviewTitles)this.m_selectedObject).setFont(new Font(f.getName(), f.getStyle(), size));
        } else if (this.m_currentDataview instanceof GridViewAttribute) {
            ViewStyle viewStyle = new ViewStyle();
            viewStyle.setFontSize(size);
            ((GridViewAttribute)this.m_currentDataview).applyViewStyle(this.m_selectedComponentHandle, viewStyle);
            if (!this.m_toolBar.hideAlertInFuture() && !((GridViewAttribute)this.m_currentDataview).compareComponentViewStyle(this.m_selectedComponentHandle, viewStyle)) {
                this.m_toolBar.displayFormatAlert();
            }
        } else if (this.m_currentDataview instanceof GraphAttribute && this.m_selectedComponentHandle instanceof PageItemComponentHandle && ((GraphAttribute)this.m_currentDataview).getComponentViewStyle(this.m_selectedComponentHandle) != null) {
            ViewStyle viewStyle = new ViewStyle();
            viewStyle.setFontSize(size);
            ((GraphAttribute)this.m_currentDataview).applyViewStyle(this.m_selectedComponentHandle, viewStyle);
        } else if (this.m_selectedObject instanceof FontAttribute) {
            Font f = ((FontAttribute)this.m_selectedObject).getFont();
            ((FontAttribute)this.m_selectedObject).setFont(new Font(f.getName(), f.getStyle(), size));
        } else if (this.m_selectedObject instanceof UIFormattedTextView) {
            ((UIFormattedTextView)this.m_selectedObject).setFontSize(size);
        } else {
            return;
        }
        this.firePropertyChange(PROPERTY_FONT_SIZE, oldSize, size);
    }

    class NumberEditor
    extends NumberTextField
    implements ComboBoxEditor {
        private int _maximumValue;

        public NumberEditor() {
            this.setBorder(null);
            this.setSigned(false);
            this.setDecimal(false);
        }

        public void setBorder(Border b) {
        }

        @Override
        public Component getEditorComponent() {
            return this;
        }

        @Override
        public void setItem(Object anObject) {
            String text = anObject == null ? null : anObject.toString();
            this.setText(text);
        }

        @Override
        public Object getItem() {
            return this.getNumber();
        }

        @Override
        public void selectAll() {
            super.selectAll();
            this.requestFocus();
        }

        public void setMaximum(int value) {
            this._maximumValue = value;
        }

        @Override
        public void addActionListener(ActionListener l) {
            super.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            super.removeActionListener(l);
        }

        protected boolean validateNumber(Number n) {
            return n.intValue() <= this._maximumValue;
        }
    }
}

