/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.crosstab;

import java.util.Enumeration;
import java.util.Vector;
import oracle.dss.crosstab.CrosstabAttributes;
import oracle.dss.crosstab.CrosstabDefaultValues;
import oracle.dss.crosstab.Total;
import oracle.dss.crosstab.managers.CrosstabRuleSizing;
import oracle.dss.dataView.BaseTitleAttributes;
import oracle.dss.gridView.GridViewCommon;
import oracle.dss.gridView.GridViewDatabodyAttributes;
import oracle.dss.gridView.GridViewHeaderAttributes;
import oracle.dss.gridView.GridViewXML;
import oracle.dss.gridView.UIFormat;
import oracle.dss.gridView.managers.GridViewDatabodyRuleStyles;
import oracle.dss.gridView.managers.GridViewHeaderRuleStyles;
import oracle.dss.gridView.managers.GridViewRuleFormatter;
import oracle.dss.pagingControl.PagingControlAttributes;
import oracle.dss.util.xml.BaseNode;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.NoSuchPropertyException;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class CrosstabXML
extends GridViewXML {
    public static final String ROWTOTAL_NAME = "RowTotal";
    public static final String COLUMNTOTAL_NAME = "ColumnTotal";
    public static final String m_version = "3.2.0.21";
    public static final String a_autoIndent = "autoIndent";
    public static final String a_bodyHighlighterVisible = "bodyHighlighterVisible";
    protected static final String a_columnHeaderGridVisible = "columnHeaderGridVisible";
    public static final String a_columnHighlighterVisible = "columnHighlighterVisible";
    public static final String a_cornerComponentColor = "cornerComponentColor";
    public static final String a_highlighterSize = "highlighterSize";
    public static final String a_indentEnabled = "indentEnabled";
    protected static final String a_measurePivotLabelTextDisplayed = "measurePivotLabelTextDisplayed";
    public static final String a_outline = "outline";
    public static final String a_pivotLabelVisible = "pivotLabelVisible";
    public static final String a_reorderType = "reorderType";
    protected static final String a_rowHeaderGridVisible = "rowHeaderGridVisible";
    public static final String a_rowHighlighterVisible = "rowHighlighterVisible";
    public static final String a_swapMembersAllowed = "swapMembersAllowed";
    public static final String a_manualRowHeaderColumnSizingEnabled = "manualRowHeaderColumnSizingEnabled";
    public static final String a_manualColumnHeaderRowSizingEnabled = "manualColumnHeaderRowSizingEnabled";
    protected int d_autoIndent;
    protected boolean d_bodyHighlighterVisible;
    protected boolean d_columnHeaderGridVisible;
    protected boolean d_columnHighlighterVisible;
    protected int d_highlighterSize;
    protected boolean d_indentEnabled;
    protected boolean d_measurePivotLabelTextDisplayed;
    protected boolean d_outline;
    protected boolean d_pivotLabelVisible;
    protected int d_reorderType;
    protected boolean d_rowHeaderGridVisible;
    protected boolean d_rowHighlighterVisible;
    protected boolean d_swapMembersAllowed;
    protected boolean d_manualRowHeaderColumnSizingEnabled;
    protected boolean d_manualColumnHeaderRowSizingEnabled;
    public static final String no_reorder = "NO_REORDER";
    public static final String reorder_measure_dimension = "REORDER_MEASURE_DIMENSION";
    public static final String reorder_all_dimensions = "REORDER_ALL_DIMENSIONS";
    private CrosstabAttributes _crosstab;

    public CrosstabXML(CrosstabAttributes crosstab) {
        super(crosstab);
        this._crosstab = crosstab;
        this.initDefaults(new CrosstabDefaultValues());
    }

    protected void initDefaults(CrosstabDefaultValues cdv) {
        super.initDefaults(cdv);
        this.d_autoIndent = cdv.getAutoIndent();
        this.d_bodyHighlighterVisible = cdv.isBodyHighlighterVisible();
        this.d_columnHeaderGridVisible = cdv.isColumnHeaderGridVisible();
        this.d_columnHighlighterVisible = cdv.isColumnHighlighterVisible();
        this.d_highlighterSize = cdv.getHighlighterSize();
        this.d_indentEnabled = cdv.isIndentEnabled();
        this.d_measurePivotLabelTextDisplayed = cdv.isMeasurePivotLabelTextDisplayed();
        this.d_outline = cdv.isOutline();
        this.d_pivotLabelVisible = cdv.isPivotLabelVisible();
        this.d_reorderType = cdv.getReorderType();
        this.d_rowHeaderGridVisible = cdv.isRowHeaderGridVisible();
        this.d_rowHighlighterVisible = cdv.isRowHighlighterVisible();
        this.d_swapMembersAllowed = cdv.isSwapMembersAllowed();
        this.d_manualRowHeaderColumnSizingEnabled = cdv.isManualRowHeaderColumnSizingEnabled();
        this.d_manualColumnHeaderRowSizingEnabled = cdv.isManualColumnHeaderRowSizingEnabled();
    }

    public void setXML(ObjectNode node, int reset) {
        ObjectNode viewFormatNode;
        ContainerNode UIFormatsNode;
        ObjectNode sizingRules;
        ObjectNode rowTotal;
        ObjectNode rowHeader;
        ContainerNode headerRuleStyles;
        ContainerNode graphicImagesPaths;
        ContainerNode ruleFormat;
        ContainerNode drillImagesPaths;
        ObjectNode title;
        ObjectNode subtitle;
        ObjectNode footnote;
        ContainerNode databodyRuleStyles;
        ObjectNode databody;
        ObjectNode columnTotal;
        ObjectNode columnHeader;
        super.setXML(node);
        PropertyNode pNode = node.getProperty("version");
        String version = m_version;
        if (pNode != null) {
            version = pNode.getValueAsString();
        }
        if ((pNode = node.getProperty(a_manualRowHeaderColumnSizingEnabled)) != null) {
            this._crosstab.setManualRowHeaderColumnSizingEnabled(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_manualColumnHeaderRowSizingEnabled)) != null) {
            this._crosstab.setManualColumnHeaderRowSizingEnabled(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_autoIndent)) != null) {
            this._crosstab.setAutoIndent(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty(a_bodyHighlighterVisible)) != null) {
            this._crosstab.setBodyHighlighterVisible(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_columnHeaderGridVisible)) != null) {
            this._crosstab.setColumnHeaderGridVisible(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_columnHighlighterVisible)) != null) {
            this._crosstab.setColumnHighlighterVisible(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_highlighterSize)) != null) {
            this._crosstab.setHighlighterSize(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty(a_indentEnabled)) != null) {
            this._crosstab.setIndentEnabled(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_measurePivotLabelTextDisplayed)) != null) {
            this._crosstab.setMeasurePivotLabelTextDisplayed(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_outline)) != null) {
            this._crosstab.setOutline(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_pivotLabelVisible)) != null) {
            this._crosstab.setPivotLabelVisible(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_reorderType)) != null) {
            String tmp = pNode.getValueAsString();
            if (tmp.equals(no_reorder)) {
                this._crosstab.setReorderType(0);
            } else if (tmp.equals(reorder_measure_dimension)) {
                this._crosstab.setReorderType(1);
            } else if (tmp.equals(reorder_all_dimensions)) {
                this._crosstab.setReorderType(2);
            }
        }
        if ((pNode = node.getProperty(a_rowHeaderGridVisible)) != null) {
            this._crosstab.setRowHeaderGridVisible(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_rowHighlighterVisible)) != null) {
            this._crosstab.setRowHighlighterVisible(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_swapMembersAllowed)) != null) {
            this._crosstab.setSwapMembersAllowed(pNode.getValueAsBoolean());
        }
        if ((columnHeader = node.getPropertyValueAsObjectNode("ColumnHeader", true)) != null) {
            ((GridViewHeaderAttributes)this._crosstab.getComponentFromID(10)).setXML(columnHeader, version, reset);
        }
        if ((columnTotal = node.getPropertyValueAsObjectNode(COLUMNTOTAL_NAME, true)) != null && columnTotal.getPropertyValueAsObjectNode("Total", true) != null) {
            Total total = new Total();
            total.setXML(columnTotal.getPropertyValueAsObjectNode("Total", true));
            this._crosstab.setTotal(0, total);
        }
        if ((databody = node.getPropertyValueAsObjectNode("Databody", true)) != null) {
            ((GridViewDatabodyAttributes)this._crosstab.getComponentFromID(9)).setXML(databody, version, reset);
        }
        if ((databodyRuleStyles = node.getContainer("DatabodyStyleManager")) != null) {
            if (this._crosstab.getGridViewDatabodyStyleManager() == null) {
                this._crosstab.setGridViewDatabodyStyleManager(new GridViewDatabodyRuleStyles());
            }
            if (this._crosstab.getGridViewDatabodyStyleManager() instanceof GridViewDatabodyRuleStyles) {
                ((GridViewDatabodyRuleStyles)this._crosstab.getGridViewDatabodyStyleManager()).setContext(this.m_context);
                ((GridViewDatabodyRuleStyles)this._crosstab.getGridViewDatabodyStyleManager()).setXML(databodyRuleStyles, (GridViewCommon)((Object)this._crosstab), version, reset);
            }
        }
        if ((footnote = node.getPropertyValueAsObjectNode("DataviewFootnote", true)) != null) {
            ((BaseTitleAttributes)this._crosstab.getComponentFromID(8)).setXML(footnote, version, reset);
        }
        if ((subtitle = node.getPropertyValueAsObjectNode("DataviewSubtitle", true)) != null) {
            ((BaseTitleAttributes)this._crosstab.getComponentFromID(7)).setXML(subtitle, version, reset);
        }
        if ((title = node.getPropertyValueAsObjectNode("DataviewTitle", true)) != null) {
            ((BaseTitleAttributes)this._crosstab.getComponentFromID(6)).setXML(title, version, reset);
        }
        if ((drillImagesPaths = node.getContainer("DrillImagesPaths")) != null) {
            Enumeration e = drillImagesPaths.getContainedObject("ImagePath");
            while (e.hasMoreElements()) {
                ObjectNode imagePathNode = (ObjectNode)e.nextElement();
                PropertyNode indexNode = imagePathNode.getProperty("index");
                PropertyNode pathNode = imagePathNode.getProperty("path");
                String path = pathNode.getValueAsString();
                if (path == null || path.length() <= 0) continue;
                int index = indexNode.getValueAsInteger();
                this._crosstab.setDrillImagePath(index, path);
            }
        }
        if ((ruleFormat = node.getContainer("FormatManager")) != null) {
            if (this._crosstab.getGridViewFormatManager() == null) {
                this._crosstab.setGridViewFormatManager(new GridViewRuleFormatter());
            }
            if (this._crosstab.getGridViewFormatManager() instanceof GridViewRuleFormatter) {
                ((GridViewRuleFormatter)this._crosstab.getGridViewFormatManager()).setContext(this.m_context);
                ((GridViewRuleFormatter)this._crosstab.getGridViewFormatManager()).setXML(ruleFormat, (GridViewCommon)((Object)this._crosstab), version, reset);
            }
        }
        if ((graphicImagesPaths = node.getContainer("GraphicImagesPaths")) != null) {
            Enumeration e = graphicImagesPaths.getContainedObject("ImagePath");
            while (e.hasMoreElements()) {
                ObjectNode imagePathNode = (ObjectNode)e.nextElement();
                PropertyNode indexNode = imagePathNode.getProperty("index");
                PropertyNode pathNode = imagePathNode.getProperty("path");
                String path = pathNode.getValueAsString();
                if (path == null || path.length() <= 0) continue;
                int index = indexNode.getValueAsInteger();
                this._crosstab.setGraphicImagePath(index, path);
            }
        }
        if ((headerRuleStyles = node.getContainer("HeaderStyleManager")) != null) {
            if (this._crosstab.getGridViewHeaderStyleManager() == null) {
                this._crosstab.setGridViewHeaderStyleManager(new GridViewHeaderRuleStyles());
            }
            if (this._crosstab.getGridViewHeaderStyleManager() instanceof GridViewHeaderRuleStyles) {
                ((GridViewHeaderRuleStyles)this._crosstab.getGridViewHeaderStyleManager()).setContext(this.m_context);
                ((GridViewHeaderRuleStyles)this._crosstab.getGridViewHeaderStyleManager()).setXML(headerRuleStyles, (GridViewCommon)((Object)this._crosstab), version, reset);
            }
        }
        try {
            String invisibleColumn = node.getPropertyValueAsString("InvisibleColumns");
            this._crosstab.setRowOrColumnVisible(true, invisibleColumn);
            String invisibleRow = node.getPropertyValueAsString("InvisibleRows");
            this._crosstab.setRowOrColumnVisible(false, invisibleRow);
        }
        catch (NoSuchPropertyException invisibleColumn) {
            // empty catch block
        }
        ObjectNode pagingControl = node.getPropertyValueAsObjectNode("PageHeader", true);
        if (pagingControl != null) {
            ((PagingControlAttributes)this._crosstab.getComponentFromID(5)).setObjectNode(pagingControl, version, reset);
        }
        if ((rowHeader = node.getPropertyValueAsObjectNode("RowHeader", true)) != null) {
            ((GridViewHeaderAttributes)this._crosstab.getComponentFromID(11)).setXML(rowHeader, version, reset);
        }
        if ((rowTotal = node.getPropertyValueAsObjectNode(ROWTOTAL_NAME, true)) != null && rowTotal.getPropertyValueAsObjectNode("Total", true) != null) {
            Total total = new Total();
            total.setXML(rowTotal.getPropertyValueAsObjectNode("Total", true));
            this._crosstab.setTotal(1, total);
        }
        if ((sizingRules = node.getPropertyValueAsObjectNode("SizingManager", true)) != null) {
            if (this._crosstab.getCrosstabSizingManager() == null) {
                this._crosstab.setCrosstabSizingManager(new CrosstabRuleSizing((GridViewCommon)((Object)this._crosstab)));
            }
            if (this._crosstab.getCrosstabSizingManager() instanceof CrosstabRuleSizing) {
                ((CrosstabRuleSizing)this._crosstab.getCrosstabSizingManager()).setContext(this.m_context);
                ((CrosstabRuleSizing)this._crosstab.getCrosstabSizingManager()).setXML(sizingRules);
            }
        }
        if ((pNode = node.getProperty("formatCount")) != null) {
            this._crosstab.setUIFormatCount(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty("toolbarFormatCount")) != null) {
            this._crosstab.setToolbarUIFormatCount(pNode.getValueAsInteger());
        }
        if ((UIFormatsNode = node.getContainer("UIFormats")) != null) {
            Enumeration e = UIFormatsNode.getContainedObject();
            Vector<UIFormat> formats = new Vector<UIFormat>();
            while (e.hasMoreElements()) {
                ObjectNode objectNode = (ObjectNode)e.nextElement();
                UIFormat format = new UIFormat();
                format.setContext(this.m_context);
                format.setXML(objectNode);
                formats.addElement(format);
            }
            this._crosstab.setUIFormats(formats);
            if (this._crosstab instanceof GridViewCommon && ((GridViewCommon)((Object)this._crosstab)).getFormatModel() != null) {
                ((GridViewCommon)((Object)this._crosstab)).getFormatModel().setUIFormats(false);
            }
        }
        if (this._crosstab.getViewFormat() != null && (viewFormatNode = node.getPropertyValueAsObjectNode("ViewFormat", true)) != null) {
            this._crosstab.getViewFormat().setXML(viewFormatNode, version, reset);
        }
    }

    public ObjectNode getObjectNode(boolean allProperties) {
        ObjectNode viewFormatNode;
        ObjectNode rowTotal;
        ObjectNode rowHeaderNode;
        ObjectNode pagingControl;
        int ival;
        String tmp;
        int size;
        ObjectNode titleNode;
        ObjectNode subtitleNode;
        ObjectNode footnoteNode;
        Object ruleManager;
        ObjectNode crosstabDataBodyNode;
        ObjectNode columnTotal;
        ObjectNode columnHeaderNode;
        ObjectNode node = new ObjectNode("Crosstab");
        node.addProperty("version", m_version);
        super.getObjectNode(node, allProperties);
        if (allProperties || this._crosstab.isManualRowHeaderColumnSizingEnabled() != this.d_manualRowHeaderColumnSizingEnabled) {
            node.addProperty(a_manualRowHeaderColumnSizingEnabled, this._crosstab.isManualRowHeaderColumnSizingEnabled());
        }
        if (allProperties || this._crosstab.isManualColumnHeaderRowSizingEnabled() != this.d_manualColumnHeaderRowSizingEnabled) {
            node.addProperty(a_manualColumnHeaderRowSizingEnabled, this._crosstab.isManualColumnHeaderRowSizingEnabled());
        }
        if (allProperties || this._crosstab.getAutoIndent() != this.d_autoIndent) {
            node.addProperty(a_autoIndent, this._crosstab.getAutoIndent());
        }
        if (allProperties || this._crosstab.isBodyHighlighterVisible() != this.d_bodyHighlighterVisible) {
            node.addProperty(a_bodyHighlighterVisible, this._crosstab.isBodyHighlighterVisible());
        }
        if (allProperties || this._crosstab.isColumnHeaderGridVisible() != this.d_columnHeaderGridVisible) {
            node.addProperty(a_columnHeaderGridVisible, this._crosstab.isColumnHeaderGridVisible());
        }
        if (allProperties || this._crosstab.isColumnHighlighterVisible() != this.d_columnHighlighterVisible) {
            node.addProperty(a_columnHighlighterVisible, this._crosstab.isColumnHighlighterVisible());
        }
        if (allProperties || this._crosstab.getHighlighterSize() != this.d_highlighterSize) {
            node.addProperty(a_highlighterSize, this._crosstab.getHighlighterSize());
        }
        if (allProperties || this._crosstab.isIndentEnabled() != this.d_indentEnabled) {
            node.addProperty(a_indentEnabled, this._crosstab.isIndentEnabled());
        }
        if (allProperties || this._crosstab.isMeasurePivotLabelTextDisplayed() != this.d_measurePivotLabelTextDisplayed) {
            node.addProperty(a_measurePivotLabelTextDisplayed, this._crosstab.isMeasurePivotLabelTextDisplayed());
        }
        if (allProperties || this._crosstab.isOutline() != this.d_outline) {
            node.addProperty(a_outline, this._crosstab.isOutline());
        }
        if (allProperties || this._crosstab.isPivotLabelVisible() != this.d_pivotLabelVisible) {
            node.addProperty(a_pivotLabelVisible, this._crosstab.isPivotLabelVisible());
        }
        if (allProperties || this._crosstab.getReorderType() != this.d_reorderType) {
            int tmp2 = this._crosstab.getReorderType();
            if (tmp2 == 0) {
                node.addProperty(a_reorderType, no_reorder);
            } else if (tmp2 == 1) {
                node.addProperty(a_reorderType, reorder_measure_dimension);
            } else if (tmp2 == 2) {
                node.addProperty(a_reorderType, reorder_all_dimensions);
            }
        }
        if (allProperties || this._crosstab.isRowHeaderGridVisible() != this.d_rowHeaderGridVisible) {
            node.addProperty(a_rowHeaderGridVisible, this._crosstab.isRowHeaderGridVisible());
        }
        if (allProperties || this._crosstab.isRowHighlighterVisible() != this.d_rowHighlighterVisible) {
            node.addProperty(a_rowHighlighterVisible, this._crosstab.isRowHighlighterVisible());
        }
        if (allProperties || this._crosstab.isSwapMembersAllowed() != this.d_swapMembersAllowed) {
            node.addProperty(a_swapMembersAllowed, this._crosstab.isSwapMembersAllowed());
        }
        if ((columnHeaderNode = ((GridViewHeaderAttributes)this._crosstab.getComponentFromID(10)).getXML(allProperties)) != null) {
            node.addProperty(columnHeaderNode);
        }
        if ((columnTotal = this.getColumnTotalXML(allProperties)) != null) {
            node.addProperty(columnTotal);
        }
        if ((crosstabDataBodyNode = ((GridViewDatabodyAttributes)this._crosstab.getComponentFromID(9)).getXML(allProperties)) != null) {
            node.addProperty(crosstabDataBodyNode);
        }
        if ((ruleManager = this._crosstab.getGridViewDatabodyStyleManager()) != null && ruleManager instanceof GridViewDatabodyRuleStyles) {
            ((GridViewDatabodyRuleStyles)ruleManager).setContext(this.m_context);
            ObjectNode styleManagerNode = ((GridViewDatabodyRuleStyles)ruleManager).getXML(allProperties, (GridViewCommon)((Object)this._crosstab));
            if (styleManagerNode != null) {
                node.addProperty(styleManagerNode);
            }
        }
        if ((footnoteNode = ((BaseTitleAttributes)this._crosstab.getComponentFromID(8)).getXML(allProperties)) != null) {
            node.addProperty(footnoteNode);
        }
        if ((subtitleNode = ((BaseTitleAttributes)this._crosstab.getComponentFromID(7)).getXML(allProperties)) != null) {
            node.addProperty(subtitleNode);
        }
        if ((titleNode = ((BaseTitleAttributes)this._crosstab.getComponentFromID(6)).getXML(allProperties)) != null) {
            node.addProperty(titleNode);
        }
        ContainerNode drillImagesPathsNode = new ContainerNode("DrillImagesPaths");
        boolean bDrillImagesPathsNodeExists = false;
        int drillImageCount = this._crosstab.getDrillImageCount();
        for (int i = 1; i < drillImageCount; ++i) {
            String path;
            ObjectNode imagePathNode = new ObjectNode("ImagePath");
            if (imagePathNode == null || (path = this._crosstab.getDrillImagePath(i)) == null || path.length() <= 0) continue;
            imagePathNode.addProperty("index", i);
            imagePathNode.addProperty("path", path);
            bDrillImagesPathsNodeExists = true;
            drillImagesPathsNode.addContainedObject((BaseNode)imagePathNode);
        }
        if (bDrillImagesPathsNodeExists) {
            node.addContainer(drillImagesPathsNode);
        }
        if ((ruleManager = this._crosstab.getGridViewFormatManager()) != null && ruleManager instanceof GridViewRuleFormatter) {
            ((GridViewRuleFormatter)ruleManager).setContext(this.m_context);
            ObjectNode formatManagerNode = ((GridViewRuleFormatter)ruleManager).getXML(allProperties, (GridViewCommon)((Object)this._crosstab));
            if (formatManagerNode != null) {
                node.addProperty(formatManagerNode);
            }
        }
        ContainerNode graphicImagesPathsNode = new ContainerNode("GraphicImagesPaths");
        boolean bGraphicImagesPathsNodeExists = false;
        int graphicImageCount = this._crosstab.getGraphicImageCount();
        for (int i = 0; i < graphicImageCount; ++i) {
            String path;
            ObjectNode imagePathNode = new ObjectNode("ImagePath");
            if (imagePathNode == null || (path = this._crosstab.getGraphicImagePath(i)) == null || path.length() <= 0) continue;
            imagePathNode.addProperty("index", i);
            imagePathNode.addProperty("path", path);
            bGraphicImagesPathsNodeExists = true;
            graphicImagesPathsNode.addContainedObject((BaseNode)imagePathNode);
        }
        if (bGraphicImagesPathsNodeExists) {
            node.addContainer(graphicImagesPathsNode);
        }
        if ((ruleManager = this._crosstab.getGridViewHeaderStyleManager()) != null && ruleManager instanceof GridViewHeaderRuleStyles) {
            ((GridViewHeaderRuleStyles)ruleManager).setContext(this.m_context);
            ObjectNode styleManagerNode = ((GridViewHeaderRuleStyles)ruleManager).getXML(allProperties, (GridViewCommon)((Object)this._crosstab));
            if (styleManagerNode != null) {
                node.addProperty(styleManagerNode);
            }
        }
        int n = size = this._crosstab.getInvisibleColumn() == null ? 0 : this._crosstab.getInvisibleColumn().size();
        if (size > 0) {
            tmp = "";
            for (int j = 0; j < size; ++j) {
                ival = (Integer)this._crosstab.getInvisibleColumn().elementAt(j);
                tmp = tmp == "" ? tmp + ival : tmp + " " + ival;
            }
            node.addProperty("InvisibleColumns", tmp, false);
        }
        int n2 = size = this._crosstab.getInvisibleRow() == null ? 0 : this._crosstab.getInvisibleRow().size();
        if (size > 0) {
            tmp = "";
            for (int j = 0; j < size; ++j) {
                ival = (Integer)this._crosstab.getInvisibleRow().elementAt(j);
                tmp = tmp == "" ? tmp + ival : tmp + " " + ival;
            }
            node.addProperty("InvisibleRows", tmp, false);
        }
        if ((pagingControl = ((PagingControlAttributes)this._crosstab.getComponentFromID(5)).getObjectNode(allProperties)) != null) {
            node.addProperty(pagingControl);
        }
        if ((rowHeaderNode = ((GridViewHeaderAttributes)this._crosstab.getComponentFromID(11)).getXML(allProperties)) != null) {
            node.addProperty(rowHeaderNode);
        }
        if ((rowTotal = this.getRowTotalXML(allProperties)) != null) {
            node.addProperty(rowTotal);
        }
        if ((ruleManager = this._crosstab.getCrosstabSizingManager()) != null && ruleManager instanceof CrosstabRuleSizing) {
            ((CrosstabRuleSizing)ruleManager).setContext(this.m_context);
            ObjectNode sizingManagerNode = ((CrosstabRuleSizing)ruleManager).getXML(allProperties);
            if (sizingManagerNode != null) {
                node.addProperty(sizingManagerNode);
            }
        }
        if (this._crosstab.getUIFormatCount() != this.d_formatCount) {
            node.addProperty("formatCount", this._crosstab.getUIFormatCount());
        }
        if (this._crosstab.getToolbarUIFormatCount() != this.d_toolbarFormatCount) {
            node.addProperty("toolbarFormatCount", this._crosstab.getToolbarUIFormatCount());
        }
        if (this._crosstab.getUIFormats() != null) {
            ContainerNode UIFormatsNode = new ContainerNode("UIFormats");
            int formatCount = this._crosstab.getUIFormats().size();
            for (int i = 0; i < formatCount; ++i) {
                UIFormat format = (UIFormat)this._crosstab.getUIFormats().elementAt(i);
                format.setContext(this.m_context);
                ObjectNode formatNode = format.getObjectNode(false);
                if (formatNode == null) continue;
                UIFormatsNode.addContainedObject((BaseNode)formatNode);
            }
            node.addContainer(UIFormatsNode);
        }
        if (this._crosstab.getViewFormat() != null && (viewFormatNode = this._crosstab.getViewFormat().getXML(allProperties)) != null) {
            node.addProperty(viewFormatNode);
        }
        return node;
    }

    protected ObjectNode getRowTotalXML(boolean allProperties) {
        ObjectNode node = new ObjectNode(ROWTOTAL_NAME);
        boolean nodeExists = false;
        if ((allProperties || this._crosstab.getTotal(1) != null) && this._crosstab.getTotal(1).getXML(allProperties) != null) {
            node.addProperty(this._crosstab.getTotal(1).getXML(allProperties));
            nodeExists = true;
        }
        if (nodeExists) {
            return node;
        }
        return null;
    }

    protected ObjectNode getColumnTotalXML(boolean allProperties) {
        ObjectNode node = new ObjectNode(COLUMNTOTAL_NAME);
        boolean nodeExists = false;
        if ((allProperties || this._crosstab.getTotal(0) != null) && this._crosstab.getTotal(0).getXML(allProperties) != null) {
            node.addProperty(this._crosstab.getTotal(0).getXML(allProperties));
            nodeExists = true;
        }
        if (nodeExists) {
            return node;
        }
        return null;
    }

    public void resetCrosstabXML(int reset) {
        if (reset == 1 || reset == 2) {
            this.initDefaults(new CrosstabDefaultValues());
        }
        this._crosstab.setManualRowHeaderColumnSizingEnabled(this.d_manualRowHeaderColumnSizingEnabled);
        this._crosstab.setManualColumnHeaderRowSizingEnabled(this.d_manualColumnHeaderRowSizingEnabled);
        this._crosstab.setAutoIndent(this.d_autoIndent);
        this._crosstab.setBodyHighlighterVisible(this.d_bodyHighlighterVisible);
        this._crosstab.setColumnHeaderGridVisible(this.d_columnHeaderGridVisible);
        this._crosstab.setColumnHighlighterVisible(this.d_columnHighlighterVisible);
        this._crosstab.setHighlighterSize(this.d_highlighterSize);
        this._crosstab.setIndentEnabled(this.d_indentEnabled);
        this._crosstab.setMeasurePivotLabelTextDisplayed(this.d_measurePivotLabelTextDisplayed);
        this._crosstab.setOutline(this.d_outline);
        this._crosstab.setPivotLabelVisible(this.d_pivotLabelVisible);
        this._crosstab.setReorderType(this.d_reorderType);
        this._crosstab.setRowHeaderGridVisible(this.d_rowHeaderGridVisible);
        this._crosstab.setRowHighlighterVisible(this.d_rowHighlighterVisible);
        this._crosstab.setSwapMembersAllowed(this.d_swapMembersAllowed);
        this._crosstab.setZoomFactor(this.d_zoomFactor);
    }
}

