/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.crosstab;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.util.EventListener;
import javax.swing.JTextPane;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridToolTipManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderToolTipManager;
import oracle.bali.ewt.pivot.CollapseEvent;
import oracle.bali.ewt.pivot.CollapseListener;
import oracle.bali.ewt.pivot.DrillEvent;
import oracle.bali.ewt.pivot.DrillListener;
import oracle.bali.ewt.pivot.PageItem;
import oracle.bali.ewt.pivot.PagingPivotEvent;
import oracle.bali.ewt.pivot.PagingPivotListener;
import oracle.bali.ewt.pivot.PivotEvent;
import oracle.bali.ewt.pivot.PivotGrid;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotHeaderEvent;
import oracle.bali.ewt.pivot.PivotHeaderResListener;
import oracle.bali.ewt.pivot.PivotListener;
import oracle.bali.ewt.pivot.PivotTableSelection;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.CellRange;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.table.TableEvent;
import oracle.bali.ewt.util.WindowUtils;
import oracle.dss.crosstab.ColPivotHeader;
import oracle.dss.crosstab.Crosstab;
import oracle.dss.crosstab.CrosstabController;
import oracle.dss.crosstab.CrosstabDatabody;
import oracle.dss.crosstab.CrosstabPivotHeader;
import oracle.dss.crosstab.CrosstabPivotTable;
import oracle.dss.crosstab.CrosstabSizingManager;
import oracle.dss.crosstab.CrosstabTips;
import oracle.dss.crosstab.CrosstabUtils;
import oracle.dss.crosstab.RowPivotHeader;
import oracle.dss.crosstab.managers.CrosstabRuleSizing;
import oracle.dss.dataView.BaseTitle;
import oracle.dss.dataView.ColumnComponentHandle;
import oracle.dss.dataView.ColumnRangeComponentHandle;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.dataView.EdgeComponentHandle;
import oracle.dss.dataView.NonDataComponentHandle;
import oracle.dss.dataView.RowComponentHandle;
import oracle.dss.dataView.RowRangeComponentHandle;
import oracle.dss.dataView.ViewComponent;
import oracle.dss.gridView.GridViewControllerAdapter;
import oracle.dss.pagingControl.PageItemComponentHandle;
import oracle.dss.pagingControl.PagingComponent;
import oracle.dss.util.ColumnComponentInfo;
import oracle.dss.util.DataException;
import oracle.dss.util.EdgeComponentInfo;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.RowComponentInfo;
import oracle.dss.util.SliceOutOfRangeException;

public class CrosstabControllerAdapter
extends GridViewControllerAdapter
implements CrosstabController,
CollapseListener,
DrillListener,
PivotListener,
PivotHeaderResListener,
PagingPivotListener {
    private static final boolean DEBUG = false;
    private static final String m_method__getDepth_DrillEvent = "int _getDepth(DrillEvent e)";
    private static final String m_method__getDepth_CollapseEvent = "int _getDepth(CollapseEvent e)";
    protected CrosstabSizingManager crosstabSizingManager = null;
    private Crosstab crosstab = null;
    private int whichclick = 1;

    public CrosstabControllerAdapter(Crosstab v) {
        super(v);
        this.crosstab = v;
        CrosstabPivotTable pt = this.crosstab.getPivotTable();
        pt.addDrillListener(this);
        pt.addCollapseListener(this);
        pt.addPivotListener(this);
        pt.addPivotHeaderResListener(this);
        pt.getCrosstabDatabody().getGrid().addFocusListener((FocusListener)((Object)this));
        pt.getPivotGrid().addMouseMotionListener((MouseMotionListener)((Object)this));
        pt.getPivotGrid().getGrid().addMouseMotionListener((MouseMotionListener)((Object)this));
        pt.getPivotGrid().getColumnHeader().addMouseMotionListener((MouseMotionListener)((Object)this));
        pt.getPivotGrid().getRowHeader().addMouseMotionListener((MouseMotionListener)((Object)this));
        pt.getPivotGrid().getCornerComponent("UPPER_LEFT_CORNER").addMouseMotionListener((MouseMotionListener)((Object)this));
        this.crosstab.getCrosstabRowHeader().getGrid().addMouseMotionListener((MouseMotionListener)((Object)this));
        this.crosstab.getCrosstabColumnHeader().getGrid().addMouseMotionListener((MouseMotionListener)((Object)this));
        this.crosstab.getCrosstabRowHeader().getColumnHeader().addMouseMotionListener((MouseMotionListener)((Object)this));
        this.crosstab.getCrosstabColumnHeader().getRowHeader().addMouseMotionListener((MouseMotionListener)((Object)this));
        pt.getPivotGrid().addMouseListener((MouseListener)((Object)this));
        pt.getPivotGrid().getGrid().addMouseListener((MouseListener)((Object)this));
        pt.getPivotGrid().getColumnHeader().addMouseListener((MouseListener)((Object)this));
        pt.getPivotGrid().getRowHeader().addMouseListener((MouseListener)((Object)this));
        pt.getPivotGrid().getCornerComponent("UPPER_LEFT_CORNER").addMouseListener((MouseListener)((Object)this));
        this.crosstab.getCrosstabRowHeader().getGrid().addMouseListener((MouseListener)((Object)this));
        this.crosstab.getCrosstabColumnHeader().getGrid().addMouseListener((MouseListener)((Object)this));
        this.crosstab.getCrosstabRowHeader().getColumnHeader().addMouseListener((MouseListener)((Object)this));
        this.crosstab.getCrosstabColumnHeader().getRowHeader().addMouseListener((MouseListener)((Object)this));
        pt.getPivotGrid().addKeyListener((KeyListener)((Object)this));
        pt.getPivotGrid().getGrid().addKeyListener((KeyListener)((Object)this));
        pt.getPivotGrid().getColumnHeader().addKeyListener((KeyListener)((Object)this));
        pt.getPivotGrid().getRowHeader().addKeyListener((KeyListener)((Object)this));
        pt.getPivotGrid().getCornerComponent("UPPER_LEFT_CORNER").addKeyListener((KeyListener)((Object)this));
        this.crosstab.getCrosstabRowHeader().getGrid().addKeyListener((KeyListener)((Object)this));
        this.crosstab.getCrosstabColumnHeader().getGrid().addKeyListener((KeyListener)((Object)this));
        this.crosstab.getCrosstabRowHeader().getColumnHeader().addKeyListener((KeyListener)((Object)this));
        this.crosstab.getCrosstabColumnHeader().getRowHeader().addKeyListener((KeyListener)((Object)this));
        this.setCrosstabSizingManager(new CrosstabRuleSizing(this.crosstab));
        this.crosstab.getPagingControl().getPagingComponent().addPivotListener((PagingPivotListener)this);
        this.crosstab.getCrosstabDatabody().getGrid().setToolTipManager((GridToolTipManager)new CrosstabTips(this.crosstab, this, 12));
        this.crosstab.getCrosstabRowHeader().getGrid().setToolTipManager((GridToolTipManager)new CrosstabTips(this.crosstab, this, 11));
        this.crosstab.getCrosstabColumnHeader().getGrid().setToolTipManager((GridToolTipManager)new CrosstabTips(this.crosstab, this, 10));
        this.crosstab.getCrosstabDatabody().getRowHeader().setToolTipManager((HeaderToolTipManager)new CrosstabTips(this.crosstab, this, 22));
        this.crosstab.getCrosstabDatabody().getColumnHeader().setToolTipManager((HeaderToolTipManager)new CrosstabTips(this.crosstab, this, 23));
        this.crosstab.getCrosstabRowHeader().getColumnHeader().setToolTipManager((HeaderToolTipManager)new CrosstabTips(this.crosstab, this, 24));
        this.crosstab.getCrosstabColumnHeader().getRowHeader().setToolTipManager((HeaderToolTipManager)new CrosstabTips(this.crosstab, this, 25));
    }

    public void collapse(CollapseEvent e) {
        int edge = this._getEdge(e);
        int layer = this._getDepth(e);
        int slice = this._getIndex(e);
        this._drillRequesting(edge, layer, slice, e.getOrientation(), e.getPivotHeader(), e.getColumn(), e.getRow());
    }

    public void headerCellDrillRequest(DrillEvent e) {
        int edge = this._getEdge(e);
        int layer = this._getDepth(e);
        int slice = this._getIndex(e);
        this._drillRequesting(edge, layer, slice, e.getOrientation(), e.getPivotHeader(), e.getColumn(), e.getRow());
    }

    private void _drillRequesting(int edge, int layer, int slice, int orientation, PivotHeader pivotHeader, int column, int row) {
        int componentID;
        this.m_bDrill = true;
        OneDSelection selection = null;
        if (orientation == 1) {
            selection = this.crosstab.getPivotTable().getSelection().getRowSelection().getColumnSelection();
            componentID = 11;
        } else {
            selection = this.crosstab.getPivotTable().getSelection().getColumnSelection().getRowSelection();
            componentID = 10;
        }
        if (!selection.contains(layer)) {
            ColumnComponentInfo cci;
            ColumnComponentHandle handle;
            if (slice != -2) {
                EdgeComponentInfo eci = new EdgeComponentInfo(edge, layer, slice);
                EdgeComponentHandle handle2 = new EdgeComponentHandle(componentID, this.crosstab.getNameFromID(componentID), (Object)pivotHeader, eci);
                if (this.fireComponentSelecting(this.crosstab, (ComponentHandle)handle2)) {
                    CrosstabUtils.selectCell(eci, edge, pivotHeader.getGrid(), this.crosstab);
                    pivotHeader.getGrid().setFocusCell(new Cell(column, row));
                    this.setSelectedObject((ComponentHandle)handle2, true);
                }
            } else if (componentID == 10) {
                RowComponentInfo rci = new RowComponentInfo(layer);
                RowComponentHandle handle3 = new RowComponentHandle(25, "ColumnGrabber", (Object)this.crosstab, rci);
                if (this.fireComponentSelecting(this.crosstab, (ComponentHandle)handle3)) {
                    selection = new OneDSelection(layer);
                    TwoDSelection colSelection = new TwoDSelection(OneDSelection.getEmptySelection(), selection);
                    PivotTableSelection pts = new PivotTableSelection(colSelection, TwoDSelection.getEmptySelection(), TwoDSelection.getEmptySelection());
                    try {
                        this.crosstab.getPivotTable().setSelection(pts);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    this.setSelectedObject((ComponentHandle)handle3, true);
                }
            } else if (componentID == 11 && this.fireComponentSelecting(this.crosstab, (ComponentHandle)(handle = new ColumnComponentHandle(24, "RowGrabber", (Object)this.crosstab, cci = new ColumnComponentInfo(layer))))) {
                selection = new OneDSelection(layer);
                TwoDSelection rowSelection = new TwoDSelection(selection, OneDSelection.getEmptySelection());
                PivotTableSelection pts = new PivotTableSelection(TwoDSelection.getEmptySelection(), rowSelection, TwoDSelection.getEmptySelection());
                try {
                    this.crosstab.getPivotTable().setSelection(pts);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                this.setSelectedObject((ComponentHandle)handle, true);
            }
        } else if (slice != -2) {
            pivotHeader.getGrid().setFocusCell(new Cell(column, row));
        } else if (componentID == 10) {
            pivotHeader.getRowHeader().setFocusItem(layer);
        } else if (componentID == 11) {
            pivotHeader.getColumnHeader().setFocusItem(layer);
        }
        if (!this.crosstab.getCrosstabModel().isDrillingEnabled() || !this.crosstab.isEnabled()) {
            return;
        }
        if (slice != -2) {
            if (this.crosstab.isMetadataDrillSupported()) {
                try {
                    int drillState = (Integer)this.crosstab.getCrosstabModel().getDataAccess().getMemberMetadata(edge, layer, slice, "drillState");
                    if (this.crosstab.getCrosstabModel().getControllerActions().canDrill((Object)this.crosstab, edge, layer, slice, 0)) {
                        this.crosstab.getPivotTable().fireDrillEvent(orientation, column, row, new Integer(drillState));
                    }
                }
                catch (DataException exception) {
                    this.crosstab.getErrorHandler().error((Throwable)exception, this.getClass().getName(), "_drillRequesting");
                }
            }
        } else {
            try {
                if (this.crosstab.getCrosstabModel().getControllerActions().canDrill((Object)this.crosstab, edge, layer, slice, 0)) {
                    this.crosstab.getCrosstabModel().getControllerActions().drillGestureHappened((Object)this.crosstab, edge, layer, slice, 0);
                }
            }
            catch (DataException de) {
                this.crosstab.getErrorHandler().log("could not drill on layer", this.getClass().getName(), "_drillRequesting");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pivot(PivotEvent e) {
        try {
            int sourceIndex = e.getSourceIndex();
            int destinationIndex = e.getDestinationIndex();
            if (this._getDestEdge(e) == this._getSourceEdge(e) && sourceIndex >= 500 && destinationIndex >= 500) {
                if (sourceIndex < destinationIndex) {
                    ++destinationIndex;
                }
                this.reorderDimensions(e);
            } else {
                if (e.getSourceIndex() >= 500) {
                    sourceIndex = this._getSourceEdge(e) == 1 ? this.crosstab.getPivotTable().getReorderCol() : this.crosstab.getPivotTable().getReorderRow();
                    if (this._getSourceEdge(e) == this._getDestEdge(e)) {
                        if (sourceIndex < destinationIndex) {
                            --destinationIndex;
                        }
                        if (sourceIndex == destinationIndex) {
                            return;
                        }
                    }
                }
                int toEdge = this._getDestEdge(e);
                int toDepth = destinationIndex;
                int flags = 0;
                if (e.getDestinationPivotHeader() == e.getSourcePivotHeader()) {
                    flags = destinationIndex > sourceIndex ? 3 : 2;
                } else {
                    int layerCount = this.crosstab.getCrosstabModel().getDataAccess().getLayerCount(toEdge);
                    if (destinationIndex == 0 && layerCount == 0) {
                        flags = 4;
                    } else if (destinationIndex >= layerCount) {
                        --toDepth;
                        flags = 3;
                    } else {
                        flags = 2;
                    }
                }
                this.setCursor(WindowUtils.getWindow((Component)((Object)this.crosstab)), this.getCursorType(2));
                if (this.crosstab.getCrosstabModel().getControllerActions().canPivot((Object)this.crosstab, this._getSourceEdge(e), toEdge, sourceIndex, toDepth, flags)) {
                    this.crosstab.getCrosstabModel().getControllerActions().pivotGestureHappened((Object)this.crosstab, this._getSourceEdge(e), toEdge, sourceIndex, toDepth, flags);
                }
            }
        }
        catch (DataException exception) {
            this.crosstab.getErrorHandler().error((Throwable)exception, this.getClass().getName(), "pivot");
        }
        finally {
            this.setCursor(WindowUtils.getWindow((Component)((Object)this.crosstab)), this.getCursorType(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swap(PivotEvent e) {
        int sourceIndex = e.getSourceIndex();
        int destinationIndex = e.getDestinationIndex();
        if (this._getDestEdge(e) == this._getSourceEdge(e) && e.getSourceIndex() >= 500 && e.getDestinationIndex() >= 500) {
            sourceIndex -= 500;
            destinationIndex -= 500;
            int depth = this._getDestEdge(e) == 1 ? this.crosstab.getPivotTable().getReorderCol() : this.crosstab.getPivotTable().getReorderRow();
            try {
                this.setCursor(WindowUtils.getWindow((Component)((Object)this.crosstab)), this.getCursorType(2));
                this.crosstab.getCrosstabModel().getGridViewControllerActions().reorderGestureHappened(this.crosstab, this._getSourceEdge(e), depth, depth, sourceIndex, destinationIndex, 1);
            }
            catch (DataException exception) {
                this.crosstab.getErrorHandler().error((Throwable)exception, this.getClass().getName(), "swap");
            }
            finally {
                this.setCursor(WindowUtils.getWindow((Component)((Object)this.crosstab)), this.getCursorType(0));
            }
        } else {
            if (e.getSourceIndex() >= 500) {
                sourceIndex = this._getSourceEdge(e) == 1 ? this.crosstab.getPivotTable().getReorderCol() : this.crosstab.getPivotTable().getReorderRow();
                if (this._getSourceEdge(e) == this._getDestEdge(e) && sourceIndex == destinationIndex) {
                    return;
                }
            }
            try {
                this.setCursor(WindowUtils.getWindow((Component)((Object)this.crosstab)), this.getCursorType(2));
                if (this.crosstab.getCrosstabModel().getControllerActions().canPivot((Object)this.crosstab, this._getSourceEdge(e), this._getDestEdge(e), sourceIndex, destinationIndex, 1)) {
                    this.crosstab.getCrosstabModel().getControllerActions().pivotGestureHappened((Object)this.crosstab, this._getSourceEdge(e), this._getDestEdge(e), sourceIndex, destinationIndex, 1);
                }
            }
            catch (DataException exception) {
                this.crosstab.getErrorHandler().error((Throwable)exception, this.getClass().getName(), "swap");
            }
            finally {
                this.setCursor(WindowUtils.getWindow((Component)((Object)this.crosstab)), this.getCursorType(0));
            }
        }
    }

    public void pivot(PagingPivotEvent e) {
        PivotEvent pe = new PivotEvent(e.getSource(), e.getID(), e.getDestination(), e.getSourceIndex(), e.getDestinationIndex());
        this.pivot(pe);
    }

    public void swap(PagingPivotEvent e) {
        PivotEvent pe = new PivotEvent(e.getSource(), e.getID(), e.getDestination(), e.getSourceIndex(), e.getDestinationIndex());
        this.swap(pe);
    }

    public void headerCellDrill(DrillEvent e) {
        if (!this.crosstab.getCrosstabModel().isDrillingEnabled() || !this.crosstab.isEnabled()) {
            return;
        }
        try {
            this.setCursor(WindowUtils.getWindow((Component)((Object)this.crosstab)), this.getCursorType(2));
            this.crosstab.getCrosstabModel().getControllerActions().drillGestureHappened((Object)this.crosstab, this._getEdge(e), this._getDepth(e), this._getIndex(e), 0);
        }
        catch (DataException exception) {
            this.crosstab.getErrorHandler().error((Throwable)exception, this.getClass().getName(), "headerCellDrill");
        }
        finally {
            this.setCursor(WindowUtils.getWindow((Component)((Object)this.crosstab)), this.getCursorType(0));
        }
    }

    @Override
    public void focusCellChanged(TableEvent e) {
        if (e.getSource() == this.crosstab.getCrosstabRowHeader()) {
            this.processViewFocusEvent(new FocusEvent((Component)e.getSource(), 1004), (ComponentHandle)new EdgeComponentHandle(11, this.crosstab.getNameFromID(11), e.getSource(), 1, e.getColumn(), e.getRow()));
        } else if (e.getSource() == this.crosstab.getCrosstabColumnHeader()) {
            this.processViewFocusEvent(new FocusEvent((Component)e.getSource(), 1004), (ComponentHandle)new EdgeComponentHandle(10, this.crosstab.getNameFromID(10), e.getSource(), 0, e.getRow(), e.getColumn()));
        } else {
            this.processViewFocusEvent(new FocusEvent((Component)this.crosstab.getPivotTable().getPivotGrid(), 1004), CrosstabUtils.createDataComponent(this.crosstab, 12, this.crosstab.getNameFromID(12), e.getSource(), e.getRow(), e.getColumn(), null, false));
        }
    }

    public void headerColumnResizing(PivotHeaderEvent e) {
        EdgeComponentHandle c = new EdgeComponentHandle(10, this.crosstab.getNameFromID(10), e.getSource(), 0, e.getRow(), e.getColumn());
        if (this.fireSizingEvent((ComponentHandle)c)) {
            return;
        }
        ((Cancelable)e).cancel();
    }

    public void headerColumnResized(PivotHeaderEvent e) {
        this.fireSizedEvent();
        CrosstabPivotHeader ph = e.getOrientation() == 0 ? this.crosstab.getCrosstabColumnHeader() : this.crosstab.getCrosstabRowHeader();
        this.crosstabSizingManager.setPreferredRowHeaderColumnWidth(e.getColumn(), DataviewUtils.scaleDownByZoom((int)ph.getColumnWidth(e.getColumn()), (int)this.crosstab.getZoomFactor()));
    }

    public void headerRowResizing(PivotHeaderEvent e) {
        EdgeComponentHandle c = new EdgeComponentHandle(11, this.crosstab.getNameFromID(11), e.getSource(), 1, e.getColumn(), e.getRow());
        if (this.fireSizingEvent((ComponentHandle)c)) {
            return;
        }
        ((Cancelable)e).cancel();
    }

    public void headerRowResized(PivotHeaderEvent e) {
        this.fireSizedEvent();
        CrosstabPivotHeader ph = e.getOrientation() == 0 ? this.crosstab.getCrosstabColumnHeader() : this.crosstab.getCrosstabRowHeader();
        this.crosstabSizingManager.setPreferredColumnHeaderRowHeight(e.getRow(), DataviewUtils.scaleDownByZoom((int)ph.getRowHeight(e.getRow()), (int)this.crosstab.getZoomFactor()));
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        if (e.getSource() instanceof PagingComponent) {
            if (!this.inSetSelectedObject) {
                return;
            }
            if (e.getPropertyName() == "selectedIndex") {
                PagingComponent dpc = (PagingComponent)e.getSource();
                PageItem pi = dpc.getSelectedItem();
                int index = dpc.getIndex(pi);
                PageItemComponentHandle pic = new PageItemComponentHandle(4, "PageItem", (Object)dpc, index);
                if (index == -1) {
                    return;
                }
                if (this.gridViewSelectionManager.canSelectComponents(this.crosstab) && this.gridViewSelectionManager.canSelectComponent(this.crosstab, (ComponentHandle)pic) && this.fireComponentSelecting(this.crosstab, (ComponentHandle)pic) && this.setSelectedObject((ComponentHandle)pic, false)) {
                    return;
                }
                throw new PropertyVetoException("Crosstab", e);
            }
            return;
        }
        if (e.getPropertyName().equals("selection")) {
            if (this.selectingCells) {
                return;
            }
            SpreadTable source = (SpreadTable)e.getSource();
            TwoDSelection sel = (TwoDSelection)e.getNewValue();
            if (sel.isEmpty()) {
                return;
            }
            if (source == this.crosstab.getCrosstabColumnHeader()) {
                OneDSelection rs = sel.getRowSelection();
                if (rs.isEmpty()) {
                    ComponentHandle c = CrosstabUtils.createEdgeComponent(this.crosstab, 10, this.crosstab.getNameFromID(10), this.crosstab.getCrosstabColumnHeader(), 0, sel.getSingleCell().row, sel.getSingleCell().column, sel.getCellRanges(), true);
                    if (this.gridViewSelectionManager.canSelectComponent(this.crosstab, c) && this.fireComponentSelecting(this.crosstab, c) && this.setSelectedObject(c, true)) {
                        return;
                    }
                } else {
                    ComponentHandle c = CrosstabUtils.createRowRangeComponent(this.crosstab, 25, this.crosstab.getNameFromID(25), this.crosstab.getCrosstabColumnHeader(), rs.getSingleItem(), rs.getRanges(), true);
                    if (this.gridViewSelectionManager.canSelectComponents(this.crosstab) && this.gridViewSelectionManager.canSelectComponent(this.crosstab, c) && this.fireComponentSelecting(this.crosstab, c) && this.setSelectedObject(c, true)) {
                        return;
                    }
                }
                throw new PropertyVetoException("Crosstab", e);
            }
            if (source == this.crosstab.getCrosstabRowHeader()) {
                OneDSelection cs = sel.getColumnSelection();
                if (cs.isEmpty()) {
                    ComponentHandle c = CrosstabUtils.createEdgeComponent(this.crosstab, 11, this.crosstab.getNameFromID(11), this.crosstab.getCrosstabRowHeader(), 1, sel.getSingleCell().row, sel.getSingleCell().column, sel.getCellRanges(), true);
                    if (this.gridViewSelectionManager.canSelectComponent(this.crosstab, c) && this.fireComponentSelecting(this.crosstab, c) && this.setSelectedObject(c, true)) {
                        return;
                    }
                } else {
                    ComponentHandle c = CrosstabUtils.createColumnRangeComponent(this.crosstab, 24, this.crosstab.getNameFromID(24), this.crosstab.getCrosstabRowHeader(), cs.getSingleItem(), cs.getRanges(), true);
                    if (this.gridViewSelectionManager.canSelectComponents(this.crosstab) && this.gridViewSelectionManager.canSelectComponent(this.crosstab, c) && this.fireComponentSelecting(this.crosstab, c) && this.setSelectedObject(c, true)) {
                        return;
                    }
                }
                throw new PropertyVetoException("Crosstab", e);
            }
            if (source == this.crosstab.getCrosstabDatabody()) {
                OneDSelection cs = sel.getColumnSelection();
                OneDSelection rs = sel.getRowSelection();
                if (!cs.isEmpty()) {
                    ComponentHandle c = CrosstabUtils.createColumnRangeComponent(this.crosstab, 14, this.crosstab.getNameFromID(14), this.crosstab.getCrosstabDatabody(), cs.getSingleItem(), cs.getRanges(), true);
                    if (this.gridViewSelectionManager.canSelectComponents(this.crosstab) && this.gridViewSelectionManager.canSelectComponent(this.crosstab, c)) {
                        int column;
                        if (c instanceof ColumnRangeComponentHandle) {
                            boolean fireSelect = true;
                            ColumnRangeComponentHandle crcid = (ColumnRangeComponentHandle)c;
                            ColumnComponentInfo[] cci = crcid.getLocationList();
                            for (int i = 0; i < cci.length; ++i) {
                                if (this.gridViewSelectionManager.canSelectColumn(this.crosstab.getCrosstabModel().getDataFromTableCol(cci[i].getColumn()))) continue;
                                fireSelect = false;
                                break;
                            }
                            if (this.fireComponentSelecting(this.crosstab, c) && this.setSelectedObject(c, true)) {
                                return;
                            }
                        } else if (c instanceof ColumnComponentHandle && this.gridViewSelectionManager.canSelectColumn(column = this.crosstab.getCrosstabModel().getDataFromTableCol(((ColumnComponentHandle)c).getColumn())) && this.fireComponentSelecting(this.crosstab, c) && this.setSelectedObject(c, true)) {
                            ((PivotGrid)this.crosstab.getDatabody()).setFocusCell(new Cell(column, 0));
                            return;
                        }
                    }
                    throw new PropertyVetoException("Crosstab", e);
                }
                if (!rs.isEmpty()) {
                    ComponentHandle c = CrosstabUtils.createRowRangeComponent(this.crosstab, 15, this.crosstab.getNameFromID(15), this.crosstab.getCrosstabDatabody(), rs.getSingleItem(), rs.getRanges(), true);
                    if (this.gridViewSelectionManager.canSelectComponents(this.crosstab) && this.gridViewSelectionManager.canSelectComponent(this.crosstab, c)) {
                        int row;
                        if (c instanceof RowRangeComponentHandle) {
                            boolean fireSelect = true;
                            RowRangeComponentHandle rrcid = (RowRangeComponentHandle)c;
                            RowComponentInfo[] rci = rrcid.getLocationList();
                            for (int i = 0; i < rci.length; ++i) {
                                if (this.gridViewSelectionManager.canSelectRow(this.crosstab.getCrosstabModel().getDataFromTableRow(rci[i].getRow()))) continue;
                                fireSelect = false;
                                break;
                            }
                            if (this.fireComponentSelecting(this.crosstab, c) && this.setSelectedObject(c, true)) {
                                return;
                            }
                        } else if (c instanceof RowComponentHandle && this.gridViewSelectionManager.canSelectRow(row = this.crosstab.getCrosstabModel().getDataFromTableRow(((RowComponentHandle)c).getRow())) && this.fireComponentSelecting(this.crosstab, c) && this.setSelectedObject(c, true)) {
                            ((PivotGrid)this.crosstab.getDatabody()).setFocusCell(new Cell(0, row));
                            return;
                        }
                    }
                    throw new PropertyVetoException("Crosstab", e);
                }
                ComponentHandle c = CrosstabUtils.createDataComponent(this.crosstab, 12, this.crosstab.getNameFromID(12), (Object)this.crosstab.getCrosstabDatabody(), sel.getSingleCell().row, sel.getSingleCell().column, sel.getCellRanges(), true);
                if (this.gridViewSelectionManager.canSelectComponents(this.crosstab) && this.gridViewSelectionManager.canSelectComponent(this.crosstab, c)) {
                    boolean canSelect;
                    if (c instanceof DataComponentHandle) {
                        canSelect = this.gridViewSelectionManager.canSelectCell(this.crosstab.getCrosstabModel().getDataFromTableRow(((DataComponentHandle)c).getRow()), this.crosstab.getCrosstabModel().getDataFromTableCol(((DataComponentHandle)c).getColumn()));
                    } else {
                        CellRange[] ranges = sel.getCellRanges();
                        CellRange lastRange = ranges[ranges.length - 1];
                        Cell cell = lastRange.getUpperLimit();
                        canSelect = this.gridViewSelectionManager.canSelectCell(this.crosstab.getCrosstabModel().getDataFromTableRow(cell.row), this.crosstab.getCrosstabModel().getDataFromTableCol(cell.column));
                    }
                    if (canSelect && this.fireComponentSelecting(this.crosstab, c)) {
                        if (!this.clickDragSelection && this.setSelectedObject(c, true)) {
                            return;
                        }
                        return;
                    }
                }
                throw new PropertyVetoException("Crosstab", e);
            }
        }
    }

    @Override
    public void columnResized(TableEvent e) {
        super.columnResized(e);
        CrosstabDatabody db = this.crosstab.getCrosstabDatabody();
        this.crosstabSizingManager.setPreferredColumnWidth(e.getColumn(), DataviewUtils.scaleDownByZoom((int)db.getColumnWidth(e.getColumn()), (int)this.crosstab.getZoomFactor()));
    }

    @Override
    public void rowResized(TableEvent e) {
        super.rowResized(e);
        CrosstabDatabody db = this.crosstab.getCrosstabDatabody();
        this.crosstabSizingManager.setPreferredRowHeight(e.getRow(), DataviewUtils.scaleDownByZoom((int)db.getRowHeight(e.getRow()), (int)this.crosstab.getZoomFactor()));
    }

    public void mouseClicked(MouseEvent e) {
        int itemSize;
        int itemPos;
        this.mouseEvent = e;
        ComponentHandle c = this.getComponentFromGrid(e.getSource(), e.getX(), e.getY(), false);
        if (!this.crosstab.isEnabled()) {
            this.processViewMouseEvent(e, c);
            return;
        }
        if (c.getID() == 23 && this.inResize && e.getClickCount() == this.AUTOFIT_CLICKS) {
            ColumnComponentHandle cci = (ColumnComponentHandle)c;
            int column = cci.getColumn();
            try {
                itemPos = ((Header)e.getSource()).getItemPosition(column);
                itemSize = ((Header)e.getSource()).getItemSize(column);
                int xLoc = e.getX();
                if (xLoc - itemPos < itemPos + itemSize - xLoc && column != this.crosstab.getCrosstabModel().getDataAccess().getEdgeExtent(0)) {
                    --column;
                }
            }
            catch (EdgeOutOfRangeException exception) {
                this.crosstab.getErrorHandler().error((Throwable)exception, this.getClass().getName(), "mouseClicked");
            }
            this.crosstab.doubleClickAutoFitColumnWidth(column);
            this.inResize = false;
            e.consume();
        }
        if (c.getID() == 22 && this.inResize && e.getClickCount() == this.AUTOFIT_CLICKS) {
            RowComponentHandle rci = (RowComponentHandle)c;
            int row = rci.getRow();
            try {
                itemPos = ((Header)e.getSource()).getItemPosition(row);
                itemSize = ((Header)e.getSource()).getItemSize(row);
                int yLoc = e.getY();
                if (yLoc - itemPos < itemPos + itemSize - yLoc && row != this.crosstab.getCrosstabModel().getDataAccess().getEdgeExtent(1)) {
                    --row;
                }
            }
            catch (EdgeOutOfRangeException exception) {
                this.crosstab.getErrorHandler().error((Throwable)exception, this.getClass().getName(), "mouseClicked");
            }
            this.crosstab.autoFitRowHeight(row);
            this.inResize = false;
            e.consume();
        }
        this.processViewMouseEvent(e, c);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseEvent = e;
        ComponentHandle c = this.getComponentFromGrid(e.getSource(), e.getX(), e.getY(), false);
        if (this.crosstab.isEnabled() && c.getID() == 13) {
            this.crosstab.getPivotTable().requestFocus();
            if (this.crosstab.getCrosstabDatabody().isColumnHeaderVisible() && this.crosstab.getCrosstabDatabody().isRowHeaderVisible() && this.crosstab.getCrosstabDatabody().isSelectAllEnabled()) {
                try {
                    this.crosstab.getCrosstabDatabody().getGrid().selectAll();
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            e.consume();
        }
        super.mousePressed(e);
    }

    @Override
    public void setCrosstabSizingManager(CrosstabSizingManager m) {
        this.setGridViewSizingManager(m);
        this.crosstabSizingManager = m;
        this.crosstab.getPivotTable().setEqualSizedColumns(false);
        this.crosstab.getPivotTable().setEqualSizedRows(false);
        this.crosstab.doSizing();
    }

    @Override
    public CrosstabSizingManager getCrosstabSizingManager() {
        return this.crosstabSizingManager;
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        CrosstabPivotTable pt = this.crosstab.getPivotTable();
        pt.removeDrillListener(this);
        pt.removeCollapseListener(this);
        pt.removePivotListener(this);
        this.crosstab.getPagingControl().getPagingComponent().removePivotListener((PagingPivotListener)this);
        pt.removePivotHeaderResListener(this);
        pt.getCrosstabDatabody().getGrid().removeFocusListener((FocusListener)((Object)this));
        pt.getPivotGrid().removeMouseMotionListener((MouseMotionListener)((Object)this));
        pt.getPivotGrid().getGrid().removeMouseMotionListener((MouseMotionListener)((Object)this));
        pt.getPivotGrid().getColumnHeader().removeMouseMotionListener((MouseMotionListener)((Object)this));
        pt.getPivotGrid().getRowHeader().removeMouseMotionListener((MouseMotionListener)((Object)this));
        pt.getPivotGrid().getCornerComponent("UPPER_LEFT_CORNER").removeMouseMotionListener((MouseMotionListener)((Object)this));
        this.crosstab.getCrosstabRowHeader().getGrid().removeMouseMotionListener((MouseMotionListener)((Object)this));
        this.crosstab.getCrosstabColumnHeader().getGrid().removeMouseMotionListener((MouseMotionListener)((Object)this));
        this.crosstab.getCrosstabRowHeader().getColumnHeader().removeMouseMotionListener((MouseMotionListener)((Object)this));
        this.crosstab.getCrosstabColumnHeader().getRowHeader().removeMouseMotionListener((MouseMotionListener)((Object)this));
        pt.getPivotGrid().removeMouseListener((MouseListener)((Object)this));
        pt.getPivotGrid().getGrid().removeMouseListener((MouseListener)((Object)this));
        pt.getPivotGrid().getColumnHeader().removeMouseListener((MouseListener)((Object)this));
        pt.getPivotGrid().getRowHeader().removeMouseListener((MouseListener)((Object)this));
        pt.getPivotGrid().getCornerComponent("UPPER_LEFT_CORNER").removeMouseListener((MouseListener)((Object)this));
        this.crosstab.getCrosstabRowHeader().getGrid().removeMouseListener((MouseListener)((Object)this));
        this.crosstab.getCrosstabColumnHeader().getGrid().removeMouseListener((MouseListener)((Object)this));
        this.crosstab.getCrosstabRowHeader().getColumnHeader().removeMouseListener((MouseListener)((Object)this));
        this.crosstab.getCrosstabColumnHeader().getRowHeader().removeMouseListener((MouseListener)((Object)this));
        pt.getPivotGrid().removeKeyListener((KeyListener)((Object)this));
        pt.getPivotGrid().getGrid().removeKeyListener((KeyListener)((Object)this));
        pt.getPivotGrid().getColumnHeader().removeKeyListener((KeyListener)((Object)this));
        pt.getPivotGrid().getRowHeader().removeKeyListener((KeyListener)((Object)this));
        pt.getPivotGrid().getCornerComponent("UPPER_LEFT_CORNER").removeKeyListener((KeyListener)((Object)this));
        this.crosstab.getCrosstabRowHeader().getGrid().removeKeyListener((KeyListener)((Object)this));
        this.crosstab.getCrosstabColumnHeader().getGrid().removeKeyListener((KeyListener)((Object)this));
        this.crosstab.getCrosstabRowHeader().getColumnHeader().removeKeyListener((KeyListener)((Object)this));
        this.crosstab.getCrosstabColumnHeader().getRowHeader().removeKeyListener((KeyListener)((Object)this));
    }

    @Override
    public Object cloneForNewView(Crosstab v) {
        CrosstabControllerAdapter cca = new CrosstabControllerAdapter(v);
        Object[] o = this.listenerList.getListenerList();
        for (int l = 0; l < o.length; l += 2) {
            cca.listenerList.add((Class)o[l], (EventListener)o[l + 1]);
        }
        return cca;
    }

    @Override
    public void setDrilling(boolean bDrilling) {
        this.m_bDrill = bDrilling;
    }

    @Override
    protected boolean fireSizingEvent(ComponentHandle comp) {
        this.sizingComponent = comp;
        return this.fireComponentSizing(this.crosstab, comp);
    }

    @Override
    protected void fireSizedEvent() {
        super.fireSizedEvent();
    }

    @Override
    protected MouseEvent getMouseEvent() {
        return super.getMouseEvent();
    }

    @Override
    protected ComponentHandle getComponentFromGrid(Object source, int x, int y, boolean useSelState) {
        JTextPane textPane;
        boolean DBHighlight = false;
        int row = -1;
        int column = -1;
        if (source instanceof PageItem) {
            return this.createComponentFromPageItem(source);
        }
        if (source instanceof Grid || source instanceof CrosstabDatabody) {
            Grid g;
            CrosstabDatabody pg = null;
            if (source instanceof Grid) {
                g = (Grid)source;
            } else {
                pg = (CrosstabDatabody)source;
                g = pg.getGrid();
            }
            Point p = g.convertOuterToCanvas(x, y);
            column = g.getColumnAt(p.x);
            row = g.getRowAt(p.y);
            if (g.getParent() instanceof RowPivotHeader) {
                if (row == -1) {
                    return this.getNonDataComponent((ViewComponent)g.getParent());
                }
                return new EdgeComponentHandle(11, this.crosstab.getNameFromID(11), (Object)g.getParent(), 1, column, row);
            }
            if (g.getParent() instanceof ColPivotHeader) {
                if (column == -1) {
                    return this.getNonDataComponent((ViewComponent)g.getParent());
                }
                return new EdgeComponentHandle(10, this.crosstab.getNameFromID(10), (Object)g.getParent(), 0, row, column);
            }
            if (row == -1 || column == -1) {
                return this.getNonDataComponent((ViewComponent)g.getParent());
            }
            if (this.crosstab.getPivotTable().getSelection().getGridSelection().getRowSelection().contains(row)) {
                return this.crosstab.getSelectedObject();
            }
            if (this.crosstab.getPivotTable().getSelection().getGridSelection().getColumnSelection().contains(column)) {
                return this.crosstab.getSelectedObject();
            }
            return CrosstabUtils.createDataComponent(this.crosstab, 12, this.crosstab.getNameFromID(12), (Object)new Cell(column, row), row, column, this.crosstab.getPivotTable().getSelection().getGridSelection().getCellRanges(), useSelState);
        }
        if (source instanceof Header) {
            return this._createComponentFromHighlighter((Header)source, x, y);
        }
        if (source == this.crosstab.getPivotTable().getPivotGrid().getCornerComponent("UPPER_LEFT_CORNER")) {
            return new NonDataComponentHandle(13, this.crosstab.getNameFromID(13), (Object)this.crosstab);
        }
        if (source instanceof ViewComponent) {
            return this.getNonDataComponent((ViewComponent)source);
        }
        if (source instanceof JTextPane && (textPane = (JTextPane)source).getParent() instanceof BaseTitle) {
            return this.getNonDataComponent((ViewComponent)textPane.getParent());
        }
        return new NonDataComponentHandle(21, "Crosstab", source);
    }

    @Override
    protected ComponentHandle getComponentFromGrid(Object source, boolean useSelState) {
        JTextPane textPane;
        int row = -1;
        int column = -1;
        if (source instanceof PageItem) {
            return this.createComponentFromPageItem(source);
        }
        if (source instanceof Grid) {
            Grid g = (Grid)source;
            Cell cell = g.getFocusCell();
            if (cell != null) {
                column = g.getFocusCell().column;
                row = g.getFocusCell().row;
            }
            if (g.getParent() instanceof RowPivotHeader) {
                if (row == -1) {
                    return this.getNonDataComponent((ViewComponent)g.getParent());
                }
                return new EdgeComponentHandle(11, this.crosstab.getNameFromID(11), (Object)g.getParent(), 1, column, row);
            }
            if (g.getParent() instanceof ColPivotHeader) {
                if (column == -1) {
                    return this.getNonDataComponent((ViewComponent)g.getParent());
                }
                return new EdgeComponentHandle(10, this.crosstab.getNameFromID(10), (Object)g.getParent(), 0, row, column);
            }
            if (row == -1 || column == -1) {
                return this.getNonDataComponent((ViewComponent)g.getParent());
            }
            return CrosstabUtils.createDataComponent(this.crosstab, 12, this.crosstab.getNameFromID(12), (Object)new Cell(column, row), row, column, this.crosstab.getPivotTable().getSelection().getGridSelection().getCellRanges(), useSelState);
        }
        if (source instanceof Header) {
            return this._createComponentFromHighlighter((Header)source, -1, -1);
        }
        if (source == this.crosstab.getPivotTable().getPivotGrid().getCornerComponent("UPPER_LEFT_CORNER")) {
            return new NonDataComponentHandle(13, this.crosstab.getNameFromID(13), (Object)this.crosstab);
        }
        if (source instanceof ViewComponent) {
            return this.getNonDataComponent((ViewComponent)source);
        }
        if (source instanceof JTextPane && (textPane = (JTextPane)source).getParent() instanceof BaseTitle) {
            return this.getNonDataComponent((ViewComponent)textPane.getParent());
        }
        return new NonDataComponentHandle(21, "Crosstab", source);
    }

    @Override
    protected void unselectGridView() {
        boolean oldSelecting = this.selectingCells;
        this.setSelectingCells(true);
        CrosstabUtils.unselectPivotTable(this.crosstab);
        this.setSelectingCells(oldSelecting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reorderDimensions(PivotEvent e) {
        int depth;
        int sourceIndex = e.getSourceIndex() - 500;
        int destinationIndex = e.getDestinationIndex() - 500;
        int flags = 0;
        if (this._getDestEdge(e) == 1) {
            try {
                depth = this.crosstab.getPivotTable().getReorderCol();
                flags = sourceIndex < destinationIndex ? 3 : 2;
                this.setCursor(WindowUtils.getWindow((Component)((Object)this.crosstab)), this.getCursorType(2));
                this.crosstab.getCrosstabModel().getGridViewControllerActions().reorderGestureHappened(this.crosstab, 1, depth, depth, sourceIndex, destinationIndex, flags);
            }
            catch (DataException ex) {
                this.crosstab.getErrorHandler().error((Throwable)ex, this.getClass().getName(), "reorderDimensions");
            }
            finally {
                this.setCursor(WindowUtils.getWindow((Component)((Object)this.crosstab)), this.getCursorType(0));
            }
        }
        if (this._getDestEdge(e) == 0) {
            try {
                depth = this.crosstab.getPivotTable().getReorderRow();
                flags = sourceIndex < destinationIndex ? 3 : 2;
                this.setCursor(WindowUtils.getWindow((Component)((Object)this.crosstab)), this.getCursorType(2));
                this.crosstab.getCrosstabModel().getGridViewControllerActions().reorderGestureHappened(this.crosstab, 0, depth, depth, sourceIndex, destinationIndex, flags);
            }
            catch (DataException ex) {
                this.crosstab.getErrorHandler().error((Throwable)ex, this.getClass().getName(), "reorderDimensions");
            }
            finally {
                this.setCursor(WindowUtils.getWindow((Component)((Object)this.crosstab)), this.getCursorType(0));
            }
        }
    }

    ComponentHandle _createComponentFromHighlighter(Header h, int x, int y) {
        boolean grabber;
        boolean bl = grabber = h.getClass().getName().indexOf("Grid") == -1;
        if (h.getOrientation() == 0) {
            int column = h.getItemAt(x, y);
            return new ColumnComponentHandle(grabber ? 24 : 23, grabber ? "RowGrabber" : "ColumnHighlighter", (Object)h, column);
        }
        int row = h.getItemAt(x, y);
        return new RowComponentHandle(grabber ? 25 : 22, grabber ? "ColumnGrabber" : "RowHighlighter", (Object)h, row);
    }

    private int _getEdge(DrillEvent e) {
        return e.getOrientation() == 0 ? 0 : 1;
    }

    private int _getEdge(CollapseEvent e) {
        return e.getOrientation() == 0 ? 0 : 1;
    }

    private int _getSourceEdge(PivotEvent e) {
        if (e.getSource() instanceof PagingComponent) {
            return 2;
        }
        if (e.getSource() instanceof ColPivotHeader) {
            return 0;
        }
        if (e.getSource() instanceof RowPivotHeader) {
            return 1;
        }
        return e.getSourcePivotHeader().getOrientation() == 0 ? 0 : 1;
    }

    private int _getDestEdge(PivotEvent e) {
        if (e.getDestination() instanceof PagingComponent) {
            return 2;
        }
        if (e.getDestination() instanceof ColPivotHeader) {
            return 0;
        }
        if (e.getDestination() instanceof RowPivotHeader) {
            return 1;
        }
        return e.getDestinationPivotHeader().getOrientation() == 0 ? 0 : 1;
    }

    private int _getDepth(DrillEvent e) {
        if (e.getOrientation() == 0) {
            return e.getRow();
        }
        if (!this.crosstab.isOutline()) {
            return e.getColumn();
        }
        int layer = e.getColumn();
        try {
            layer = this.crosstab.getModel().getDataAccess().getSliceOutlineLayer(1, e.getRow());
        }
        catch (EdgeOutOfRangeException eoore) {
            this.crosstab.getErrorHandler().log("edge out of range", this.getClass().getName(), m_method__getDepth_DrillEvent);
        }
        catch (SliceOutOfRangeException soore) {
            this.crosstab.getErrorHandler().log("slice out of range", this.getClass().getName(), m_method__getDepth_DrillEvent);
        }
        return layer;
    }

    private int _getDepth(CollapseEvent e) {
        if (e.getOrientation() == 0) {
            return e.getRow();
        }
        if (!this.crosstab.isOutline()) {
            return e.getColumn();
        }
        int layer = e.getColumn();
        try {
            layer = this.crosstab.getModel().getDataAccess().getSliceOutlineLayer(1, e.getRow());
        }
        catch (EdgeOutOfRangeException eoore) {
            this.crosstab.getErrorHandler().log("edge out of range", this.getClass().getName(), m_method__getDepth_CollapseEvent);
        }
        catch (SliceOutOfRangeException soore) {
            this.crosstab.getErrorHandler().log("slice out of range", this.getClass().getName(), m_method__getDepth_CollapseEvent);
        }
        return layer;
    }

    private int _getIndex(DrillEvent e) {
        return e.getOrientation() == 0 ? e.getColumn() : e.getRow();
    }

    private int _getIndex(CollapseEvent e) {
        return e.getOrientation() == 0 ? e.getColumn() : e.getRow();
    }
}

