/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlcl.commands.aq;

import java.sql.Connection;
import java.util.Map;
import java.util.logging.Logger;
import oracle.dbtools.extension.SQLCLService;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.CommandParserConstants;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.Help.CommandHelp;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.CommandHelpClassException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.CommandOptionsClassException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ConnectionNotValidException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ExtraParameterException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.InvalidCommandException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.MissingRequiredParameterException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ParameterFailedValidationException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.interfaces.ICommandSyntax;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.parameter.StandardParameter;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.parser.CommandParser;
import oracle.dbtools.sqlcl.commands.aq.AQOptionsV2;
import oracle.dbtools.sqlcl.commands.aq.Messages;

public class AQCommandV2
extends CommandListener
implements IHelp,
SQLCLService,
ICommandSyntax {
    public static ScriptRunnerContext ctx;
    private CommandHelp help;
    public static String COMMAND;
    public static String COMMAND_AQ_ADM;
    public static String COMMAND_AQ_USER;
    protected static final Logger LOGGER;

    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void beginScript(Connection conn, ScriptRunnerContext ctx) {
        LOGGER.info("aqcommand - begin");
    }

    public void endScript(Connection conn, ScriptRunnerContext ctx) {
        LOGGER.info("aqcommand - end");
    }

    public String getCommand() {
        return COMMAND;
    }

    public String getHelp() {
        try {
            this.help = new CommandHelp(new ScriptRunnerContext(), AQOptionsV2.class);
            ScriptRunnerContext theCtx = new ScriptRunnerContext();
            this.help = new CommandHelp(theCtx, AQOptionsV2.class);
            CommandParser.loadParams((String)"aq.params", (String)"aq help", (ScriptRunnerContext)theCtx, AQOptionsV2.class);
            return this.help.getCommandHelp();
        }
        catch (CommandHelpClassException | CommandOptionsClassException | ConnectionNotValidException | ExtraParameterException | InvalidCommandException | MissingRequiredParameterException | ParameterFailedValidationException e) {
            return "No Help";
        }
    }

    public boolean isSqlPlus() {
        return false;
    }

    public Class<? extends CommandListener> getCommandListener() {
        return ((Object)((Object)this)).getClass();
    }

    public String getExtensionDescription() {
        String desc = Messages.getString("AQCMD.EXTENSIONDESCRIPTION").trim();
        return desc;
    }

    public String getExtensionName() {
        String name = "Advanced Queue";
        return "Advanced Queue";
    }

    public String getExtensionVersion() {
        String version = Messages.getString("SQLclVersion.VERSION");
        return version;
    }

    public boolean handleEvent(Connection sqlConn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (!cmd.getLoweredTrimmedSQL().startsWith(COMMAND)) {
            return false;
        }
        try {
            this.help = new CommandHelp(ctx, AQOptionsV2.class);
            CommandParser.loadParams((String)"aq.params", (String)cmd.getSql(), (ScriptRunnerContext)ctx, AQOptionsV2.class, (boolean)true, (boolean)true);
            String _command = ctx.getParameterInstance().getParameterAsString("aq.params", CommandParserConstants.COMMAND);
            boolean _help = ctx.getParameterInstance().getParameterAsBoolean("aq.params", CommandParserConstants.HELP);
            if (_help) {
                ctx.write(this.help.getCommandHelp());
                return true;
            }
        }
        catch (CommandHelpClassException | CommandOptionsClassException | ConnectionNotValidException | ExtraParameterException | InvalidCommandException | MissingRequiredParameterException | ParameterFailedValidationException e) {
            e.printStackTrace();
        }
        return true;
    }

    public String getCommandLongName() {
        return null;
    }

    public Map<String, Map<String, StandardParameter>> getCommandModel() {
        return null;
    }

    public String getCommandShortName() {
        return null;
    }

    static {
        COMMAND = "aq";
        COMMAND_AQ_ADM = "aq -adm";
        COMMAND_AQ_USER = "aq -user";
        LOGGER = Logger.getLogger(AQCommandV2.class.getName());
    }
}

