/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.xml.dtd;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import oracle.jdeveloper.xml.dtd.DtdLoadingUtils;
import oracle.jdeveloper.xml.dtd.grammar.DtdGrammar;

public class DtdRegistry {
    private static ConcurrentHashMap<String, SystemIdEntry> systemIdEntryMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, String> publicIdMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, String> systemIdMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, DtdGrammar> definitionMap = new ConcurrentHashMap();

    public static void registerPublicId(String publicID, String systemID) {
        publicIdMap.put(publicID, systemID);
        systemIdMap.put(systemID, publicID);
    }

    public static String getSystemId(String publicID) {
        return publicID == null ? null : publicIdMap.get(publicID);
    }

    public static boolean isCaseSensitiveSystemId(String systemID) {
        SystemIdEntry entry;
        boolean caseSensitive = true;
        SystemIdEntry systemIdEntry = entry = systemID == null ? null : systemIdEntryMap.get(systemID);
        if (entry != null) {
            caseSensitive = entry.caseSensitive;
        }
        return caseSensitive;
    }

    public static boolean isCaseSensitivePublicId(String publicID) {
        return DtdRegistry.isCaseSensitiveSystemId(DtdRegistry.getSystemId(publicID));
    }

    public static boolean isSystemIdRegisteredLocally(String systemID) {
        return systemID == null ? false : systemIdEntryMap.get(systemID) != null;
    }

    public static boolean isPublicIdRegisteredLocally(String publicID) {
        return DtdRegistry.isSystemIdRegisteredLocally(DtdRegistry.getSystemId(publicID));
    }

    public static void registerSystemId(String systemID, URL dtdLocation) throws DuplicateSystemIdException {
        DtdRegistry.registerSystemId(systemID, dtdLocation, false, false);
    }

    public static void registerSystemId(String systemID, String dtdLocation) throws DuplicateSystemIdException {
        DtdRegistry.registerSystemId(systemID, dtdLocation, false, false);
    }

    public static void registerSystemId(String systemID, URL dtdLocation, boolean dtdXmlFormat, boolean caseSensitive) throws DuplicateSystemIdException {
        if (systemID == null) {
            throw new IllegalArgumentException("Systen ID can not be null.");
        }
        if (dtdLocation == null) {
            throw new IllegalArgumentException("DTD location can not be null.");
        }
        SystemIdEntry entry = systemIdEntryMap.get(systemID);
        if (entry != null) {
            throw new DuplicateSystemIdException(systemID);
        }
        entry = new SystemIdEntry();
        entry.systemID = systemID;
        entry.dtdURL = dtdLocation;
        entry.xmlFormat = dtdXmlFormat;
        entry.caseSensitive = caseSensitive;
        systemIdEntryMap.put(systemID, entry);
    }

    public static void registerSystemId(String systemID, String dtdLocation, boolean dtdXmlFormat, boolean caseSensitive) throws DuplicateSystemIdException {
        if (systemID == null) {
            throw new IllegalArgumentException("Systen ID can not be null.");
        }
        if (dtdLocation == null) {
            throw new IllegalArgumentException("DTD location can not be null.");
        }
        SystemIdEntry entry = systemIdEntryMap.get(systemID);
        if (entry != null) {
            throw new DuplicateSystemIdException(systemID);
        }
        entry = new SystemIdEntry();
        entry.systemID = systemID;
        entry.dtdLocation = dtdLocation;
        entry.xmlFormat = dtdXmlFormat;
        entry.caseSensitive = caseSensitive;
        systemIdEntryMap.put(systemID, entry);
    }

    public static URL getLocalSystemIdLocation(String systemID) {
        SystemIdEntry entry;
        SystemIdEntry systemIdEntry = entry = systemID == null ? null : systemIdEntryMap.get(systemID);
        if (entry != null) {
            if (entry.dtdURL == null) {
                entry.dtdURL = DtdRegistry.class.getResource(entry.dtdLocation);
                if (entry.dtdURL == null && entry.dtdLocation != null) {
                    try {
                        entry.dtdURL = new URL(entry.dtdLocation);
                    }
                    catch (MalformedURLException badUrlExc) {
                        entry.dtdURL = null;
                    }
                }
            }
            return entry.dtdURL;
        }
        return null;
    }

    public static URL getSystemIdLocation(String systemID) {
        return DtdRegistry.getLocalSystemIdLocation(systemID);
    }

    public static URL getLocalPublicIdLocation(String publicID) {
        String systemID = DtdRegistry.getSystemId(publicID);
        if (systemID != null) {
            return DtdRegistry.getLocalSystemIdLocation(systemID);
        }
        return null;
    }

    public static URL getPublicIdLocation(String publicID) {
        return DtdRegistry.getLocalPublicIdLocation(publicID);
    }

    public static DtdGrammar getGrammarDefinition(String namespace, String rootElement, String systemId) throws IOException {
        return DtdRegistry.getDefinition(namespace, rootElement, systemId == null ? null : systemIdMap.get(systemId), systemId);
    }

    public static DtdGrammar getPublicGrammarDefinition(String namespace, String rootElement, String publicId) throws IOException {
        return DtdRegistry.getDefinition(namespace, rootElement, publicId, DtdRegistry.getSystemId(publicId));
    }

    public static void clearCache() {
        definitionMap.clear();
    }

    protected static DtdGrammar getDefinition(String namespace, String rootElement, String publicId, String systemId) throws IOException {
        SystemIdEntry sysIdEntry;
        SystemIdEntry systemIdEntry = sysIdEntry = systemId == null ? null : systemIdEntryMap.get(systemId);
        if (sysIdEntry == null) {
            if (publicId != null) {
                throw new IOException("Location of " + systemId + " unknown.");
            }
            throw new IOException("System ID " + systemId + " unknown.");
        }
        String key = namespace + ":" + systemId;
        DtdGrammar grammar = definitionMap.get(key);
        if (grammar == null) {
            grammar = DtdRegistry.loadDefinition(namespace, rootElement, publicId, systemId, sysIdEntry);
            definitionMap.put(key, grammar);
        }
        return grammar;
    }

    private static DtdGrammar loadDefinition(String namespace, String rootElement, String publicId, String systemId, SystemIdEntry sysIdEntry) throws IOException {
        DtdGrammar grammar = DtdLoadingUtils.loadDtd(namespace, publicId, systemId, rootElement, sysIdEntry.xmlFormat, sysIdEntry.caseSensitive);
        if (grammar == null) {
            throw new IOException("Could not load : " + sysIdEntry.systemID);
        }
        return grammar;
    }

    private static class SystemIdEntry {
        String systemID;
        boolean xmlFormat;
        boolean caseSensitive;
        URL dtdURL;
        String dtdLocation;

        private SystemIdEntry() {
        }
    }

    public static class DuplicateSystemIdException
    extends Exception {
        DuplicateSystemIdException(String msg) {
            super(msg);
        }
    }
}

