/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util.xpath;

import java.beans.Beans;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.bali.xml.util.xpath.AbstractXPathEvaluator;
import org.w3c.dom.Node;

public class JaxpXPathEvaluator
extends AbstractXPathEvaluator {
    private static final String _JAXP_XPATH_FACTORY_IMPL = "com.sun.org.apache.xpath.internal.jaxp.XPathFactoryImpl";
    private static final String _DTM_MANAGER_SYS_PROP = "com.sun.org.apache.xml.internal.dtm.DTMManager";
    private static final String _DTM_MANAGER_SYS_PROP_VALUE = "com.sun.org.apache.xml.internal.dtm.ref.DTMManagerDefault";
    private XPath _jaxpXPath;

    public XPathFactory getXPathFactory() {
        return JaxpXPathEvaluator.getJaxpXPathFactory();
    }

    public Object evaluateXPath(String expression, Node subtreeRoot, QName returnType) throws XPathExpressionException {
        this._getXPath().setNamespaceContext(this.getXPathNamespaceContext());
        return this._getXPath().evaluate(expression, subtreeRoot, returnType);
    }

    private XPath _getXPath() {
        if (this._jaxpXPath == null) {
            this._jaxpXPath = this.getXPathFactory().newXPath();
        }
        return this._jaxpXPath;
    }

    public static XPathFactory getJaxpXPathFactory() {
        XPathFactory jaxpFactory = null;
        if (Beans.isDesignTime()) {
            try {
                String dtmProp;
                Class<?> jaxpImplClass = Class.forName(_JAXP_XPATH_FACTORY_IMPL);
                if (jaxpImplClass != null) {
                    jaxpFactory = (XPathFactory)jaxpImplClass.newInstance();
                }
                if (jaxpFactory != null && (dtmProp = System.getProperty(_DTM_MANAGER_SYS_PROP)) == null) {
                    String string = System.setProperty(_DTM_MANAGER_SYS_PROP, _DTM_MANAGER_SYS_PROP_VALUE);
                }
            }
            catch (Throwable t) {
                jaxpFactory = null;
            }
        }
        if (jaxpFactory == null) {
            jaxpFactory = XPathFactory.newInstance();
        }
        return jaxpFactory;
    }
}

