/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.structured;

import java.util.Map;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.structured.MutableStructuredMetadataBean;
import oracle.bali.xml.metadata.structured.StructuredMetadataBean;

public class StructuredMetadataConverter {
    public final StructuredMetadataBean convertStructuredMetadataBean(StructuredMetadataBean original, QualifiedName newName) {
        if (original == null) {
            throw new IllegalStateException("convertStructuredMetadataBean passed null original bean");
        }
        if (newName == null) {
            newName = original.getName();
        }
        MutableStructuredMetadataBean newBean = new MutableStructuredMetadataBean(newName);
        Map<QualifiedName, Object> hintMap = original.getHints();
        for (QualifiedName hintName : hintMap.keySet()) {
            this.addHint(newBean, hintName, hintMap.get(hintName));
        }
        Map<QualifiedName, String> propertyMap = original.getProperties();
        for (QualifiedName propertyName : propertyMap.keySet()) {
            this.addProperty(newBean, propertyName, propertyMap.get(propertyName));
        }
        this.setBeanTextValue(newBean, original.getValue());
        for (StructuredMetadataBean child : original.getChildren()) {
            this.addChild(newBean, child);
        }
        return newBean;
    }

    public void addHint(MutableStructuredMetadataBean bean, QualifiedName hintName, Object value) {
        bean.addHint(hintName, value);
    }

    public void addProperty(MutableStructuredMetadataBean bean, QualifiedName propertyName, String value) {
        bean.addProperty(propertyName, value);
    }

    public void setBeanTextValue(MutableStructuredMetadataBean bean, String beanTextValue) {
        bean.setValue(beanTextValue);
    }

    public void addChild(MutableStructuredMetadataBean parent, StructuredMetadataBean child) {
        StructuredMetadataBean newChild = this.convertStructuredMetadataBean(child, child.getName());
        parent.addChild(newChild);
    }
}

