/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.standalone;

import java.util.HashMap;
import java.util.Map;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.standalone.AttributeMetadata;
import oracle.bali.xml.metadata.standalone.ElementMetadata;
import oracle.bali.xml.metadata.standalone.GrammarMetadata;
import oracle.bali.xml.metadata.standalone.OracleStandaloneMetadataFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataGroup {
    private static final String _NAME_ATTR = "name";
    private String _targetNamespace;
    private String _groupName;
    private GrammarMetadata _grammarMetadata;
    private HashMap<QualifiedName, AttributeMetadata> _attributeMetadataMap = new HashMap();
    private HashMap<QualifiedName, ElementMetadata> _elementMetadataMap = new HashMap();

    public MetadataGroup(String targetNamespace, Node defineGroupNode, GrammarMetadata grammarMetadata) {
        this._targetNamespace = targetNamespace;
        this._grammarMetadata = grammarMetadata;
        this._buildMetadataMaps(defineGroupNode);
    }

    public String getTargetNamespace() {
        return this._targetNamespace;
    }

    public String getName() {
        return this._groupName;
    }

    public ElementMetadata getElementMetadataByName(String elementLocalName) {
        return this.getElementMetadataByName(QualifiedName.getQualifiedName(this._targetNamespace, elementLocalName));
    }

    public ElementMetadata getElementMetadataByName(QualifiedName elementQualifiedName) {
        return this._elementMetadataMap.get(elementQualifiedName);
    }

    public AttributeMetadata getAttributeMetadataByName(String attributeLocalName) {
        return this.getAttributeMetadataByName(QualifiedName.getQualifiedName(null, attributeLocalName));
    }

    public AttributeMetadata getAttributeMetadataByName(QualifiedName attributeQualifiedName) {
        return this._attributeMetadataMap.get(attributeQualifiedName);
    }

    public Map<QualifiedName, ElementMetadata> getElementMetadataMap() {
        return this._elementMetadataMap;
    }

    public Map<QualifiedName, AttributeMetadata> getAttributeMetadataMap() {
        return this._attributeMetadataMap;
    }

    private void _buildMetadataMaps(Node defineGroupNode) {
        this._groupName = ((Element)defineGroupNode).getAttributeNS(null, _NAME_ATTR);
        for (Node currNode = defineGroupNode.getFirstChild(); currNode != null; currNode = currNode.getNextSibling()) {
            if (currNode.getNodeType() != 1) continue;
            String localName = currNode.getLocalName();
            if (localName.equals("elementMetadata")) {
                OracleStandaloneMetadataFactory.addElementMetadataToMap(this._targetNamespace, currNode, this._grammarMetadata, this._elementMetadataMap);
                continue;
            }
            if (!localName.equals("attributeMetadata")) continue;
            OracleStandaloneMetadataFactory.addAttributeMetadataToMap(this._targetNamespace, currNode, this._grammarMetadata, false, this._attributeMetadataMap);
        }
    }
}

