/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.standalone;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.MetadataException;
import oracle.bali.xml.metadata.MetadataFunctionRegistry;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.metadata.grammar.GrammarMetadataProvider;
import oracle.bali.xml.metadata.standalone.AttributeMetadata;
import oracle.bali.xml.metadata.standalone.ElementMetadata;
import oracle.bali.xml.metadata.standalone.MetadataComponent;
import oracle.bali.xml.metadata.standalone.MetadataGroup;
import oracle.bali.xml.metadata.standalone.OracleStandaloneMetadataFactory;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFileException;
import oracle.bali.xml.metadata.structured.StructuredMetadataBean;
import oracle.bali.xml.metadata.structured.StructuredMetadataUtils;
import oracle.bali.xml.metadata.util.MetadataProviderUtils;
import oracle.bali.xml.util.XmlNameUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammarMetadata
implements MetadataComponent {
    private static final String _DEFINE_GROUP_NAME = "defineGroup";
    private static final String _SHARED_ATTRIBUTE_METADATA_NAME = "sharedAttributeMetadata";
    private static final String _SHARED_ELEMENT_METADATA_NAME = "sharedElementMetadata";
    private static final String _FUNCTIONS_NAME = "functions";
    private static final String _GLOBAL_METADATA = "globalMetadata";
    private static final String _NAMESPACE_ATTR = "namespace";
    private String _targetNamespace;
    private Map _metadataMap = new HashMap();
    private Map<QualifiedName, AttributeMetadata> _attributeMetadataMap = new HashMap<QualifiedName, AttributeMetadata>();
    private Map<QualifiedName, ElementMetadata> _elementMetadataMap = new HashMap<QualifiedName, ElementMetadata>();
    private Map _defineGroupMap = new HashMap();
    private Map _sharedElementMetadata = new HashMap();
    private Map _sharedAttributeMetadata = new HashMap();
    private MetadataFunctionRegistry _functionRegistry = new MetadataFunctionRegistry();
    private Map<QualifiedName, List<StructuredMetadataBean>> _globalMetadataMap = new LinkedHashMap<QualifiedName, List<StructuredMetadataBean>>();
    public static final String GRAMMAR_METADATA_NAME = "grammarMetadata";
    private static final Logger _LOGGER = Logger.getLogger(GrammarMetadataProvider.class.getName());

    public GrammarMetadata(URL location) throws ParserConfigurationException, IOException, SAXException, StandaloneMetadataFileException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        this._buildMetadataMaps(docBuilder.parse(location.toExternalForm()));
    }

    public GrammarMetadata(Document document) throws StandaloneMetadataFileException {
        this._buildMetadataMaps(document);
    }

    public ElementMetadata getElementMetadataByName(String elementLocalName) {
        return this._elementMetadataMap.get(QualifiedName.getQualifiedName(this._targetNamespace, elementLocalName));
    }

    public Map<QualifiedName, ElementMetadata> getElementMetadataMap() {
        return this._elementMetadataMap;
    }

    public AttributeMetadata getAttributeMetadataByName(String attributeName) {
        return this._attributeMetadataMap.get(QualifiedName.getQualifiedName(this._targetNamespace, attributeName));
    }

    public Map<QualifiedName, AttributeMetadata> getAttributeMetadataMap() {
        return this._attributeMetadataMap;
    }

    public MetadataGroup getMetadataGroupByName(String groupName) {
        return (MetadataGroup)this._defineGroupMap.get(groupName);
    }

    @Override
    public String getTargetNamespace() {
        return this._targetNamespace;
    }

    @Override
    public Map getMetadataMap() {
        return this._metadataMap;
    }

    public Map getSharedElementMetadata() {
        return this._sharedElementMetadata;
    }

    public Map getSharedAttributeMetadata() {
        return this._sharedAttributeMetadata;
    }

    public Object getFunction(String prefix, String name) {
        return this._functionRegistry.getFunction(prefix, name);
    }

    public List<StructuredMetadataBean> getGlobalMetadata(QualifiedName globalItemName) {
        List<StructuredMetadataBean> perGrammarList = this._globalMetadataMap.get(globalItemName);
        if (perGrammarList == null) {
            perGrammarList = Collections.emptyList();
        }
        return perGrammarList;
    }

    private void _buildMetadataMaps(Document doc) throws StandaloneMetadataFileException {
        LogRecord lr;
        Element grammarMetadataNode = doc.getDocumentElement();
        if (!GRAMMAR_METADATA_NAME.equals(grammarMetadataNode.getLocalName())) {
            throw new StandaloneMetadataFileException("Metadata file does not begin with grammarMetadata");
        }
        this._targetNamespace = grammarMetadataNode.getAttributeNS(null, _NAMESPACE_ATTR);
        if ("".equals(this._targetNamespace)) {
            this._targetNamespace = null;
        }
        try {
            XmlNameUtils.validateNamespace(this._targetNamespace);
        }
        catch (Exception e) {
            _LOGGER.log(Level.WARNING, "Standalone metadata file registered for invalid target namespace: " + this._targetNamespace);
            this._targetNamespace = "error:invalid-namespace";
        }
        LinkedList<Element> newFunctions = new LinkedList<Element>();
        LinkedList<Element> oldFunctions = new LinkedList<Element>();
        for (Node currNode = grammarMetadataNode.getFirstChild(); currNode != null; currNode = currNode.getNextSibling()) {
            if (currNode.getNodeType() != 1) continue;
            String currNodeName = currNode.getLocalName();
            if (currNodeName.equals("elementMetadata")) {
                OracleStandaloneMetadataFactory.addElementMetadataToMap(this._targetNamespace, currNode, this, this._elementMetadataMap);
                continue;
            }
            if (currNodeName.equals("attributeMetadata")) {
                OracleStandaloneMetadataFactory.addAttributeMetadataToMap(this._targetNamespace, currNode, this, true, this._attributeMetadataMap);
                continue;
            }
            if (currNodeName.equals(_DEFINE_GROUP_NAME)) {
                this._addDefineGroupToMap(currNode);
                continue;
            }
            if (currNodeName.equals(_SHARED_ELEMENT_METADATA_NAME)) {
                this._addSharedMetadata(currNode.getFirstChild(), this._sharedElementMetadata);
                continue;
            }
            if (currNodeName.equals(_SHARED_ATTRIBUTE_METADATA_NAME)) {
                this._addSharedMetadata(currNode.getFirstChild(), this._sharedAttributeMetadata);
                continue;
            }
            if (currNodeName.equals(_FUNCTIONS_NAME)) {
                oldFunctions.add((Element)currNode);
                continue;
            }
            if (_GLOBAL_METADATA.equals(currNodeName)) {
                for (Node globalChild = currNode.getFirstChild(); globalChild != null; globalChild = globalChild.getNextSibling()) {
                    if (!DomUtils.isElement(globalChild)) continue;
                    Element globalChildElem = (Element)globalChild;
                    QualifiedName globalChildName = DomUtils.getQualifiedName(globalChildElem);
                    if (MetadataProviderUtils.FUNCTIONS_QNAME.equals(globalChildName)) {
                        newFunctions.add((Element)globalChild);
                        continue;
                    }
                    XmlKey ownerNSKey = ImmutableXmlKey.createNamespaceKey(this._targetNamespace);
                    StructuredMetadataBean bean = StructuredMetadataUtils.createStructuredMetadata(globalChildElem, ownerNSKey);
                    if (bean == null) continue;
                    List<StructuredMetadataBean> smdList = this._globalMetadataMap.get(globalChildName);
                    if (smdList == null) {
                        smdList = new ArrayList<StructuredMetadataBean>(5);
                        this._globalMetadataMap.put(globalChildName, smdList);
                    }
                    smdList.add(bean);
                }
                continue;
            }
            MetadataProviderUtils.addMetadataToMap(this._metadataMap, (Element)currNode);
        }
        String preferredPrefix = null;
        String foundPrefix = (String)this._metadataMap.get(MetadataProviderUtils.PREFERRED_PREFIX_QNAME);
        if (foundPrefix != null) {
            preferredPrefix = foundPrefix.trim();
        }
        for (Element functionsEl : oldFunctions) {
            try {
                MetadataProviderUtils.processFunctionsElement(functionsEl, this._functionRegistry, preferredPrefix, true);
            }
            catch (MetadataException e) {
                lr = new LogRecord(Level.WARNING, "Error registering metadata functions from standalone MD for namespace {0}!");
                lr.setThrown(e);
                lr.setParameters(new Object[]{this._targetNamespace});
                _LOGGER.log(lr);
            }
        }
        for (Element functionsEl : newFunctions) {
            try {
                MetadataProviderUtils.processFunctionsElement(functionsEl, this._functionRegistry, null, true);
            }
            catch (MetadataException e) {
                lr = new LogRecord(Level.WARNING, "Error registering metadata functions from standalone MD for namespace {0}!");
                lr.setThrown(e);
                lr.setParameters(new Object[]{this._targetNamespace});
                _LOGGER.log(lr);
            }
        }
    }

    private void _addDefineGroupToMap(Node node) {
        MetadataGroup metadataGroup = new MetadataGroup(this._targetNamespace, node, this);
        this._defineGroupMap.put(metadataGroup.getName(), metadataGroup);
    }

    private void _addSharedMetadata(Node metadataItem, Map metadataMap) {
        while (metadataItem != null) {
            if (metadataItem.getNodeType() == 1) {
                MetadataProviderUtils.addMetadataToMap(metadataMap, (Element)metadataItem);
            }
            metadataItem = metadataItem.getNextSibling();
        }
    }
}

