/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.el.impl;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import oracle.bali.xml.metadata.el.ELException;
import oracle.bali.xml.metadata.el.VariableResolver;
import oracle.bali.xml.metadata.el.impl.ASTOperand;
import oracle.bali.xml.metadata.el.impl.ASTUnaryOperator;
import oracle.bali.xml.metadata.el.impl.PrimitiveTypes;

final class ASTEmpty
extends ASTUnaryOperator {
    private static final ASTEmpty _sInstance = new ASTEmpty();

    public Object apply(VariableResolver vResolver, ASTOperand operand) throws ELException {
        Object result = operand.getValue(vResolver);
        if (result == null) {
            return PrimitiveTypes.getBoolean(true);
        }
        if (result instanceof String) {
            return PrimitiveTypes.getBoolean(((String)result).length() == 0);
        }
        Class<?> resultClass = result.getClass();
        if (resultClass.isArray()) {
            return PrimitiveTypes.getBoolean(Array.getLength(result) == 0);
        }
        if (result instanceof Map) {
            return PrimitiveTypes.getBoolean(((Map)result).isEmpty());
        }
        if (result instanceof Collection) {
            return PrimitiveTypes.getBoolean(((Collection)result).isEmpty());
        }
        return Boolean.FALSE;
    }

    public Class getType(VariableResolver vResolver, ASTOperand operand) throws ELException {
        return Boolean.class;
    }

    public void toString(StringBuffer buffer, ASTOperand operand) {
        buffer.append("(empty ");
        operand.toString(buffer);
        buffer.append(')');
    }

    public static ASTEmpty sharedInstance() {
        return _sInstance;
    }

    private ASTEmpty() {
    }
}

