/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.el.impl;

import oracle.bali.xml.metadata.el.ELException;
import oracle.bali.xml.metadata.el.PropertyResolver;
import oracle.bali.xml.metadata.el.VariableResolver;
import oracle.bali.xml.metadata.el.impl.ASTBinaryOperator;
import oracle.bali.xml.metadata.el.impl.ASTOperand;
import oracle.bali.xml.metadata.el.impl.Coercions;

final class ASTArraySuffix
extends ASTBinaryOperator {
    private final PropertyResolver _presolver;

    public Object apply(VariableResolver vResolver, ASTOperand left, ASTOperand right) throws ELException {
        Object outer = left.getValue(vResolver);
        if (outer == null) {
            return null;
        }
        Object inner = right.getValue(vResolver);
        if (inner == null) {
            return null;
        }
        if (inner instanceof Number) {
            int index = Coercions.toInt(inner);
            return this._presolver.getValue(outer, index);
        }
        return this._presolver.getValue(outer, Coercions.toString(inner));
    }

    public boolean isReadOnly(VariableResolver vResolver, ASTOperand left, ASTOperand right) throws ELException {
        Object outer = left.getValue(vResolver);
        if (outer == null) {
            return true;
        }
        Object inner = right.getValue(vResolver);
        if (inner == null) {
            return true;
        }
        if (inner instanceof Number) {
            int index = Coercions.toInt(inner);
            return this._presolver.isReadOnly(outer, index);
        }
        return this._presolver.isReadOnly(outer, Coercions.toString(inner));
    }

    public void apply(VariableResolver vResolver, ASTOperand left, ASTOperand right, Object value) throws ELException {
        Object outer = left.getValue(vResolver);
        if (outer == null) {
            return;
        }
        Object inner = right.getValue(vResolver);
        if (inner == null) {
            return;
        }
        if (inner instanceof Number) {
            int index = Coercions.toInt(inner);
            this._presolver.setValue(outer, index, value);
        } else {
            this._presolver.setValue(outer, Coercions.toString(inner), value);
        }
    }

    public Class getType(VariableResolver vResolver, ASTOperand left, ASTOperand right) throws ELException {
        Object outer = left.getValue(vResolver);
        if (outer == null) {
            return Object.class;
        }
        Object inner = right.getValue(vResolver);
        if (inner == null) {
            return Object.class;
        }
        if (inner instanceof Number) {
            int index = Coercions.toInt(inner);
            return this._presolver.getType(outer, index);
        }
        return this._presolver.getType(outer, Coercions.toString(inner));
    }

    public void toString(StringBuffer buffer, ASTOperand left, ASTOperand right) {
        left.toString(buffer);
        buffer.append('[');
        right.toString(buffer);
        buffer.append(']');
    }

    ASTArraySuffix(PropertyResolver presolver) {
        this._presolver = presolver;
    }
}

