/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ConstrainingFacet;
import oracle.bali.xml.grammar.SimpleType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeValueUtils {
    public static Set<String> getAttributeValues(AttributeDef attrDef, SimpleType type) {
        if (attrDef.getFixedValue() != null) {
            return Collections.singleton(attrDef.getFixedValue());
        }
        return AttributeValueUtils.getAttributeValues(type);
    }

    public static Set<String> getAttributeValues(AttributeDef attrDef) {
        return AttributeValueUtils.getAttributeValues(attrDef, attrDef.getType());
    }

    public static Set<String> getAttributeValues(SimpleType attributeType) {
        Set<String> values = Collections.emptySet();
        if (attributeType != null) {
            List l;
            Collection facets = attributeType.getConstrainingFacets();
            if (facets != null && !facets.isEmpty()) {
                values = new TreeSet<String>();
                for (ConstrainingFacet aFacet : facets) {
                    Collection facetEnumValues = aFacet.getEnumerationValues();
                    if (facetEnumValues == null || facetEnumValues.isEmpty()) continue;
                    ArrayList enumValueList = new ArrayList(facetEnumValues);
                    for (int j = 0; j < enumValueList.size(); ++j) {
                        String enumValue = enumValueList.get(j).toString();
                        values.add(enumValue);
                    }
                }
            }
            if (attributeType.getVariety() == 2 && (l = attributeType.getUnionMemberTypes()) != null) {
                for (SimpleType type : l) {
                    Set<String> newSet = AttributeValueUtils.getAttributeValues(type);
                    if (newSet == null || newSet.size() <= 0) continue;
                    if (values.isEmpty()) {
                        values = new TreeSet<String>();
                    }
                    values.addAll(newSet);
                }
            }
        }
        return values;
    }

    public static boolean isConstrainedToEnumerations(AttributeDef attrDef) {
        return AttributeValueUtils.isConstrainedToEnumerations(attrDef.getType());
    }

    public static boolean isConstrainedToEnumerations(SimpleType attributeType) {
        boolean constrainedToEnumerations;
        block4: {
            List members;
            int variety;
            block5: {
                constrainedToEnumerations = false;
                if (attributeType == null) break block4;
                variety = attributeType.getVariety();
                if (0 != variety) break block5;
                Collection facets = attributeType.getConstrainingFacets();
                if (facets == null || facets.isEmpty()) break block4;
                for (ConstrainingFacet aFacet : facets) {
                    if (aFacet.getFacetID() != 10) continue;
                    constrainedToEnumerations = true;
                    break block4;
                }
                break block4;
            }
            if (2 == variety && (members = attributeType.getUnionMemberTypes()) != null) {
                for (SimpleType memberType : members) {
                    if (AttributeValueUtils.isConstrainedToEnumerations(memberType)) {
                        constrainedToEnumerations = true;
                        continue;
                    }
                    constrainedToEnumerations = false;
                    break;
                }
            }
        }
        return constrainedToEnumerations;
    }

    public static boolean containsEnumerations(SimpleType attributeType) {
        boolean containsEnumerations;
        block3: {
            List members;
            int variety;
            block4: {
                containsEnumerations = false;
                if (attributeType == null) break block3;
                variety = attributeType.getVariety();
                if (0 != variety) break block4;
                Collection facets = attributeType.getConstrainingFacets();
                if (facets == null || facets.isEmpty()) break block3;
                for (ConstrainingFacet aFacet : facets) {
                    if (aFacet.getFacetID() != 10) continue;
                    containsEnumerations = true;
                    break block3;
                }
                break block3;
            }
            if (2 == variety && (members = attributeType.getUnionMemberTypes()) != null) {
                for (SimpleType memberType : members) {
                    if (!AttributeValueUtils.containsEnumerations(memberType)) continue;
                    containsEnumerations = true;
                    break;
                }
            }
        }
        return containsEnumerations;
    }

    private AttributeValueUtils() {
    }
}

