/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import oracle.bali.xml.grammar.Annotation;
import oracle.bali.xml.grammar.ContentGroup;
import oracle.bali.xml.grammar.Particle;
import oracle.bali.xml.grammar.schema.OracleAnnotation;
import oracle.bali.xml.grammar.schema.OracleElementDef;
import oracle.bali.xml.grammar.schema.OracleSchemaFactory;
import oracle.bali.xml.grammar.schema.OracleWildcard;
import oracle.xml.parser.schema.XSDAny;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDGroup;
import oracle.xml.parser.schema.XSDNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleContentGroup
implements ContentGroup {
    private OracleSchemaFactory _factory = null;
    private XSDGroup _xsdGroup = null;
    private volatile List<Particle> _components = null;
    private volatile Annotation _annotation = null;
    private volatile ContentGroup _referencedContentGroup = null;
    private static final List<Particle> _EMPTY_PARTICLE_LIST = Collections.emptyList();

    @Override
    public String getName() {
        return this._xsdGroup.getName();
    }

    @Override
    public String getTargetNamespace() {
        String namespace = this._xsdGroup.getTargetNS();
        if (namespace != null && namespace.length() == 0) {
            return null;
        }
        return namespace;
    }

    @Override
    public int getMinOccurs() {
        return this._xsdGroup.getMinOccurs();
    }

    @Override
    public int getMaxOccurs() {
        int maxOccurs = this._xsdGroup.getMaxOccurs();
        if (0x7FFFFFF8 == maxOccurs) {
            maxOccurs = -1;
        }
        return maxOccurs;
    }

    @Override
    public boolean isReference() {
        ContentGroup reference = this.getReferencedContentGroup();
        return reference != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentGroup getReferencedContentGroup() {
        if (this._referencedContentGroup == null) {
            OracleContentGroup oracleContentGroup = this;
            synchronized (oracleContentGroup) {
                if (this._referencedContentGroup == null) {
                    String refNamespace = this._xsdGroup.getRefNamespace();
                    String refLocalName = this._xsdGroup.getRefLocalname();
                    if (refLocalName != null) {
                        ContentGroup referencedContentGroup = this._factory.resolveContentGroupReference(refNamespace, refLocalName);
                        this._referencedContentGroup = referencedContentGroup == this ? null : referencedContentGroup;
                    }
                }
            }
        }
        return this._referencedContentGroup;
    }

    @Override
    public Collection getComponents() {
        return this._getComponents();
    }

    @Override
    public int getVariety() {
        int groupVariety = this._xsdGroup.getOrder();
        if (2 == groupVariety) {
            return 7;
        }
        if (1 == groupVariety) {
            return 8;
        }
        if (0 == groupVariety) {
            return 9;
        }
        return 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Annotation getAnnotation() {
        if (this._annotation == null) {
            OracleContentGroup oracleContentGroup = this;
            synchronized (oracleContentGroup) {
                if (this._annotation == null) {
                    this._annotation = new OracleAnnotation((XSDNode)this._xsdGroup);
                }
            }
        }
        return this._annotation;
    }

    OracleContentGroup(OracleSchemaFactory factory, XSDGroup xsdGroup) {
        this._factory = factory;
        this._xsdGroup = xsdGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Particle> _getComponents() {
        if (this._components == null) {
            OracleContentGroup oracleContentGroup = this;
            synchronized (oracleContentGroup) {
                if (this._components == null) {
                    List<Particle> newComponentList = _EMPTY_PARTICLE_LIST;
                    Vector xsdParticles = this._xsdGroup.getNodeVector();
                    if (xsdParticles != null && xsdParticles.size() > 0) {
                        newComponentList = new ArrayList<Particle>(xsdParticles.size());
                        for (int i = 0; i < xsdParticles.size(); ++i) {
                            Object particle = xsdParticles.get(i);
                            if (particle == null) continue;
                            if (particle instanceof XSDElement) {
                                XSDElement element = (XSDElement)particle;
                                OracleElementDef elementWrapper = this._factory.getElementWrapper(element);
                                newComponentList.add(elementWrapper);
                                continue;
                            }
                            if (particle instanceof XSDGroup) {
                                XSDGroup particleGroup = (XSDGroup)particle;
                                OracleContentGroup groupWrapper = this._factory.getContentGroupWrapper(particleGroup);
                                newComponentList.add(groupWrapper);
                                continue;
                            }
                            if (!(particle instanceof XSDAny)) continue;
                            XSDAny xsdAny = (XSDAny)particle;
                            OracleWildcard wildcardWrapper = this._factory.getWildcardWrapper(xsdAny);
                            newComponentList.add(wildcardWrapper);
                        }
                    }
                    this._components = newComponentList;
                }
            }
        }
        return this._components;
    }
}

