/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.bali.xml.grammar.Annotation;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ContentGroup;
import oracle.bali.xml.grammar.Type;
import oracle.bali.xml.grammar.Wildcard;
import oracle.bali.xml.grammar.schema.OracleAnnotation;
import oracle.bali.xml.grammar.schema.OracleAttributeDef;
import oracle.bali.xml.grammar.schema.OracleSchemaFactory;
import oracle.xml.parser.schema.XSDAny;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDGroup;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleComplexType
implements ComplexType {
    private OracleSchemaFactory _factory = null;
    private XSDComplexType _xsdComplexType = null;
    private volatile Type _baseType = null;
    private volatile List<AttributeDef> _attributes = null;
    private volatile ContentGroup _contentGroup = null;
    private volatile Annotation _annotation = null;
    private volatile Wildcard _attributeWildcard = null;
    private static final List<AttributeDef> _EMPTY_ATTRIBUTE_LIST = Collections.emptyList();

    @Override
    public String getName() {
        return this._xsdComplexType.getName();
    }

    @Override
    public String getTargetNamespace() {
        String namespace = this._xsdComplexType.getTargetNS();
        if (namespace != null && namespace.length() == 0) {
            return null;
        }
        return namespace;
    }

    @Override
    public ContentGroup getContentGroup() {
        return this._getContentGroup();
    }

    @Override
    public boolean isAbstract() {
        return this._xsdComplexType.isAbstract();
    }

    @Override
    public Collection getAttributeDefs() {
        return this._getAttributeDefs();
    }

    @Override
    public Wildcard getAttributeWildcard() {
        return this._getAttributeWildcard();
    }

    @Override
    public Type getBaseType() {
        return this._getBaseType();
    }

    @Override
    public int getDerivationMethod() {
        String xsdMethod = this._xsdComplexType.getDerivedMethod();
        if ("extension".equals(xsdMethod)) {
            return 0;
        }
        if ("restriction".equals(xsdMethod)) {
            return 1;
        }
        return 2;
    }

    @Override
    public int getVariety() {
        int complexVariety = this._xsdComplexType.getContent();
        if (12 == complexVariety) {
            return 3;
        }
        if (13 == complexVariety) {
            return 4;
        }
        if (11 == complexVariety) {
            return 5;
        }
        if (10 == complexVariety) {
            return 6;
        }
        return 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Annotation getAnnotation() {
        if (this._annotation == null) {
            OracleComplexType oracleComplexType = this;
            synchronized (oracleComplexType) {
                if (this._annotation == null) {
                    this._annotation = new OracleAnnotation((XSDNode)this._xsdComplexType);
                }
            }
        }
        return this._annotation;
    }

    OracleComplexType(OracleSchemaFactory factory, XSDComplexType xsdComplexType) {
        this._factory = factory;
        this._xsdComplexType = xsdComplexType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContentGroup _getContentGroup() {
        if (this._contentGroup == null) {
            OracleComplexType oracleComplexType = this;
            synchronized (oracleComplexType) {
                XSDGroup xsdGroup;
                if (this._contentGroup == null && (xsdGroup = this._xsdComplexType.getGroup()) != null) {
                    this._contentGroup = this._factory.getContentGroupWrapper(xsdGroup);
                }
            }
        }
        return this._contentGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Type _getBaseType() {
        if (this._baseType == null) {
            OracleComplexType oracleComplexType = this;
            synchronized (oracleComplexType) {
                XSDNode xsdType;
                if (this._baseType == null && (xsdType = this._xsdComplexType.getBaseType()) != null) {
                    if (xsdType instanceof XSDSimpleType) {
                        XSDSimpleType simpleType = (XSDSimpleType)xsdType;
                        this._baseType = this._factory.getSimpleTypeWrapper(simpleType);
                    } else if (xsdType instanceof XSDComplexType) {
                        XSDComplexType complexType = (XSDComplexType)xsdType;
                        this._baseType = this._factory.getComplexTypeWrapper(complexType);
                    }
                }
            }
        }
        return this._baseType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AttributeDef> _getAttributeDefs() {
        if (this._attributes == null) {
            OracleComplexType oracleComplexType = this;
            synchronized (oracleComplexType) {
                if (this._attributes == null) {
                    List<AttributeDef> newAttributeList = _EMPTY_ATTRIBUTE_LIST;
                    XSDAttribute[] attrs = this._xsdComplexType.getAttributeDeclarations();
                    if (attrs != null && attrs.length > 0) {
                        newAttributeList = new ArrayList<AttributeDef>(attrs.length);
                        for (int i = 0; i < attrs.length; ++i) {
                            XSDAttribute anAttribute = attrs[i];
                            if (anAttribute == null) continue;
                            OracleAttributeDef attributeWrapper = this._factory.getAttributeWrapper(anAttribute);
                            newAttributeList.add(attributeWrapper);
                        }
                    }
                    this._attributes = newAttributeList;
                }
            }
        }
        return this._attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Wildcard _getAttributeWildcard() {
        if (this._attributeWildcard == null) {
            OracleComplexType oracleComplexType = this;
            synchronized (oracleComplexType) {
                XSDAny xsdAny;
                if (this._attributeWildcard == null && (xsdAny = this._xsdComplexType.getAttributeWildcard()) != null) {
                    this._attributeWildcard = this._factory.getWildcardWrapper(xsdAny);
                }
            }
        }
        return this._attributeWildcard;
    }
}

