/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ContentGroup;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.bali.xml.grammar.IdentityConstraint;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.SubstitutionGroup;
import oracle.bali.xml.grammar.SubstitutionGroupEvent;
import oracle.bali.xml.grammar.SubstitutionGroupListener;
import oracle.bali.xml.grammar.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractElementDef
implements ElementDef,
SubstitutionGroupListener {
    private volatile Map<QualifiedName, AttributeDef> _attributeMap;
    private volatile Map<QualifiedName, ElementDef> _elementMap;
    private ArrayList<SubstitutionGroup> _substGroups;
    private static final Map<QualifiedName, AttributeDef> _EMPTY_ATTRIBUTE_MAP = Collections.emptyMap();
    private static final Map<QualifiedName, ElementDef> _EMPTY_ELEMENT_MAP = Collections.emptyMap();

    @Override
    public Collection getAttributeDefs() {
        return this._getAttributeMap().values();
    }

    @Override
    public final AttributeDef getAttributeDefByName(String attributeName) {
        return this.getAttributeDefByName(null, attributeName);
    }

    @Override
    public final AttributeDef getAttributeDefByName(String namespace, String attributeName) {
        return this.getAttributeDefByName(QualifiedName.getQualifiedName(namespace, attributeName));
    }

    @Override
    public AttributeDef getAttributeDefByName(QualifiedName qName) {
        return this._getAttributeMap().get(qName);
    }

    @Override
    public Collection getElementDefs() {
        return this._getElementMap().values();
    }

    @Override
    public final ElementDef getElementDefByName(String elementName) {
        return this.getElementDefByName(this.getTargetNamespace(), elementName);
    }

    @Override
    public final ElementDef getElementDefByName(String namespace, String elementName) {
        return this.getElementDefByName(QualifiedName.getQualifiedName(namespace, elementName));
    }

    @Override
    public ElementDef getElementDefByName(QualifiedName qName) {
        return this._getElementMap().get(qName);
    }

    @Override
    public Collection getParentElementDefs() {
        return null;
    }

    @Override
    public boolean isReference() {
        return false;
    }

    @Override
    public ElementDef getReferencedElementDef() {
        return null;
    }

    @Override
    public void addToSubstitutionGroup(ElementDef elementDef) {
        this.getSubstitutionGroup().addElementDef(elementDef);
    }

    @Override
    public void removeFromSubstitutionGroup(ElementDef elementDef) {
        this.getSubstitutionGroup().removeElementDef(elementDef);
    }

    @Override
    public QualifiedName getQualifiedName() {
        return QualifiedName.getQualifiedName(this.getTargetNamespace(), this.getName());
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean hasIdentityConstraints() {
        return false;
    }

    @Override
    public Collection<IdentityConstraint> getIdentityConstraints() {
        return Collections.emptyList();
    }

    @Override
    public void elementAdded(SubstitutionGroupEvent e) {
        if (this._elementMap == null) {
            return;
        }
        ElementDef elementDef = e.getElementDef();
        this._elementMap.put(elementDef.getQualifiedName(), elementDef);
    }

    @Override
    public void elementRemoved(SubstitutionGroupEvent e) {
        if (this._elementMap == null) {
            return;
        }
        ElementDef elementDef = e.getElementDef();
        if (!this._containedInSubstGroups(elementDef)) {
            this._elementMap.remove(elementDef.getQualifiedName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidate() {
        AbstractElementDef abstractElementDef = this;
        synchronized (abstractElementDef) {
            this._attributeMap = null;
            this._elementMap = null;
            if (this._substGroups != null) {
                for (SubstitutionGroup substGroup : this._substGroups) {
                    substGroup.removeSubstitutionGroupListener(this);
                }
            }
            this._substGroups = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<QualifiedName, ElementDef> _getElementMap() {
        Map<QualifiedName, ElementDef> returnMap = this._elementMap;
        if (returnMap == null) {
            AbstractElementDef abstractElementDef = this;
            synchronized (abstractElementDef) {
                if (this._elementMap == null) {
                    Map<QualifiedName, ElementDef> newElementMap = _EMPTY_ELEMENT_MAP;
                    Type elementType = this.getType();
                    if (elementType != null && elementType instanceof ComplexType) {
                        newElementMap = new LinkedHashMap<QualifiedName, ElementDef>();
                        ComplexType complexType = (ComplexType)elementType;
                        ContentGroup group = complexType.getContentGroup();
                        if (group != null) {
                            this._addContentGroup(newElementMap, group);
                        }
                    }
                    this._elementMap = newElementMap;
                }
                returnMap = this._elementMap;
            }
        }
        return returnMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<QualifiedName, AttributeDef> _getAttributeMap() {
        Map<QualifiedName, AttributeDef> returnMap = this._attributeMap;
        if (returnMap == null) {
            AbstractElementDef abstractElementDef = this;
            synchronized (abstractElementDef) {
                if (this._attributeMap == null) {
                    Map<QualifiedName, AttributeDef> newAttributeMap = _EMPTY_ATTRIBUTE_MAP;
                    Type elementType = this.getType();
                    if (elementType != null && elementType instanceof ComplexType) {
                        newAttributeMap = new LinkedHashMap<QualifiedName, AttributeDef>(8);
                        ComplexType complexType = (ComplexType)elementType;
                        Collection attributeDefs = complexType.getAttributeDefs();
                        if (attributeDefs != null) {
                            for (AttributeDef attributeDef : attributeDefs) {
                                if (attributeDef.getName() == null) continue;
                                newAttributeMap.put(attributeDef.getQualifiedName(), attributeDef);
                            }
                        }
                    }
                    this._attributeMap = newAttributeMap;
                }
                returnMap = this._attributeMap;
            }
        }
        return returnMap;
    }

    private void _addContentGroup(Map<QualifiedName, ElementDef> newElementMap, ContentGroup group) {
        Collection groupComponents;
        if (group != null && (groupComponents = group.getComponents()) != null) {
            for (GrammarComponent component : groupComponents) {
                if (component instanceof ContentGroup) {
                    ContentGroup subGroup = (ContentGroup)component;
                    this._addContentGroup(newElementMap, subGroup);
                    continue;
                }
                if (!(component instanceof ElementDef)) continue;
                ElementDef childElement = (ElementDef)component;
                if (!childElement.isAbstract() && childElement.getName() != null) {
                    newElementMap.put(childElement.getQualifiedName(), childElement);
                }
                SubstitutionGroup substGroup = childElement.getSubstitutionGroup();
                if (this._substGroups == null) {
                    this._substGroups = new ArrayList();
                }
                this._substGroups.add(substGroup);
                substGroup.addSubstitutionGroupListener(this);
                Collection substGroupCollection = substGroup.getElementDefs();
                if (substGroupCollection == null) continue;
                for (ElementDef aSubst : substGroupCollection) {
                    newElementMap.put(aSubst.getQualifiedName(), aSubst);
                }
            }
        }
    }

    private boolean _containedInSubstGroups(ElementDef elementDef) {
        if (this._substGroups == null) {
            return false;
        }
        for (SubstitutionGroup substGroup : this._substGroups) {
            if (!substGroup.containsElementDef(elementDef)) continue;
            return true;
        }
        return false;
    }
}

