/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.traversal;

import oracle.bali.xml.dom.traversal.FilteredTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;

public class NodeFilterTreeTraversal
extends FilteredTreeTraversal {
    private final int _whatToShow;
    private final NodeFilter _filter;
    private final TreeTraversal _traversal;

    public NodeFilterTreeTraversal(TreeTraversal traversal, int whatToShow, NodeFilter filter) {
        this._traversal = traversal;
        this._whatToShow = whatToShow;
        this._filter = filter;
    }

    public NodeFilterTreeTraversal(int whatToShow, NodeFilter filter) {
        this(null, whatToShow, filter);
    }

    public int getWhatToShow() {
        return this._whatToShow;
    }

    public NodeFilter getNodeFilter() {
        return this._filter;
    }

    protected short acceptNode(Node node) {
        short nodeType;
        int typeMask;
        int whatToShow = this.getWhatToShow();
        if (whatToShow != -1 && (whatToShow & (typeMask = 1 << (nodeType = node.getNodeType()) - 1)) == 0) {
            return 3;
        }
        NodeFilter filter = this.getNodeFilter();
        if (filter != null) {
            return filter.acceptNode(node);
        }
        return 1;
    }

    protected TreeTraversal getBeforeTraversal() {
        if (this._traversal != null) {
            return this._traversal;
        }
        return super.getBeforeTraversal();
    }
}

