/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.position;

import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.QualifiedName;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DomPositionFactory {
    public static DomPosition createDomPosition(Node targetNode, int relativePosition) {
        return new DomPosition(targetNode, relativePosition);
    }

    public static DomPosition createAttributePosition(Element targetElement, QualifiedName attrQName, int textOffset) {
        return new DomPosition(targetElement, attrQName, textOffset);
    }

    public static DomPosition createDomPosition(Element targetElement, QualifiedName attrQName, int textOffset) {
        return DomPositionFactory.createAttributePosition(targetElement, attrQName, textOffset);
    }

    public static DomPosition createAttributePosition(Attr attr, int textOffset) {
        return DomPositionFactory.createAttributePosition(attr.getOwnerElement(), DomUtils.getQualifiedName(attr), textOffset);
    }

    public static DomPosition createTextPosition(CharacterData targetTextNode, int textOffset) {
        return DomPosition.createTextPosition(targetTextNode, textOffset);
    }

    public static DomPosition createInsideOrAfterPosition(Node targetNode) {
        return DomPosition.createInsideOrAfterPosition(targetNode);
    }

    public static DomPosition createInsideOrBeforePosition(Node targetNode) {
        return DomPosition.createInsideOrBeforePosition(targetNode);
    }

    public static DomPosition before(Node node) {
        return DomPosition.before(node);
    }

    public static DomPosition after(Node node) {
        return DomPosition.after(node);
    }

    public static DomPosition inside(Node node) {
        return DomPosition.inside(node);
    }

    public static DomPosition beforeFirstChildOrInside(Node parent) {
        Node child = parent.getFirstChild();
        if (child == null) {
            return DomPositionFactory.inside(parent);
        }
        return DomPositionFactory.before(child);
    }

    public static DomPosition afterLastChildOrInside(Node parent) {
        Node child = parent.getLastChild();
        if (child == null) {
            return DomPositionFactory.inside(parent);
        }
        return DomPositionFactory.after(child);
    }

    public static DomPosition firstOffsetOrBefore(Node node) {
        if (node instanceof CharacterData) {
            return DomPositionFactory.createTextPosition((CharacterData)node, 0);
        }
        if (node instanceof Attr) {
            return DomPositionFactory.createAttributePosition((Attr)node, 0);
        }
        return DomPositionFactory.before(node);
    }

    public static DomPosition lastOffsetOrAfter(Node node) {
        if (node instanceof CharacterData) {
            CharacterData cd = (CharacterData)node;
            return DomPositionFactory.createTextPosition(cd, cd.getLength());
        }
        if (node instanceof Attr) {
            Attr attr = (Attr)node;
            return DomPositionFactory.createAttributePosition(attr, attr.getValue().length());
        }
        return DomPositionFactory.after(node);
    }

    public static DomPosition asTextOffsetPositionIfPossible(DomPosition orig) {
        boolean attemptStart;
        Node attemptNode;
        if (orig.hasTextOffset()) {
            return orig;
        }
        Node target = orig.getTargetNode();
        if (DomUtils.isText(target)) {
            CharacterData text = (CharacterData)target;
            if (orig.isBefore()) {
                return DomPositionFactory.createTextPosition(text, 0);
            }
            assert (orig.isAfter());
            return DomPositionFactory.createTextPosition(text, text.getLength());
        }
        if (orig.isBefore()) {
            attemptNode = target.getPreviousSibling();
            attemptStart = false;
        } else if (orig.isAfter()) {
            attemptNode = target.getNextSibling();
            attemptStart = true;
        } else {
            assert (orig.isInside());
            attemptNode = target.getLastChild();
            attemptStart = false;
        }
        if (DomUtils.isText(attemptNode)) {
            CharacterData text = (CharacterData)attemptNode;
            int index = attemptStart ? 0 : text.getLength();
            return DomPositionFactory.createTextPosition(text, index);
        }
        return orig;
    }

    private DomPositionFactory() {
    }
}

