/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands.modeler;

import java.text.MessageFormat;
import java.util.Map;
import oracle.dbtools.crest.exports.ddl.DDLFileMaker;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.swingui.ddl.DDLConfig;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.commands.modeler.AbstractModelerGenerator;
import oracle.dbtools.raptor.scriptrunner.commands.modeler.Messages;

public class ModelerDDLGenerator
extends AbstractModelerGenerator {
    private String outputFileName;
    private String ddlConfigFileName;
    private String dbSiteName;

    public ModelerDDLGenerator(ScriptRunnerContext ctx, Map<String, String> arguments) {
        super(ctx, arguments);
        this.outputFileName = arguments.get("-OUTPUTFILE");
        this.ddlConfigFileName = arguments.get("-DDLCONFIGFILE");
        this.dbSiteName = arguments.get("-DBSITE");
    }

    public void generateDDL() {
        try {
            RelationalDesign relModel = this.loadRelationalModel(this.designFileName, this.relModelName, this.dbSiteName);
            if (relModel != null) {
                StorageDesign sd = relModel.getStorageDesign();
                if (this.ddlConfigFileName != null && !"".equalsIgnoreCase(this.ddlConfigFileName)) {
                    DDLConfig.loadConfig((String)this.ddlConfigFileName, (RelationalDesign)relModel);
                }
                DDLFileMaker ddlFileMaker = new DDLFileMaker(relModel.getDesign());
                ddlFileMaker.setStorageDesign(sd);
                ddlFileMaker.generateDDLContent();
                String content = ddlFileMaker.getContent();
                if (this.outputFileName != null) {
                    this.saveLocalCopy(this.outputFileName, content);
                } else {
                    this.ctx.write("\n");
                    this.ctx.write(content);
                }
            } else {
                this.ctx.write(Messages.getString("RELATIONAL_MODEL_NOT_EXISTS"));
            }
        }
        catch (Exception e) {
            this.ctx.write(MessageFormat.format(Messages.getString("MODELER_GENERIC_ERROR"), e.getMessage()));
        }
    }
}

