/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.UIResource;
import oracle.maps.core.GeoObject;
import oracle.maps.core.HoverableLayer;
import oracle.maps.core.Layer;
import oracle.maps.core.LayerManager;
import oracle.maps.core.MapCanvas;
import oracle.maps.core.SelectionEvent;
import oracle.maps.core.SelectionListener;
import oracle.maps.geoobject.AbstractFeature;
import oracle.maps.geoobject.GeometryFeature;
import oracle.maps.layer.ui.FeatureTipLayer;
import oracle.maps.layer.ui.MapNavLayer;
import oracle.maps.layer.ui.ScaleBarLayer;
import oracle.maps.layer.ui.SimpleBGLayer;
import oracle.maps.tools.FeaturePickTool;
import oracle.mapviewer.share.AnnotationTextMetadata;
import oracle.mapviewer.share.FeatureConflictDescriptor;
import oracle.mapviewer.share.Field;
import oracle.mdeditor.MapConstants;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.session.layer.WorkspaceLayer;
import oracle.mdeditor.ui.ErrorDialog;
import oracle.mdeditor.ui.OlafDialog;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.sdovis.text.AnnotationText;
import oracle.spatial.edit.index.AbstractIndexedDataSet;
import oracle.spatial.edit.index.annotationtext.IndexedAnnotationTextSet;
import oracle.spatial.edit.index.geometry.IndexedGeometrySet;
import oracle.spatial.edit.layer.AbstractDataSetLayer;
import oracle.spatial.edit.layer.AnnotationTextSetLayer;
import oracle.spatial.edit.layer.GeometrySetLayer;
import oracle.spatial.edit.model.AbstractDataSet;
import oracle.spatial.edit.model.annotationtext.AnnotationTextFeature;
import oracle.spatial.edit.model.annotationtext.AnnotationTextSet;
import oracle.spatial.edit.model.geometry.GeometrySet;
import oracle.spatial.edit.producer.AbstractDataSetProducer;
import oracle.spatial.edit.producer.AnnotationTextSetProducer;
import oracle.spatial.edit.producer.GeometrySetProducer;
import oracle.spatial.edit.session.MDSEditSession;
import oracle.spatial.geometry.JGeometry;
import sun.swing.DefaultLookup;

public class MergeWorkspacePanel
extends JPanel {
    protected Hashtable<WorkspaceLayer, Vector<FeatureConflictDescriptor>> conflicts = null;
    protected Hashtable<String, FeatureConflictRecord> records = null;
    protected MDSEditSession editSession = null;
    protected OlafDialog dlg = null;
    protected ConflictListModel listModel = new ConflictListModel();
    protected JList featureList = null;
    protected ConflictAttributeSelectionPanel attrSelectPane = null;
    protected JScrollPane attrSelectScrollPane = null;
    protected GridBagConstraints attrSPConstraints = null;
    protected ImageIcon resolvedImage = Icons.getIcon("check.png");
    protected ImageIcon unresolvedImage = Icons.getIcon("delete.gif");
    protected MapCanvas miniCanvas = null;
    protected Hashtable<String, Layer> backgroundLayers = null;
    protected Hashtable<String, Rectangle2D> layerMBRs = null;
    protected FeatureConflictRecord previousRecord = null;
    protected String backgroundFeaturesStyle = "color_gray_black_255";
    protected String activeFeaturesStyle = "color_red_black_90";
    protected String labelStyle = "text_Dialog_red_12_false_false";

    public MergeWorkspacePanel(MDSEditSession editSession, Hashtable<WorkspaceLayer, Vector<FeatureConflictDescriptor>> conflicts, OlafDialog dlg) {
        this.editSession = editSession;
        this.conflicts = conflicts;
        this.dlg = dlg;
        dlg.setContentPane(this);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private boolean isSpatialObject(Object o) {
        return o instanceof JGeometry || o instanceof AnnotationText;
    }

    private int getSpatialObjectSRID(Object o) {
        if (o instanceof JGeometry) {
            return ((JGeometry)o).getSRID();
        }
        if (o instanceof AnnotationText) {
            return ((AnnotationText)o).getEnvelope().getSRID();
        }
        return -1;
    }

    private Rectangle2D getSpatialObjectMBR(Object o) {
        if (o instanceof JGeometry) {
            double[] cm = ((JGeometry)o).getMBR();
            return new Rectangle2D.Double(cm[0], cm[1], cm[2] - cm[0], cm[3] - cm[1]);
        }
        if (o instanceof AnnotationText) {
            return this.getSpatialObjectMBR(((AnnotationText)o).getEnvelope());
        }
        return null;
    }

    private void jbInit() throws Exception {
        Layer layer;
        this.records = new Hashtable();
        for (WorkspaceLayer layer2 : this.conflicts.keySet()) {
            for (FeatureConflictDescriptor fcd : this.conflicts.get(layer2)) {
                FeatureConflictRecord record = this.records.get(layer2.getName() + "@" + fcd.getKey());
                if (record == null) {
                    record = new FeatureConflictRecord();
                    record.setKey(fcd.getKey());
                    record.setLayer(layer2.getName());
                    record.setConflicts(new Vector<FeatureConflictDescriptor>());
                    record.setResolved(false);
                    this.listModel.addElement(record);
                    this.records.put(layer2.getName() + "@" + fcd.getKey(), record);
                }
                record.getConflicts().add(fcd);
                if (!this.isSpatialObject(fcd.getChildValue())) continue;
                if (this.miniCanvas == null) {
                    this.miniCanvas = new MapCanvas();
                    this.miniCanvas.setPreferredSize(new Dimension(340, 250));
                    this.miniCanvas.setBorder(BorderFactory.createLineBorder(Color.BLACK));
                    LayerManager layerManager = this.miniCanvas.getLayerManager();
                    SimpleBGLayer simpleBGLayer = new SimpleBGLayer(this.miniCanvas);
                    layerManager.add(simpleBGLayer, MapConstants.POSITION_BACKGROUND_LAYERS);
                    layerManager.tag((Layer)simpleBGLayer, new String[]{"controlLayer", "backgroundLayer"});
                    ScaleBarLayer sbl = new ScaleBarLayer(this.miniCanvas);
                    layerManager.add(sbl, MapConstants.POSITION_OVERDATA_LAYERS);
                    layerManager.tag((Layer)sbl, new String[]{"scaleBarLayer", "controlLayer"});
                    FeaturePickTool pickTool = new FeaturePickTool(this.miniCanvas);
                    layerManager.add(pickTool, MapConstants.POSITION_OVERDATA_LAYERS);
                    layerManager.tag((Layer)pickTool, "toolLayer");
                    MapNavLayer mapNavLayer = new MapNavLayer(this.miniCanvas);
                    layerManager.add(mapNavLayer, MapConstants.POSITION_OVERHEAD_LAYERS);
                    layerManager.tag((Layer)mapNavLayer, new String[]{"mapNavigationLayer", "controlLayer"});
                    FeatureTipLayer ftl = new FeatureTipLayer(this.miniCanvas);
                    layerManager.add(ftl, MapConstants.POSITION_OVERHEAD_LAYERS);
                    layerManager.tag((Layer)ftl, new String[]{"featureTipLayer", "controlLayer"});
                    int srid = this.getSpatialObjectSRID(fcd.getChildValue());
                    this.miniCanvas.getMapRegion().setMapSrid(srid);
                    this.miniCanvas.getMapRegion().setDataWindowSrid(srid);
                    this.backgroundLayers = new Hashtable();
                    this.layerMBRs = new Hashtable();
                }
                Rectangle2D combinedMBR = this.getSpatialObjectMBR(fcd.getChildValue());
                combinedMBR.add(this.getSpatialObjectMBR(fcd.getParentValue()));
                AffineTransform at = new AffineTransform();
                at.setToTranslation(combinedMBR.getCenterX(), combinedMBR.getCenterY());
                at.scale(1.15, 1.15);
                at.translate(-combinedMBR.getCenterX(), -combinedMBR.getCenterY());
                combinedMBR = at.createTransformedShape(combinedMBR).getBounds2D();
                record.setConflictView(combinedMBR);
                if (this.layerMBRs == null) continue;
                Rectangle2D mbr = this.layerMBRs.get(layer2.getName());
                if (mbr == null) {
                    mbr = (Rectangle2D)combinedMBR.clone();
                    this.layerMBRs.put(layer2.getName(), mbr);
                    continue;
                }
                mbr.add(combinedMBR);
            }
        }
        this.featureList = new JList(this.listModel);
        this.featureList.setSelectedIndex(0);
        this.featureList.setCellRenderer(new ConflictListCellRenderer());
        this.featureList.setSelectionMode(0);
        this.featureList.setLayoutOrientation(2);
        this.featureList.setVisibleRowCount(-1);
        this.featureList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index;
                if (!e.getValueIsAdjusting() && (index = MergeWorkspacePanel.this.featureList.getSelectedIndex()) != -1) {
                    Layer layer;
                    FeatureConflictRecord record = (FeatureConflictRecord)MergeWorkspacePanel.this.listModel.get(index);
                    String baseTable = "";
                    if (record != null && MergeWorkspacePanel.this.editSession != null && (layer = MergeWorkspacePanel.this.editSession.getLayers().getLayerByName(record.getLayer())) != null) {
                        baseTable = " (" + layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable") + ")";
                    }
                    MergeWorkspacePanel.this.remove(MergeWorkspacePanel.this.attrSelectScrollPane);
                    MergeWorkspacePanel.this.attrSelectPane = new ConflictAttributeSelectionPanel(record, MergeWorkspacePanel.this.editSession.getName());
                    MergeWorkspacePanel.this.attrSelectScrollPane = new JScrollPane(MergeWorkspacePanel.this.attrSelectPane);
                    MergeWorkspacePanel.this.attrSelectScrollPane.setBorder(BorderFactory.createTitledBorder(MessagesBundle.getMessage("Conflicts") + baseTable));
                    MergeWorkspacePanel.this.add((Component)MergeWorkspacePanel.this.attrSelectScrollPane, MergeWorkspacePanel.this.attrSPConstraints);
                    MergeWorkspacePanel.this.revalidate();
                }
            }
        });
        this.setLayout(new GridBagLayout());
        JScrollPane listScrollPane = new JScrollPane(this.featureList);
        listScrollPane.setBorder(BorderFactory.createTitledBorder(MessagesBundle.getMessage("Features")));
        FeatureConflictRecord record = (FeatureConflictRecord)this.listModel.get(this.featureList.getSelectedIndex());
        String baseTable = "";
        if (record != null && this.editSession != null && (layer = this.editSession.getLayers().getLayerByName(record.getLayer())) != null) {
            baseTable = " (" + layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable") + ")";
        }
        this.attrSelectPane = new ConflictAttributeSelectionPanel(record, this.editSession.getName());
        this.attrSelectScrollPane = new JScrollPane(this.attrSelectPane);
        this.attrSelectScrollPane.setBorder(BorderFactory.createTitledBorder(MessagesBundle.getMessage("Conflicts") + baseTable));
        this.add((Component)listScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.attrSPConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0);
        this.add((Component)this.attrSelectScrollPane, this.attrSPConstraints);
        this.dlg.getOkButton().setEnabled(false);
    }

    public boolean allSolved() {
        for (WorkspaceLayer layer : this.conflicts.keySet()) {
            for (FeatureConflictDescriptor fcd : this.conflicts.get(layer)) {
                if (fcd.getResolveWorkspace() != null) continue;
                return false;
            }
        }
        return true;
    }

    public boolean anySolved() {
        for (WorkspaceLayer layer : this.conflicts.keySet()) {
            for (FeatureConflictDescriptor fcd : this.conflicts.get(layer)) {
                if (fcd.getResolveWorkspace() == null) continue;
                return true;
            }
        }
        return false;
    }

    private class ConflictAttributeSelectionPanel
    extends JPanel
    implements ItemListener,
    SelectionListener {
        JCheckBox allChild;
        JCheckBox allParent;
        ArrayList<AttrDisplay> childElems;
        ArrayList<AttrDisplay> parentElems;
        Hashtable<String, AttrDisplay> geomDisplays;

        public ConflictAttributeSelectionPanel(FeatureConflictRecord record, String sessionName) {
            this.allChild = new JCheckBox(MessagesBundle.getMessage("All") + " " + MergeWorkspacePanel.this.editSession.getName());
            this.allParent = new JCheckBox(MessagesBundle.getMessage("All") + " LIVE");
            this.childElems = null;
            this.parentElems = null;
            this.geomDisplays = null;
            Vector<FeatureConflictDescriptor> conflicts = record.getConflicts();
            if (conflicts == null || conflicts.size() == 0) {
                return;
            }
            this.setLayout(new GridBagLayout());
            this.allChild.addItemListener(this);
            this.allParent.addItemListener(this);
            JPanel allChildPanel = new JPanel();
            allChildPanel.setLayout(new GridBagLayout());
            JPanel allParentPanel = new JPanel();
            allParentPanel.setLayout(new GridBagLayout());
            allChildPanel.add((Component)this.allChild, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            allParentPanel.add((Component)this.allParent, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            int gY = 0;
            boolean headerAdded = false;
            this.childElems = new ArrayList(conflicts.size());
            this.parentElems = new ArrayList(conflicts.size());
            for (FeatureConflictDescriptor fcd : conflicts) {
                int srid;
                AbstractDataSetLayer idxLayer;
                if (!MergeWorkspacePanel.this.isSpatialObject(fcd.getChildValue())) continue;
                if (!headerAdded) {
                    MergeWorkspacePanel.this.miniCanvas.getMapRegion().setDataWindow(record.getConflictView());
                    this.add((Component)MergeWorkspacePanel.this.miniCanvas, new GridBagConstraints(0, gY, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                    this.add((Component)allChildPanel, new GridBagConstraints(1, ++gY, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                    this.add((Component)allParentPanel, new GridBagConstraints(2, gY, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                    ++gY;
                    headerAdded = true;
                }
                if (this.geomDisplays == null) {
                    this.geomDisplays = new Hashtable();
                }
                Layer layer = MergeWorkspacePanel.this.editSession.getLayers().getLayerByName(record.getLayer());
                if (MergeWorkspacePanel.this.backgroundLayers != null && MergeWorkspacePanel.this.backgroundLayers.get(record.getLayer()) == null) {
                    AbstractDataSet ads = null;
                    if (fcd.getChildValue() instanceof JGeometry) {
                        ads = new GeometrySet();
                    } else if (fcd.getChildValue() instanceof AnnotationText) {
                        ads = new AnnotationTextSet();
                    }
                    ads.setName("background");
                    AbstractIndexedDataSet indexedSet = null;
                    AbstractDataSetProducer idxProd = null;
                    idxLayer = null;
                    if (fcd.getChildValue() instanceof JGeometry) {
                        indexedSet = new IndexedGeometrySet((GeometrySet)ads);
                        idxLayer = new GeometrySetLayer(MergeWorkspacePanel.this.miniCanvas, (IndexedGeometrySet)indexedSet);
                        idxProd = new GeometrySetProducer((GeometrySetLayer)idxLayer);
                    } else if (fcd.getChildValue() instanceof AnnotationText) {
                        indexedSet = new IndexedAnnotationTextSet((AnnotationTextSet)ads);
                        idxLayer = new AnnotationTextSetLayer(MergeWorkspacePanel.this.miniCanvas, (IndexedAnnotationTextSet)indexedSet);
                        idxProd = new AnnotationTextSetProducer((AnnotationTextSetLayer)idxLayer);
                    }
                    srid = MergeWorkspacePanel.this.getSpatialObjectSRID(fcd.getChildValue());
                    idxProd.setTargetSRID(srid);
                    idxLayer.setName(ads.getName());
                    idxLayer.setSRID(srid);
                    idxLayer.setDataSource(((AbstractDataSetLayer)layer).getDataSource());
                    idxLayer.setGeoDataProducer(idxProd);
                    idxLayer.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable", layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable"));
                    idxLayer.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keyColumn", layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keyColumn"));
                    idxLayer.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn", layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn"));
                    idxLayer.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.renderStyle", MergeWorkspacePanel.this.backgroundFeaturesStyle);
                    idxLayer.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.renderOnMapviewer", Boolean.toString(false));
                    MergeWorkspacePanel.this.backgroundLayers.put(record.getLayer(), idxLayer);
                }
                if (record.getActiveLayer() == null) {
                    AbstractFeature childFeature = null;
                    AbstractFeature parentFeature = null;
                    AbstractIndexedDataSet indexedSet = null;
                    idxLayer = null;
                    if (fcd.getChildValue() instanceof JGeometry) {
                        childFeature = new GeometryFeature();
                        parentFeature = new GeometryFeature();
                        indexedSet = new IndexedGeometrySet(new GeometrySet());
                        idxLayer = new GeometrySetLayer(MergeWorkspacePanel.this.miniCanvas, (IndexedGeometrySet)indexedSet);
                    } else if (fcd.getChildValue() instanceof AnnotationText) {
                        childFeature = new AnnotationTextFeature();
                        parentFeature = new AnnotationTextFeature();
                        AnnotationTextMetadata atm = ((AnnotationTextSet)((AnnotationTextSetLayer)MergeWorkspacePanel.this.backgroundLayers.get(record.getLayer())).getIndexedDataSet().getDataSet()).getMetadata();
                        indexedSet = new IndexedAnnotationTextSet(new AnnotationTextSet());
                        idxLayer = new AnnotationTextSetLayer(MergeWorkspacePanel.this.miniCanvas, (IndexedAnnotationTextSet)indexedSet);
                    }
                    childFeature.setSpatialAttribute(fcd.getChildValue());
                    childFeature.setAttribute("key", Field.createField((String)sessionName, (String)"string"));
                    childFeature.setLayer(idxLayer);
                    parentFeature.setSpatialAttribute(fcd.getParentValue());
                    parentFeature.setAttribute("key", Field.createField((String)"LIVE", (String)"string"));
                    parentFeature.setLayer(idxLayer);
                    srid = MergeWorkspacePanel.this.getSpatialObjectSRID(fcd.getChildValue());
                    idxLayer.setName("active");
                    idxLayer.setSRID(srid);
                    idxLayer.setDataSource(((AbstractDataSetLayer)layer).getDataSource());
                    idxLayer.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable", layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable"));
                    idxLayer.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keyColumn", "key");
                    idxLayer.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn", layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn"));
                    idxLayer.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.renderStyle", MergeWorkspacePanel.this.activeFeaturesStyle);
                    idxLayer.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.renderOnMapviewer", Boolean.toString(false));
                    try {
                        indexedSet.appendFeature(childFeature);
                        indexedSet.appendFeature(parentFeature);
                    }
                    catch (Exception ex) {
                        ErrorDialog.showErrorDialog(ex, this, "Could not append features", "Error", 2);
                    }
                    record.setActiveLayer(idxLayer);
                }
                this.addConflict(record, fcd, gY);
                ++gY;
            }
            if (MergeWorkspacePanel.this.miniCanvas != null && record.getActiveLayer() != null) {
                LayerManager lm = MergeWorkspacePanel.this.miniCanvas.getLayerManager();
                if (MergeWorkspacePanel.this.previousRecord == null || MergeWorkspacePanel.this.previousRecord.getLayer() != record.getLayer()) {
                    lm.removeAll(lm.filterSetByTags(new String[]{"dataLayer"}));
                    lm.add(MergeWorkspacePanel.this.backgroundLayers.get(record.getLayer()), MapConstants.POSITION_DATA_LAYERS);
                    lm.tag(MergeWorkspacePanel.this.backgroundLayers.get(record.getLayer()), "dataLayer");
                } else {
                    lm.remove(MergeWorkspacePanel.this.previousRecord.getActiveLayer());
                }
                lm.add(record.getActiveLayer(), MapConstants.POSITION_DATA_LAYERS + 1);
                lm.tag((Layer)record.getActiveLayer(), "selectionLayer");
                lm.tag((Layer)record.getActiveLayer(), "dataLayer");
                record.getActiveLayer().addSelectionListener(this);
                MergeWorkspacePanel.this.previousRecord = record;
            }
            Collections.sort(conflicts, new Comparator<FeatureConflictDescriptor>(){

                @Override
                public int compare(FeatureConflictDescriptor o1, FeatureConflictDescriptor o2) {
                    return o1.getAttribute().compareToIgnoreCase(o2.getAttribute());
                }
            });
            for (FeatureConflictDescriptor fcd : conflicts) {
                if (MergeWorkspacePanel.this.isSpatialObject(fcd.getChildValue())) continue;
                if (!headerAdded) {
                    this.add((Component)allChildPanel, new GridBagConstraints(1, gY, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                    this.add((Component)allParentPanel, new GridBagConstraints(2, gY, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                    ++gY;
                    headerAdded = true;
                }
                this.addConflict(record, fcd, gY);
                ++gY;
            }
            if (MergeWorkspacePanel.this.miniCanvas == null || record.getActiveLayer() == null) {
                this.add((Component)new JPanel(), new GridBagConstraints(0, gY, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.add((Component)new JPanel(), new GridBagConstraints(1, gY, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.add((Component)new JPanel(), new GridBagConstraints(2, gY, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
        }

        private void addConflict(FeatureConflictRecord record, FeatureConflictDescriptor fcd, int gY) {
            Color alternateColor;
            Object childValue = fcd.getChildValue();
            AbstractFeature childGeo = null;
            if (fcd.isChildRecordDeleted()) {
                childValue = "DELETED";
            } else if (MergeWorkspacePanel.this.isSpatialObject(childValue)) {
                childValue = MergeWorkspacePanel.this.editSession.getName();
                childGeo = record.getActiveLayer().getIndexedDataSet().getAbstractFeature(MergeWorkspacePanel.this.editSession.getName());
            }
            Object parentValue = fcd.getParentValue();
            AbstractFeature parentGeo = null;
            if (fcd.isParentRecordDeleted()) {
                parentValue = "DELETED";
            } else if (MergeWorkspacePanel.this.isSpatialObject(parentValue)) {
                parentValue = "LIVE";
                parentGeo = record.getActiveLayer().getIndexedDataSet().getAbstractFeature("LIVE");
            }
            boolean childSelected = false;
            boolean parentSelected = false;
            if (fcd.getResolveWorkspace() != null) {
                if (fcd.getResolveWorkspace().equals("CHILD")) {
                    childSelected = true;
                } else {
                    parentSelected = true;
                }
            }
            JPanel attrDisplay = new JPanel();
            attrDisplay.setLayout(new GridBagLayout());
            attrDisplay.add((Component)new JLabel(fcd.getAttribute()), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            ButtonGroup bg = new ButtonGroup();
            AttrDisplay childDisplay = new AttrDisplay(childValue.toString(), childSelected, bg, this.allParent, record, fcd, "CHILD");
            AttrDisplay parentDisplay = new AttrDisplay(parentValue.toString(), parentSelected, bg, this.allChild, record, fcd, "PARENT");
            if (childGeo != null) {
                this.geomDisplays.put(childGeo.getKey().toString(), childDisplay);
            }
            if (parentGeo != null) {
                this.geomDisplays.put(parentGeo.getKey().toString(), parentDisplay);
            }
            if (record.getActiveLayer() != null) {
                AbstractFeature parentHover;
                AbstractFeature childHover = record.getActiveLayer().getIndexedDataSet().getAbstractFeature(MergeWorkspacePanel.this.editSession.getName());
                if (childHover != null) {
                    childDisplay.setCanvas(MergeWorkspacePanel.this.miniCanvas);
                    childDisplay.setLinkedObj(childHover);
                }
                if ((parentHover = record.getActiveLayer().getIndexedDataSet().getAbstractFeature("LIVE")) != null) {
                    parentDisplay.setCanvas(MergeWorkspacePanel.this.miniCanvas);
                    parentDisplay.setLinkedObj(parentHover);
                }
            }
            this.childElems.add(childDisplay);
            this.parentElems.add(parentDisplay);
            Color background = this.getBackground();
            if ((background == null || background instanceof UIResource) && (alternateColor = DefaultLookup.getColor(this, this.ui, "Table.alternateRowColor")) != null && gY % 2 != 0) {
                background = alternateColor;
            }
            attrDisplay.setBackground(background);
            childDisplay.setBackground(background);
            parentDisplay.setBackground(background);
            this.add((Component)attrDisplay, new GridBagConstraints(0, gY, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)childDisplay, new GridBagConstraints(1, gY, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)parentDisplay, new GridBagConstraints(2, gY, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                ArrayList<AttrDisplay> toSelect = null;
                JCheckBox toDeselect = null;
                if (e.getSource() == this.allChild) {
                    toSelect = this.childElems;
                    toDeselect = this.allParent;
                } else if (e.getSource() == this.allParent) {
                    toSelect = this.parentElems;
                    toDeselect = this.allChild;
                }
                if (toSelect != null && toDeselect != null) {
                    toDeselect.setSelected(false);
                    for (AttrDisplay elem : toSelect) {
                        elem.setSelected(true);
                    }
                }
            }
        }

        @Override
        public void selectionChanged(SelectionEvent e) {
            List<GeoObject> selected = MergeWorkspacePanel.this.miniCanvas.getLayerManager().getAllSelections();
            if (selected.size() != 1) {
                return;
            }
            AttrDisplay ad = this.geomDisplays.get(selected.get(0).getKey().toString());
            if (ad != null) {
                ad.setSelected(true);
            }
            MergeWorkspacePanel.this.miniCanvas.getLayerManager().clearAllSelections();
        }
    }

    private class AttrDisplay
    extends JPanel
    implements ItemListener,
    MouseListener {
        FeatureConflictRecord record = null;
        FeatureConflictDescriptor fcd = null;
        String resolveWorkspace = null;
        JRadioButton radio = null;
        JCheckBox deselect = null;
        MapCanvas canvas = null;
        GeoObject linkedObj = null;

        public AttrDisplay(String value, boolean selected, ButtonGroup bg, JCheckBox deselect, FeatureConflictRecord record, FeatureConflictDescriptor fcd, String resolveWorkspace) {
            this.deselect = deselect;
            this.record = record;
            this.fcd = fcd;
            this.resolveWorkspace = resolveWorkspace;
            this.setLayout(new GridBagLayout());
            this.radio = new JRadioButton(value, selected);
            this.add((Component)this.radio, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.radio.addItemListener(this);
            this.radio.addMouseListener(this);
            bg.add(this.radio);
        }

        public void setSelected(boolean selected) {
            if (this.radio.isSelected() != selected) {
                this.radio.setSelected(selected);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                this.deselect.setSelected(false);
                this.fcd.setResolveWorkspace(this.resolveWorkspace);
                if (!this.record.isResolved().booleanValue()) {
                    for (FeatureConflictDescriptor fcd : this.record.getConflicts()) {
                        if (fcd.getResolveWorkspace() != null) continue;
                        return;
                    }
                    this.record.setResolved(true);
                    if (MergeWorkspacePanel.this.anySolved()) {
                        MergeWorkspacePanel.this.dlg.getOkButton().setEnabled(true);
                    }
                    MergeWorkspacePanel.this.listModel.fireContentsChanged(this.record);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.radio.setSelected(true);
            this.radio.requestFocusInWindow();
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            Layer l;
            if (this.canvas != null && this.linkedObj != null && (l = this.linkedObj.getLayer()) instanceof HoverableLayer) {
                ArrayList<GeoObject> list = new ArrayList<GeoObject>(1);
                list.add(this.linkedObj);
                ((HoverableLayer)l).setHover(list);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Layer l;
            if (this.canvas != null && this.linkedObj != null && (l = this.linkedObj.getLayer()) instanceof HoverableLayer) {
                ((HoverableLayer)l).clearHover();
            }
        }

        public void setCanvas(MapCanvas canvas) {
            this.canvas = canvas;
        }

        public MapCanvas getCanvas() {
            return this.canvas;
        }

        public void setLinkedObj(GeoObject linkedObj) {
            this.linkedObj = linkedObj;
        }

        public GeoObject getLinkedObj() {
            return this.linkedObj;
        }
    }

    private class ConflictListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            FeatureConflictRecord r = (FeatureConflictRecord)value;
            if (r.isResolved().booleanValue()) {
                this.setIcon(MergeWorkspacePanel.this.resolvedImage);
            } else {
                this.setIcon(MergeWorkspacePanel.this.unresolvedImage);
            }
            this.setText(r.getKey());
            this.setHorizontalTextPosition(4);
            return this;
        }
    }

    private class FeatureConflictRecord {
        private String layer = null;
        private String key = null;
        private Boolean resolved = false;
        private Vector<FeatureConflictDescriptor> conflicts = null;
        private Rectangle2D conflictView = null;
        private AbstractDataSetLayer activeLayer = null;

        private FeatureConflictRecord() {
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public void setResolved(Boolean resolved) {
            this.resolved = resolved;
        }

        public Boolean isResolved() {
            return this.resolved;
        }

        public void setLayer(String layer) {
            this.layer = layer;
        }

        public String getLayer() {
            return this.layer;
        }

        public void setConflicts(Vector<FeatureConflictDescriptor> conflicts) {
            this.conflicts = conflicts;
        }

        public Vector<FeatureConflictDescriptor> getConflicts() {
            return this.conflicts;
        }

        public void setConflictView(Rectangle2D conflictView) {
            this.conflictView = conflictView;
        }

        public Rectangle2D getConflictView() {
            return this.conflictView;
        }

        public void setActiveLayer(AbstractDataSetLayer activeLayer) {
            this.activeLayer = activeLayer;
        }

        public AbstractDataSetLayer getActiveLayer() {
            return this.activeLayer;
        }
    }

    private class ConflictListModel
    extends DefaultListModel {
        private ConflictListModel() {
        }

        public void fireContentsChanged(FeatureConflictRecord fcr) {
            for (int i = 0; i < this.getSize(); ++i) {
                FeatureConflictRecord cr = (FeatureConflictRecord)this.get(i);
                if (cr != fcr) continue;
                this.fireContentsChanged(this, i, i);
            }
        }
    }
}

