/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.maps.core.Layer;
import oracle.mapviewer.share.DimensionInfo;
import oracle.mapviewer.share.SpatialTableMetadata;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mdeditor.ui.AnnotationTextMetadataAttrsPanel;
import oracle.mdeditor.ui.ErrorDialog;
import oracle.mdeditor.ui.OlafDialog;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.sdovis.SRS;
import oracle.spatial.edit.model.AbstractDataAccessObject;
import oracle.spatial.edit.model.AbstractDataSource;
import oracle.spatial.edit.model.MDSException;

public class CreateAnnotationTextTablePanel
extends JPanel {
    protected OlafDialog dlg = null;
    protected AbstractDataSource dataSource = null;
    protected SpatialTableMetadata result = null;
    protected String keyColumn = null;
    protected String keySequence = null;
    private static Logger log = LogFactory.getLogger((LogFactory.LoggerEnum)LogFactory.LoggerEnum.MAPEDITOR);
    private JLabel mbscaleLabel = new JLabel();
    private JTextField mbscaleTxt = new JTextField();
    private JLabel textexpLabel = new JLabel();
    private JTextField textexpTxt = new JTextField();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel label_Filler = new JLabel();
    private JLabel textattrLabel = new JLabel();
    private AnnotationTextMetadataAttrsPanel textattrPanel = new AnnotationTextMetadataAttrsPanel(null);
    private JLabel basetableLabel = new JLabel();
    private JLabel basecolumnLabel = new JLabel();
    private JTextField basetableTxt = new JTextField();
    private JTextField basecolumnTxt = new JTextField();
    private JLabel keyLabel = new JLabel();
    private JTextField keyTxt = new JTextField();
    private JLabel labelLabel = new JLabel();
    private JTextField labelTxt = new JTextField();
    private JLabel sridLabel = new JLabel();
    private JTextField sridTxt = new JTextField();
    private JCheckBox createSequenceBox = new JCheckBox();

    public CreateAnnotationTextTablePanel(AbstractDataSource dataSource, OlafDialog dlg) {
        this.dataSource = dataSource;
        this.dlg = dlg;
        dlg.setContentPane(this);
        if (dataSource == null) {
            throw new IllegalArgumentException("null datasource");
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.setPreferredSize(new Dimension(440, 640));
        this.basetableLabel.setText(MessagesBundle.getMessage("Label_annotation_table"));
        this.add((Component)this.basetableLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.basetableTxt.setText("texttb");
        this.add((Component)this.basetableTxt, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.basecolumnLabel.setText(MessagesBundle.getMessage("Label_annotation_column"));
        this.add((Component)this.basecolumnLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.basecolumnTxt.setText("textgeom");
        this.add((Component)this.basecolumnTxt, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.keyLabel.setText(MessagesBundle.getMessage("Label_primarykey_integer"));
        this.add((Component)this.keyLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.keyTxt.setText("featid");
        this.add((Component)this.keyTxt, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.labelLabel.setText(MessagesBundle.getMessage("Label_labelcolumn_64char"));
        this.add((Component)this.labelLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.labelTxt.setText("name");
        this.add((Component)this.labelTxt, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.sridLabel.setText(MessagesBundle.getMessage("Label_srid"));
        this.add((Component)this.sridLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.sridTxt.setText("8307");
        this.add((Component)this.sridTxt, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.mbscaleLabel.setText(MessagesBundle.getMessage("Label_metadata_map_base_scale"));
        this.add((Component)this.mbscaleLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.setMapBaseScale(1.0E7);
        this.mbscaleTxt.setToolTipText(MessagesBundle.getMessage("Tooltip_annotation_map_scale"));
        this.add((Component)this.mbscaleTxt, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.textexpLabel.setText(MessagesBundle.getMessage("Label_metadata_text_expression"));
        this.add((Component)this.textexpLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.textexpTxt.setText("name");
        this.add((Component)this.textexpTxt, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.textattrLabel.setText(MessagesBundle.getMessage("Metadata_text_attributes"));
        this.add((Component)this.textattrLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.textattrPanel, new GridBagConstraints(0, 8, 3, 2, 1.0, 1.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.createSequenceBox.setText(MessagesBundle.getMessage("Create_sequence"));
        this.createSequenceBox.setSelected(true);
        this.add((Component)this.createSequenceBox, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 5, 5, 0), 0, 0));
        this.dlg.getOkButton().setText(MessagesBundle.getMessage("Create_table"));
        this.dlg.getOkButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateAnnotationTextTablePanel.this.createButton_actionPerformed(e);
            }
        });
    }

    public Layer getLayer() {
        return null;
    }

    public void setMapBaseScale(double scale) {
        NumberFormat nf = NumberFormat.getInstance();
        if (Double.isNaN(scale) || scale < 1.0) {
            this.mbscaleTxt.setText("");
        } else {
            this.mbscaleTxt.setText(nf.format(scale));
        }
    }

    public double getMapBaseScale() {
        String text = this.mbscaleTxt.getText();
        if (text == null || text.length() == 0) {
            return Double.NaN;
        }
        NumberFormat nf = NumberFormat.getInstance();
        try {
            double scale = nf.parse(text).doubleValue();
            if (scale < 1.0) {
                return Double.NaN;
            }
            return scale;
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public String getExpression() {
        return this.textexpTxt.getText();
    }

    public void setExpression(String expr) {
        if (expr == null) {
            this.textexpTxt.setText("");
        } else {
            this.textexpTxt.setText(expr);
        }
    }

    public AnnotationTextMetadataAttrsPanel getMetadataAttributesPanel() {
        return this.textattrPanel;
    }

    public String getBaseTable() {
        String value = this.basetableTxt.getText().trim();
        if (value == null || value.length() == 0) {
            return null;
        }
        return value;
    }

    public String getBaseColumn() {
        String column = this.basecolumnTxt.getText().trim();
        if (column == null || column.length() == 0) {
            return null;
        }
        return column;
    }

    public long getSRID() {
        NumberFormat nf = NumberFormat.getInstance();
        try {
            return nf.parse(this.sridTxt.getText()).longValue();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createButton_actionPerformed(ActionEvent e) {
        String table = this.getBaseTable();
        if (table == null) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getMessage("Undefined_table_name"), MessagesBundle.getMessage("Warning"), 2);
            return;
        }
        String column = this.getBaseColumn();
        if (column == null) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getMessage("Undefined_annotationtext_column"), MessagesBundle.getMessage("Warning"), 2);
            return;
        }
        if (this.keyTxt.getText() == null || this.keyTxt.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getMessage("Undefined_key_column"), MessagesBundle.getMessage("Warning"), 2);
            return;
        }
        String key = this.keyTxt.getText().trim();
        if (this.labelTxt.getText() == null || this.labelTxt.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getMessage("Undefined_label_column"), MessagesBundle.getMessage("Warning"), 2);
            return;
        }
        String label = this.labelTxt.getText().trim();
        long srid = this.getSRID();
        SRS srs = null;
        AbstractDataAccessObject da = this.dataSource.getDataAccessObject();
        Throwable exception = null;
        try {
            da.openConnection();
            srs = da.getSRS("" + srid);
        }
        catch (MDSException ex) {
            exception = ex;
        }
        catch (Exception ex) {
            exception = ex;
        }
        finally {
            try {
                da.closeConnection();
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        if (exception != null) {
            ErrorDialog.showErrorDialog(exception, this, MessagesBundle.getFormattedMessage("Unable_toget_srs", " " + srid), MessagesBundle.getMessage("Warning"), 2);
            return;
        }
        String[] dimnames = new String[]{"X", "Y"};
        double[] minvalues = new double[2];
        double[] maxvalues = new double[2];
        double[] tolvalues = new double[2];
        if (srs == null || !srs.isGeodetic()) {
            minvalues[0] = 0.0;
            minvalues[1] = 0.0;
            maxvalues[0] = 1.0;
            maxvalues[1] = 1.0;
        } else {
            minvalues[0] = -180.0;
            minvalues[1] = -90.0;
            maxvalues[0] = 180.0;
            maxvalues[1] = 90.0;
        }
        tolvalues[0] = 5.0E-6;
        tolvalues[1] = 5.0E-6;
        double mapScale = this.getMapBaseScale();
        String textExpression = this.textexpTxt.getText().trim();
        String graphicAttrs = this.textattrPanel.getCurrentXML();
        String[] attrs = new String[]{key, column, label};
        String[] types = new String[]{"NUMBER", "MDSYS.ST_ANNOTATION_TEXT", "VARCHAR2(64)"};
        boolean[] notNull = new boolean[]{true, false, false};
        this.setCursor(new Cursor(3));
        Vector<SpatialTableMetadata> metadata = new Vector<SpatialTableMetadata>();
        SpatialTableMetadata meta = new SpatialTableMetadata();
        meta.setName(table.toUpperCase());
        meta.setType(SpatialTableMetadata.ANNOTATION_TYPE);
        meta.setSpatialColumn(column);
        meta.setSRID((int)srid);
        meta.setOwner(this.dataSource.getConnectionProperties().getProperty("dataSource").toUpperCase());
        for (int i = 0; i < 2; ++i) {
            DimensionInfo dinfo = new DimensionInfo(dimnames[i], minvalues[i], maxvalues[i], tolvalues[i]);
            meta.addDimensionInfo(dinfo);
        }
        metadata.add(meta);
        da = this.dataSource.getDataAccessObject();
        try {
            da.openConnection();
            da.createTable(table, attrs, types, notNull, key, metadata);
            da.createAnnotationTextMetadata(table, column, mapScale, textExpression, graphicAttrs);
        }
        catch (MDSException ex) {
            exception = ex;
        }
        catch (Exception ex) {
            exception = ex;
        }
        finally {
            try {
                da.closeConnection();
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
        if (exception != null) {
            ErrorDialog.showErrorDialog(exception, this, MessagesBundle.getFormattedMessage("Unable_tocreate_table", table), MessagesBundle.getMessage("Warning"), 2);
            return;
        }
        this.result = meta;
        this.keyColumn = key.toUpperCase();
        if (this.createSequenceBox.isSelected()) {
            String seqName = (table + "_" + key + "_SEQ").toUpperCase();
            try {
                da.openConnection();
                da.createSequence(seqName, 1L);
                this.keySequence = seqName;
            }
            catch (MDSException ex) {
                System.out.println("Warning: " + MessagesBundle.getFormattedMessage("Unable_tocreate_sequence_name", seqName) + "\n" + ex.getMessage());
            }
            catch (Exception ex) {
                System.out.println("Warning: " + MessagesBundle.getFormattedMessage("Unable_tocreate_sequence_name", seqName) + "\n" + ex.getMessage());
            }
            finally {
                try {
                    da.closeConnection();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        }
        JOptionPane.showMessageDialog(this, MessagesBundle.getFormattedMessage("Table_created_registered_indexed", table), MessagesBundle.getMessage("Information"), 1);
    }

    public SpatialTableMetadata getSpatialTableMetadata() {
        return this.result;
    }

    public String getKeyColumn() {
        return this.keyColumn;
    }

    public String getKeySequence() {
        return this.keySequence;
    }
}

