/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.session;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.bali.ewt.border.TitledPane;
import oracle.maps.core.EditableLayer;
import oracle.maps.core.Layer;
import oracle.maps.core.LayerManager;
import oracle.maps.core.MapCanvas;
import oracle.maps.core.MapRegion;
import oracle.maps.core.SelectableLayer;
import oracle.maps.util.PropertySupportObject;
import oracle.mapviewer.share.FeatureConflictDescriptor;
import oracle.mapviewer.share.Sequence;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mdeditor.MapConstants;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.session.EditSession;
import oracle.mdeditor.session.EditSessionProvider;
import oracle.mdeditor.session.layer.WorkspaceLayer;
import oracle.mdeditor.ui.ErrorDialog;
import oracle.mdeditor.ui.OlafDialog;
import oracle.mdeditor.ui.ProgressDialog;
import oracle.mdeditor.ui.TextFieldPanel;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.mdeditor.wfs.layer.WFSLayer;
import oracle.sdovis.SRS;
import oracle.spatial.edit.layer.AbstractDataSetLayer;
import oracle.spatial.edit.layer.GeometrySetLayer;
import oracle.spatial.edit.layer.TopologyPrimitiveLayer;
import oracle.spatial.edit.layer.TopologySetLayer;
import oracle.spatial.edit.model.AbstractDataAccessObject;
import oracle.spatial.edit.model.AbstractDataSource;
import oracle.spatial.edit.model.MDSException;
import oracle.spatial.edit.session.MDSEditSessionProvider;
import oracle.spatial.edit.ui.MergeWorkspacePanel;
import oracle.spatial.edit.ui.RemoveEditSessionPanel;
import oracle.spatial.edit.util.MVConnection;

public class MDSEditSession
implements EditSession {
    private static final Logger log = LogFactory.getLogger((LogFactory.LoggerEnum)LogFactory.LoggerEnum.MAPEDITOR);
    public static final String PROPERTY_AREA = "oracle.spatial.edit.session.MDSEditSession.area";
    public static final String PROPERTY_VERSIONED = "oracle.spatial.edit.session.MDSEditSession.versioned";
    public static final String PROPERTY_STATUS = "oracle.spatial.edit.session.MDSEditSession.status";
    public static final String PROPERTY_LOG_LEVEL = "oracle.spatial.edit.session.MDSEditSession.loglevel";
    public static final String PROPERTY_PROXY_HOST = "oracle.spatial.edit.session.MDSEditSession.proxyhost";
    public static final String PROPERTY_PROXY_PORT = "oracle.spatial.edit.session.MDSEditSession.proxyport";
    public static final String PROPERTY_HTTP_TIMEOUT = "oracle.spatial.edit.session.MDSEditSession.httptimeout";
    public static final String STATUS_LOCKED = "ACTIVE";
    public static final String STATUS_UNLOCKED = "INACTIVE";
    protected AbstractDataSource dataSource = null;
    protected Frame frame = null;
    protected MapCanvas canvas = null;
    protected PropertySupportObject properties = new PropertySupportObject(this);
    protected JButton mergeButton = new JButton(Icons.getIcon("commit_ena.png"));
    protected JButton createTableButton = new JButton(Icons.getIcon("addtable.png"));
    protected JButton createSequenceButton = new JButton(Icons.getIcon("addsequence.png"));

    public MDSEditSession(AbstractDataSource dataSource, Frame frame, Properties props) {
        this.dataSource = dataSource;
        this.frame = frame;
        this.properties.setDefaultProperty(PROPERTY_STATUS, STATUS_UNLOCKED);
        this.properties.setDefaultProperty(PROPERTY_VERSIONED, Boolean.toString(false));
        if (props != null) {
            for (Map.Entry<Object, Object> e : props.entrySet()) {
                this.setProperty(e.getKey().toString(), e.getValue().toString());
            }
        }
        this.canvas = new MapCanvas();
    }

    @Override
    public String getName() {
        return this.getProperty("oracle.mdeditor.session.EditSession.name");
    }

    @Override
    public void setName(String name) {
        this.setProperty("oracle.mdeditor.session.EditSession.name", name);
    }

    @Override
    public Properties getProperties() {
        return this.properties.getProperties();
    }

    @Override
    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    @Override
    public String setProperty(String key, String value) {
        return this.properties.setProperty(key, value);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.properties.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.properties.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.properties.getPropertyChangeListeners();
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.properties.getPropertyChangeListeners(propertyName);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.properties.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.properties.removePropertyChangeListener(propertyName, listener);
    }

    public boolean start() {
        this.setStatus(STATUS_LOCKED);
        return this.saveDefinition();
    }

    public boolean end() {
        this.setStatus(STATUS_UNLOCKED);
        return this.saveDefinition();
    }

    @Override
    public boolean isModified() {
        for (Layer l : this.canvas.getLayerManager()) {
            if (!(l instanceof EditableLayer) || !((EditableLayer)l).isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean delete(Collection<EditSession> loadedSessions) {
        boolean deleted = false;
        if (this.isVersioned()) {
            RemoveEditSessionPanel rmPanel = new RemoveEditSessionPanel(this.frame, this, loadedSessions);
            if (rmPanel.getRowCount() > 0) {
                OlafDialog rmDlg = new OlafDialog(this.frame, MessagesBundle.getMessage("Remove_session"), rmPanel);
                rmDlg.setSize(360, 500);
                rmDlg.setAsCloseSelection(true);
                rmDlg.setVisible(true);
                rmDlg.dispose();
                deleted = rmPanel.isRemoved();
            } else {
                deleted = this.simpleDelete(true);
            }
        } else {
            deleted = this.simpleDelete(true);
        }
        return deleted;
    }

    @Override
    public void clearChanges() {
        for (Layer l : this.canvas.getLayerManager()) {
            if (!(l instanceof EditableLayer)) continue;
            ((EditableLayer)l).clearChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveDefinition() {
        this.setArea(this.canvas.getMapRegion().getDataWindow());
        AbstractDataAccessObject dataAccess = this.dataSource.getDataAccessObject();
        Throwable exception = null;
        try {
            dataAccess.openConnection();
            dataAccess.updateEditSession(this);
        }
        catch (MDSException ex) {
            exception = ex;
        }
        catch (Exception ex) {
            exception = ex;
        }
        finally {
            if (dataAccess != null) {
                try {
                    dataAccess.closeConnection();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (exception != null) {
            ErrorDialog.showErrorDialog(exception, this.frame, MessagesBundle.getMessage("Unable_toupdate_session_onserver"), MessagesBundle.getMessage("Error"), 2);
            return false;
        }
        return true;
    }

    @Override
    public boolean saveData() {
        boolean success = true;
        for (Layer l : this.canvas.getLayerManager()) {
            if (!(l instanceof EditableLayer) || ((EditableLayer)l).save()) continue;
            success = false;
        }
        return success;
    }

    public boolean isVersioned() {
        return Boolean.parseBoolean(this.getProperty(PROPERTY_VERSIONED));
    }

    public void setVersioned(boolean versioned) {
        this.setProperty(PROPERTY_VERSIONED, Boolean.toString(versioned));
    }

    public String getEditor() {
        return this.dataSource.getConnectionProperties().getProperty("editor");
    }

    @Override
    public String getDescription() {
        return this.getProperty("oracle.mdeditor.session.EditSession.description");
    }

    @Override
    public void setDescription(String description) {
        this.setProperty("oracle.mdeditor.session.EditSession.description", description);
    }

    public String getStatus() {
        return this.getProperty(PROPERTY_STATUS);
    }

    private void setStatus(String status) {
        this.setProperty(PROPERTY_STATUS, status);
    }

    public boolean isLocked() {
        return this.getStatus().equalsIgnoreCase(STATUS_LOCKED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean simpleDelete(boolean askToConfirm) {
        int confirm;
        String sessionName = this.getName();
        if (askToConfirm && (confirm = JOptionPane.showConfirmDialog(this.frame, MessagesBundle.getFormattedMessage("Question_delete_session", sessionName), MessagesBundle.getMessage("Delete"), 0, 2)) != 0) {
            return false;
        }
        if (this.frame != null) {
            this.frame.setCursor(new Cursor(3));
        }
        AbstractDataAccessObject dataAccess = this.dataSource.getDataAccessObject();
        boolean success = false;
        Throwable exception = null;
        try {
            dataAccess.openConnection();
            success = dataAccess.removeEditSession(sessionName);
        }
        catch (MDSException ex) {
            exception = ex;
        }
        catch (Exception ex) {
            exception = ex;
        }
        finally {
            if (dataAccess != null) {
                try {
                    dataAccess.closeConnection();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.frame != null) {
                this.frame.setCursor(Cursor.getDefaultCursor());
            }
        }
        if (!success || exception != null) {
            ErrorDialog.showErrorDialog(exception, this.frame, MessagesBundle.getFormattedMessage("Unable_toremove_session", sessionName), MessagesBundle.getMessage("Error"), 0);
            return false;
        }
        return true;
    }

    public void merge(Collection<EditSession> loadedSessions, EditSessionProvider sessionProvider) {
        Iterator<Layer> itrl = this.getLayers().iterator();
        boolean hasLayers = false;
        while (itrl.hasNext()) {
            Layer l = itrl.next();
            if (!(l instanceof WorkspaceLayer) || l instanceof WFSLayer || !l.isVisible()) continue;
            WorkspaceLayer layer = (WorkspaceLayer)l;
            try {
                if (!layer.isVersionEnabled()) continue;
                hasLayers = true;
                break;
            }
            catch (Exception ex) {
                log.warning("Layer [" + layer.getName() + "] " + ex.getMessage());
            }
        }
        if (!hasLayers) {
            JOptionPane.showMessageDialog(this.canvas.getFrameForDialog(), MessagesBundle.getMessage("No_visible_versioned_layers"), MessagesBundle.getMessage("Warning"), 2);
            return;
        }
        int confirm = JOptionPane.showConfirmDialog(this.frame, MessagesBundle.getMessage("Question_merge_layers"), MessagesBundle.getMessage("Merge_tool"), 0, 2);
        if (confirm != 0) {
            return;
        }
        Hashtable<WorkspaceLayer, Vector<FeatureConflictDescriptor>> conflicts = new Hashtable<WorkspaceLayer, Vector<FeatureConflictDescriptor>>();
        int totalConflicts = 0;
        Iterator<Layer> itr = this.getLayers().iterator();
        ProgressDialog gcPgd = new ProgressDialog(this.canvas.getFrameForDialog());
        GetConflictsThread gcThread = new GetConflictsThread(itr, conflicts, gcPgd);
        gcThread.start();
        gcPgd.setVisible(true);
        if (gcPgd.isCancelled()) {
            gcThread.endThread();
            gcPgd.dispose();
            return;
        }
        totalConflicts = gcThread.getNumberOfConflicts();
        gcPgd.dispose();
        if (totalConflicts > 0) {
            OlafDialog ctDlg = new OlafDialog(this.frame, MessagesBundle.getMessage("Resolve_conflicts"), null);
            MergeWorkspacePanel mwPanel = new MergeWorkspacePanel(this, conflicts, ctDlg);
            ctDlg.setAsCloseSelection(false);
            ctDlg.setVisible(true);
            if (ctDlg.isCancelled()) {
                ctDlg.dispose();
                return;
            }
            ctDlg.dispose();
        }
        Hashtable<WorkspaceLayer, String> layerStatus = new Hashtable<WorkspaceLayer, String>();
        itr = this.getLayers().iterator();
        ProgressDialog rcmPgd = new ProgressDialog(this.canvas.getFrameForDialog());
        ResolveConflictsAndMergeThread rcmThread = new ResolveConflictsAndMergeThread(itr, conflicts, loadedSessions, sessionProvider, layerStatus, rcmPgd);
        rcmThread.start();
        rcmPgd.setVisible(true);
        if (rcmPgd.isCancelled()) {
            rcmThread.endThread();
            rcmPgd.dispose();
        } else {
            rcmPgd.dispose();
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<WorkspaceLayer, String> e : layerStatus.entrySet()) {
            WorkspaceLayer layer = e.getKey();
            String status = e.getValue();
            sb.append(layer.getName() + ": ");
            sb.append(status + "\n\n");
        }
        JTextArea result = new JTextArea(sb.toString());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(result), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        OlafDialog dialog = new OlafDialog(this.frame, MessagesBundle.getMessage("Merge_report"), panel);
        dialog.setAsCloseSelection(true);
        dialog.setVisible(true);
        dialog.dispose();
    }

    private MVConnection.DataSource getMVConnectionDataSource(MDSEditSessionProvider sessionProvider, EditSession session) {
        if (sessionProvider == null || session == null) {
            return null;
        }
        DefaultMutableTreeNode rootNode = sessionProvider.getProviderRootNode();
        if (rootNode == null) {
            return null;
        }
        DefaultMutableTreeNode parentNode = rootNode;
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            TreeNode node = rootNode.getChildAt(i);
            Object child = ((DefaultMutableTreeNode)node).getUserObject();
            if (!(child instanceof MVConnection)) continue;
            for (int j = 0; j < node.getChildCount(); ++j) {
                TreeNode mvcdsNode = node.getChildAt(j);
                Object mvcdschild = ((DefaultMutableTreeNode)mvcdsNode).getUserObject();
                if (!(mvcdschild instanceof MVConnection.DataSource) || ((MVConnection.DataSource)mvcdschild).getEditSession(session.getName()) == null) continue;
                return (MVConnection.DataSource)mvcdschild;
            }
        }
        return null;
    }

    public void setDataSource(AbstractDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public AbstractDataSource getDataSource() {
        return this.dataSource;
    }

    private void setArea(Rectangle2D area) {
        String areaStr = null;
        if (area != null) {
            areaStr = area.getMinX() + "," + area.getMinY() + "," + area.getWidth() + "," + area.getHeight();
        }
        this.setProperty(PROPERTY_AREA, areaStr);
    }

    public Rectangle2D getArea() {
        String[] s;
        Rectangle2D.Double area = null;
        String areaStr = this.getProperty(PROPERTY_AREA);
        if (areaStr != null && (s = areaStr.split(",")) != null && s.length == 4) {
            try {
                double x = Double.parseDouble(s[0]);
                double y = Double.parseDouble(s[1]);
                double w = Double.parseDouble(s[2]);
                double h = Double.parseDouble(s[3]);
                area = new Rectangle2D.Double(x, y, w, h);
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
        }
        return area;
    }

    @Override
    public MapCanvas getMapCanvas() {
        return this.canvas;
    }

    @Override
    public LayerManager getLayers() {
        return this.canvas.getLayerManager();
    }

    private void setWaitCursor() {
        this.frame.setCursor(Cursor.getPredefinedCursor(3));
    }

    private void setDefaultCursor() {
        this.frame.setCursor(Cursor.getPredefinedCursor(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSequence() {
        TextFieldPanel txtPanel = new TextFieldPanel(MessagesBundle.getMessage("Label_sequence"));
        txtPanel.setTextFieldTooltip(MessagesBundle.getMessage("Tooltip_sequence_name"));
        txtPanel.setTextFieldValue("");
        OlafDialog txtDlg = new OlafDialog(this.frame, MessagesBundle.getMessage("Create_sequence"), txtPanel);
        txtDlg.setSize(300, 140);
        txtDlg.setVisible(true);
        AbstractDataAccessObject da = null;
        if (!txtDlg.isCancelled()) {
            String name = txtPanel.getTextFieldValue();
            if (name != null && name.trim().length() > 0) {
                try {
                    da = this.dataSource.getDataAccessObject();
                    da.openConnection();
                    da.createSequence(name.trim().toUpperCase(), 1L);
                    Sequence seq = new Sequence();
                    seq.setName(name.trim().toUpperCase());
                    JOptionPane.showMessageDialog(this.frame, MessagesBundle.getFormattedMessage("Create_sequence_info", name.trim().toUpperCase()), MessagesBundle.getMessage("Information"), 1);
                }
                catch (MDSException ex) {
                    JOptionPane.showMessageDialog(this.frame, MessagesBundle.getMessage("Unable_tocreate_sequence") + ex.getMessage(), MessagesBundle.getMessage("Error"), 0);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this.frame, MessagesBundle.getMessage("Unable_tocreate_sequence") + ex.getMessage(), MessagesBundle.getMessage("Error"), 0);
                }
                finally {
                    if (da != null) {
                        try {
                            da.closeConnection();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            } else {
                JOptionPane.showMessageDialog(this.frame, MessagesBundle.getMessage("Undefined_sequence_name"), MessagesBundle.getMessage("Warning"), 2);
            }
        }
        txtDlg.dispose();
    }

    @Override
    public boolean removeLayer(Layer layer) {
        if (layer == null) {
            return false;
        }
        String message = MessagesBundle.getFormattedMessage("Question_remove_layer", layer.getName());
        int sel = JOptionPane.showConfirmDialog(this.frame, message, MessagesBundle.getMessage("Remove_layer"), 0);
        if (sel != 0) {
            return false;
        }
        if (layer instanceof EditableLayer && ((EditableLayer)layer).isModified()) {
            int saveOpt = JOptionPane.showConfirmDialog(this.frame, "Save before?", "Changes found", 1);
            if (saveOpt == 0) {
                ((EditableLayer)layer).save();
            } else if (saveOpt == 2) {
                return false;
            }
        }
        this.canvas.getLayerManager().remove(layer);
        layer.removed(this);
        this.saveDefinition();
        return true;
    }

    public int getSRID() {
        for (Layer layer : this.getLayers()) {
            int layerSRID = layer.getSRID();
            if (layerSRID <= 0) continue;
            return layerSRID;
        }
        return 0;
    }

    @Override
    public boolean addLayer(Layer layer) {
        boolean added;
        ArrayList<String> tags = new ArrayList<String>(3);
        tags.add("dataLayer");
        LayerManager layers = this.getLayers();
        if (layer instanceof EditableLayer && ((EditableLayer)layer).isEditable() && layers.getLayerByTag("targetLayer") == null) {
            tags.add("targetLayer");
        }
        if (!(layer instanceof SelectableLayer) || layers.getLayerByTag("selectionLayer") == null) {
            // empty if block
        }
        if (added = this.addLayer(layer, MapConstants.POSITION_DATA_LAYERS, tags.toArray(new String[tags.size()]))) {
            this.saveDefinition();
        }
        return added;
    }

    public boolean addLayer(Layer layer, Integer position, String[] tags) {
        Rectangle2D layerExtent;
        MapRegion region;
        if (layer instanceof WFSLayer) {
            ((WFSLayer)layer).setDataSource(this.dataSource);
        }
        int layerSRID = layer.getSRID();
        int sessionSRID = this.getSRID();
        if (sessionSRID != 0 && sessionSRID != layerSRID && layerSRID > 0 && layerSRID != 262148 && layer instanceof EditableLayer) {
            ErrorDialog.showErrorDialog(null, this.frame, MessagesBundle.getFormattedMessage("Unable_toadd_layer_into_session", "" + layerSRID, "" + sessionSRID), MessagesBundle.getMessage("Warning"), 2);
            return false;
        }
        if (this.isVersioned() && (layer instanceof TopologySetLayer || layer instanceof TopologyPrimitiveLayer)) {
            JOptionPane.showMessageDialog(this.frame, MessagesBundle.getMessage("Versioned_topology_editing_not_support_yet"), MessagesBundle.getMessage("Warning"), 2);
            return false;
        }
        layer.setName(this.getLayerNameAvailabilityFor(layer.getName()));
        layer.added(this);
        this.canvas.getLayerManager().add(layer, position);
        if (tags != null) {
            this.canvas.getLayerManager().tag(layer, tags);
        }
        if ((region = this.canvas.getMapRegion()).getDataWindow() == null && (layerExtent = layer.getFullExtent()) != null) {
            double cx = layerExtent.getMinX() + 0.25 * layerExtent.getWidth();
            double cy = layerExtent.getMinY() + 0.4 * layerExtent.getHeight();
            double width = 0.3 * layerExtent.getWidth();
            double height = 0.3 * layerExtent.getHeight();
            Rectangle2D.Double area = new Rectangle2D.Double(cx - width / 2.0, cy - height / 2.0, width, height);
            region.setDataWindow(area);
        }
        if (layerSRID > 0 && sessionSRID == 0 && this.canvas != null && this.canvas.getMapRegion() != null) {
            region.setMapSrid(layerSRID);
            region.setDataWindowSrid(layerSRID);
            region.setUserSrid(layerSRID);
            if (region.getSRS() == null) {
                region.setSRS(this.getSRS(layerSRID));
            }
        }
        return true;
    }

    private String getLayerNameAvailabilityFor(String name) {
        if (name == null) {
            return null;
        }
        if (this.canvas.getLayerManager().getLayerByName(name) == null) {
            return name;
        }
        int value = (int)(Math.random() * 1000.0);
        while (this.canvas.getLayerManager().getLayerByName(name + "_" + value) != null) {
            value = (int)(Math.random() * 1000.0);
        }
        return name + "_" + value;
    }

    @Override
    public JPanel getConfigurationPanel(Component parent) {
        return new EditSessionPreferencesPanel(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SRS getSRS(int srid) {
        if (this.dataSource == null) {
            return null;
        }
        SRS srs = null;
        AbstractDataAccessObject dao = null;
        try {
            dao = this.dataSource.getDataAccessObject();
            dao.openConnection();
            SRS sRS = srs = dao.getSRS("" + srid);
            return sRS;
        }
        catch (MDSException ex) {
            log.warning(MessagesBundle.getFormattedMessage("Unable_toget_srs", "" + srid) + ": " + ex.getMessage());
        }
        catch (Exception ex) {
            log.warning(MessagesBundle.getFormattedMessage("Unable_toget_srs", "" + srid) + ": " + ex.getMessage());
        }
        finally {
            try {
                dao.closeConnection();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return srs;
    }

    private class ResolveConflictsAndMergeThread
    extends Thread {
        private Iterator<Layer> itr = null;
        private Hashtable<WorkspaceLayer, Vector<FeatureConflictDescriptor>> conflicts = null;
        private ProgressDialog dlg = null;
        private Collection<EditSession> loadedSessions = null;
        private EditSessionProvider sessionProvider = null;
        private Hashtable<WorkspaceLayer, String> layerStatus = null;
        private boolean endThread = false;

        public ResolveConflictsAndMergeThread(Iterator<Layer> itr, Hashtable<WorkspaceLayer, Vector<FeatureConflictDescriptor>> conflicts, Collection<EditSession> loadedSessions, EditSessionProvider sessionProvider, Hashtable<WorkspaceLayer, String> layerStatus, ProgressDialog dlg) {
            this.itr = itr;
            this.conflicts = conflicts;
            this.loadedSessions = loadedSessions;
            this.sessionProvider = sessionProvider;
            this.layerStatus = layerStatus;
            this.dlg = dlg;
        }

        @Override
        public void run() {
            this.endThread = false;
            if (this.itr == null || this.conflicts == null) {
                log.warning("Unable to process resolve conflicts and merge thread.");
                return;
            }
            if (this.dlg != null) {
                this.dlg.setTitle("Resolve Conflicts and Merge");
            }
            block4: while (this.itr.hasNext() && !this.endThread) {
                ArrayList<EditSession> sessions;
                boolean success;
                Exception ex;
                Layer l = this.itr.next();
                if (!(l instanceof WorkspaceLayer) || l instanceof WFSLayer || !l.isVisible()) continue;
                WorkspaceLayer layer = (WorkspaceLayer)l;
                if (this.dlg != null) {
                    this.dlg.setTaskMessage(MessagesBundle.getFormattedMessage("Resolving_layer_conflicts", l.getName()));
                }
                Vector<FeatureConflictDescriptor> layerConflicts = this.conflicts.get(layer);
                boolean hasChangefromParent = false;
                if (layerConflicts != null && layerConflicts.size() > 0) {
                    log.info("Resolving conflicts for layer [" + l.getName() + "] ...");
                    ex = null;
                    success = false;
                    try {
                        success = layer.resolveConflicts(layerConflicts);
                    }
                    catch (Exception exx) {
                        log.severe("Exception: " + exx.getMessage());
                        ex = exx;
                    }
                    if (ex != null || !success) {
                        this.layerStatus.put(layer, MessagesBundle.getMessage("Unable_toresolve_conflicts"));
                        continue;
                    }
                    for (FeatureConflictDescriptor conflict : layerConflicts) {
                        if (conflict.getResolveWorkspace() == null || !conflict.getResolveWorkspace().equalsIgnoreCase("PARENT")) continue;
                        hasChangefromParent = true;
                        break;
                    }
                    for (FeatureConflictDescriptor conflict : layerConflicts) {
                        if (conflict.getResolveWorkspace() != null) continue;
                        this.layerStatus.put(layer, MessagesBundle.getMessage("Partial_resolve"));
                        if (!hasChangefromParent || !(layer instanceof GeometrySetLayer)) continue block4;
                        ((GeometrySetLayer)layer).buildDataSet();
                        continue block4;
                    }
                    log.info("Done resolving conflicts for layer [" + l.getName() + "].");
                }
                if (hasChangefromParent && layer instanceof GeometrySetLayer) {
                    ((GeometrySetLayer)layer).buildDataSet();
                }
                ex = null;
                success = true;
                try {
                    if (!layer.isVersionEnabled()) continue;
                    if (this.dlg != null) {
                        this.dlg.setTaskMessage(MessagesBundle.getFormattedMessage("Merging_layer", l.getName()));
                    }
                    log.info("Merging layer [" + l.getName() + "] ...");
                    success = layer.mergeWorkspace();
                    log.info("Done merging layer [" + l.getName() + "].");
                }
                catch (Exception eex) {
                    log.severe("Exception: " + eex.getMessage());
                    ex = eex;
                }
                if (ex != null || !success) {
                    this.layerStatus.put(layer, MessagesBundle.getMessage("Unable_tomerge_conflicts"));
                    continue;
                }
                this.layerStatus.put(layer, MessagesBundle.getMessage("Layer_merge_success"));
                String baseTable = layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable");
                String spatialColumn = layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn");
                if (baseTable == null || spatialColumn == null || !(this.sessionProvider instanceof MDSEditSessionProvider) || (sessions = new ArrayList<EditSession>(this.loadedSessions)).size() <= 0) continue;
                for (int i = 0; i < sessions.size(); ++i) {
                    EditSession s = sessions.get(i);
                    if (!(s instanceof MDSEditSession) || s == this || ((MDSEditSession)s).isVersioned() || (MDSEditSession)s == MVConnection.DataSource.getNullSessionMarker()) continue;
                    for (Layer ls : s.getLayers()) {
                        MVConnection.DataSource ds;
                        if (ls instanceof WFSLayer || !(ls instanceof AbstractDataSetLayer)) continue;
                        String lsBaseTable = ((AbstractDataSetLayer)ls).getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable");
                        String lsSpatialColumn = ((AbstractDataSetLayer)ls).getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn");
                        if (!baseTable.equalsIgnoreCase(lsBaseTable) || !spatialColumn.equalsIgnoreCase(lsSpatialColumn) || (ds = MDSEditSession.this.getMVConnectionDataSource((MDSEditSessionProvider)this.sessionProvider, s)) == null) continue;
                        ds.setAsNullSession(s.getName());
                    }
                }
            }
            if (this.dlg != null) {
                this.dlg.setVisible(false);
            }
        }

        public void endThread() {
            this.endThread = true;
        }
    }

    private class GetConflictsThread
    extends Thread {
        private int totalConflicts = 0;
        private Iterator<Layer> itr = null;
        private Hashtable<WorkspaceLayer, Vector<FeatureConflictDescriptor>> conflicts = null;
        private ProgressDialog dlg = null;
        private boolean endThread = false;

        public GetConflictsThread(Iterator<Layer> itr, Hashtable<WorkspaceLayer, Vector<FeatureConflictDescriptor>> conflicts, ProgressDialog dlg) {
            this.itr = itr;
            this.conflicts = conflicts;
            this.dlg = dlg;
        }

        @Override
        public void run() {
            this.endThread = false;
            this.totalConflicts = 0;
            if (this.itr == null || this.conflicts == null) {
                log.warning("Unable to process conflicts thread.");
                return;
            }
            if (this.dlg != null) {
                this.dlg.setTitle(MessagesBundle.getMessage("Building_conflict_list"));
            }
            while (this.itr.hasNext() && !this.endThread) {
                Layer l = this.itr.next();
                if (!(l instanceof WorkspaceLayer) || l instanceof WFSLayer || !l.isVisible()) continue;
                WorkspaceLayer layer = (WorkspaceLayer)l;
                Vector<FeatureConflictDescriptor> c = null;
                if (this.dlg != null) {
                    this.dlg.setTaskMessage(MessagesBundle.getFormattedMessage("Processing_layer", layer.getName()));
                }
                try {
                    if (layer.isVersionEnabled()) {
                        c = layer.getConflicts();
                    }
                    if (c == null || c.size() <= 0) continue;
                    this.conflicts.put(layer, c);
                    this.totalConflicts += c.size();
                }
                catch (Exception ex) {
                    log.warning("Exception while getting conflicts for layer [" + layer.getName() + "]: " + ex.getMessage());
                }
            }
            if (this.dlg != null) {
                this.dlg.setVisible(false);
            }
        }

        public int getNumberOfConflicts() {
            return this.totalConflicts;
        }

        public void endThread() {
            this.endThread = true;
        }
    }

    private class EditSessionPreferencesPanel
    extends JPanel {
        private JLabel versionedLabel = new JLabel();
        private JLabel versionedValueLabel = new JLabel();
        private JLabel timeoutLabel = new JLabel();
        private JTextField timeoutTxt = new JTextField();
        private JLabel loggingLabel = new JLabel();
        private JComboBox loggingCombo = new JComboBox();
        private TitledPane proxyTitledPane = new TitledPane();
        private JPanel proxyPanel = new JPanel();
        private JCheckBox proxyBox = new JCheckBox();
        private JLabel proxyHostL = new JLabel();
        private JLabel proxyPortL = new JLabel();
        private JTextField proxyHostTF = new JTextField();
        private JTextField proxyPortTF = new JTextField();
        private JButton applyButton = new JButton();
        private GridBagLayout gridBagLayout1 = new GridBagLayout();
        private MDSEditSession editSession = null;

        public EditSessionPreferencesPanel(MDSEditSession edsession) {
            this.editSession = edsession;
            try {
                this.jbInit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void jbInit() throws Exception {
            this.setLayout(this.gridBagLayout1);
            this.setSize(new Dimension(305, 154));
            this.versionedLabel.setText(MessagesBundle.getMessage("Label_versioned_session"));
            this.timeoutLabel.setText(MessagesBundle.getMessage("Label_http_timeout"));
            this.timeoutTxt.setText("30");
            this.timeoutTxt.setToolTipText(MessagesBundle.getMessage("Tooltip_http_timeout"));
            this.loggingLabel.setText(MessagesBundle.getMessage("Label_logging_level"));
            this.loggingCombo.addItem("info");
            this.loggingCombo.addItem("finest");
            this.proxyBox.setText(MessagesBundle.getMessage("Checkbox_use_httpproxy"));
            this.proxyBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditSessionPreferencesPanel.this.proxyBox_actionPerformed(e);
                }
            });
            this.proxyHostL.setText(MessagesBundle.getMessage("Label_host"));
            this.proxyPortL.setText(MessagesBundle.getMessage("Label_port"));
            this.proxyHostTF.setText("www-proxy.yourhost.com");
            this.proxyPortTF.setText("80");
            this.proxyPanel.setLayout(new GridBagLayout());
            this.proxyPanel.setSize(new Dimension(240, 100));
            this.proxyPanel.setPreferredSize(new Dimension(240, 10));
            this.proxyTitledPane.setTitle((Component)this.proxyBox);
            this.proxyTitledPane.setContent((Component)this.proxyPanel);
            this.proxyPanel.add((Component)this.proxyHostL, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 25, 0, 0), 0, 0));
            this.proxyPanel.add((Component)this.proxyHostTF, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 70, 0, 10), 0, 0));
            this.proxyPanel.add((Component)this.proxyPortL, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 25, 10, 0), 0, 0));
            this.proxyPanel.add((Component)this.proxyPortTF, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 70, 10, 10), 0, 0));
            this.applyButton.setText(MessagesBundle.getMessage("Button_apply"));
            this.applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditSessionPreferencesPanel.this.applyButton_actionPerformed(e);
                }
            });
            this.add((Component)this.versionedLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 0, 0), 0, 0));
            this.add((Component)this.versionedValueLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 0, 10), 0, 0));
            this.add((Component)this.loggingLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 0, 0), 0, 0));
            this.add((Component)this.loggingCombo, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 0, 10), 0, 0));
            this.add((Component)this.timeoutLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 0), 0, 0));
            this.add((Component)this.timeoutTxt, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
            this.add((Component)this.proxyTitledPane, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 17, 1, new Insets(15, 10, 0, 10), 0, 0));
            this.add((Component)this.applyButton, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 0, 0), 0, 0));
            this.updateFields();
            this.updateFieldsStatus();
        }

        public boolean useProxyServer() {
            return this.proxyBox.isSelected();
        }

        public void setProxyServerUse(boolean use) {
            this.proxyBox.setSelected(use);
        }

        public String getProxyHost() {
            return this.proxyHostTF.getText();
        }

        public void setProxyHost(String host) {
            if (host == null) {
                this.proxyHostTF.setText("www-proxy.foo.com");
            } else {
                this.proxyHostTF.setText(host.trim());
            }
        }

        public String getProxyPort() {
            return this.proxyPortTF.getText();
        }

        public void setProxyPort(String port) {
            if (port == null) {
                this.proxyPortTF.setText("80");
            } else {
                this.proxyPortTF.setText(port.trim());
            }
        }

        private void proxyBox_actionPerformed(ActionEvent e) {
            this.updateFieldsStatus();
        }

        public void updateFieldsStatus() {
            if (this.proxyBox.isSelected()) {
                this.proxyHostTF.setEnabled(true);
                this.proxyPortTF.setEnabled(true);
            } else {
                this.proxyHostTF.setEnabled(false);
                this.proxyPortTF.setEnabled(false);
            }
        }

        public void setConnectionTimeout(int timeout) {
            NumberFormat nf = NumberFormat.getInstance();
            this.timeoutTxt.setText(nf.format(timeout));
        }

        public int getConnectionTimeout() {
            String text = this.timeoutTxt.getText();
            if (text == null || text.length() == 0) {
                return 30;
            }
            NumberFormat nf = NumberFormat.getInstance();
            try {
                int id = nf.parse(text).intValue();
                return id;
            }
            catch (Exception e) {
                return 30;
            }
        }

        public void setLoggingLevel(String level) {
            if (level == null) {
                return;
            }
            this.loggingCombo.setSelectedItem(level.toLowerCase());
        }

        public String getLoggingLevel() {
            return this.loggingCombo.getSelectedItem().toString();
        }

        private void applyButton_actionPerformed(ActionEvent e) {
            Properties p;
            if (this.editSession == null) {
                return;
            }
            this.editSession.setProperty(MDSEditSession.PROPERTY_LOG_LEVEL, this.getLoggingLevel());
            Level level = Level.INFO;
            if (this.getLoggingLevel().equalsIgnoreCase("finest")) {
                level = Level.FINEST;
            }
            log;
            for (Handler h : Logger.getLogger("").getHandlers()) {
                if (!(h instanceof ConsoleHandler)) continue;
                h.setLevel(level);
            }
            log.setLevel(level);
            this.editSession.setProperty(MDSEditSession.PROPERTY_HTTP_TIMEOUT, String.valueOf(this.getConnectionTimeout()));
            if (this.useProxyServer()) {
                this.editSession.setProperty(MDSEditSession.PROPERTY_PROXY_HOST, this.getProxyHost());
                this.editSession.setProperty(MDSEditSession.PROPERTY_PROXY_PORT, this.getProxyPort());
                p = new Properties(System.getProperties());
                p.put("proxySet", "true");
                p.put("proxyHost", this.getProxyHost());
                p.put("proxyPort", this.getProxyPort());
            } else {
                this.editSession.setProperty(MDSEditSession.PROPERTY_PROXY_HOST, null);
                this.editSession.setProperty(MDSEditSession.PROPERTY_PROXY_PORT, null);
                p = new Properties(System.getProperties());
                p.remove("proxySet");
                p.remove("proxyHost");
                p.remove("proxyPort");
            }
        }

        private void updateFields() {
            String httpTimeout;
            if (this.editSession == null) {
                return;
            }
            String versioned = this.editSession.getProperty(MDSEditSession.PROPERTY_VERSIONED);
            this.versionedValueLabel.setText(versioned);
            String logLevel = this.editSession.getProperty(MDSEditSession.PROPERTY_LOG_LEVEL);
            if (logLevel != null && !logLevel.equalsIgnoreCase("null")) {
                this.setLoggingLevel(logLevel.toLowerCase());
            }
            if ((httpTimeout = this.editSession.getProperty(MDSEditSession.PROPERTY_HTTP_TIMEOUT)) != null && !httpTimeout.equalsIgnoreCase("null")) {
                try {
                    int value = Integer.parseInt(httpTimeout);
                    this.setConnectionTimeout(value);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            String proxyHost = this.editSession.getProperty(MDSEditSession.PROPERTY_PROXY_HOST);
            String proxyPort = this.editSession.getProperty(MDSEditSession.PROPERTY_PROXY_PORT);
            if (proxyHost != null && !proxyHost.equalsIgnoreCase("null") && proxyPort != null && !proxyPort.equalsIgnoreCase("null")) {
                this.setProxyHost(proxyHost);
                this.setProxyPort(proxyPort);
                this.setProxyServerUse(true);
            } else {
                this.setProxyServerUse(false);
            }
        }
    }
}

