/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.model.topology;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import oracle.maps.geoobject.AbstractFeature;
import oracle.maps.geoobject.WorkSpace;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.TopoPrimitiveDescriptor;
import oracle.mapviewer.share.TopologyMetadata;
import oracle.spatial.edit.model.AbstractDataAccessObject;
import oracle.spatial.edit.model.AbstractDataSet;
import oracle.spatial.edit.model.EditChangeEvent;
import oracle.spatial.edit.model.MDSException;
import oracle.spatial.edit.model.topology.TopologyFeature;
import oracle.spatial.edit.model.topology.TopologyGeometry;
import oracle.spatial.edit.model.topology.TopologyModel;

public class TopologySet
extends AbstractDataSet {
    private TopologyModel topoModel = null;
    private TopologyMetadata metadata = null;
    private Hashtable<String, ArrayList<TopologyFeature>> nodeRelations = new Hashtable();
    private Hashtable<String, ArrayList<TopologyFeature>> edgeRelations = new Hashtable();
    private Hashtable<String, ArrayList<TopologyFeature>> faceRelations = new Hashtable();
    private TopologySet childSet = null;
    private Hashtable<String, TopologyFeature> topogeomRelations = new Hashtable();

    public TopologySet(String name, TopologyModel model) {
        this.setName(name);
        this.dataModel = model;
        this.topoModel = model;
        if (model != null) {
            model.registerTopologySet(this);
        }
        this.type = AbstractDataSet.TOPOLOGY_FEATURE_SET;
    }

    public TopologyModel getTopologyModel() {
        return this.topoModel;
    }

    public void setTopologyModel(TopologyModel model) {
        this.dataModel = model;
        this.topoModel = model;
        if (model != null) {
            model.registerTopologySet(this);
        }
    }

    public TopologySet getTopologyChildSet() {
        return this.childSet;
    }

    public void setTopologyChildSet(TopologySet set) {
        this.childSet = set;
    }

    public boolean loadData(AbstractDataAccessObject da, Rectangle2D mbr, String workspace, int mode) throws Exception, MDSException {
        if (this.topoModel == null) {
            throw new Exception("Topology model is null.");
        }
        if (this.metadata == null) {
            this.metadata = da.loadTopologyMetadata(this.topoModel.getName(), this.baseTable, this.geometryColumn);
        }
        super.loadData(da, mbr, new WorkSpace(workspace), mode);
        Vector<AbstractFeature> topoFeatures = da.loadTopologyFeatures(this.topoModel.getName(), this.baseTable, this.geometryColumn, mbr, new WorkSpace(workspace));
        if (topoFeatures != null) {
            for (int i = 0; i < topoFeatures.size(); ++i) {
                AbstractFeature tf = topoFeatures.get(i);
                Field f = tf.getAttribute(this.keyColumn);
                if (f == null) continue;
                String key = f.getValue().toString();
                this.features.put(key, tf);
                this.updateFeatureParameters((TopologyFeature)tf);
                this.addTopoPrimitiveRelations((TopologyFeature)tf);
                this.addTopoFeatureRelation((TopologyFeature)tf);
            }
            if (this.geomDimension == -1 && topoFeatures.size() > 0) {
                this.geomDimension = 2;
            }
        }
        return true;
    }

    public TopologyMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(TopologyMetadata meta) {
        this.metadata = meta;
    }

    @Override
    public boolean addFeature(AbstractFeature feature) throws Exception {
        super.addFeature(feature);
        this.updateFeatureParameters((TopologyFeature)feature);
        this.addTopoPrimitiveRelations((TopologyFeature)feature);
        this.addTopoFeatureRelation((TopologyFeature)feature);
        return true;
    }

    @Override
    public boolean appendFeature(AbstractFeature feature) throws Exception {
        super.appendFeature(feature);
        this.updateFeatureParameters((TopologyFeature)feature);
        this.addTopoPrimitiveRelations((TopologyFeature)feature);
        this.addTopoFeatureRelation((TopologyFeature)feature);
        return true;
    }

    @Override
    public boolean removeFeature(String key) throws Exception {
        TopologyFeature feature = (TopologyFeature)this.getFeature(key);
        if (feature == null) {
            return false;
        }
        super.removeFeature(key);
        this.removeTopoPrimitiveRelations(feature);
        this.removeTopoFeatureRelation(feature);
        return true;
    }

    @Override
    public boolean updateFeatureGeometry(String key, Object newGeometry) throws Exception {
        if (key == null || newGeometry == null) {
            return false;
        }
        TopologyFeature feature = (TopologyFeature)this.getFeature(key);
        if (feature == null) {
            return false;
        }
        this.removeTopoPrimitiveRelations(feature);
        super.updateFeatureGeometry(key, newGeometry);
        this.addTopoPrimitiveRelations(feature);
        this.addTopoFeatureRelation(feature);
        return true;
    }

    private void updateFeatureParameters(TopologyFeature feature) {
        TopologyGeometry tpgeom;
        if (feature == null) {
            return;
        }
        feature.setTopologyModel(this.topoModel);
        if (this.geomDimension == -1) {
            this.geomDimension = feature.getSpatialDimension();
        }
        if ((tpgeom = feature.getSpatialAttribute()) != null && this.metadata != null) {
            tpgeom.setLayerId(this.metadata.getTopoLayerId());
            tpgeom.setTopoType(this.metadata.getTopoLayerType());
        }
    }

    private boolean addTopoPrimitiveRelations(TopologyFeature feature) {
        TopoPrimitiveDescriptor[] tpds;
        if (feature == null || this.metadata == null) {
            return false;
        }
        if (this.metadata.getTopoLayerLevel() != 0) {
            return false;
        }
        TopologyGeometry tpgeom = feature.getSpatialAttribute();
        if (tpgeom != null && (tpds = tpgeom.getTopoPrimitives()) != null) {
            for (int j = 0; j < tpds.length; ++j) {
                this.addTopoPrimitiveRelation(tpds[j].getTopoId(), tpds[j].getTopoType(), feature);
            }
        }
        return true;
    }

    private boolean addTopoPrimitiveRelation(int topoId, int topoType, TopologyFeature feature) {
        if (feature == null || this.metadata == null) {
            return false;
        }
        if (this.metadata.getTopoLayerLevel() != 0) {
            return false;
        }
        if (topoType == 1) {
            ArrayList<TopologyFeature> feats = this.nodeRelations.get("" + topoId);
            if (feats == null) {
                feats = new ArrayList();
                this.nodeRelations.put("" + topoId, feats);
            }
            feats.add(feature);
        } else if (topoType == 2) {
            ArrayList<TopologyFeature> feats = this.edgeRelations.get("" + topoId);
            if (feats == null) {
                feats = new ArrayList();
                this.edgeRelations.put("" + topoId, feats);
            }
            feats.add(feature);
        } else if (topoType == 3) {
            ArrayList<TopologyFeature> feats = this.faceRelations.get("" + topoId);
            if (feats == null) {
                feats = new ArrayList();
                this.faceRelations.put("" + topoId, feats);
            }
            feats.add(feature);
        } else {
            return false;
        }
        return true;
    }

    private boolean removeTopoPrimitiveRelations(TopologyFeature feature) {
        TopoPrimitiveDescriptor[] tpds;
        if (feature == null) {
            return false;
        }
        Field key = feature.getAttribute(this.keyColumn);
        if (key == null || key.getValue() == null) {
            return false;
        }
        TopologyGeometry tpgeom = feature.getSpatialAttribute();
        if (tpgeom != null && (tpds = tpgeom.getTopoPrimitives()) != null) {
            for (int j = 0; j < tpds.length; ++j) {
                this.removeTopoPrimitiveRelation(tpds[j].getTopoId(), tpds[j].getTopoType(), key.getValue().toString());
            }
        }
        return true;
    }

    private boolean removeTopoPrimitiveRelation(int topoId, int topoType, String featureKey) {
        if (featureKey == null) {
            return false;
        }
        ArrayList<TopologyFeature> feats = null;
        if (topoType == 1) {
            feats = this.nodeRelations.get("" + topoId);
        } else if (topoType == 2) {
            feats = this.edgeRelations.get("" + topoId);
        } else if (topoType == 3) {
            feats = this.faceRelations.get("" + topoId);
        } else {
            return false;
        }
        if (feats == null) {
            return false;
        }
        for (int j = 0; j < feats.size(); ++j) {
            TopologyFeature tf = feats.get(j);
            Field key = tf.getAttribute(this.keyColumn);
            if (key == null || key.getValue() == null || !key.getValue().equals(featureKey)) continue;
            feats.remove(j);
            return true;
        }
        return false;
    }

    private boolean addTopoFeatureRelation(TopologyFeature feature) {
        if (feature == null) {
            return false;
        }
        TopologyGeometry tpgeom = feature.getSpatialAttribute();
        if (tpgeom != null) {
            int id = tpgeom.getId();
            this.topogeomRelations.put("" + id, feature);
        }
        return true;
    }

    private boolean removeTopoFeatureRelation(TopologyFeature feature) {
        if (feature == null) {
            return false;
        }
        TopologyGeometry tpgeom = feature.getSpatialAttribute();
        if (tpgeom != null) {
            this.topogeomRelations.remove("" + tpgeom.getId());
        }
        return true;
    }

    public TopologyFeature getFeatureFromTopoRelation(int tpgeomId) {
        return this.topogeomRelations.get("" + tpgeomId);
    }

    public TopologyFeature[] getFeaturesWithTopoPrimitiveRelation(int topoId, int topoType) {
        ArrayList<TopologyFeature> features = null;
        if (topoType == 1) {
            features = this.nodeRelations.get("" + topoId);
        } else if (topoType == 2) {
            features = this.edgeRelations.get("" + topoId);
        } else if (topoType == 3) {
            features = this.faceRelations.get("" + topoId);
        }
        if (features == null || features.size() == 0) {
            return null;
        }
        return features.toArray(new TopologyFeature[features.size()]);
    }

    public int getNextTopoGeometryId(AbstractDataAccessObject dataAccess) throws Exception {
        if (dataAccess == null) {
            throw new Exception("Data access is null.");
        }
        if (this.metadata == null) {
            throw new Exception("Metadata is null.");
        }
        try {
            int nextId;
            dataAccess.openConnection();
            int n = nextId = (int)dataAccess.getSequenceNextValue(this.metadata.getTopoGeometrySequence());
            return n;
        }
        catch (Exception ex) {
            throw ex;
        }
        catch (MDSException me) {
            throw new Exception(me.getMessage());
        }
        finally {
            try {
                dataAccess.closeConnection();
            }
            catch (Exception e) {}
        }
    }

    @Override
    public boolean save(AbstractDataAccessObject da) throws Exception, MDSException {
        if (!this.isModified()) {
            return true;
        }
        if (this.topoModel != null && this.topoModel.isModified()) {
            throw new Exception("Base topology primitives have been modified. Use save method of topology model class");
        }
        return super.save(da);
    }

    @Override
    public void undo(EditChangeEvent change) {
        if (change == null) {
            return;
        }
        String key = change.getKey();
        int eventType = change.getEventType();
        int updateType = change.getUpdateType();
        TopologyFeature feature = null;
        if (eventType == EditChangeEvent.NEW_EVENT || eventType == EditChangeEvent.UPDATE_EVENT && updateType == EditChangeEvent.SPATIAL_UPDATE) {
            feature = (TopologyFeature)this.getFeature(key);
            if (feature == null) {
                return;
            }
            this.removeTopoPrimitiveRelations(feature);
            this.removeTopoFeatureRelation(feature);
        }
        super.undo(change);
        if (eventType == EditChangeEvent.REMOVE_EVENT || eventType == EditChangeEvent.UPDATE_EVENT && updateType == EditChangeEvent.SPATIAL_UPDATE) {
            feature = (TopologyFeature)this.getFeature(key);
            if (feature == null) {
                return;
            }
            this.addTopoPrimitiveRelations(feature);
            this.addTopoFeatureRelation(feature);
        }
    }

    @Override
    public void redo(EditChangeEvent change) {
        if (change == null) {
            return;
        }
        String key = change.getKey();
        int eventType = change.getEventType();
        int updateType = change.getUpdateType();
        TopologyFeature feature = null;
        if (eventType == EditChangeEvent.REMOVE_EVENT || eventType == EditChangeEvent.UPDATE_EVENT && updateType == EditChangeEvent.SPATIAL_UPDATE) {
            feature = (TopologyFeature)this.getFeature(key);
            if (feature == null) {
                return;
            }
            this.removeTopoPrimitiveRelations(feature);
            this.removeTopoFeatureRelation(feature);
        }
        super.redo(change);
        if (eventType == EditChangeEvent.NEW_EVENT || eventType == EditChangeEvent.UPDATE_EVENT && updateType == EditChangeEvent.SPATIAL_UPDATE) {
            feature = (TopologyFeature)this.getFeature(key);
            if (feature == null) {
                return;
            }
            this.addTopoPrimitiveRelations(feature);
            this.addTopoFeatureRelation(feature);
        }
    }
}

