/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.model;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.maps.core.GeoObject;
import oracle.maps.geoobject.AbstractFeature;
import oracle.maps.geoobject.WorkSpace;
import oracle.mapviewer.share.Field;
import oracle.spatial.edit.index.AbstractIndexedDataSet;
import oracle.spatial.edit.model.AbstractDataAccessObject;
import oracle.spatial.edit.model.AbstractDataModel;
import oracle.spatial.edit.model.EditChangeEvent;
import oracle.spatial.edit.model.EditChangeManager;
import oracle.spatial.edit.model.MDSException;
import oracle.spatial.edit.util.TableAttributesMetadata;

public abstract class AbstractDataSet {
    public static int READ_ONLY_SET = 1;
    public static int READ_WRITE_SET = 2;
    public static String GEOMETRY_SET = "geometry";
    public static String TOPOLOGY_FEATURE_SET = "topofeature";
    public static String ANNOTATION_TEXT_SET = "annotation";
    protected AbstractIndexedDataSet indexedSet = null;
    protected String datasetName = null;
    protected String baseTable = null;
    protected String geometryColumn = null;
    protected String keyColumn = null;
    protected String workspace = null;
    protected String sequenceName = null;
    protected Hashtable<String, AbstractFeature> features = new Hashtable();
    protected EditChangeManager changeCache = new EditChangeManager(this.features, this);
    protected int geomDimension = -1;
    protected long geomSRID = 0L;
    protected boolean hasGeodeticSRID = false;
    protected int mode = READ_WRITE_SET;
    protected String type = null;
    protected AbstractDataModel dataModel = null;
    protected Rectangle2D workingArea = null;
    protected Hashtable<String, String> attrJavaTypes = new Hashtable();
    protected Vector<String> nonNullAttributes = new Vector();
    protected String queryCondition = null;

    public String getName() {
        return this.datasetName;
    }

    public void setName(String name) {
        this.datasetName = name;
    }

    public void setSpatialInfo(String tableName, String keyColumn, String geomColumn) {
        this.baseTable = tableName;
        this.keyColumn = keyColumn;
        this.geometryColumn = geomColumn;
        if (this.features.size() > 0) {
            Hashtable<String, AbstractFeature> clone = new Hashtable<String, AbstractFeature>(this.features);
            this.features.clear();
            for (AbstractFeature f : clone.values()) {
                Field keyField = f.getAttribute(keyColumn);
                if (keyField == null || keyField.getValue() == null) continue;
                this.features.put(keyField.getValue().toString(), f);
            }
        }
    }

    public String getBaseTable() {
        return this.baseTable;
    }

    public String getGeometryColumn() {
        return this.geometryColumn;
    }

    public String getKeyColumn() {
        return this.keyColumn;
    }

    public void setSequenceName(String sequence) {
        this.sequenceName = sequence;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public boolean loadMetaData(AbstractDataAccessObject da) throws Exception, MDSException {
        if (da == null) {
            throw new Exception("Data access object is null.");
        }
        if (this.baseTable == null) {
            throw new Exception("Data set base table is null.");
        }
        if (this.geometryColumn == null) {
            throw new Exception("Data set spatial column is null.");
        }
        if (this.keyColumn == null) {
            throw new Exception("Data set key column is null.");
        }
        try {
            da.openConnection();
            TableAttributesMetadata tbmeta = da.getTableAttributesMetadata(this.baseTable, this.geometryColumn, this.type);
            this.geomSRID = tbmeta.getSRID();
            this.hasGeodeticSRID = tbmeta.isGeoedeticSRID();
            this.attrJavaTypes = tbmeta.getAttributesJavaType();
            Vector<String> nonNullAttrs = tbmeta.getNonNullAttributes();
            this.adjustColumnNames();
            if (this.keyColumn != null && this.keyColumn.equalsIgnoreCase("rowid") && this.attrJavaTypes != null) {
                this.attrJavaTypes.put(this.keyColumn, "String");
            }
            if (this.keyColumn != null && !this.keyColumn.equalsIgnoreCase("rowid")) {
                this.addToNonNullAttributes(this.keyColumn);
            }
            if (nonNullAttrs != null) {
                for (int i = 0; i < nonNullAttrs.size(); ++i) {
                    this.addToNonNullAttributes(nonNullAttrs.get(i));
                }
            }
        }
        catch (MDSException ex) {
            ex.printStackTrace();
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            throw ex;
        }
        finally {
            try {
                da.closeConnection();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return true;
    }

    public boolean loadData(AbstractDataAccessObject da, Rectangle2D mbr, WorkSpace workspace, int mode) throws Exception, MDSException {
        if (da == null) {
            throw new Exception("Data access object is null.");
        }
        if (this.baseTable == null) {
            throw new Exception("Data set base table is null.");
        }
        if (this.geometryColumn == null) {
            throw new Exception("Data set spatial column is null.");
        }
        if (this.keyColumn == null) {
            throw new Exception("Data set key column is null.");
        }
        if (mbr == null) {
            throw new Exception("Edit area to load is null.");
        }
        this.clearFeatures();
        da.setProperty("layerName", this.datasetName);
        try {
            Vector<AbstractFeature> geomFeatures;
            da.openConnection();
            TableAttributesMetadata tbmeta = da.getTableAttributesMetadata(this.baseTable, this.geometryColumn, this.type);
            this.geomSRID = tbmeta.getSRID();
            this.hasGeodeticSRID = tbmeta.isGeoedeticSRID();
            this.attrJavaTypes = tbmeta.getAttributesJavaType();
            Vector<String> nonNullAttrs = tbmeta.getNonNullAttributes();
            this.adjustColumnNames();
            if (this.keyColumn != null && this.keyColumn.equalsIgnoreCase("rowid") && this.attrJavaTypes != null) {
                this.attrJavaTypes.put(this.keyColumn, "String");
            }
            if (this.keyColumn != null && !this.keyColumn.equalsIgnoreCase("rowid")) {
                this.addToNonNullAttributes(this.keyColumn);
            }
            if (nonNullAttrs != null) {
                for (int i = 0; i < nonNullAttrs.size(); ++i) {
                    this.addToNonNullAttributes(nonNullAttrs.get(i));
                }
            }
            this.geomDimension = -1;
            if (!(this.type != null && this.type.equalsIgnoreCase(TOPOLOGY_FEATURE_SET) || (geomFeatures = da.loadData(mbr, workspace, this.type, this.getQueryForLoading(), this.baseTable, this.geometryColumn, this.geomSRID, this.hasGeodeticSRID)) == null)) {
                for (int i = 0; i < geomFeatures.size(); ++i) {
                    AbstractFeature gf = geomFeatures.get(i);
                    Field f = gf.getAttribute(this.keyColumn);
                    if (f == null) continue;
                    String key = f.getValue().toString();
                    this.features.put(key, gf);
                }
                if (this.features.size() > 0) {
                    this.geomDimension = geomFeatures.get(0).getSpatialDimension();
                }
            }
            this.mode = mode;
            this.workingArea = mbr;
        }
        catch (MDSException ex) {
            ex.printStackTrace();
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            throw ex;
        }
        finally {
            try {
                da.closeConnection();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return true;
    }

    public boolean save(AbstractDataAccessObject da) throws Exception, MDSException {
        if (this.mode != READ_WRITE_SET) {
            throw new Exception("Data set is read only.");
        }
        if (da == null) {
            throw new Exception("Data access object is null.");
        }
        if (!this.isModified()) {
            return true;
        }
        da.openConnection();
        boolean save = da.saveDataSet(this);
        if (!save) {
            return false;
        }
        this.clearChanges();
        return true;
    }

    public String getType() {
        return this.type;
    }

    public int getMode() {
        return this.mode;
    }

    public boolean isInEditMode() {
        return this.mode == READ_WRITE_SET;
    }

    public void setDataModel(AbstractDataModel model) {
        this.dataModel = model;
    }

    public AbstractDataModel getDataModel() {
        return this.dataModel;
    }

    public Rectangle2D getWorkingArea() {
        return this.workingArea;
    }

    public String getAttributeJavaType(String attrName) {
        if (attrName == null || this.attrJavaTypes == null) {
            return null;
        }
        return this.attrJavaTypes.get(attrName);
    }

    public String setAttributeJavaType(String attrName, String attrType) {
        if (attrName == null || attrName.trim().isEmpty() || attrType == null || attrType.trim().isEmpty()) {
            return null;
        }
        if (this.attrJavaTypes == null) {
            this.attrJavaTypes = new Hashtable();
        }
        return this.attrJavaTypes.put(attrName, attrType);
    }

    public String[] getAttributeNames() {
        String[] attrs = new String[this.attrJavaTypes == null ? 0 : this.attrJavaTypes.size()];
        int i = 0;
        Enumeration<String> e = this.attrJavaTypes.keys();
        while (e.hasMoreElements()) {
            attrs[i] = e.nextElement();
            ++i;
        }
        return attrs;
    }

    public String getRealKeyValue(String keyColumn, String keyValue) {
        Field f;
        if (keyColumn == null || keyColumn.trim().isEmpty() || keyValue == null || keyValue.trim().isEmpty()) {
            return keyValue;
        }
        String key = keyValue;
        String keyType = this.getAttributeJavaType(keyColumn);
        if (keyType != null && !keyType.trim().isEmpty() && !keyType.equalsIgnoreCase("String") && (f = Field.createField((String)keyValue, (String)keyType.toLowerCase())) != null && f.getValue() != null) {
            key = f.getValue().toString();
        }
        return key;
    }

    public Vector<String> getNonNullAttributes() {
        return this.nonNullAttributes;
    }

    public void addToNonNullAttributes(String attr) {
        if (attr == null) {
            return;
        }
        for (int i = 0; i < this.nonNullAttributes.size(); ++i) {
            if (!attr.equalsIgnoreCase(this.nonNullAttributes.get(i))) continue;
            return;
        }
        this.nonNullAttributes.add(attr);
    }

    public boolean isNonNullAttribute(String attr) {
        if (attr == null) {
            return false;
        }
        for (int i = 0; i < this.nonNullAttributes.size(); ++i) {
            if (!attr.equalsIgnoreCase(this.nonNullAttributes.get(i))) continue;
            return true;
        }
        return false;
    }

    public Object getFeatureSpatialAttribute(String key) {
        if (key == null) {
            return null;
        }
        AbstractFeature feat = this.getFeature(key);
        if (feat == null) {
            return null;
        }
        return feat.getSpatialAttribute();
    }

    public Field getFeatureAttribute(String key, String attrName) {
        if (key == null || attrName == null) {
            return null;
        }
        AbstractFeature feat = this.getFeature(key);
        if (feat == null) {
            return null;
        }
        return feat.getAttribute(attrName);
    }

    public int getGeometryDimensions() {
        return this.geomDimension;
    }

    public long getGeometrySrid() {
        return this.geomSRID;
    }

    public String[] getModifiedFeatures() {
        return this.changeCache.getModifiedFeatures();
    }

    public String[] getNewFeatures() {
        return this.changeCache.getNewFeatures();
    }

    public String[] getRemovedFeatures() {
        return this.changeCache.getRemovedFeatures();
    }

    public int size() {
        return this.features.size();
    }

    public boolean put(AbstractFeature feature) {
        if (feature == null) {
            return false;
        }
        if (this.keyColumn == null) {
            System.out.println("Data set key column is undefined.");
            return false;
        }
        Field f = feature.getAttribute(this.keyColumn);
        if (f == null) {
            return false;
        }
        String key = f.getValue().toString();
        if (this.getFeature(key) != null) {
            System.out.println("Unable to put feature [" + key + "], as it already exists.");
            return false;
        }
        this.features.put(key, feature);
        return true;
    }

    public boolean addFeature(AbstractFeature feature) throws Exception {
        if (!this.isInEditMode()) {
            throw new Exception("Data set is READ-ONLY");
        }
        if (this.keyColumn == null || feature == null) {
            throw new Exception("keycolumn or feature is null");
        }
        Field field = feature.getAttribute(this.keyColumn);
        if (field == null || field.getValue() == null) {
            throw new Exception("Feature must have a key value defined.");
        }
        if (this.getFeature(field.getValue().toString()) != null) {
            throw new Exception("Unable to add feature: key value [" + field.getValue().toString() + "] already exists.");
        }
        int backupDim = this.geomDimension;
        if (feature != null) {
            if (this.geomDimension == -1) {
                this.geomDimension = feature.getSpatialDimension();
            } else if (this.geomDimension != feature.getSpatialDimension()) {
                throw new Exception("Spatial attribute must have same dimension of current set.");
            }
        }
        String key = field.getValue().toString();
        try {
            this.changeCache.addFeature(key, feature);
        }
        catch (Exception ex) {
            this.geomDimension = backupDim;
            throw ex;
        }
        return true;
    }

    public boolean appendFeature(AbstractFeature feature) throws Exception {
        if (this.keyColumn == null || feature == null) {
            throw new Exception("keycolumn or feature is null");
        }
        Field field = feature.getAttribute(this.keyColumn);
        if (field == null || field.getValue() == null) {
            throw new Exception("Feature must have a key value defined.");
        }
        if (this.getFeature(field.getValue().toString()) != null) {
            throw new Exception("Unable to append feature: key value [" + field.getValue().toString() + "] already exists.");
        }
        if (feature != null) {
            if (this.geomDimension == -1) {
                this.geomDimension = feature.getSpatialDimension();
            } else if (this.geomDimension != feature.getSpatialDimension()) {
                throw new Exception("Spatial attribute must have same dimension of current set.");
            }
        }
        String key = field.getValue().toString();
        this.features.put(key, feature);
        return true;
    }

    public boolean deleteFeature(String key) throws Exception {
        if (key == null) {
            throw new Exception("key is null");
        }
        String keyValue = this.getRealKeyValue(this.keyColumn, key);
        return this.features.remove(key) != null;
    }

    public boolean removeFeature(String key) throws Exception {
        if (!this.isInEditMode()) {
            throw new Exception("dataset is READ-ONLY");
        }
        if (key == null) {
            throw new Exception("key is null");
        }
        String keyValue = this.getRealKeyValue(this.keyColumn, key);
        return this.changeCache.removeFeature(keyValue);
    }

    public boolean isRemovedFeature(String key) {
        if (key == null) {
            return false;
        }
        String keyValue = this.getRealKeyValue(this.keyColumn, key);
        return this.changeCache.isRemovedFeature(keyValue);
    }

    public boolean isModifiedFeature(String key) {
        if (key == null) {
            return false;
        }
        String keyValue = this.getRealKeyValue(this.keyColumn, key);
        return this.changeCache.isModifiedFeature(keyValue);
    }

    public boolean isNewFeature(String key) {
        if (key == null) {
            return false;
        }
        String keyValue = this.getRealKeyValue(this.keyColumn, key);
        return this.changeCache.isNewFeature(keyValue);
    }

    public boolean updateFeatureAttribute(String key, Field newValue) throws Exception {
        return this.updateFeatureAttributes(key, new Field[]{newValue});
    }

    public boolean updateFeatureAttributes(String key, Field[] newValues) throws Exception {
        if (!this.isInEditMode()) {
            throw new Exception("dataset is READ-ONLY");
        }
        if (newValues == null || newValues.length == 0) {
            throw new Exception("no fields to update");
        }
        AbstractFeature feature = this.getFeature(key);
        if (feature == null) {
            throw new Exception("There are no feature to be updated for key: " + key);
        }
        ArrayList<Field> toUpdate = new ArrayList<Field>();
        for (int i = 0; i < newValues.length; ++i) {
            String fieldName = newValues[i].getName();
            if (fieldName == null) {
                throw new Exception("Attribute field name must not be null. [" + i + "]");
            }
            if (fieldName.equalsIgnoreCase(this.keyColumn)) continue;
            Field featAttr = feature.getAttribute(fieldName);
            if (newValues[i].getValue() == null || newValues[i].getValue().toString() == null || featAttr != null && featAttr.getValue() != null && newValues[i].getValue().toString().equals(featAttr.getValue().toString())) continue;
            toUpdate.add(newValues[i]);
        }
        if (toUpdate.size() == 0) {
            return true;
        }
        String keyValue = this.getRealKeyValue(this.keyColumn, key);
        return this.changeCache.updateFeature(keyValue, toUpdate.toArray(new Field[toUpdate.size()]), EditChangeEvent.ATTRIBUTE_UPDATE);
    }

    public boolean updateFeatureGeometry(String key, Object newGeometry) throws Exception {
        if (!this.isInEditMode()) {
            throw new Exception("dataset is READ-ONLY");
        }
        if (key == null || newGeometry == null) {
            throw new Exception("key or newgeometry is null");
        }
        String keyValue = this.getRealKeyValue(this.keyColumn, key);
        return this.changeCache.updateFeature(keyValue, newGeometry, EditChangeEvent.SPATIAL_UPDATE);
    }

    public boolean isModified() {
        return this.changeCache.hasChanges();
    }

    public void undo(EditChangeEvent change) {
        this.changeCache.undo(change);
    }

    public void redo(EditChangeEvent change) {
        this.changeCache.redo(change);
    }

    public void clearFeatures() {
        this.features.clear();
        this.clearChanges();
    }

    public void clearChanges() {
        this.changeCache.clearChanges();
    }

    public List<GeoObject> getFeatures() {
        Vector<GeoObject> feats = new Vector<GeoObject>();
        Enumeration<AbstractFeature> e = this.features.elements();
        while (e.hasMoreElements()) {
            feats.add(e.nextElement());
        }
        return feats;
    }

    public AbstractFeature getFeature(String key) {
        if (key == null) {
            return null;
        }
        String keyValue = this.getRealKeyValue(this.keyColumn, key);
        return this.features.get(keyValue);
    }

    public String getFeatureKeyValue(AbstractFeature feat) {
        if (feat == null) {
            return null;
        }
        Field f = feat.getAttribute(this.keyColumn);
        if (f == null || f.getValue() == null) {
            return null;
        }
        return f.getValue().toString();
    }

    public String getQueryForLoading() {
        if (this.baseTable == null) {
            return null;
        }
        String query = null;
        query = this.keyColumn == null || this.keyColumn != null && !this.keyColumn.equalsIgnoreCase("rowid") ? "select * from " + this.baseTable : "select abs_set_edt.rowid, abs_set_edt.* from " + this.baseTable + " abs_set_edt";
        if (this.queryCondition != null) {
            query = query + " where " + this.queryCondition;
        }
        return query;
    }

    public boolean hasSpatialAttributeChanged(String key) {
        String keyValue = this.getRealKeyValue(this.keyColumn, key);
        return this.changeCache.hasSpatialAttributeChanged(keyValue);
    }

    public String[] getChangedAttributesOfModifiedFeature(String key) {
        String keyValue = this.getRealKeyValue(this.keyColumn, key);
        return this.changeCache.getChangedAttributesOfModifiedFeature(keyValue);
    }

    public void setHoldLayerUpdate(boolean value) {
        this.changeCache.setHoldLayerUpdate(value);
    }

    public String getKeyColumnJavaType() {
        if (this.keyColumn == null || this.attrJavaTypes == null) {
            return null;
        }
        return this.attrJavaTypes.get(this.keyColumn);
    }

    protected void adjustColumnNames() {
        int i;
        String[] attrs = this.getAttributeNames();
        if (this.keyColumn != null) {
            for (i = 0; i < attrs.length; ++i) {
                if (!this.keyColumn.equalsIgnoreCase(attrs[i])) continue;
                this.keyColumn = attrs[i];
                break;
            }
        }
        if (this.geometryColumn != null) {
            for (i = 0; i < attrs.length; ++i) {
                if (!this.geometryColumn.equalsIgnoreCase(attrs[i])) continue;
                this.geometryColumn = attrs[i];
                break;
            }
        }
    }

    public boolean hasGeodeticSRID() {
        return this.hasGeodeticSRID;
    }

    public String getQueryCondition() {
        return this.queryCondition;
    }

    public void setQueryCondition(String condition) {
        this.queryCondition = condition;
    }

    public void setIndexedSet(AbstractIndexedDataSet indexedSet) {
        this.indexedSet = indexedSet;
    }

    public AbstractIndexedDataSet getIndexedSet() {
        return this.indexedSet;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public String getWorkspace() {
        return this.workspace;
    }
}

