/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.model;

import java.awt.geom.Rectangle2D;
import oracle.spatial.edit.layer.AbstractDataSetLayer;
import oracle.spatial.edit.model.AbstractDataAccessObject;
import oracle.spatial.edit.model.AbstractDataSource;
import oracle.spatial.edit.model.MDSException;

public abstract class AbstractDataModel {
    public static int READ_ONLY_SET = 1;
    public static int READ_WRITE_SET = 2;
    public static String NETWORK_MODEL = "network";
    public static String TOPOLOGY_MODEL = "topology";
    protected String modelName = null;
    protected AbstractDataSetLayer layer = null;
    protected String type = null;
    protected int mode = READ_ONLY_SET;

    public String getName() {
        return this.modelName;
    }

    public void setName(String name) {
        this.modelName = name;
    }

    public String getType() {
        return this.type;
    }

    public int getMode() {
        return this.mode;
    }

    public abstract boolean load(AbstractDataAccessObject var1, Rectangle2D var2, String var3, int var4) throws Exception, MDSException;

    public boolean load(int mode) throws Exception, MDSException {
        if (this.layer == null) {
            System.out.println("DataSet layer is null.");
            throw new Exception("DataSet layer is null.");
        }
        AbstractDataSource dsrc = this.layer.getDataSource();
        if (dsrc == null) {
            System.out.println("Layer data source is null.");
            throw new Exception("Layer data source is null.");
        }
        AbstractDataAccessObject dataAccess = dsrc.getDataAccessObject();
        try {
            this.load(dataAccess, this.layer.getCanvas().getMapRegion().getDataWindow(), this.layer.getWorkspace().getName(), mode);
        }
        catch (MDSException ex) {
            ex.printStackTrace();
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            throw ex;
        }
        finally {
            if (dataAccess != null) {
                try {
                    dataAccess.closeConnection();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return true;
    }

    public abstract void clearModel();

    public abstract boolean isModified();

    public abstract boolean save() throws Exception, MDSException;

    public boolean isInEditMode() {
        return this.mode == READ_WRITE_SET;
    }

    public boolean closeDataAccessConnection() throws Exception {
        AbstractDataSource dsrc = this.layer.getDataSource();
        if (dsrc == null) {
            System.out.println("Edit session data source is null.");
            throw new Exception("Edit session data source is null.");
        }
        AbstractDataAccessObject dataAccess = dsrc.getDataAccessObject();
        if (dataAccess == null) {
            return true;
        }
        return dataAccess.closeConnection();
    }

    public abstract void undo() throws Exception;

    public abstract void startChangeBlock();

    public abstract void endChangeBlock();

    public abstract void clearChanges();

    public AbstractDataAccessObject getDataAccess() {
        AbstractDataSource dsrc = this.layer.getDataSource();
        if (dsrc == null) {
            return null;
        }
        AbstractDataAccessObject dataAccess = dsrc.getDataAccessObject();
        return dataAccess;
    }

    public void setLayer(AbstractDataSetLayer layer) {
        this.layer = layer;
    }

    public AbstractDataSetLayer getLayer() {
        return this.layer;
    }
}

