/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.index;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import oracle.maps.core.GeoObject;
import oracle.spatial.edit.index.AbstractSpatialIndex;
import oracle.spatial.util.RTree;

public class RTreeIndex
extends AbstractSpatialIndex
implements Serializable {
    static final long serialVersionUID = 65468421L;
    private RTree tree = null;

    public RTree getTree() {
        return this.tree;
    }

    @Override
    public boolean create(Properties props) {
        int dimension = 2;
        int nodeSize = 8;
        int minimumFill = 1;
        if (props != null) {
            String mf;
            String ns = props.getProperty("nodeSize");
            if (ns != null) {
                try {
                    nodeSize = Integer.valueOf(ns);
                    if (nodeSize < 1) {
                        nodeSize = 8;
                    }
                }
                catch (Exception e) {
                    nodeSize = 8;
                }
            }
            if ((mf = props.getProperty("minimuFill")) != null) {
                try {
                    minimumFill = Integer.valueOf(mf);
                    if (minimumFill < 1) {
                        minimumFill = 1;
                    }
                }
                catch (Exception e) {
                    minimumFill = 1;
                }
            }
        }
        this.properties = new Properties();
        this.properties.put("dimension", String.valueOf(dimension));
        this.properties.put("nodeSize", String.valueOf(nodeSize));
        this.properties.put("minimumFill", String.valueOf(minimumFill));
        this.tree = new RTree(dimension, nodeSize, minimumFill);
        return true;
    }

    @Override
    public boolean create(Properties props, List<GeoObject> features) {
        if (!this.create(props)) {
            return false;
        }
        if (features == null || features.size() == 0) {
            return true;
        }
        int count = 0;
        for (int i = 0; i < features.size(); ++i) {
            GeoObject edfeat = features.get(i);
            Rectangle2D mbr = edfeat.getMBR();
            if (mbr != null) continue;
            ++count;
        }
        if (count > 0) {
            System.out.println("RTreeIndex.create: " + count + " features with null MBR.");
        }
        Object[] objs = new Object[features.size() - count];
        double[][][] mbhlList = new double[features.size() - count][2][2];
        count = 0;
        for (int i = 0; i < features.size(); ++i) {
            GeoObject edfeat = features.get(i);
            Rectangle2D mbr = edfeat.getMBR();
            if (mbr == null) continue;
            objs[count] = edfeat;
            mbhlList[count][0][0] = mbr.getMinX();
            mbhlList[count][0][1] = mbr.getMaxX();
            mbhlList[count][1][0] = mbr.getMinY();
            mbhlList[count][1][1] = mbr.getMaxY();
            ++count;
        }
        try {
            this.tree.packTree(mbhlList, objs);
        }
        catch (Exception e) {
            this.tree = null;
            return false;
        }
        return true;
    }

    @Override
    public boolean addEntry(GeoObject feature) throws Exception {
        if (this.tree == null) {
            throw new Exception("Create tree first.");
        }
        if (feature == null) {
            throw new Exception("Feature is null");
        }
        Rectangle2D mbr = feature.getMBR();
        if (mbr == null) {
            throw new Exception("Feature spatial representation has null mbr.");
        }
        double[][] span = new double[][]{new double[2], new double[2]};
        span[0][0] = mbr.getMinX();
        span[0][1] = mbr.getMaxX();
        span[1][0] = mbr.getMinY();
        span[1][1] = mbr.getMaxY();
        this.tree.addEntry((double[][])span, (Object)feature);
        return true;
    }

    @Override
    public boolean removeEntry(GeoObject feature) throws Exception {
        if (this.tree == null) {
            throw new Exception("Create tree first");
        }
        if (feature == null) {
            throw new Exception("Feature is null");
        }
        Rectangle2D mbr = feature.getMBR();
        if (mbr == null) {
            throw new Exception("Feature spatial representation has null mbr.");
        }
        double[][] span = new double[][]{new double[2], new double[2]};
        span[0][0] = mbr.getMinX();
        span[0][1] = mbr.getMaxX();
        span[1][0] = mbr.getMinY();
        span[1][1] = mbr.getMaxY();
        if (!this.tree.removeEntry((double[][])span, (Object)feature)) {
            throw new Exception("Unable ro remove feature from tree.");
        }
        return true;
    }

    @Override
    public List<GeoObject> searchEntries(Rectangle2D mbr) {
        if (mbr == null || this.tree == null) {
            return null;
        }
        Vector<GeoObject> feats = new Vector<GeoObject>();
        double xl = mbr.getX();
        double yl = mbr.getY();
        double dx = mbr.getWidth();
        double dy = mbr.getHeight();
        try {
            boolean gotSome = false;
            double[][] searchMBR = new double[][]{new double[2], new double[2]};
            searchMBR[0][0] = xl;
            searchMBR[0][1] = xl + dx;
            searchMBR[1][0] = yl;
            searchMBR[1][1] = yl + dy;
            ArrayList a = new ArrayList(500);
            a.clear();
            gotSome = this.tree.search((double[][])searchMBR, a);
            if (gotSome) {
                for (int i = 0; i < a.size(); ++i) {
                    feats.add((GeoObject)a.get(i));
                }
                return feats;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }
}

