/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.index;

import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.maps.core.GeoObject;
import oracle.maps.geoobject.AbstractFeature;
import oracle.maps.util.TransformUtils;
import oracle.mapviewer.share.Field;
import oracle.spatial.edit.index.AbstractSpatialIndex;
import oracle.spatial.edit.layer.AbstractDataSetLayer;
import oracle.spatial.edit.model.AbstractDataSet;
import oracle.spatial.edit.model.EditChangeEvent;

public abstract class AbstractIndexedDataSet {
    protected AbstractDataSetLayer dataSetLayer = null;
    protected AbstractDataSet dataSet = null;
    protected AbstractSpatialIndex sptIndex = null;

    public AbstractDataSet getDataSet() {
        return this.dataSet;
    }

    public AbstractSpatialIndex getSpatialindex() {
        return this.sptIndex;
    }

    public void setSpatialIndex(AbstractSpatialIndex index) {
        this.sptIndex = index;
    }

    public boolean addFeature(AbstractFeature feature) throws Exception {
        if (this.dataSet == null) {
            throw new Exception("dataset is null");
        }
        if (this.sptIndex == null) {
            throw new Exception("spatial index is null");
        }
        this.dataSet.addFeature(feature);
        this.sptIndex.addEntry(feature);
        return true;
    }

    public boolean appendFeature(AbstractFeature feature) throws Exception {
        if (feature == null || this.dataSet == null) {
            throw new Exception("feature or dataset is null");
        }
        if (this.sptIndex == null) {
            throw new Exception("spatial index is null");
        }
        this.dataSet.appendFeature(feature);
        this.sptIndex.addEntry(feature);
        return true;
    }

    public boolean removeFeature(AbstractFeature feature) throws Exception {
        if (feature == null || this.dataSet == null) {
            throw new Exception("feature or dataset null");
        }
        if (this.sptIndex == null) {
            throw new Exception("spatial index is null");
        }
        String keyColumn = this.dataSet.getKeyColumn();
        Field f = feature.getAttribute(keyColumn);
        if (f == null || f.getValue() == null) {
            throw new Exception("undefined key for this feature");
        }
        this.dataSet.removeFeature(f.getValue().toString());
        this.sptIndex.removeEntry(feature);
        return true;
    }

    public boolean updateSpatialAttribute(Object key, Object spatialChange) throws Exception {
        boolean result = false;
        AbstractFeature feat = this.getDataSet().getFeature(key.toString());
        this.sptIndex.removeEntry(feat);
        try {
            result = this.getDataSet().updateFeatureGeometry(key.toString(), spatialChange);
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            this.sptIndex.addEntry(feat);
        }
        return result;
    }

    public List<GeoObject> getFeatures(Point2D point, double tolerance) {
        Rectangle2D.Double mbr = null;
        if (point != null && tolerance > 0.0) {
            mbr = new Rectangle2D.Double(point.getX() - tolerance, point.getY() - tolerance, tolerance * 2.0, tolerance * 2.0);
        }
        return this.getFeatures(mbr);
    }

    public List<GeoObject> getFeatures(Rectangle2D mbr) {
        List<GeoObject> res = this.sptIndex.searchEntries(mbr);
        if (res == null) {
            return new Vector<GeoObject>();
        }
        return res;
    }

    public Set<GeoObject> getFeatures(Area area) {
        HashSet<GeoObject> result = new HashSet<GeoObject>();
        List<Rectangle2D> rectangles = TransformUtils.areaToRectangles(area);
        for (Rectangle2D rec : rectangles) {
            List<GeoObject> srch = this.sptIndex.searchEntries(rec);
            if (srch == null) continue;
            result.addAll(srch);
        }
        return result;
    }

    public AbstractFeature getAbstractFeature(String featKey) {
        if (featKey == null || this.dataSet == null) {
            return null;
        }
        return this.dataSet.getFeature(featKey);
    }

    public void undo(EditChangeEvent change) throws Exception {
        this.dataSet.undo(change);
        if (change.getEventType() == EditChangeEvent.NEW_EVENT) {
            AbstractFeature gf = (AbstractFeature)change.getCurrentObject();
            if (this.sptIndex != null && !this.sptIndex.removeEntry(gf)) {
                throw new Exception("Unable to remove feature from index tree.");
            }
        } else if (change.getEventType() == EditChangeEvent.REMOVE_EVENT) {
            AbstractFeature gf = (AbstractFeature)change.getOldObject();
            if (this.sptIndex != null && !this.sptIndex.addEntry(gf)) {
                throw new Exception("Unable to insert tree entry.");
            }
        } else if (change.getEventType() == EditChangeEvent.UPDATE_EVENT && change.getUpdateType() == EditChangeEvent.SPATIAL_UPDATE) {
            Object old = change.getOldObject();
            Object current = change.getCurrentObject();
            String key = change.getKey();
            AbstractFeature gf = this.dataSet.getFeature(key);
            if (this.sptIndex != null) {
                gf.setSpatialAttribute(current);
                if (!this.sptIndex.removeEntry(gf)) {
                    gf.setSpatialAttribute(old);
                    throw new Exception("Unable to remove tree entry.");
                }
                gf.setSpatialAttribute(old);
                if (!this.sptIndex.addEntry(gf)) {
                    throw new Exception("Unable to insert tree entry.");
                }
            }
        }
    }

    public void redo(EditChangeEvent change) throws Exception {
        this.dataSet.redo(change);
        if (change.getEventType() == EditChangeEvent.NEW_EVENT) {
            AbstractFeature gf = (AbstractFeature)change.getCurrentObject();
            if (this.sptIndex != null && !this.sptIndex.addEntry(gf)) {
                throw new Exception("Unable to remove feature from index tree.");
            }
        } else if (change.getEventType() == EditChangeEvent.REMOVE_EVENT) {
            AbstractFeature gf = (AbstractFeature)change.getOldObject();
            if (this.sptIndex != null && !this.sptIndex.removeEntry(gf)) {
                throw new Exception("Unable to remove tree entry.");
            }
        } else if (change.getEventType() == EditChangeEvent.UPDATE_EVENT && change.getUpdateType() == EditChangeEvent.SPATIAL_UPDATE) {
            Object old = change.getOldObject();
            Object current = change.getCurrentObject();
            String key = change.getKey();
            AbstractFeature gf = this.dataSet.getFeature(key);
            if (this.sptIndex != null) {
                gf.setSpatialAttribute(old);
                if (!this.sptIndex.removeEntry(gf)) {
                    gf.setSpatialAttribute(current);
                    throw new Exception("Unable to remove tree entry.");
                }
                gf.setSpatialAttribute(current);
                if (!this.sptIndex.addEntry(gf)) {
                    throw new Exception("Unable to insert tree entry.");
                }
            }
        }
    }

    public abstract AbstractFeature identify(Point2D var1, double var2, int var4);

    public void setDataSetLayer(AbstractDataSetLayer dataSetLayer) {
        this.dataSetLayer = dataSetLayer;
    }

    public AbstractDataSetLayer getDataSetLayer() {
        return this.dataSetLayer;
    }

    public List<GeoObject> getFeaturesByAttribute(Rectangle2D mbr, Field attribute) {
        Vector<GeoObject> output = new Vector<GeoObject>();
        if (attribute == null || attribute.getName() == null || attribute.getValue() == null) {
            return output;
        }
        List<GeoObject> res = this.sptIndex.searchEntries(mbr);
        if (res == null) {
            return output;
        }
        String attrName = attribute.getName();
        for (int i = 0; i < res.size(); ++i) {
            Field f = ((AbstractFeature)res.get(i)).getAttribute(attrName);
            if (f == null || f.compareTo((Object)attribute) != 0) continue;
            output.add(res.get(i));
        }
        return output;
    }
}

