/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.wfs.producer;

import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingWorker;
import oracle.maps.geoobject.AbstractFeature;
import oracle.maps.geoobject.GeometryFeature;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.VisContext;
import oracle.sdovis.theme.WFSThemeProducer;
import oracle.spatial.edit.layer.AbstractDataSetLayer;
import oracle.spatial.edit.producer.AbstractDataSetProducer;

public class WFSLayerProducer
extends AbstractDataSetProducer {
    protected WFSThemeProducer themeProd = null;

    public WFSLayerProducer(AbstractDataSetLayer abstractDataSetLayer, WFSThemeProducer themeProd) {
        super(abstractDataSetLayer);
        this.themeProd = themeProd;
    }

    @Override
    protected String buildQuery(Area queryArea, int srid) {
        return null;
    }

    @Override
    protected String getSpatialType() {
        return null;
    }

    @Override
    public synchronized void loadData(Area qa, int srid) {
        Area queryArea = new Area(qa);
        queryArea.subtract(this.loadedArea);
        queryArea.subtract(this.loadingArea);
        if (queryArea.isEmpty()) {
            return;
        }
        this.loadingArea.add(queryArea);
        WFSDataGetter worker = new WFSDataGetter(queryArea);
        worker.addPropertyChangeListener(this.layer.getCanvas());
        worker.execute();
    }

    public void setThemeProd(WFSThemeProducer themeProd) {
        this.themeProd = themeProd;
    }

    public WFSThemeProducer getThemeProd() {
        return this.themeProd;
    }

    private class WFSDataGetter
    extends SwingWorker<Void, AbstractFeature> {
        private Area queryArea = null;

        public WFSDataGetter(Area queryArea) {
            this.queryArea = queryArea;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void doInBackground() {
            Exception exception = null;
            try {
                this.getPropertyChangeSupport().firePropertyChange("progressIndeterminate", null, (Object)true);
                this.getPropertyChangeSupport().firePropertyChange("progressString", null, MessagesBundle.getMessage("Progressbar_waitingresponse"));
                WFSLayerProducer.this.themeProd.prepareData(this.queryArea.getBounds2D(), new VisContext());
                this.getPropertyChangeSupport().firePropertyChange("progressIndeterminate", null, (Object)false);
                this.getPropertyChangeSupport().firePropertyChange("progressString", null, MessagesBundle.getMessage("Progressbar_processfeatures"));
                StyledFeatureI[] sf = WFSLayerProducer.this.themeProd.getStyledFeatures();
                if (sf != null && sf.length > 0) {
                    for (int i = 0; i < sf.length; ++i) {
                        StyledFeatureI feat = sf[i];
                        feat.getGeometry().setSRID(WFSLayerProducer.this.layer.getSRID());
                        GeometryFeature geomFeat = new GeometryFeature();
                        geomFeat.setLayer(WFSLayerProducer.this.layer);
                        geomFeat.setAttributes(feat.getAttributes());
                        geomFeat.setSpatialAttribute(feat.getGeometry());
                        geomFeat.setKey(feat.getID());
                        this.publish(geomFeat);
                        this.setProgress(100 * (i / sf.length));
                    }
                }
            }
            catch (Exception ex) {
                exception = ex;
            }
            WFSLayerProducer wFSLayerProducer = WFSLayerProducer.this;
            synchronized (wFSLayerProducer) {
                WFSLayerProducer.this.loadingArea.subtract(this.queryArea);
                if (exception == null) {
                    WFSLayerProducer.this.loadedArea.add(this.queryArea);
                }
            }
            if (exception != null) {
                WFSLayerProducer.this.layer.onDataException(WFSLayerProducer.this, exception);
            }
            return null;
        }

        @Override
        protected void process(List<AbstractFeature> list) {
            WFSLayerProducer.this.layer.onDataReady(WFSLayerProducer.this, new ArrayList<AbstractFeature>(list));
        }
    }
}

