/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui.actiongroup;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.maps.core.LayerManager;
import oracle.maps.core.MapCanvas;
import oracle.maps.core.SelectionEvent;
import oracle.maps.core.SelectionListener;
import oracle.mdeditor.session.EditSession;
import oracle.mdeditor.ui.CollapsiblePanel;
import oracle.mdeditor.ui.EditSessionPanel;
import oracle.mdeditor.ui.MainAppPanel;
import oracle.mdeditor.ui.MultiRowFlowLayout;
import oracle.mdeditor.ui.SDEUIComponent;

public abstract class BasicToolsPane
extends JPanel
implements SDEUIComponent,
SelectionListener,
ChangeListener,
PropertyChangeListener {
    protected MainAppPanel mainApp = null;
    protected AbstractButton[] buttons = null;

    public BasicToolsPane(MainAppPanel mainApp) {
        this.mainApp = mainApp;
        this.mainApp.getEditSessionPanel().addChangeListener(this);
        this.setLayout(new MultiRowFlowLayout());
    }

    protected MainAppPanel getMainApp() {
        return this.mainApp;
    }

    protected MapCanvas getMapCanvas() {
        return this.mainApp.getMapCanvas();
    }

    @Override
    public void selectionChanged(SelectionEvent e) {
        this.updateUIStatus();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateUIStatus();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (src instanceof EditSessionPanel) {
            EditSession newSession;
            EditSessionPanel panel = (EditSessionPanel)src;
            EditSessionPanel.SessionChangeEvent evt = (EditSessionPanel.SessionChangeEvent)e;
            EditSession oldSession = evt.getOldSession();
            if (oldSession != null && oldSession.getLayers() != null) {
                oldSession.getLayers().removeChangeListener(this);
                oldSession.getLayers().removeSelectionListener(this);
                oldSession.getLayers().removePropertyChangeListener("oracle.maps.core.Layer.visible", this);
                oldSession.getLayers().removePropertyChangeListener("oracle.maps.core.EditableLayer.editable", this);
            }
            if ((newSession = evt.getNewSession()) != null && newSession.getLayers() != null) {
                newSession.getLayers().addChangeListener(this);
                newSession.getLayers().addSelectionListener(this);
                newSession.getLayers().addPropertyChangeListener("oracle.maps.core.Layer.visible", this);
                newSession.getLayers().addPropertyChangeListener("oracle.maps.core.EditableLayer.editable", this);
            }
        }
        if (src instanceof LayerManager) {
            this.updateUIStatus();
        }
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void updateUIStatus() {
        for (AbstractButton btn : this.buttons) {
            btn.setEnabled(false);
        }
        CollapsiblePanel cp = CollapsiblePanel.getCollapsiblePanelParent(this);
        if (cp != null) {
            cp.setExpanded(false);
        }
        this.updateButtonsStatus();
        if (cp != null) {
            for (AbstractButton btn : this.buttons) {
                if (!btn.isEnabled()) continue;
                cp.setExpanded(true);
                break;
            }
        }
    }

    public abstract void updateButtonsStatus();
}

