/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.maps.core.MapCanvas;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.TopoPrimitiveDescriptor;
import oracle.mdeditor.ui.AttributeValueTablePanel;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.spatial.edit.index.topology.IndexedTopologySet;
import oracle.spatial.edit.model.topology.TopologyFeature;
import oracle.spatial.edit.model.topology.TopologyGeometry;

public class TopoFeaturePrimitivesPanel
extends JPanel {
    private TopologyFeature feature = null;
    private IndexedTopologySet toposet = null;
    private MapCanvas drawPanel = null;
    private JLabel featLabel = new JLabel();
    private JTextField featText = new JTextField();
    private JLabel topofeatlayeridLabel = new JLabel();
    private JTextField topofeatlayeridText = new JTextField();
    private JLabel topofeatidLabel = new JLabel();
    private JTextField topofeatidText = new JTextField();
    AttributeValueTablePanel attrPanel = new AttributeValueTablePanel();

    public TopoFeaturePrimitivesPanel(IndexedTopologySet gset, TopologyFeature feat, MapCanvas dp) {
        this.feature = feat;
        this.toposet = gset;
        this.drawPanel = dp;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String keyColumn;
        Field key;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(300, 200));
        this.featLabel.setText(MessagesBundle.getMessage("Label_feature"));
        this.featText.setEditable(false);
        this.topofeatlayeridLabel.setText(MessagesBundle.getMessage("Label_topo_layer_id"));
        this.topofeatlayeridText.setEditable(false);
        this.topofeatidLabel.setText(MessagesBundle.getMessage("Label_topo_geometry_id"));
        this.topofeatidText.setEditable(false);
        this.attrPanel.getTableModel().setColumnName(0, MessagesBundle.getMessage("Topo_primitive_id"));
        this.attrPanel.getTableModel().setColumnName(1, MessagesBundle.getMessage("Topo_primitive_type"));
        this.add((Component)this.featLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.featText, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 10), 0, 0));
        this.add((Component)this.topofeatlayeridLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.topofeatlayeridText, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 10), 0, 0));
        this.add((Component)this.topofeatidLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.topofeatidText, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 10), 0, 0));
        this.add((Component)this.attrPanel, new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 17, 1, new Insets(10, 10, 10, 10), 0, 0));
        if (this.feature != null && this.toposet != null && this.toposet.getDataSet() != null && (key = this.feature.getAttribute(keyColumn = this.toposet.getDataSet().getKeyColumn())) != null && key.getValue() != null) {
            this.featText.setText(key.getValue().toString());
            TopologyGeometry tpgeom = this.feature.getSpatialAttribute();
            if (tpgeom != null) {
                this.topofeatlayeridText.setText("" + tpgeom.getLayerId());
                this.topofeatidText.setText("" + tpgeom.getId());
                TopoPrimitiveDescriptor[] tpds = tpgeom.getTopoPrimitives();
                if (tpds != null) {
                    for (int i = 0; i < tpds.length; ++i) {
                        this.attrPanel.addRow("" + tpds[i].getTopoId(), "" + tpds[i].getTopoType(), false);
                    }
                }
            }
        }
    }
}

