/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.mdeditor.ui.resources.MessagesBundle;

public class TextFieldPanel
extends JPanel {
    private JLabel fieldLabel = new JLabel(MessagesBundle.getMessage("Label_value"));
    private JTextField valueTxt = new JTextField();

    public TextFieldPanel(String fieldName) {
        if (fieldName != null) {
            this.fieldLabel.setText(fieldName);
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(300, 45));
        this.add((Component)this.fieldLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.valueTxt, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 20), 80, 0));
    }

    public String getTextFieldValue() {
        String value = this.valueTxt.getText();
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        return value.trim();
    }

    public void setTextFieldValue(String value) {
        if (value == null) {
            this.valueTxt.setText("");
        } else {
            this.valueTxt.setText(value);
        }
    }

    public void setTextFieldTooltip(String tip) {
        if (tip == null) {
            this.valueTxt.setToolTipText("");
        } else {
            this.valueTxt.setToolTipText(tip);
        }
    }
}

