/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.sdovis.SRS;

public class SizePanel
extends JPanel {
    private JLabel jLabel1 = new JLabel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JTextField sizeTxt = new JTextField();
    private JComboBox unitCombo = new JComboBox();
    private JLabel jLabelFillerX = new JLabel();
    private JLabel jLabelFiller = new JLabel();

    public SizePanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.setSize(new Dimension(190, 22));
        this.jLabel1.setText(MessagesBundle.getMessage("Label_size"));
        this.unitCombo.setToolTipText(MessagesBundle.getMessage("Tooltip_size_unit"));
        this.add((Component)this.sizeTxt, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 0, 0), 50, 0));
        this.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.unitCombo, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.jLabelFiller, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jLabelFillerX, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.fillUnitCombo();
    }

    public void setSizeValue(double size) {
        NumberFormat nf = NumberFormat.getInstance();
        this.sizeTxt.setText(nf.format(size));
    }

    public double getSizeValue() {
        NumberFormat nf = NumberFormat.getInstance();
        try {
            return nf.parse(this.sizeTxt.getText()).doubleValue();
        }
        catch (Exception e) {
            return 12.0;
        }
    }

    public void setSizeLabel(String text) {
        this.jLabel1.setText(text);
    }

    private void fillUnitCombo() {
        this.unitCombo.removeAllItems();
        ArrayList<String> units = new ArrayList<String>();
        units.add("px");
        units.add("pt");
        Hashtable ulist = SRS.getDistanceUnitList();
        Enumeration e = ulist.keys();
        while (e.hasMoreElements()) {
            units.add(((String)e.nextElement()).toLowerCase());
        }
        Collections.sort(units);
        for (int i = 0; i < units.size(); ++i) {
            this.unitCombo.addItem(units.get(i));
        }
        this.setUnit(null);
    }

    public String getUnit() {
        if (this.unitCombo.getSelectedIndex() < 0) {
            return null;
        }
        return this.unitCombo.getSelectedItem().toString();
    }

    public void setUnit(String unit) {
        if (unit == null || unit.trim().length() == 0) {
            this.unitCombo.setSelectedItem("px");
            return;
        }
        this.unitCombo.setSelectedItem(unit.toLowerCase());
    }

    public void setUnitEnabled(boolean edit) {
        this.unitCombo.setEnabled(edit);
    }

    public void setUnitVisible(boolean visible) {
        this.unitCombo.setVisible(visible);
    }

    public void enableAll() {
        this.sizeTxt.setEnabled(true);
        this.unitCombo.setEnabled(true);
    }

    public void disableAll() {
        this.sizeTxt.setEnabled(false);
        this.unitCombo.setEnabled(false);
    }
}

