/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.maps.core.Layer;
import oracle.maps.util.StyleModelUtils;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.ui.EditSessionPanel;
import oracle.mdeditor.ui.SDEUIComponent;
import oracle.mdeditor.ui.resources.MessagesBundle;

public class RenderingStylePicker
extends JPanel
implements SDEUIComponent,
ListSelectionListener {
    private final int TYPE_FILL_COLOR = 0;
    private final int TYPE_STROKE_COLOR = 1;
    private final int TYPE_STROKE_WIDTH = 2;
    private final int TYPE_MARKER_TYPE = 3;
    private final int TYPE_MARKER_SIZE = 4;
    private final int LPAD = 10;
    private final int RPAD = 10;
    private final int TPAD = 10;
    private EditSessionPanel editSessionPanel = null;
    private JTabbedPane tabPane = new JTabbedPane();
    private StylePanel lineSP = new StylePanel();
    private StylePanel colorSP = new StylePanel();
    private StylePanel markerSP = new StylePanel();
    private Hashtable<String, ImageIcon> labelIcons = new Hashtable(6);
    private Hashtable<String, Color> colors = new Hashtable(13);
    private Hashtable<String, Shape> markerShapes = new Hashtable(3);
    private JButton applyButton = new JButton(MessagesBundle.getMessage("Apply"));

    public RenderingStylePicker(EditSessionPanel editSessionPanel) {
        if (editSessionPanel == null) {
            throw new IllegalArgumentException();
        }
        this.editSessionPanel = editSessionPanel;
        editSessionPanel.getSelectionModel().addListSelectionListener(this);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName(MessagesBundle.getMessage("Rendering_properties"));
        this.setLayout(new GridBagLayout());
        this.buildColorsHash();
        this.buildIconsHash();
        this.tabPane.addTab(MessagesBundle.getMessage("Color"), this.createColorStylePanel());
        this.tabPane.addTab(MessagesBundle.getMessage("Line"), this.createLineStylePanel());
        this.tabPane.addTab(MessagesBundle.getMessage("Marker"), this.createMarkerStylePanel());
        this.add((Component)this.tabPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.applyButton.setEnabled(false);
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Layer layer = RenderingStylePicker.this.editSessionPanel.getSelectedLayer();
                if (layer == null) {
                    return;
                }
                StyleModel stm = RenderingStylePicker.this.getStyleModel();
                layer.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.renderStyle", stm.getName());
            }
        });
        this.add((Component)this.applyButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 10, 0), 0, 0));
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void updateUIStatus() {
        this.valueChanged(null);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        String renderStyle;
        if (e != null && e.getValueIsAdjusting()) {
            return;
        }
        this.applyButton.setEnabled(false);
        Layer layer = this.editSessionPanel.getSelectedLayer();
        if (layer != null && (renderStyle = layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.renderStyle")) != null) {
            this.applyButton.setEnabled(true);
            this.setStyleParameters(renderStyle);
        }
    }

    private JPanel createColorStylePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setPreferredSize(new Dimension(10, 10));
        JComboBox<String> fillComboBox = new JComboBox<String>();
        fillComboBox.setToolTipText(MessagesBundle.getMessage("Tooltip_fill_color"));
        fillComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RenderingStylePicker.this.repaint();
                RenderingStylePicker.this.fillComboBox_actionPerformed(e);
            }
        });
        for (String key : this.colors.keySet()) {
            fillComboBox.addItem(key);
        }
        fillComboBox.setSelectedItem("green");
        JComboBox<String> strkComboBox = new JComboBox<String>();
        strkComboBox.setToolTipText(MessagesBundle.getMessage("Tooltip_stroke_color"));
        strkComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RenderingStylePicker.this.repaint();
                RenderingStylePicker.this.strkComboBox_actionPerformed(e);
            }
        });
        for (String key : this.colors.keySet()) {
            strkComboBox.addItem(key);
        }
        strkComboBox.setSelectedItem("black");
        JSlider opacSlider = new JSlider(0, 255);
        opacSlider.setToolTipText(MessagesBundle.getMessage("Tooltip_fill_opacity"));
        opacSlider.setValue(255);
        opacSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RenderingStylePicker.this.repaint();
                RenderingStylePicker.this.opacSlider_stateChanged(e);
            }
        });
        this.colorSP.setFillComboBox(fillComboBox);
        this.colorSP.setStrkComboBox(strkComboBox);
        this.colorSP.setOpacSlider(opacSlider);
        this.colorSP.setFillComboBoxRenderer(new ComboRenderer(0, this.colorSP));
        fillComboBox.setRenderer(this.colorSP.getFillComboBoxRenderer());
        this.colorSP.setStrkComboBoxRenderer(new ComboRenderer(1, this.colorSP));
        strkComboBox.setRenderer(this.colorSP.getStrkComboBoxRenderer());
        int gridY = 0;
        panel.add((Component)new JLabel(this.labelIcons.get("fillColor")), new GridBagConstraints(0, gridY, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 0, 10), 0, 0));
        panel.add(fillComboBox, new GridBagConstraints(1, gridY++, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 0, 0, 10), 0, 0));
        panel.add((Component)new JLabel(this.labelIcons.get("lineColor")), new GridBagConstraints(0, gridY, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        panel.add(strkComboBox, new GridBagConstraints(1, gridY++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        panel.add((Component)new JLabel(this.labelIcons.get("opacity")), new GridBagConstraints(0, gridY, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        panel.add((Component)opacSlider, new GridBagConstraints(1, gridY++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        panel.add((Component)new JPanel(), new GridBagConstraints(0, gridY, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel createLineStylePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setPreferredSize(new Dimension(10, 10));
        JComboBox<String> strkComboBox = new JComboBox<String>();
        strkComboBox.setToolTipText(MessagesBundle.getMessage("Tooltip_stroke_color"));
        strkComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RenderingStylePicker.this.repaint();
                RenderingStylePicker.this.strkComboBox_actionPerformed(e);
            }
        });
        for (String key : this.colors.keySet()) {
            strkComboBox.addItem(key);
        }
        strkComboBox.setSelectedItem("red");
        JComboBox<String> strkwdCombo = new JComboBox<String>();
        strkwdCombo.setToolTipText(MessagesBundle.getMessage("Tooltip_stroke_width"));
        strkwdCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RenderingStylePicker.this.repaint();
                RenderingStylePicker.this.strkwdCombo_actionPerformed(e);
            }
        });
        strkwdCombo.addItem("1");
        strkwdCombo.addItem("2");
        strkwdCombo.addItem("4");
        strkwdCombo.addItem("8");
        JSlider opacSlider = new JSlider(0, 255);
        opacSlider.setToolTipText(MessagesBundle.getMessage("Tooltip_stroke_opacity"));
        opacSlider.setValue(255);
        opacSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RenderingStylePicker.this.repaint();
                RenderingStylePicker.this.opacSlider_stateChanged(e);
            }
        });
        this.lineSP.setStrkComboBox(strkComboBox);
        this.lineSP.setStrkwdCombo(strkwdCombo);
        this.lineSP.setOpacSlider(opacSlider);
        this.lineSP.setStrkComboBoxRenderer(new ComboRenderer(1, this.lineSP));
        strkComboBox.setRenderer(this.lineSP.getStrkComboBoxRenderer());
        this.lineSP.setStrkwdComboRenderer(new ComboRenderer(2, this.lineSP));
        strkwdCombo.setRenderer(this.lineSP.getStrkwdComboRenderer());
        int gridY = 0;
        panel.add((Component)new JLabel(this.labelIcons.get("fillColor")), new GridBagConstraints(0, gridY, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 0, 10), 0, 0));
        panel.add(strkComboBox, new GridBagConstraints(1, gridY++, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 0, 0, 10), 0, 0));
        panel.add((Component)new JLabel(this.labelIcons.get("lineWidth")), new GridBagConstraints(0, gridY, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        panel.add(strkwdCombo, new GridBagConstraints(1, gridY++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        panel.add((Component)new JLabel(this.labelIcons.get("opacity")), new GridBagConstraints(0, gridY, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        panel.add((Component)opacSlider, new GridBagConstraints(1, gridY++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        panel.add((Component)new JPanel(), new GridBagConstraints(0, gridY, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel createMarkerStylePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setPreferredSize(new Dimension(10, 120));
        JComboBox<String> mktypeCombo = new JComboBox<String>();
        mktypeCombo.setToolTipText(MessagesBundle.getMessage("Tooltip_marker_type"));
        mktypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RenderingStylePicker.this.repaint();
                RenderingStylePicker.this.mktypeCombo_actionPerformed(e);
            }
        });
        mktypeCombo.addItem("star");
        mktypeCombo.addItem("circle");
        mktypeCombo.addItem("rect");
        mktypeCombo.addItem("arrow");
        JComboBox<String> fillComboBox = new JComboBox<String>();
        fillComboBox.setToolTipText(MessagesBundle.getMessage("Tooltip_fill_color"));
        fillComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RenderingStylePicker.this.repaint();
                RenderingStylePicker.this.fillComboBox_actionPerformed(e);
            }
        });
        for (String key : this.colors.keySet()) {
            fillComboBox.addItem(key);
        }
        fillComboBox.setSelectedItem("red");
        JComboBox<String> strkComboBox = new JComboBox<String>();
        strkComboBox.setToolTipText(MessagesBundle.getMessage("Tooltip_stroke_color"));
        strkComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RenderingStylePicker.this.repaint();
                RenderingStylePicker.this.strkComboBox_actionPerformed(e);
            }
        });
        for (String key : this.colors.keySet()) {
            strkComboBox.addItem(key);
        }
        strkComboBox.setSelectedItem("black");
        JComboBox<String> mksizeCombo = new JComboBox<String>();
        mksizeCombo.setToolTipText(MessagesBundle.getMessage("Tooltip_marker_size"));
        mksizeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RenderingStylePicker.this.repaint();
                RenderingStylePicker.this.mksizeCombo_actionPerformed(e);
            }
        });
        mksizeCombo.addItem("8");
        mksizeCombo.addItem("12");
        mksizeCombo.addItem("18");
        mksizeCombo.addItem("24");
        mksizeCombo.addItem("32");
        JSlider opacSlider = new JSlider(0, 255);
        opacSlider.setToolTipText(MessagesBundle.getMessage("Tooltip_marker_opacity"));
        opacSlider.setValue(255);
        opacSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RenderingStylePicker.this.repaint();
                RenderingStylePicker.this.opacSlider_stateChanged(e);
            }
        });
        this.markerSP.setMktypeCombo(mktypeCombo);
        this.markerSP.setFillComboBox(fillComboBox);
        this.markerSP.setStrkComboBox(strkComboBox);
        this.markerSP.setMksizeCombo(mksizeCombo);
        this.markerSP.setOpacSlider(opacSlider);
        this.markerSP.setMktypeComboRenderer(new ComboRenderer(3, this.markerSP));
        mktypeCombo.setRenderer(this.markerSP.getMktypeComboRenderer());
        this.markerSP.setFillComboBoxRenderer(new ComboRenderer(0, this.markerSP));
        fillComboBox.setRenderer(this.markerSP.getFillComboBoxRenderer());
        this.markerSP.setStrkComboBoxRenderer(new ComboRenderer(1, this.markerSP));
        strkComboBox.setRenderer(this.markerSP.getStrkComboBoxRenderer());
        this.markerSP.setMksizeComboRenderer(new ComboRenderer(4, this.markerSP));
        mksizeCombo.setRenderer(this.markerSP.getMksizeComboRenderer());
        int gridY = 0;
        panel.add((Component)new JLabel(this.labelIcons.get("markerType")), new GridBagConstraints(0, gridY, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 0, 10), 0, 0));
        panel.add(mktypeCombo, new GridBagConstraints(1, gridY++, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 0, 0, 10), 0, 0));
        panel.add((Component)new JLabel(this.labelIcons.get("fillColor")), new GridBagConstraints(0, gridY, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        panel.add(fillComboBox, new GridBagConstraints(1, gridY++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        panel.add((Component)new JLabel(this.labelIcons.get("lineColor")), new GridBagConstraints(0, gridY, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        panel.add(strkComboBox, new GridBagConstraints(1, gridY++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        panel.add((Component)new JLabel(this.labelIcons.get("markerSize")), new GridBagConstraints(0, gridY, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        panel.add(mksizeCombo, new GridBagConstraints(1, gridY++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        panel.add((Component)new JLabel(this.labelIcons.get("opacity")), new GridBagConstraints(0, gridY, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        panel.add((Component)opacSlider, new GridBagConstraints(1, gridY++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        panel.add((Component)new JPanel(), new GridBagConstraints(0, gridY, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private void buildIconsHash() {
        this.labelIcons.put("fillColor", Icons.getIcon("fill.png"));
        this.labelIcons.put("lineWidth", Icons.getIcon("linethickness_ena.png"));
        this.labelIcons.put("opacity", Icons.getIcon("notstarted.png"));
        this.labelIcons.put("lineColor", Icons.getIcon("linetool_ena.png"));
        this.labelIcons.put("markerType", Icons.getIcon("mark_as_fav.png"));
        this.labelIcons.put("markerSize", Icons.getIcon("layoutpane_ena.png"));
        double[] star = new double[]{138.0, 123.0, 161.0, 198.0, 100.0, 152.0, 38.0, 198.0, 61.0, 123.0, 0.0, 76.0, 76.0, 76.0, 100.0, 0.0, 123.0, 76.0, 199.0, 76.0};
        GeneralPath gp = new GeneralPath();
        gp.moveTo(star[0], star[1]);
        for (int i = 2; i < star.length; i += 2) {
            gp.lineTo(star[i], star[i + 1]);
        }
        gp.closePath();
        this.markerShapes.put("star", gp);
        this.markerShapes.put("rect", new Rectangle2D.Double(0.0, 0.0, 100.0, 100.0));
        this.markerShapes.put("circle", new Ellipse2D.Double(0.0, 0.0, 100.0, 100.0));
        double[] arrow = new double[]{50.0, 100.0, 100.0, 100.0, 100.0, 120.0, 130.0, 90.0, 100.0, 60.0, 100.0, 80.0, 50.0, 80.0, 50.0, 100.0};
        gp = new GeneralPath();
        gp.moveTo(arrow[0], arrow[1]);
        for (int i = 2; i < arrow.length; i += 2) {
            gp.lineTo(arrow[i], arrow[i + 1]);
        }
        gp.closePath();
        this.markerShapes.put("arrow", gp);
    }

    private void buildColorsHash() {
        this.colors.put("black", Color.black);
        this.colors.put("white", Color.white);
        this.colors.put("red", Color.red);
        this.colors.put("green", Color.green);
        this.colors.put("blue", Color.blue);
        this.colors.put("yellow", Color.yellow);
        this.colors.put("magenta", Color.magenta);
        this.colors.put("orange", Color.orange);
        this.colors.put("pink", Color.pink);
        this.colors.put("cyan", Color.cyan);
        this.colors.put("darkGray", Color.darkGray);
        this.colors.put("gray", Color.gray);
        this.colors.put("lightGray", Color.lightGray);
    }

    private void fillComboBox_actionPerformed(ActionEvent e) {
    }

    private void strkComboBox_actionPerformed(ActionEvent e) {
    }

    private void strkwdCombo_actionPerformed(ActionEvent e) {
    }

    private void opacSlider_stateChanged(ChangeEvent e) {
    }

    private void mktypeCombo_actionPerformed(ActionEvent e) {
    }

    private void mksizeCombo_actionPerformed(ActionEvent e) {
    }

    public void setStyleParameters(String name) {
        String[] params;
        String style = name;
        if (name == null) {
            style = StyleModelUtils.defaultColorName;
        }
        if ((params = style.split("_"))[0].equalsIgnoreCase("line")) {
            this.tabPane.setSelectedIndex(1);
            if (params.length != 4) {
                return;
            }
            this.lineSP.getStrkComboBox().setSelectedItem(params[1]);
            this.lineSP.getStrkwdCombo().setSelectedItem(params[2]);
            try {
                this.lineSP.getOpacSlider().setValue(Integer.parseInt(params[3]));
            }
            catch (NumberFormatException nfe) {
                return;
            }
        } else if (params[0].equalsIgnoreCase("color")) {
            this.tabPane.setSelectedIndex(0);
            if (params.length != 4) {
                return;
            }
            this.colorSP.getFillComboBox().setSelectedItem(params[1]);
            this.colorSP.getStrkComboBox().setSelectedItem(params[2]);
            try {
                this.colorSP.getOpacSlider().setValue(Integer.parseInt(params[3]));
            }
            catch (NumberFormatException nfe) {
                return;
            }
        } else if (params[0].equalsIgnoreCase("marker")) {
            this.tabPane.setSelectedIndex(2);
            if (params.length != 6) {
                return;
            }
            this.markerSP.getMktypeCombo().setSelectedItem(params[1]);
            this.markerSP.getFillComboBox().setSelectedItem(params[2]);
            this.markerSP.getStrkComboBox().setSelectedItem(params[3]);
            this.markerSP.getMksizeCombo().setSelectedItem(params[4]);
            try {
                this.markerSP.getOpacSlider().setValue(Integer.parseInt(params[5]));
            }
            catch (NumberFormatException nfe) {
                return;
            }
        } else {
            return;
        }
    }

    public StyleModel getStyleModel() {
        int tab = this.tabPane.getSelectedIndex();
        if (tab == 0) {
            return this.getColorStyleModel();
        }
        if (tab == 1) {
            return this.getLineStyleModel();
        }
        if (tab == 2) {
            return this.getMarkerStyleModel();
        }
        return this.getColorStyleModel();
    }

    public StyleModel getLineStyleModel() {
        String fillColor = this.lineSP.getStrkComboBox().getSelectedItem().toString();
        int lineWidth = Integer.parseInt(this.lineSP.getStrkwdCombo().getSelectedItem().toString());
        int opacity = this.lineSP.getOpacSlider().getValue();
        StringBuilder modelName = new StringBuilder("line");
        modelName.append("_" + fillColor);
        modelName.append("_" + lineWidth);
        modelName.append("_" + opacity);
        return StyleModelUtils.getStyleModel(modelName.toString());
    }

    public StyleModel getColorStyleModel() {
        String fillColor = this.colorSP.getFillComboBox().getSelectedItem().toString();
        String strokeColor = this.colorSP.getStrkComboBox().getSelectedItem().toString();
        int opacity = this.colorSP.getOpacSlider().getValue();
        StringBuilder modelName = new StringBuilder("color");
        modelName.append("_" + fillColor);
        modelName.append("_" + strokeColor);
        modelName.append("_" + opacity);
        return StyleModelUtils.getStyleModel(modelName.toString());
    }

    public StyleModel getMarkerStyleModel() {
        String fillColor = this.markerSP.getFillComboBox().getSelectedItem().toString();
        String strokeColor = this.markerSP.getStrkComboBox().getSelectedItem().toString();
        int opacity = this.markerSP.getOpacSlider().getValue();
        String mkType = this.markerSP.getMktypeCombo().getSelectedItem().toString();
        int mkSize = Integer.parseInt(this.markerSP.getMksizeCombo().getSelectedItem().toString());
        StringBuilder modelName = new StringBuilder("marker");
        modelName.append("_" + mkType);
        modelName.append("_" + fillColor);
        modelName.append("_" + strokeColor);
        modelName.append("_" + mkSize);
        modelName.append("_" + opacity);
        return StyleModelUtils.getStyleModel(modelName.toString());
    }

    public void setApplyButtonVisible(boolean visible) {
        this.applyButton.setVisible(visible);
    }

    public void setColorTabEnabled(boolean enabled) {
        this.tabPane.setEnabledAt(0, enabled);
    }

    public void setLineTabEnabled(boolean enabled) {
        this.tabPane.setEnabledAt(1, enabled);
    }

    public void setMarkerTabEnabled(boolean enabled) {
        this.tabPane.setEnabledAt(2, enabled);
    }

    private class ComboRenderer
    extends JLabel
    implements ListCellRenderer {
        private int type;
        private StylePanel sp = null;
        private Color fillColor = Color.RED;
        private Color strokeColor = Color.BLUE;
        private int strokeWidth = 1;
        private String markerType = "star";
        private int markerSize = 12;

        public ComboRenderer(int type, StylePanel sp) {
            this.type = type;
            this.sp = sp;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            String text = value.toString();
            if (this.sp.getFillComboBox() != null) {
                this.fillColor = (Color)RenderingStylePicker.this.colors.get(this.sp.getFillComboBox().getSelectedItem().toString());
            }
            if (this.sp.getStrkComboBox() != null) {
                this.strokeColor = (Color)RenderingStylePicker.this.colors.get(this.sp.getStrkComboBox().getSelectedItem().toString());
            }
            if (this.sp.getStrkwdCombo() != null) {
                this.strokeWidth = Integer.parseInt(this.sp.getStrkwdCombo().getSelectedItem().toString());
            }
            if (this.sp.getMktypeCombo() != null) {
                this.markerType = this.sp.getMktypeCombo().getSelectedItem().toString();
            }
            if (this.sp.getMksizeCombo() != null) {
                this.markerSize = Integer.parseInt(this.sp.getMksizeCombo().getSelectedItem().toString());
            }
            switch (this.type) {
                case 0: {
                    this.fillColor = (Color)RenderingStylePicker.this.colors.get(text);
                    break;
                }
                case 1: {
                    this.strokeColor = (Color)RenderingStylePicker.this.colors.get(text);
                    break;
                }
                case 2: {
                    this.strokeWidth = Integer.parseInt(text);
                    break;
                }
                case 3: {
                    this.markerType = text;
                    Image i = Icons.getIcon("blank.png").getImage().getScaledInstance(32, 40, 2);
                    ImageIcon ii = new ImageIcon(i);
                    this.setIcon(ii);
                    break;
                }
                case 4: {
                    this.markerSize = Integer.parseInt(text);
                    Image i = Icons.getIcon("blank.png").getImage().getScaledInstance(32, 40, 2);
                    ImageIcon ii = new ImageIcon(i);
                    this.setIcon(ii);
                }
            }
            this.setText(text);
            this.setHorizontalAlignment(4);
            return this;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            super.paintComponent(g2);
            float alpha = (float)((double)this.sp.getOpacSlider().getValue() / 255.0);
            AlphaComposite composite = AlphaComposite.getInstance(3, alpha);
            g2.setComposite(composite);
            int yPad = 3;
            int xPad = 5;
            switch (this.type) {
                case 1: 
                case 2: {
                    Rectangle2D textBounds = this.getFont().createGlyphVector(g2.getFontRenderContext(), "DarkGray").getVisualBounds();
                    g2.setColor(this.strokeColor);
                    g2.fillRect(xPad, (this.getHeight() - this.strokeWidth) / 2, (int)((double)this.getWidth() - textBounds.getWidth() - (double)(xPad * 2)), this.strokeWidth);
                    break;
                }
                case 0: {
                    Rectangle2D textBounds = this.getFont().createGlyphVector(g2.getFontRenderContext(), "DarkGray").getVisualBounds();
                    g2.setColor(this.fillColor);
                    g2.fillRect(xPad, yPad, (int)((double)this.getWidth() - textBounds.getWidth() - (double)(xPad * 2)), this.getHeight() - yPad * 2);
                    g2.setColor(this.strokeColor);
                    g2.drawRect(xPad, yPad, (int)((double)this.getWidth() - textBounds.getWidth() - (double)(xPad * 2)), this.getHeight() - yPad * 2);
                    break;
                }
                case 3: 
                case 4: {
                    Shape mkr = (Shape)RenderingStylePicker.this.markerShapes.get(this.markerType);
                    AffineTransform af = new AffineTransform();
                    af.scale((double)this.markerSize / mkr.getBounds2D().getWidth(), (double)this.markerSize / mkr.getBounds2D().getHeight());
                    af.translate(-mkr.getBounds2D().getMinX(), -mkr.getBounds2D().getMinY());
                    mkr = af.createTransformedShape(mkr);
                    g2.translate(xPad, (this.getHeight() - this.markerSize) / 2);
                    g2.setColor(this.fillColor);
                    g2.fill(mkr);
                    g2.setColor(this.strokeColor);
                    g2.draw(mkr);
                    g2.translate(-xPad, -(this.getHeight() - this.markerSize) / 2);
                }
            }
        }

        public void setFillColor(Color fillColor) {
            this.fillColor = fillColor;
        }

        public Color getFillColor() {
            return this.fillColor;
        }

        public void setStrokeColor(Color strokeColor) {
            this.strokeColor = strokeColor;
        }

        public Color getStrokeColor() {
            return this.strokeColor;
        }

        public void setStrokeWidth(int strokeWidth) {
            this.strokeWidth = strokeWidth;
        }

        public int getStrokeWidth() {
            return this.strokeWidth;
        }

        public void setMarkerType(String markerType) {
            this.markerType = markerType;
        }

        public String getMarkerType() {
            return this.markerType;
        }

        public void setMarkerSize(int markerSize) {
            this.markerSize = markerSize;
        }

        public int getMarkerSize() {
            return this.markerSize;
        }

        public void setType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public void setSp(StylePanel sp) {
            this.sp = sp;
        }

        public StylePanel getSp() {
            return this.sp;
        }
    }

    private class StylePanel
    extends JPanel {
        private JComboBox fillComboBox = null;
        private JComboBox strkwdCombo = null;
        private JSlider opacSlider = null;
        private JComboBox strkComboBox = null;
        private JComboBox mktypeCombo = null;
        private JComboBox mksizeCombo = null;
        private ListCellRenderer fillComboBoxRenderer = null;
        private ListCellRenderer strkwdComboRenderer = null;
        private ListCellRenderer strkComboBoxRenderer = null;
        private ListCellRenderer mktypeComboRenderer = null;
        private ListCellRenderer mksizeComboRenderer = null;

        private StylePanel() {
        }

        public void setFillComboBox(JComboBox fillButton) {
            this.fillComboBox = fillButton;
        }

        public JComboBox getFillComboBox() {
            return this.fillComboBox;
        }

        public void setStrkwdCombo(JComboBox strkwdCombo) {
            this.strkwdCombo = strkwdCombo;
        }

        public JComboBox getStrkwdCombo() {
            return this.strkwdCombo;
        }

        public void setOpacSlider(JSlider opacSlider) {
            this.opacSlider = opacSlider;
        }

        public JSlider getOpacSlider() {
            return this.opacSlider;
        }

        public void setStrkComboBox(JComboBox strkButton) {
            this.strkComboBox = strkButton;
        }

        public JComboBox getStrkComboBox() {
            return this.strkComboBox;
        }

        public void setMktypeCombo(JComboBox mktypeCombo) {
            this.mktypeCombo = mktypeCombo;
        }

        public JComboBox getMktypeCombo() {
            return this.mktypeCombo;
        }

        public void setMksizeCombo(JComboBox mksizeCombo) {
            this.mksizeCombo = mksizeCombo;
        }

        public JComboBox getMksizeCombo() {
            return this.mksizeCombo;
        }

        public void setFillComboBoxRenderer(ListCellRenderer fillComboBoxRenderer) {
            this.fillComboBoxRenderer = fillComboBoxRenderer;
        }

        public ListCellRenderer getFillComboBoxRenderer() {
            return this.fillComboBoxRenderer;
        }

        public void setStrkwdComboRenderer(ListCellRenderer strkwdComboRenderer) {
            this.strkwdComboRenderer = strkwdComboRenderer;
        }

        public ListCellRenderer getStrkwdComboRenderer() {
            return this.strkwdComboRenderer;
        }

        public void setStrkComboBoxRenderer(ListCellRenderer strkComboBoxRenderer) {
            this.strkComboBoxRenderer = strkComboBoxRenderer;
        }

        public ListCellRenderer getStrkComboBoxRenderer() {
            return this.strkComboBoxRenderer;
        }

        public void setMktypeComboRenderer(ListCellRenderer mktypeComboRenderer) {
            this.mktypeComboRenderer = mktypeComboRenderer;
        }

        public ListCellRenderer getMktypeComboRenderer() {
            return this.mktypeComboRenderer;
        }

        public void setMksizeComboRenderer(ListCellRenderer mksizeComboRenderer) {
            this.mksizeComboRenderer = mksizeComboRenderer;
        }

        public ListCellRenderer getMksizeComboRenderer() {
            return this.mksizeComboRenderer;
        }
    }
}

