/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.mapviewer.share.MVThemeMetadata;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.ui.resources.MessagesBundle;

public class PredefinedThemesSelectionPanel
extends JPanel {
    private static final Logger log = LogFactory.getLogger((LogFactory.LoggerEnum)LogFactory.LoggerEnum.MAPBUILDER);
    private static ImageIcon annotationThemeIcon = Icons.getIcon("font.png");
    private static ImageIcon customgeomThemeIcon = Icons.getIcon("ora_geomThemeItem.png");
    private static ImageIcon geometryThemeIcon = Icons.getIcon("geometry_theme.png");
    private static ImageIcon georasterThemeIcon = Icons.getIcon("georaster_theme.png");
    private static ImageIcon imageThemeIcon = Icons.getIcon("image_theme.png");
    private static ImageIcon networkThemeIcon = Icons.getIcon("network_theme.png");
    private static ImageIcon topologyThemeIcon = Icons.getIcon("topology_theme.png");
    private static ImageIcon wfsThemeIcon = Icons.getIcon("earth16.gif");
    private static ImageIcon wmsThemeIcon = Icons.getIcon("earth16.gif");
    private static ImageIcon wmtsThemeIcon = Icons.getIcon("earth16.gif");
    private static ImageIcon closedfolderIcon = Icons.getIcon("folder_closed.png");
    private static ImageIcon openedfolderIcon = Icons.getIcon("folder_opened.png");
    public static String ANNOTATIONTHEME_ENTRY = "Annotation Themes";
    public static String CUSTOMGEOMETRYTHEME_ENTRY = "Custom Geometry Themes";
    public static String GEOMETRYTHEME_ENTRY = "Geometry Themes";
    public static String IMAGETHEME_ENTRY = "Image Themes";
    public static String GEORASTERTHEME_ENTRY = "GeoRaster Themes";
    public static String NETWORKTHEME_ENTRY = "Network Themes";
    public static String TOPOLOGYTHEME_ENTRY = "Topology Themes";
    public static String WFSTHEME_ENTRY = "Wfs Themes";
    public static String WMSTHEME_ENTRY = "Wms Themes";
    public static String WMTSTHEME_ENTRY = "Wmts Themes";
    private JLabel jLabel1 = new JLabel();
    private DefaultMutableTreeNode rootNode;
    private DefaultMutableTreeNode themeNode = this.rootNode = new DefaultMutableTreeNode(MessagesBundle.getMessage("Available_themes"));
    private DefaultMutableTreeNode annothemeNode = null;
    private DefaultMutableTreeNode customgeomthemeNode = null;
    private DefaultMutableTreeNode geomthemeNode = null;
    private DefaultMutableTreeNode imgthemeNode = null;
    private DefaultMutableTreeNode georthemeNode = null;
    private DefaultMutableTreeNode netthemeNode = null;
    private DefaultMutableTreeNode topothemeNode = null;
    private DefaultMutableTreeNode wfsthemeNode = null;
    private DefaultMutableTreeNode wmsthemeNode = null;
    private DefaultMutableTreeNode wmtsthemeNode = null;
    private DefaultTreeModel treeModel = new DefaultTreeModel(this.rootNode);
    private JTree tree = new JTree(this.treeModel);
    private JScrollPane jScrollPane1 = new JScrollPane();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();

    public PredefinedThemesSelectionPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.setSize(new Dimension(300, 324));
        this.jLabel1.setText(MessagesBundle.getMessage("Select_themes"));
        this.jScrollPane1.getViewport().add(this.tree);
        nodeIcon renderer = new nodeIcon();
        this.jLabel1.setForeground(SystemColor.textHighlight);
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.tree.setCellRenderer(renderer);
        this.add((Component)this.jScrollPane1, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
    }

    public String[] getSelectedThemes() {
        TreePath[] paths = this.tree.getSelectionModel().getSelectionPaths();
        String[] s = new String[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            TreeNode node = (TreeNode)paths[i].getLastPathComponent();
            s[i] = (String)((DefaultMutableTreeNode)node).getUserObject();
        }
        return s;
    }

    public void setupTree(String[] incThemes, Vector<MVThemeMetadata> mvPredefinedThemes) {
        this.buildTree(incThemes, mvPredefinedThemes);
    }

    public void buildTree(String[] inMap, Vector<MVThemeMetadata> mvPredefinedThemes) {
        this.annothemeNode = new DefaultMutableTreeNode(ANNOTATIONTHEME_ENTRY);
        this.treeModel.insertNodeInto(this.annothemeNode, this.themeNode, this.themeNode.getChildCount());
        this.customgeomthemeNode = new DefaultMutableTreeNode(CUSTOMGEOMETRYTHEME_ENTRY);
        this.treeModel.insertNodeInto(this.customgeomthemeNode, this.themeNode, this.themeNode.getChildCount());
        this.geomthemeNode = new DefaultMutableTreeNode(GEOMETRYTHEME_ENTRY);
        this.treeModel.insertNodeInto(this.geomthemeNode, this.themeNode, this.themeNode.getChildCount());
        this.georthemeNode = new DefaultMutableTreeNode(GEORASTERTHEME_ENTRY);
        this.treeModel.insertNodeInto(this.georthemeNode, this.themeNode, this.themeNode.getChildCount());
        this.imgthemeNode = new DefaultMutableTreeNode(IMAGETHEME_ENTRY);
        this.treeModel.insertNodeInto(this.imgthemeNode, this.themeNode, this.themeNode.getChildCount());
        this.netthemeNode = new DefaultMutableTreeNode(NETWORKTHEME_ENTRY);
        this.treeModel.insertNodeInto(this.netthemeNode, this.themeNode, this.themeNode.getChildCount());
        this.topothemeNode = new DefaultMutableTreeNode(TOPOLOGYTHEME_ENTRY);
        this.treeModel.insertNodeInto(this.topothemeNode, this.themeNode, this.themeNode.getChildCount());
        this.wfsthemeNode = new DefaultMutableTreeNode(WFSTHEME_ENTRY);
        this.treeModel.insertNodeInto(this.wfsthemeNode, this.themeNode, this.themeNode.getChildCount());
        this.wmsthemeNode = new DefaultMutableTreeNode(WMSTHEME_ENTRY);
        this.treeModel.insertNodeInto(this.wmsthemeNode, this.themeNode, this.themeNode.getChildCount());
        this.wmtsthemeNode = new DefaultMutableTreeNode(WMTSTHEME_ENTRY);
        this.treeModel.insertNodeInto(this.wmtsthemeNode, this.themeNode, this.themeNode.getChildCount());
        Vector<MVThemeMetadata> themes = this.pruneThemes(mvPredefinedThemes, inMap);
        for (int i = 0; i < themes.size(); ++i) {
            MVThemeMetadata t = themes.get(i);
            String type = t.getType();
            DefaultMutableTreeNode nd = new DefaultMutableTreeNode(t.getName());
            if (MVThemeMetadata.GEOMETRY_TYPE.equalsIgnoreCase(type)) {
                this.treeModel.insertNodeInto(nd, this.geomthemeNode, this.geomthemeNode.getChildCount());
                continue;
            }
            if (MVThemeMetadata.GEORASTER_TYPE.equalsIgnoreCase(type)) {
                this.treeModel.insertNodeInto(nd, this.georthemeNode, this.georthemeNode.getChildCount());
                continue;
            }
            if (MVThemeMetadata.NETWORK_TYPE.equalsIgnoreCase(type)) {
                this.treeModel.insertNodeInto(nd, this.netthemeNode, this.netthemeNode.getChildCount());
                continue;
            }
            if (MVThemeMetadata.TOPOLOGY_TYPE.equalsIgnoreCase(type)) {
                this.treeModel.insertNodeInto(nd, this.topothemeNode, this.topothemeNode.getChildCount());
                continue;
            }
            if (MVThemeMetadata.IMAGE_TYPE.equalsIgnoreCase(type)) {
                this.treeModel.insertNodeInto(nd, this.imgthemeNode, this.imgthemeNode.getChildCount());
                continue;
            }
            if (MVThemeMetadata.WFS_TYPE.equalsIgnoreCase(type)) {
                this.treeModel.insertNodeInto(nd, this.wfsthemeNode, this.wfsthemeNode.getChildCount());
                continue;
            }
            if (MVThemeMetadata.WMS_TYPE.equalsIgnoreCase(type)) {
                this.treeModel.insertNodeInto(nd, this.wmsthemeNode, this.wmsthemeNode.getChildCount());
                continue;
            }
            if (MVThemeMetadata.ANNOTATION_TYPE.equalsIgnoreCase(type)) {
                this.treeModel.insertNodeInto(nd, this.annothemeNode, this.annothemeNode.getChildCount());
                continue;
            }
            if (MVThemeMetadata.CUSTOMGEOM_TYPE.equalsIgnoreCase(type)) {
                this.treeModel.insertNodeInto(nd, this.customgeomthemeNode, this.customgeomthemeNode.getChildCount());
                continue;
            }
            if (MVThemeMetadata.WMTS_TYPE.equalsIgnoreCase(type)) {
                this.treeModel.insertNodeInto(nd, this.wmtsthemeNode, this.wmtsthemeNode.getChildCount());
                continue;
            }
            this.treeModel.insertNodeInto(nd, this.geomthemeNode, this.geomthemeNode.getChildCount());
        }
        this.tree.expandRow(0);
        this.updateUI();
    }

    private Vector<MVThemeMetadata> pruneThemes(Vector<MVThemeMetadata> themes, String[] inMap) {
        if (inMap != null && inMap.length > 0) {
            Hashtable<String, String> ht = new Hashtable<String, String>(inMap.length * 3 + 1);
            for (int i = 0; i < inMap.length; ++i) {
                ht.put(inMap[i].toUpperCase(), "");
            }
            int initSz = themes.size() - inMap.length;
            Vector<MVThemeMetadata> al = new Vector<MVThemeMetadata>();
            for (int i = 0; i < themes.size(); ++i) {
                MVThemeMetadata t = themes.get(i);
                if (ht.containsKey(t.getName().toUpperCase())) continue;
                al.add(t);
            }
            return al;
        }
        return themes;
    }

    private class nodeIcon
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            String nodeName = node.toString();
            String parentName = null;
            TreeNode parent = node.getParent();
            if (parent != null) {
                parentName = parent.toString();
            }
            switch (node.getLevel()) {
                case 0: 
                case 1: {
                    if (expanded) {
                        this.setIcon(openedfolderIcon);
                        break;
                    }
                    this.setIcon(closedfolderIcon);
                    break;
                }
                case 2: {
                    if (parentName.equals(ANNOTATIONTHEME_ENTRY)) {
                        this.setIcon(annotationThemeIcon);
                    }
                    if (parentName.equals(CUSTOMGEOMETRYTHEME_ENTRY)) {
                        this.setIcon(customgeomThemeIcon);
                        break;
                    }
                    if (parentName.equals(GEOMETRYTHEME_ENTRY)) {
                        this.setIcon(geometryThemeIcon);
                        break;
                    }
                    if (parentName.equals(GEORASTERTHEME_ENTRY)) {
                        this.setIcon(georasterThemeIcon);
                        break;
                    }
                    if (parentName.equals(IMAGETHEME_ENTRY)) {
                        this.setIcon(imageThemeIcon);
                        break;
                    }
                    if (parentName.equals(NETWORKTHEME_ENTRY)) {
                        this.setIcon(networkThemeIcon);
                        break;
                    }
                    if (parentName.equals(TOPOLOGYTHEME_ENTRY)) {
                        this.setIcon(topologyThemeIcon);
                        break;
                    }
                    if (parentName.equals(WFSTHEME_ENTRY)) {
                        this.setIcon(wfsThemeIcon);
                        break;
                    }
                    if (parentName.equals(WMSTHEME_ENTRY)) {
                        this.setIcon(wmsThemeIcon);
                        break;
                    }
                    if (!parentName.equals(WMTSTHEME_ENTRY)) break;
                    this.setIcon(wmtsThemeIcon);
                    break;
                }
            }
            return this;
        }
    }
}

