/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.maps.core.MapCanvas;
import oracle.mdeditor.ui.EditSessionPanel;
import oracle.mdeditor.ui.MainAppPanel;
import oracle.mdeditor.ui.MapActionsToolBar;
import oracle.mdeditor.ui.MapCoveragePanel;
import oracle.mdeditor.ui.SDEUIComponent;
import oracle.mdeditor.ui.StatusBarPanel;
import oracle.mdeditor.ui.resources.MessagesBundle;

public class MapRenderingPanel
extends JPanel
implements SDEUIComponent,
ChangeListener {
    private MainAppPanel mainApp = null;
    private MapActionsToolBar toolPane = null;
    private MapCanvas canvas = null;
    private StatusBarPanel statusBar = null;

    public MapRenderingPanel(MainAppPanel mainApp) {
        if (mainApp == null) {
            throw new IllegalArgumentException("null parameter");
        }
        this.mainApp = mainApp;
        this.mainApp.getEditSessionPanel().addChangeListener(this);
        this.canvas = new MapCanvas();
        this.toolPane = new MapActionsToolBar(this.canvas, mainApp);
        this.statusBar = new StatusBarPanel(this.canvas.getProgressBar());
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() {
        this.setName(MessagesBundle.getMessage("Map_canvas"));
        this.setInheritsPopupMenu(true);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.toolPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.canvas, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.statusBar, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 1, 0, 0), 0, 0));
        this.setVisible(true);
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        Object src = evt.getSource();
        if (src instanceof EditSessionPanel) {
            this.toolPane.setCanvas(null);
            this.statusBar.setProgressBar(null);
            this.statusBar.setLayerManager(null);
            this.canvas.getUndoManager().removeChangeListener(this.toolPane);
            this.canvas.getLayerManager().removeEditChangeListener(this.toolPane);
            this.canvas.getLayerManager().removeChangeListener(this.toolPane);
            this.canvas.getMapRegion().removeChangeListener(this.toolPane.getCoveragePane());
            this.canvas.getLayerManager().removeChangeListener(this.statusBar);
            this.canvas.getLayerManager().removeSelectionListener(this.statusBar);
            int cvWidth = this.canvas.getWidth();
            int cvHeight = this.canvas.getHeight();
            this.remove(this.canvas);
            this.remove(this.statusBar);
            EditSessionPanel.SessionChangeEvent e = (EditSessionPanel.SessionChangeEvent)evt;
            this.canvas = e.getNewSession() != null && e.getNewSession().getMapCanvas() != null ? e.getNewSession().getMapCanvas() : new MapCanvas();
            this.canvas.setSize(cvWidth, cvHeight);
            this.toolPane.setCanvas(this.canvas);
            this.statusBar.setProgressBar(this.canvas.getProgressBar());
            this.statusBar.setLayerManager(this.canvas.getLayerManager());
            this.canvas.getUndoManager().addChangeListener(this.toolPane);
            this.canvas.getLayerManager().addEditChangeListener(this.toolPane);
            this.canvas.getLayerManager().addChangeListener(this.toolPane);
            this.canvas.getMapRegion().addChangeListener(this.toolPane.getCoveragePane());
            this.canvas.getLayerManager().addChangeListener(this.statusBar);
            this.canvas.getLayerManager().addSelectionListener(this.statusBar);
            this.add((Component)this.canvas, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.statusBar, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 1, 0, 0), 0, 0));
        }
    }

    public MapActionsToolBar getToolPanel() {
        return this.toolPane;
    }

    public MapCoveragePanel getMapCoveragePanel() {
        return this.toolPane.getCoveragePane();
    }

    public StatusBarPanel getStatusBarPanel() {
        return this.statusBar;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void updateUIStatus() {
        this.toolPane.updateButtonStatus();
    }
}

