/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.spatial.edit.layer.AbstractDataSetLayer;

public class GeometryUnionPanel
extends JPanel {
    private JLabel targetLayerLabel = new JLabel();
    private JTextField targetLayerTxt = new JTextField();
    private JLabel targetKeyColLabel = new JLabel();
    private JTextField targetKeyColTxt = new JTextField();
    private JLabel selLayerLabel = new JLabel();
    private JTextField selLayerTxt = new JTextField();
    private JLabel selJoincolLabel = new JLabel();
    private JComboBox selJoincolCombo = new JComboBox();
    private AbstractDataSetLayer targetLayer = null;
    private AbstractDataSetLayer selectionLayer = null;

    public GeometryUnionPanel(AbstractDataSetLayer targetLayer, AbstractDataSetLayer selectionLayer) {
        this.targetLayer = targetLayer;
        this.selectionLayer = selectionLayer;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(300, 120));
        this.targetLayerLabel.setText(MessagesBundle.getMessage("Label_target_layer"));
        this.targetLayerTxt.setEditable(false);
        this.targetKeyColLabel.setText(MessagesBundle.getMessage("Label_target_key_attribute"));
        this.targetKeyColTxt.setEditable(false);
        if (this.targetLayer != null) {
            this.targetLayerTxt.setText(this.targetLayer.getName());
            this.targetKeyColTxt.setText(this.targetLayer.getDataSet().getKeyColumn().toUpperCase());
        }
        this.selLayerLabel.setText(MessagesBundle.getMessage("Label_selection_layer"));
        this.selLayerTxt.setEditable(false);
        this.selJoincolLabel.setText(MessagesBundle.getMessage("Label_selection_join_attribute"));
        if (this.selectionLayer != null) {
            this.selLayerTxt.setText(this.selectionLayer.getName());
            String[] attributes = this.selectionLayer.getDataSet().getAttributeNames();
            if (attributes != null && attributes.length > 0) {
                for (int i = 0; i < attributes.length; ++i) {
                    this.selJoincolCombo.addItem(attributes[i].toUpperCase());
                }
                this.selJoincolCombo.setSelectedItem(this.targetLayer.getDataSet().getKeyColumn().toUpperCase());
            }
        }
        this.add((Component)this.targetLayerLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.targetLayerTxt, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 10), 0, 0));
        this.add((Component)this.targetKeyColLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.targetKeyColTxt, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 10), 0, 0));
        this.add((Component)this.selLayerLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.selLayerTxt, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 10), 0, 0));
        this.add((Component)this.selJoincolLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.selJoincolCombo, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 10), 0, 0));
    }

    public String getTargetKeyColumn() {
        String key = this.targetKeyColTxt.getText();
        if (key == null || key.trim().length() == 0) {
            return null;
        }
        return key.trim();
    }

    public String getSelectionJoinColumn() {
        if (this.selJoincolCombo.getItemCount() < 1) {
            return null;
        }
        return this.selJoincolCombo.getSelectedItem().toString();
    }
}

