/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import oracle.mdeditor.ui.resources.MessagesBundle;

public class FontPanel
extends JPanel {
    private JLabel jLabel1 = new JLabel();
    private JCheckBox jCheckBoxBold = new JCheckBox();
    private JCheckBox jCheckBoxItalic = new JCheckBox();
    private JLabel jLabel2 = new JLabel();
    private JSpinner jSpinnerSize = new JSpinner();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel jLabelFiller = new JLabel();
    private JComboBox jComboBox_font = new JComboBox();
    private JLabel styleLabel = new JLabel();
    private SpinnerModel spinModel = new SpinnerNumberModel(1.0, 1.0, 128.0, 1.0);
    private String[] javaFonts = new String[]{"Dialog", "SansSerif", "Serif", "Monospaced", "DialogInput"};

    public FontPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.setBorder(BorderFactory.createTitledBorder(MessagesBundle.getMessage("Font")));
        this.setSize(new Dimension(279, 133));
        this.jLabel1.setText(MessagesBundle.getMessage("Label_name"));
        this.styleLabel.setText(MessagesBundle.getMessage("Label_style"));
        this.jCheckBoxBold.setText(MessagesBundle.getMessage("Bold"));
        this.jCheckBoxBold.setFont(new Font("Serif", 1, 14));
        this.jCheckBoxItalic.setText(MessagesBundle.getMessage("Italic"));
        this.jCheckBoxItalic.setFont(new Font("Serif", 2, 14));
        this.jLabel2.setText(MessagesBundle.getMessage("Label_size"));
        for (int i = 0; i < this.javaFonts.length; ++i) {
            this.jComboBox_font.addItem(this.javaFonts[i]);
        }
        this.jComboBox_font.setSelectedItem("Serif");
        this.jSpinnerSize.setModel(this.spinModel);
        this.add((Component)this.jSpinnerSize, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.add((Component)this.jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 0), 0, 0));
        this.add((Component)this.jCheckBoxItalic, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.jCheckBoxBold, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 0, 0), 0, 0));
        this.add((Component)this.jLabelFiller, new GridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jComboBox_font, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)this.styleLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 0), 0, 0));
    }

    public void setStyleFontName(String font) {
        this.jComboBox_font.setSelectedItem(font);
    }

    public String getStyleFontName() {
        return this.jComboBox_font.getSelectedItem().toString();
    }

    public float getStyleFontSize() {
        SpinnerNumberModel mod = (SpinnerNumberModel)this.jSpinnerSize.getModel();
        return mod.getNumber().floatValue();
    }

    public void setStyleFontSize(float f) {
        this.jSpinnerSize.getModel().setValue(new Float(f));
    }

    public Font getStyleFont() {
        String name = this.getStyleFontName();
        boolean italic = this.jCheckBoxItalic.isSelected();
        boolean bold = this.jCheckBoxBold.isSelected();
        float size = this.getStyleFontSize();
        int style = 0;
        if (bold && italic) {
            style = 3;
        } else if (bold) {
            style = 1;
        } else if (italic) {
            style = 2;
        }
        return new Font(name, style, (int)size);
    }

    public void setStyleFont(Font f) {
        this.setStyleFontName(f.getFamily());
        this.jCheckBoxItalic.setSelected(f.isItalic());
        this.jCheckBoxBold.setSelected(f.isBold());
        this.setStyleFontSize(f.getSize());
    }

    public boolean isBoldSelected() {
        return this.jCheckBoxBold.isSelected();
    }

    public void setBoldSelected(boolean value) {
        this.jCheckBoxBold.setSelected(value);
    }

    public boolean isItalicSelected() {
        return this.jCheckBoxItalic.isSelected();
    }

    public void setItalicSelected(boolean value) {
        this.jCheckBoxItalic.setSelected(value);
    }

    public void allowChanges(boolean enable) {
        this.jComboBox_font.setEnabled(enable);
        this.jSpinnerSize.setEnabled(enable);
        this.jCheckBoxItalic.setEnabled(enable);
        this.jCheckBoxBold.setEnabled(enable);
    }
}

