/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.mapviewer.share.Field;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.spatial.edit.layer.AbstractDataSetLayer;

public class FeaturePickByAttributePanel
extends JPanel {
    private JLabel selLayerLabel = new JLabel();
    private JComboBox selLayerCombo = new JComboBox();
    private JLabel selAttrLabel = new JLabel();
    private JComboBox selAttrCombo = new JComboBox();
    private JLabel selValueLabel = new JLabel();
    private JTextField selValueTxt = new JTextField();
    private JCheckBox appendBox = new JCheckBox();
    private AbstractDataSetLayer[] selectionLayers = null;

    public FeaturePickByAttributePanel(AbstractDataSetLayer[] selectionLayers) {
        this.selectionLayers = selectionLayers;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(300, 120));
        this.selLayerLabel.setText(MessagesBundle.getMessage("Label_selection_layer"));
        this.selLayerCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeaturePickByAttributePanel.this.selLayerCombo_actionPerformed(e);
            }
        });
        this.selAttrLabel.setText(MessagesBundle.getMessage("Label_attribute"));
        this.selValueLabel.setText(MessagesBundle.getMessage("Label_value"));
        this.appendBox.setText(MessagesBundle.getMessage("Checkbox_append_features"));
        this.add((Component)this.selLayerLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.selLayerCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 10), 0, 0));
        this.add((Component)this.selAttrLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.selAttrCombo, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 10), 0, 0));
        this.add((Component)this.selValueLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.selValueTxt, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 10), 0, 0));
        this.add((Component)this.appendBox, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 10), 0, 0));
        this.fillLayers();
        this.fillAttributes();
    }

    private void fillLayers() {
        this.selLayerCombo.removeAllItems();
        if (this.selectionLayers != null) {
            for (int i = 0; i < this.selectionLayers.length; ++i) {
                if (!(this.selectionLayers[i] instanceof AbstractDataSetLayer)) continue;
                this.selLayerCombo.addItem(this.selectionLayers[i].getName());
            }
        }
    }

    private void fillAttributes() {
        this.selAttrCombo.removeAllItems();
        if (this.selLayerCombo.getItemCount() == 0) {
            return;
        }
        int layerIndex = this.selLayerCombo.getSelectedIndex();
        if (layerIndex == -1) {
            return;
        }
        String[] attributes = this.selectionLayers[layerIndex].getDataSet().getAttributeNames();
        if (attributes != null && attributes.length > 0) {
            int i;
            ArrayList<String> sortedNames = new ArrayList<String>();
            for (i = 0; i < attributes.length; ++i) {
                sortedNames.add(attributes[i].toUpperCase());
            }
            Collections.sort(sortedNames);
            for (i = 0; i < sortedNames.size(); ++i) {
                this.selAttrCombo.addItem(sortedNames.get(i));
            }
            this.selAttrCombo.setSelectedItem(this.selectionLayers[layerIndex].getDataSet().getKeyColumn().toUpperCase());
        }
    }

    public AbstractDataSetLayer getSelectedLayer() {
        int layerIndex = this.selLayerCombo.getSelectedIndex();
        if (layerIndex == -1) {
            return null;
        }
        return this.selectionLayers[layerIndex];
    }

    public String getAttributeName() {
        if (this.selAttrCombo.getItemCount() < 1) {
            return null;
        }
        return this.selAttrCombo.getSelectedItem().toString();
    }

    public Field getAttributeValue() {
        if (this.selectionLayers == null) {
            return null;
        }
        AbstractDataSetLayer selectedLayer = this.getSelectedLayer();
        if (selectedLayer == null) {
            return null;
        }
        String javaType = selectedLayer.getDataSet().getAttributeJavaType(this.getAttributeName());
        if (javaType == null) {
            return null;
        }
        Field outField = null;
        try {
            outField = javaType.equalsIgnoreCase("short") ? Field.createField((String)this.selValueTxt.getText(), (String)"short") : (javaType.equalsIgnoreCase("integer") ? Field.createField((String)this.selValueTxt.getText(), (String)"integer") : (javaType.equalsIgnoreCase("float") ? Field.createField((String)this.selValueTxt.getText(), (String)"float") : (javaType.equalsIgnoreCase("double") ? Field.createField((String)this.selValueTxt.getText(), (String)"double") : (javaType.equalsIgnoreCase("long") ? Field.createField((String)this.selValueTxt.getText(), (String)"long") : (javaType.equalsIgnoreCase("date") ? Field.createField((String)this.selValueTxt.getText(), (String)"date") : (javaType.equalsIgnoreCase("boolean") ? Field.createField((String)this.selValueTxt.getText(), (String)"boolean") : new Field(this.selValueTxt.getText())))))));
            outField.setName(this.getAttributeName());
        }
        catch (Exception ex) {
            outField = null;
        }
        return outField;
    }

    private void selLayerCombo_actionPerformed(ActionEvent e) {
        this.fillAttributes();
    }

    public boolean appendSelections() {
        return this.appendBox.isSelected();
    }
}

