/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.maps.core.Layer;
import oracle.maps.core.LayerManager;
import oracle.mdeditor.session.EditSession;
import oracle.mdeditor.session.layer.ConfigurableLayer;
import oracle.mdeditor.ui.MainAppPanel;
import oracle.mdeditor.ui.resources.MessagesBundle;

public class EditSessionPreferencesPanel
extends JPanel {
    protected MainAppPanel mainApp = null;
    protected EditSession editSession = null;
    protected JTree preferencesTree = new JTree();
    protected JPanel attrPanel = new JPanel();
    protected Layer initialSelection = null;

    public EditSessionPreferencesPanel(MainAppPanel mainApp, EditSession editSession, Layer initialSelection) {
        this.mainApp = mainApp;
        this.editSession = editSession;
        this.initialSelection = initialSelection;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(610, 400));
        this.preferencesTree.setEditable(false);
        this.preferencesTree.setToggleClickCount(1);
        this.preferencesTree.setCellRenderer(new MyTreeCellRenderer());
        this.preferencesTree.getSelectionModel().setSelectionMode(1);
        this.attrPanel.setLayout(new GridBagLayout());
        this.buildTree();
        JScrollPane treeScrollPane = new JScrollPane(this.preferencesTree);
        treeScrollPane.setPreferredSize(new Dimension(185, 1));
        treeScrollPane.setMinimumSize(new Dimension(185, 1));
        this.preferencesTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                EditSessionPreferencesPanel.this.processTreeSelection(e);
            }
        });
        JScrollPane attrScollPane = new JScrollPane(this.attrPanel);
        attrScollPane.setBorder(UIManager.getBorder("TitledBorder.border"));
        JSplitPane sp = new JSplitPane(1, treeScrollPane, attrScollPane);
        sp.setDividerSize(2);
        this.add((Component)sp, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 10, 0, 10), 0, 0));
    }

    private void buildTree() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(MessagesBundle.getMessage("Preference_itens"));
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        this.preferencesTree.setModel(treeModel);
        DefaultMutableTreeNode sessionPrefsNode = new DefaultMutableTreeNode(this.editSession);
        rootNode.add(sessionPrefsNode);
        DefaultMutableTreeNode controlLayersNode = new DefaultMutableTreeNode(MessagesBundle.getMessage("Treenode_control_layer_props"));
        rootNode.add(controlLayersNode);
        DefaultMutableTreeNode dataLayersNode = new DefaultMutableTreeNode(MessagesBundle.getMessage("Treenode_data_layer_props"));
        rootNode.add(dataLayersNode);
        DefaultMutableTreeNode selectNode = sessionPrefsNode;
        Iterator<LayerManager.Entry> itr = this.editSession.getLayers().entryIterator();
        while (itr.hasNext()) {
            LayerManager.Entry e = itr.next();
            Layer l = e.getLayer();
            if (!(l instanceof ConfigurableLayer)) continue;
            DefaultMutableTreeNode layerNode = new DefaultMutableTreeNode(l);
            DefaultMutableTreeNode addTo = null;
            addTo = e.getTags().contains("dataLayer") ? dataLayersNode : controlLayersNode;
            addTo.add(layerNode);
            if (!l.equals(this.initialSelection)) continue;
            selectNode = layerNode;
        }
        this.preferencesTree.expandRow(0);
        this.preferencesTree.expandPath(new TreePath(controlLayersNode.getPath()));
        this.preferencesTree.expandPath(new TreePath(dataLayersNode.getPath()));
        this.preferencesTree.setRootVisible(false);
        this.preferencesTree.setSelectionPath(new TreePath(selectNode.getPath()));
        this.updatePanel(selectNode.getUserObject());
    }

    private void processTreeSelection(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.preferencesTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object o = node.getUserObject();
        this.updatePanel(o);
    }

    private void updatePanel(Object o) {
        this.attrPanel.removeAll();
        JPanel configPanel = null;
        if (o instanceof ConfigurableLayer) {
            configPanel = ((ConfigurableLayer)o).getConfigurationPanel(this.mainApp.getFrameForDialog());
        } else if (o instanceof EditSession) {
            configPanel = ((EditSession)o).getConfigurationPanel(this.mainApp.getFrameForDialog());
        }
        JScrollPane sp = new JScrollPane(configPanel);
        sp.setBorder(null);
        this.attrPanel.add((Component)sp, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.revalidate();
    }

    private class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object o = node.getUserObject();
            if (o instanceof ConfigurableLayer) {
                ConfigurableLayer layer = (ConfigurableLayer)o;
                value = layer.getName();
            } else if (o instanceof EditSession) {
                EditSession session = (EditSession)o;
                value = MessagesBundle.getFormattedMessage("Treenode_session_props", session.getName());
            } else {
                value = value.toString();
            }
            return super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
    }
}

