/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.tools.configurable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.maps.core.MapCanvas;
import oracle.maps.layer.BasicLayer;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mdeditor.session.layer.ConfigurableLayer;
import oracle.mdeditor.ui.ColorIcon;
import oracle.mdeditor.ui.resources.MessagesBundle;

public class DrawToolsConfigurable
extends BasicLayer
implements ConfigurableLayer {
    public static final String TAG_DRAWINGTOOLS_CONFIG = "drawingToolsConfigLayer";
    public static final String PROPERTY_CURSOR_POINT_CENTER_COLOR = "oracle.maps.tools.configurable.DrawToolsConfigurable.cursorPointCenterColor";
    public static final String PROPERTY_CURSOR_POINT_BORDER_COLOR = "oracle.maps.tools.configurable.DrawToolsConfigurable.cursorPointBorderColor";
    public static final String PROPERTY_CURSOR_POINT_SIZE = "oracle.maps.tools.configurable.DrawToolsConfigurable.cursorPointSize";
    public static final String PROPERTY_LINE_SEGMENT_COLOR = "oracle.maps.tools.configurable.DrawToolsConfigurable.lineSegmentColor";
    public static final String PROPERTY_LINE_SEGMENT_WIDTH = "oracle.maps.tools.configurable.DrawToolsConfigurable.lineSegmentSize";
    public static final String PROPERTY_RUBBERBAND_SEGMENT_COLOR = "oracle.maps.tools.configurable.DrawToolsConfigurable.rubberbandSegmentColor";
    public static final String PROPERTY_RUBBERBAND_SEGMENT_WIDTH = "oracle.maps.tools.configurable.DrawToolsConfigurable.rubberbandSegmentSize";
    public static final String PROPERTY_SNAP_POINT_CENTER_COLOR = "oracle.maps.tools.configurable.DrawToolsConfigurable.snapCenterColor";
    public static final String PROPERTY_SNAP_POINT_BORDER_COLOR = "oracle.maps.tools.configurable.DrawToolsConfigurable.snapBorderColor";

    public DrawToolsConfigurable(MapCanvas mapCanvas) {
        super(mapCanvas);
        this.properties.setDefaultProperty("oracle.maps.core.Layer.name", "Drawing Tools");
        this.properties.setDefaultProperty("oracle.maps.core.Layer.visible", Boolean.toString(true));
        this.properties.setDefaultProperty(PROPERTY_CURSOR_POINT_CENTER_COLOR, StyleUtils.getHexidecimalString((Color)Color.blue));
        this.properties.setDefaultProperty(PROPERTY_CURSOR_POINT_BORDER_COLOR, StyleUtils.getHexidecimalString((Color)Color.blue));
        this.properties.setDefaultProperty(PROPERTY_LINE_SEGMENT_COLOR, StyleUtils.getHexidecimalString((Color)Color.red));
        this.properties.setDefaultProperty(PROPERTY_RUBBERBAND_SEGMENT_COLOR, StyleUtils.getHexidecimalString((Color)Color.yellow));
        this.properties.setDefaultProperty(PROPERTY_SNAP_POINT_CENTER_COLOR, StyleUtils.getHexidecimalString((Color)Color.red));
        this.properties.setDefaultProperty(PROPERTY_SNAP_POINT_BORDER_COLOR, StyleUtils.getHexidecimalString((Color)Color.red));
        this.properties.setDefaultProperty(PROPERTY_CURSOR_POINT_SIZE, "12");
        this.properties.setDefaultProperty(PROPERTY_LINE_SEGMENT_WIDTH, "2");
        this.properties.setDefaultProperty(PROPERTY_RUBBERBAND_SEGMENT_WIDTH, "2");
    }

    @Override
    public JPanel getConfigurationPanel(Component parent) {
        DrawingToolsPreferencesPanel p = new DrawingToolsPreferencesPanel(parent);
        return p;
    }

    private Color getColorProperty(String property) {
        try {
            Integer i = Integer.decode(this.getProperty(property));
            return new Color(i);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void setColorProperty(String property, Color c) {
        this.setProperty(property, StyleUtils.getHexidecimalString((Color)c));
    }

    @Override
    public boolean handleEvent(EventObject evt) {
        return true;
    }

    private class DrawingToolsPreferencesPanel
    extends JPanel {
        private Component parent = null;
        private Color cursorCenterColor = null;
        private Color cursorBorderColor = null;
        private int cursorSize = 8;
        private Color snapCenterColor = null;
        private Color snapBorderColor = null;
        private Color lineSegmentColor = null;
        private int lineSegmentWidth = 1;
        private Color rubberbandSegmentColor = null;
        private int rubberbandSegmentWidth = 1;

        public DrawingToolsPreferencesPanel(Component parent) {
            this.parent = parent;
            this.cursorCenterColor = DrawToolsConfigurable.this.getColorProperty(DrawToolsConfigurable.PROPERTY_CURSOR_POINT_CENTER_COLOR);
            this.cursorBorderColor = DrawToolsConfigurable.this.getColorProperty(DrawToolsConfigurable.PROPERTY_CURSOR_POINT_BORDER_COLOR);
            this.cursorSize = Integer.parseInt(DrawToolsConfigurable.this.getProperty(DrawToolsConfigurable.PROPERTY_CURSOR_POINT_SIZE));
            this.snapCenterColor = DrawToolsConfigurable.this.getColorProperty(DrawToolsConfigurable.PROPERTY_SNAP_POINT_CENTER_COLOR);
            this.snapBorderColor = DrawToolsConfigurable.this.getColorProperty(DrawToolsConfigurable.PROPERTY_SNAP_POINT_BORDER_COLOR);
            this.lineSegmentColor = DrawToolsConfigurable.this.getColorProperty(DrawToolsConfigurable.PROPERTY_LINE_SEGMENT_COLOR);
            this.lineSegmentWidth = Integer.parseInt(DrawToolsConfigurable.this.getProperty(DrawToolsConfigurable.PROPERTY_LINE_SEGMENT_WIDTH));
            this.rubberbandSegmentColor = DrawToolsConfigurable.this.getColorProperty(DrawToolsConfigurable.PROPERTY_RUBBERBAND_SEGMENT_COLOR);
            this.rubberbandSegmentWidth = Integer.parseInt(DrawToolsConfigurable.this.getProperty(DrawToolsConfigurable.PROPERTY_RUBBERBAND_SEGMENT_WIDTH));
            try {
                this.jbInit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void jbInit() throws Exception {
            this.setLayout(new GridBagLayout());
            this.setSize(new Dimension(305, 154));
            JLabel cursorCenterColorLabel = new JLabel(MessagesBundle.getMessage("Label_pref_cursor_center_color"));
            JButton cursorCenterColorButton = new JButton(new ColorIcon(32, 16, this.cursorCenterColor));
            cursorCenterColorButton.addActionListener(new ColorIconButtonActionListener(this.parent){

                @Override
                public void colorChanged(Color color) {
                    DrawingToolsPreferencesPanel.this.cursorCenterColor = color;
                }
            });
            JLabel cursorBorderColorLabel = new JLabel(MessagesBundle.getMessage("Label_pref_cursor_border_color"));
            JButton cursorBorderColorButton = new JButton(new ColorIcon(32, 16, this.cursorBorderColor));
            cursorBorderColorButton.addActionListener(new ColorIconButtonActionListener(this.parent){

                @Override
                public void colorChanged(Color color) {
                    DrawingToolsPreferencesPanel.this.cursorBorderColor = color;
                }
            });
            JLabel snapCenterColorLabel = new JLabel(MessagesBundle.getMessage("Label_pref_snap_center_color"));
            JButton snapCenterColorButton = new JButton(new ColorIcon(32, 16, this.snapCenterColor));
            snapCenterColorButton.addActionListener(new ColorIconButtonActionListener(this.parent){

                @Override
                public void colorChanged(Color color) {
                    DrawingToolsPreferencesPanel.this.snapCenterColor = color;
                }
            });
            JLabel snapBorderColorLabel = new JLabel(MessagesBundle.getMessage("Label_pref_snap_border_color"));
            JButton snapBorderColorButton = new JButton(new ColorIcon(32, 16, this.snapBorderColor));
            snapBorderColorButton.addActionListener(new ColorIconButtonActionListener(this.parent){

                @Override
                public void colorChanged(Color color) {
                    DrawingToolsPreferencesPanel.this.snapBorderColor = color;
                }
            });
            JLabel cursorSizeLabel = new JLabel(MessagesBundle.getMessage("Label_pref_cursor_size"));
            JSpinner cursorSizeSpinner = new JSpinner(new SpinnerNumberModel(this.cursorSize, 1, 40, 1));
            cursorSizeSpinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JSpinner s = (JSpinner)e.getSource();
                    DrawingToolsPreferencesPanel.this.cursorSize = (Integer)s.getValue();
                }
            });
            JLabel lineColorLabel = new JLabel(MessagesBundle.getMessage("Label_pref_line_segment_color"));
            JButton lineColorButton = new JButton(new ColorIcon(32, 16, this.lineSegmentColor));
            lineColorButton.addActionListener(new ColorIconButtonActionListener(this.parent){

                @Override
                public void colorChanged(Color color) {
                    DrawingToolsPreferencesPanel.this.lineSegmentColor = color;
                }
            });
            JLabel lineWidthLabel = new JLabel(MessagesBundle.getMessage("Label_pref_line_segment_width"));
            JSpinner lineWidthSpinner = new JSpinner(new SpinnerNumberModel(this.lineSegmentWidth, 1, 40, 1));
            lineWidthSpinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JSpinner s = (JSpinner)e.getSource();
                    DrawingToolsPreferencesPanel.this.lineSegmentWidth = (Integer)s.getValue();
                }
            });
            JLabel rubberColorLabel = new JLabel(MessagesBundle.getMessage("Label_pref_rubberband_color"));
            JButton rubberColorButton = new JButton(new ColorIcon(32, 16, this.rubberbandSegmentColor));
            rubberColorButton.addActionListener(new ColorIconButtonActionListener(this.parent){

                @Override
                public void colorChanged(Color color) {
                    DrawingToolsPreferencesPanel.this.rubberbandSegmentColor = color;
                }
            });
            JLabel rubberWidthLabel = new JLabel(MessagesBundle.getMessage("Label_pref_rubberband_width"));
            JSpinner rubberWidthSpinner = new JSpinner(new SpinnerNumberModel(this.rubberbandSegmentWidth, 1, 40, 1));
            rubberWidthSpinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JSpinner s = (JSpinner)e.getSource();
                    DrawingToolsPreferencesPanel.this.rubberbandSegmentWidth = (Integer)s.getValue();
                }
            });
            JButton applyButton = new JButton(MessagesBundle.getMessage("Button_apply"));
            applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DrawToolsConfigurable.this.setColorProperty(DrawToolsConfigurable.PROPERTY_CURSOR_POINT_CENTER_COLOR, DrawingToolsPreferencesPanel.this.cursorCenterColor);
                    DrawToolsConfigurable.this.setColorProperty(DrawToolsConfigurable.PROPERTY_CURSOR_POINT_BORDER_COLOR, DrawingToolsPreferencesPanel.this.cursorBorderColor);
                    DrawToolsConfigurable.this.setColorProperty(DrawToolsConfigurable.PROPERTY_SNAP_POINT_CENTER_COLOR, DrawingToolsPreferencesPanel.this.snapCenterColor);
                    DrawToolsConfigurable.this.setColorProperty(DrawToolsConfigurable.PROPERTY_SNAP_POINT_BORDER_COLOR, DrawingToolsPreferencesPanel.this.snapBorderColor);
                    DrawToolsConfigurable.this.setProperty(DrawToolsConfigurable.PROPERTY_CURSOR_POINT_SIZE, "" + DrawingToolsPreferencesPanel.this.cursorSize);
                    DrawToolsConfigurable.this.setColorProperty(DrawToolsConfigurable.PROPERTY_LINE_SEGMENT_COLOR, DrawingToolsPreferencesPanel.this.lineSegmentColor);
                    DrawToolsConfigurable.this.setProperty(DrawToolsConfigurable.PROPERTY_LINE_SEGMENT_WIDTH, "" + DrawingToolsPreferencesPanel.this.lineSegmentWidth);
                    DrawToolsConfigurable.this.setColorProperty(DrawToolsConfigurable.PROPERTY_RUBBERBAND_SEGMENT_COLOR, DrawingToolsPreferencesPanel.this.rubberbandSegmentColor);
                    DrawToolsConfigurable.this.setProperty(DrawToolsConfigurable.PROPERTY_RUBBERBAND_SEGMENT_WIDTH, "" + DrawingToolsPreferencesPanel.this.rubberbandSegmentWidth);
                }
            });
            int y = 0;
            this.add((Component)cursorCenterColorLabel, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 13, 0, new Insets(10, 0, 0, 0), 0, 0));
            this.add((Component)cursorCenterColorButton, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
            this.add((Component)cursorBorderColorLabel, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)cursorBorderColorButton, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)cursorSizeLabel, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)cursorSizeSpinner, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)snapCenterColorLabel, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)snapCenterColorButton, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)snapBorderColorLabel, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)snapBorderColorButton, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)lineColorLabel, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)lineColorButton, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)lineWidthLabel, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)lineWidthSpinner, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)rubberColorLabel, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)rubberColorButton, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)rubberWidthLabel, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)rubberWidthSpinner, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)applyButton, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 13, 0, new Insets(15, 0, 0, 0), 0, 0));
        }
    }

    private abstract class ColorIconButtonActionListener
    implements ActionListener {
        Component parent = null;

        public ColorIconButtonActionListener(Component parent) {
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton button = (JButton)e.getSource();
            ColorIcon ci = (ColorIcon)button.getIcon();
            Color c = JColorChooser.showDialog(this.parent, MessagesBundle.getMessage("Choose_color"), ci.getColor());
            if (c != null) {
                ci.setColor(c);
                this.colorChanged(c);
            }
        }

        public abstract void colorChanged(Color var1);
    }
}

