/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.tools;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.EventObject;
import java.util.List;
import oracle.maps.core.GeoObject;
import oracle.maps.core.HoverableLayer;
import oracle.maps.core.Layer;
import oracle.maps.core.LayerManager;
import oracle.maps.core.MapCanvas;
import oracle.maps.core.SelectableLayer;
import oracle.maps.layer.ui.ManipulatorLayer;
import oracle.maps.layer.ui.ShapeDrawingLayer;
import oracle.maps.tools.BasicTool;
import oracle.maps.tools.RectangleDrawer;
import oracle.spatial.edit.layer.AnnotationTextSetLayer;
import oracle.spatial.edit.model.annotationtext.AnnotationTextFeature;

public class FeaturePickTool
extends BasicTool
implements ShapeDrawingLayer {
    private boolean hoverAlwaysOn = true;
    private RectangleDrawer rectDrawer = null;
    private Rectangle2D selectBox = null;

    public FeaturePickTool(MapCanvas canvas) {
        super(canvas);
        this.properties.setDefaultProperty("oracle.maps.core.Layer.name", "Feature selection");
    }

    @Override
    public long render(Graphics2D g) {
        long t1 = System.currentTimeMillis();
        if (this.selectBox != null) {
            g.setColor(Color.BLUE);
            g.setComposite(AlphaComposite.getInstance(3, 0.25f));
            g.fill(this.selectBox);
            g.setComposite(AlphaComposite.getInstance(3, 0.4f));
            g.draw(this.selectBox);
        }
        return System.currentTimeMillis() - t1;
    }

    public void setMultiSelection(boolean multiSelection) {
        this.rectDrawer = multiSelection ? new RectangleDrawer(this) : null;
    }

    public boolean isMultiSelection() {
        return this.rectDrawer != null;
    }

    private void mouseMoved(MouseEvent e, LayerManager selectionLayers) {
        Object hoverShape = null;
        for (Layer l : selectionLayers) {
            SelectableLayer selectionLayer;
            List<GeoObject> selected;
            if (!(l instanceof SelectableLayer) || !(l instanceof HoverableLayer) || (selected = (selectionLayer = (SelectableLayer)l).getSelection()).size() > 0 && !this.hoverAlwaysOn) continue;
            int granularity = 0;
            if (selectionLayer instanceof AnnotationTextSetLayer) {
                granularity = AnnotationTextFeature.LVL_COMPONENT;
            }
            List<GeoObject> hits = selectionLayer.hitTest(e.getX(), e.getY(), granularity);
            ((HoverableLayer)l).setHover(hits);
        }
    }

    private void mouseClicked(MouseEvent e, Rectangle2D rect, LayerManager selectionLayers) {
        for (Layer l : selectionLayers) {
            if (!(l instanceof SelectableLayer)) continue;
            SelectableLayer selectionLayer = (SelectableLayer)l;
            int granularity = 0;
            if (selectionLayer instanceof AnnotationTextSetLayer) {
                granularity = AnnotationTextFeature.LVL_COMPONENT;
            }
            List<GeoObject> hits = null;
            hits = rect == null ? selectionLayer.hitTest(e.getX(), e.getY(), granularity) : selectionLayer.hitTest(rect, granularity);
            if (e.isShiftDown()) {
                selectionLayer.select(hits);
            } else {
                selectionLayer.setSelection(hits);
            }
            if (!(l instanceof HoverableLayer)) continue;
            ((HoverableLayer)l).clearHover();
        }
    }

    @Override
    public boolean handleEvent(EventObject evt) {
        boolean propagate = true;
        LayerManager selectionLayers = this.canvas.getLayerManager().filterSetByTags(new String[]{"selectionLayer"});
        if (selectionLayers.isEmpty()) {
            return propagate;
        }
        if (this.canvas != null && evt instanceof MouseEvent) {
            MouseEvent e = (MouseEvent)evt;
            int id = e.getID();
            switch (id) {
                case 503: {
                    this.mouseMoved(e, selectionLayers);
                    break;
                }
                case 500: {
                    if (e.getButton() != 1) break;
                    this.mouseClicked(e, null, selectionLayers);
                    propagate = false;
                    break;
                }
                case 501: 
                case 506: {
                    if (this.rectDrawer == null || (e.getModifiersEx() & 0x400) != 1024) break;
                    this.rectDrawer.handleEvent(e);
                    propagate = false;
                    break;
                }
                case 502: {
                    if (this.rectDrawer == null || this.selectBox == null || e.getButton() != 1) break;
                    this.rectDrawer.handleEvent(e);
                    propagate = false;
                }
            }
        }
        return propagate;
    }

    public boolean isHoverAlwaysOn() {
        return this.hoverAlwaysOn;
    }

    public void setHoverAlwaysOn(boolean hoverAlwaysOn) {
        this.hoverAlwaysOn = hoverAlwaysOn;
    }

    @Override
    public void setShape(Shape shape) {
        this.selectBox = (Rectangle2D)shape;
    }

    @Override
    public void shapeCompleted(MouseEvent e) {
        if (this.selectBox == null) {
            return;
        }
        LayerManager selectionLayers = this.canvas.getLayerManager().filterSetByTags(new String[]{"selectionLayer"});
        this.mouseClicked(e, this.selectBox, selectionLayers);
        this.selectBox = null;
    }

    @Override
    public Point2D getSnapPoint(Point2D point) {
        return point;
    }

    @Override
    public void added(Object source) {
        Layer manipulator;
        super.added(source);
        if (source instanceof MapCanvas && (manipulator = this.canvas.getLayerManager().getLayerByTag("manipulatorLayer")) instanceof ManipulatorLayer) {
            manipulator.setVisible(true);
        }
    }

    @Override
    public void removed(Object source) {
        Layer manipulator;
        if (source instanceof MapCanvas && (manipulator = this.canvas.getLayerManager().getLayerByTag("manipulatorLayer")) instanceof ManipulatorLayer) {
            manipulator.setVisible(false);
        }
    }
}

