/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.producer;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import oracle.lbs.mapclient.MapViewer;
import oracle.lbs.mapclient.ThemeDescriptor;
import oracle.maps.core.DataProducer;
import oracle.maps.core.GeoDataProducer;
import oracle.maps.core.GeoObject;
import oracle.maps.core.Layer;
import oracle.maps.core.MVThemeLayer;
import oracle.maps.core.MapCanvas;
import oracle.maps.core.MapRegion;
import oracle.maps.geoobject.ImageObject;
import oracle.maps.layer.MVImageLayer;
import oracle.maps.layer.ui.ProgressIndicatorLayer;
import oracle.maps.util.StyleModelUtils;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.spatial.edit.layer.AbstractDataSetLayer;

public class MVImageProducer
implements GeoDataProducer {
    private static final Logger log = LogFactory.getLogger((LogFactory.LoggerEnum)LogFactory.LoggerEnum.MAPEDITOR);
    private String mapviewerURL = null;
    private String mapviewerDSRC = null;
    private Layer layer = null;
    private ArrayList<MVThemeLayer> layers = new ArrayList();
    private GeoObject[] cachedData = null;
    private Rectangle2D mbr = null;
    protected SwingWorker worker = null;
    protected boolean ignoreException = false;

    public MVImageProducer(Layer layer, String mapviewerURL, String mapviewerDSRC) {
        this.layer = layer;
        this.mapviewerURL = mapviewerURL;
        this.mapviewerDSRC = mapviewerDSRC;
        this.initMapViewerObject();
    }

    private MapViewer initMapViewerObject() {
        if (this.mapviewerURL == null || this.mapviewerDSRC == null) {
            return null;
        }
        MapViewer mapViewer = new MapViewer(this.mapviewerURL);
        mapViewer.setDataSourceName(this.mapviewerDSRC);
        mapViewer.setImageFormat(9);
        mapViewer.setDeviceSize(new Dimension(500, 500));
        mapViewer.setBackgroundTransparent(true);
        return mapViewer;
    }

    @Override
    public GeoObject[] getData() {
        return this.cachedData;
    }

    @Override
    public void clear() {
        this.cachedData = null;
        this.mbr = null;
    }

    @Override
    public void setTargetSRID(int srid) {
    }

    @Override
    public int getTargetSRID() {
        return this.layer.getSRID();
    }

    private void clear(MapViewer mapViewer) {
        if (mapViewer == null) {
            return;
        }
        try {
            mapViewer.deleteAllThemes();
            mapViewer.removeAllDynamicStyles();
            mapViewer.setBaseMapName(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Rectangle2D getDataMBR() {
        return this.mbr;
    }

    @Override
    public void loadData(Rectangle2D queryWin, int qwSrid) {
        if (this.layers.size() == 0) {
            this.cachedData = null;
            this.mbr = null;
            return;
        }
        this.worker = new ImageGetterThread(queryWin, qwSrid, this);
        this.worker.addPropertyChangeListener(this.layer.getCanvas());
        this.worker.execute();
    }

    @Override
    public void loadData(Area queryArea, int qwSrid) {
        this.loadData(queryArea.getBounds2D(), qwSrid);
    }

    @Override
    public void abortLoad() {
        if (this.worker != null && !this.worker.isDone()) {
            this.worker.cancel(true);
        }
    }

    private void buildRequest(MapViewer mapViewer) {
        ArrayList<String> topologies = new ArrayList<String>();
        long themeRequestTimeout = 10000L;
        this.clear(mapViewer);
        if (this.layers.size() > 0) {
            block8: for (MVThemeLayer themeLayer : this.layers) {
                ThemeDescriptor td = themeLayer.getThemeDescriptor();
                if (!td.enabled) continue;
                int type = td.type;
                String query = "";
                StyleModel renderStyle = null;
                switch (type) {
                    case 2: {
                        query = "select " + td.spatialColumn;
                        if (td.labelColumn != null) {
                            query = query + "," + td.labelColumn;
                        }
                        query = query + " from " + td.featureTableName;
                        if (td.WFS_queryCondition != null) {
                            query = query + " where " + td.WFS_queryCondition;
                        }
                        mapViewer.addJDBCTheme(this.mapviewerDSRC, td.name, query, td.spatialColumn, String.valueOf(td.SRID), td.renderStyleName, td.labelColumn, td.labelStyleName, false);
                        renderStyle = StyleModelUtils.getStyleModel(td.renderStyleName);
                        if (renderStyle == null) {
                            renderStyle = StyleModelUtils.getDefaultRenderStyle();
                        }
                        mapViewer.addStyle(renderStyle.getName(), renderStyle);
                        if (td.labelColumn == null) break;
                        StyleModel labelStyle = StyleModelUtils.getStyleModel(td.labelStyleName);
                        if (labelStyle == null) {
                            labelStyle = StyleModelUtils.getDefaultLabelStyle();
                        }
                        mapViewer.addStyle(labelStyle.getName(), labelStyle);
                        break;
                    }
                    case 7: {
                        StyleModel labelStyle;
                        renderStyle = StyleModelUtils.getStyleModel(td.renderStyleName);
                        if (renderStyle == null) {
                            renderStyle = StyleModelUtils.getDefaultRenderStyle();
                        }
                        mapViewer.addStyle(renderStyle.getName(), renderStyle);
                        if (td.labelColumn != null) {
                            labelStyle = StyleModelUtils.getStyleModel(td.labelStyleName);
                            if (labelStyle == null) {
                                labelStyle = StyleModelUtils.getDefaultLabelStyle();
                            }
                            mapViewer.addStyle(labelStyle.getName(), labelStyle);
                        }
                        if (td.isDebugTheme) {
                            String labelStyleName = null;
                            if (td.labelColumn != null) {
                                labelStyleName = td.labelStyleName;
                            }
                            mapViewer.addTopologyDebugTheme(this.mapviewerDSRC, td.name + "_TP", td.topologyName, String.valueOf(td.SRID), null, null, 8, null, null, null, td.renderStyleName, labelStyleName, false);
                            break;
                        }
                        query = "select " + td.spatialColumn;
                        if (td.labelColumn != null) {
                            query = query + "," + td.labelColumn;
                        }
                        query = query + " from " + td.featureTableName;
                        if (td.WFS_queryCondition != null) {
                            query = query + " where " + td.WFS_queryCondition;
                        }
                        mapViewer.addTopologyTheme(this.mapviewerDSRC, td.name, query, td.topologyName, td.featureTableName, td.spatialColumn, String.valueOf(td.SRID), td.renderStyleName, td.labelColumn, td.labelStyleName, false);
                        if (td.nodeStyle == null && td.linkStyle == null && td.faceStyle == null || topologies.contains(td.topologyName.toUpperCase())) break;
                        topologies.add(td.topologyName.toUpperCase());
                        mapViewer.addTopologyDebugTheme(this.mapviewerDSRC, td.name + "_TP", td.topologyName, String.valueOf(td.SRID), td.linkStyle, null, 8, td.edgeLabelStyle, td.nodeStyle, td.nodeLabelStyle, td.faceStyle, td.faceLabelStyle, false);
                        if (td.nodeStyle != null) {
                            StyleModel nodeStyle = StyleModelUtils.getStyleModel(td.nodeStyle);
                            if (nodeStyle == null) {
                                nodeStyle = StyleModelUtils.getDefaultMarkerStyle();
                            }
                            mapViewer.addStyle(nodeStyle.getName(), nodeStyle);
                            if (td.nodeLabelStyle != null) {
                                StyleModel nodeLabelStyle = StyleModelUtils.getStyleModel(td.nodeLabelStyle);
                                if (nodeLabelStyle == null) {
                                    nodeLabelStyle = StyleModelUtils.getDefaultLabelStyle();
                                }
                                mapViewer.addStyle(nodeLabelStyle.getName(), nodeLabelStyle);
                            }
                        }
                        if (td.linkStyle != null) {
                            StyleModel edgeStyle = StyleModelUtils.getStyleModel(td.linkStyle);
                            if (edgeStyle == null) {
                                edgeStyle = StyleModelUtils.getDefaultLineStyle();
                            }
                            mapViewer.addStyle(edgeStyle.getName(), edgeStyle);
                            if (td.edgeLabelStyle != null) {
                                StyleModel edgeLabelStyle = StyleModelUtils.getStyleModel(td.edgeLabelStyle);
                                if (edgeLabelStyle == null) {
                                    edgeLabelStyle = StyleModelUtils.getDefaultLabelStyle();
                                }
                                mapViewer.addStyle(edgeLabelStyle.getName(), edgeLabelStyle);
                            }
                        }
                        if (td.faceStyle == null) break;
                        StyleModel faceStyle = StyleModelUtils.getStyleModel(td.faceStyle);
                        if (faceStyle == null) {
                            faceStyle = StyleModelUtils.getDefaultRenderStyle();
                        }
                        mapViewer.addStyle(faceStyle.getName(), faceStyle);
                        if (td.faceLabelStyle == null) break;
                        StyleModel faceLabelStyle = StyleModelUtils.getStyleModel(td.faceLabelStyle);
                        if (faceLabelStyle == null) {
                            faceLabelStyle = StyleModelUtils.getDefaultLabelStyle();
                        }
                        mapViewer.addStyle(faceLabelStyle.getName(), faceLabelStyle);
                        break;
                    }
                    case 12: {
                        query = "select " + td.spatialColumn;
                        if (td.labelColumn != null) {
                            query = query + "," + td.labelColumn;
                        }
                        query = query + " from " + td.featureTableName;
                        if (td.WFS_queryCondition != null) {
                            query = query + " where " + td.WFS_queryCondition;
                        }
                        mapViewer.addAnnotationTextTheme(this.mapviewerDSRC, td.name, query, td.featureTableName, td.spatialColumn, String.valueOf(td.SRID), td.renderStyleName, false);
                        if (td.labelColumn != null) {
                            mapViewer.setAnnoTextThemeExpressionColumn(td.name, td.labelColumn);
                        }
                        if (td.renderStyleName == null) break;
                        renderStyle = StyleModelUtils.getStyleModel(td.renderStyleName);
                        if (renderStyle == null) {
                            renderStyle = StyleModelUtils.getDefaultRenderStyle();
                        }
                        mapViewer.addStyle(renderStyle.getName(), renderStyle);
                        break;
                    }
                    case 9: {
                        mapViewer.addMapTileTheme(td.name, this.mapviewerDSRC, td.cacheMapSource, true);
                        mapViewer.setSnapToCachedZoomLevel(true);
                        break;
                    }
                    case 1: {
                        mapViewer.addPredefinedTheme(td.name);
                        break;
                    }
                    case 0: {
                        mapViewer.setBaseMapName(td.name);
                        break;
                    }
                    default: {
                        continue block8;
                    }
                }
                mapViewer.setThemeRequestTimeout(td.name, themeRequestTimeout);
                mapViewer.setThemeWorkspace(td.name, td.workspaceName);
            }
        }
    }

    @Override
    public Layer getLayer() {
        return this.layer;
    }

    @Override
    public void setLayer(Layer layer) {
        this.layer = (MVImageLayer)layer;
    }

    public void addMVThemeLayer(MVThemeLayer layer) {
        this.layers.add(layer);
    }

    public void removeMVThemeLayer(MVThemeLayer layer) {
        this.layers.remove(layer);
    }

    public void clearMVThemeLayers() {
        this.layers.clear();
    }

    static /* synthetic */ GeoObject[] access$402(MVImageProducer x0, GeoObject[] x1) {
        x0.cachedData = x1;
        return x1;
    }

    private class ImageGetterThread
    extends SwingWorker<Void, Image> {
        private DataProducer parent;
        MapViewer mapViewer = null;

        public ImageGetterThread(Rectangle2D queryWindow, int qwSrid, DataProducer parent) {
            this.parent = parent;
            this.mapViewer = MVImageProducer.this.initMapViewerObject();
            if (this.mapViewer == null) {
                return;
            }
            MapCanvas canvas = MVImageProducer.this.layer.getCanvas();
            int w = canvas.getWidth();
            int h = canvas.getHeight();
            this.mapViewer.setDeviceSize(new Dimension(w, h));
            this.mapViewer.setMapRequestSRID(MVImageProducer.this.layer.getSRID());
            MVImageProducer.this.buildRequest(this.mapViewer);
            if (queryWindow == null) {
                this.mapViewer.setFullExtent();
            } else {
                this.mapViewer.setBox(queryWindow.getMinX(), queryWindow.getMinY(), queryWindow.getMaxX(), queryWindow.getMaxY(), qwSrid, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected Void doInBackground() {
            try {
                if (this.isCancelled()) {
                    MVImageProducer.this.clear();
                    Void void_ = null;
                    return void_;
                }
                this.getPropertyChangeSupport().firePropertyChange("progressString", null, MessagesBundle.getMessage("Progressbar_loadingmvimage"));
                this.getPropertyChangeSupport().firePropertyChange("progressIndeterminate", null, (Object)true);
                log.info("Image Data loading: started...");
                ProgressIndicatorLayer prog = MVImageProducer.this.layer.getCanvas().getProgressIndicator();
                if (prog != null) {
                    prog.taskStarted();
                }
                long t1 = System.currentTimeMillis();
                String req = this.mapViewer.getMapRequestString();
                log.finest("MapViewer request:\n" + req);
                this.mapViewer.run();
                long t2 = System.currentTimeMillis();
                log.info("Image Data loading: finished after " + (t2 - t1) + " ms.");
                Image img = this.mapViewer.getGeneratedMapImage();
                if (img != null) {
                    ImageObject imgObj = new ImageObject("image", img);
                    MVImageProducer.access$402(MVImageProducer.this, new GeoObject[1]);
                    ((MVImageProducer)MVImageProducer.this).cachedData[0] = imgObj;
                    double[] imgmbr = this.mapViewer.getMapMBR();
                    if (imgmbr != null) {
                        MVImageProducer.this.mbr = new Rectangle2D.Double(imgmbr[0], imgmbr[1], imgmbr[2] - imgmbr[0], imgmbr[3] - imgmbr[1]);
                        MapRegion region = MVImageProducer.this.layer.getCanvas().getMapRegion();
                        Rectangle2D cw = region.getDataWindow();
                        if (cw != null) {
                            double tol = Math.min(cw.getHeight(), cw.getWidth()) * 0.01;
                            double gap1 = Math.abs(MVImageProducer.this.mbr.getWidth() - cw.getWidth());
                            double gap2 = Math.abs(MVImageProducer.this.mbr.getHeight() - cw.getHeight());
                            double gap3 = Math.abs(MVImageProducer.this.mbr.getMinX() - cw.getMinX());
                            double gap4 = Math.abs(MVImageProducer.this.mbr.getMinY() - cw.getMinY());
                            if (!(gap1 > tol || gap2 > tol || gap3 > tol || gap4 > tol)) {
                                // empty if block
                            }
                        }
                    } else {
                        MVImageProducer.this.mbr = null;
                    }
                } else {
                    MVImageProducer.access$402(MVImageProducer.this, null);
                    MVImageProducer.this.mbr = null;
                }
                if (this.isCancelled()) {
                    MVImageProducer.this.clear();
                    return null;
                }
                this.publish(img);
                return null;
            }
            catch (Exception ex) {
                if (MVImageProducer.this.ignoreException) return null;
                if (MVImageProducer.this.layer instanceof AbstractDataSetLayer) {
                    ((AbstractDataSetLayer)MVImageProducer.this.layer).onDataException(MVImageProducer.this, ex);
                    return null;
                }
                if (!(MVImageProducer.this.layer instanceof MVImageLayer)) return null;
                ((MVImageLayer)MVImageProducer.this.layer).onDataException(ex);
                return null;
            }
            finally {
                ProgressIndicatorLayer prog = MVImageProducer.this.layer.getCanvas().getProgressIndicator();
                if (prog != null) {
                    prog.taskCompleted();
                }
            }
        }

        @Override
        protected void process(List<Image> list) {
            if (MVImageProducer.this.layer instanceof AbstractDataSetLayer) {
                ((AbstractDataSetLayer)MVImageProducer.this.layer).onDataReady(MVImageProducer.this, null);
            } else if (MVImageProducer.this.layer instanceof MVImageLayer) {
                ((MVImageLayer)MVImageProducer.this.layer).onDataReady();
            }
        }
    }
}

