/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.layer.ui;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import oracle.maps.core.Drawable;
import oracle.maps.core.EditChangeListener;
import oracle.maps.core.EditableLayer;
import oracle.maps.core.GeoObject;
import oracle.maps.core.Layer;
import oracle.maps.core.LayerManagerEvent;
import oracle.maps.core.MapCanvas;
import oracle.maps.core.MapRegionEvent;
import oracle.maps.core.SelectableLayer;
import oracle.maps.core.SelectionEvent;
import oracle.maps.core.SelectionListener;
import oracle.maps.core.SnappableLayer;
import oracle.maps.geoobject.GeometryFeature;
import oracle.maps.graphics.AnimatedStroke;
import oracle.maps.layer.BasicLayer;
import oracle.maps.util.TransformUtils;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.session.layer.ConfigurableLayer;
import oracle.mdeditor.ui.ColorIcon;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.sdovis.edit.util.JGeometrySegmentPoint;
import oracle.sdovis.util.ShapeUtil;
import oracle.spatial.edit.index.geometry.IndexedGeometrySet;
import oracle.spatial.edit.layer.AbstractDataSetLayer;
import oracle.spatial.edit.layer.TopologyPrimitiveLayer;
import oracle.spatial.edit.util.JGeometrySegmentUtil;
import oracle.spatial.geometry.JGeometry;

public class ManipulatorLayer
extends BasicLayer
implements SelectionListener,
ChangeListener,
EditChangeListener,
ConfigurableLayer {
    public static final String PROPERTY_COLOR = "oracle.maps.layer.ui.ManipulatorLayer.color";
    public static final String PROPERTY_SNAP_POINT_COLOR = "oracle.maps.layer.ui.ManipulatorLayer.snapPointColor";
    public static final String PROPERTY_CHANGED_FEATURE_COLOR = "oracle.maps.layer.ui.ManipulatorLayer.changedFeatureColor";
    public static final String PROPERTY_HANDLE_SIZE = "oracle.maps.layer.ui.ManipulatorLayer.handleSize";
    public static final String PROPERTY_TRANSLATION_FACTOR = "oracle.maps.layer.ui.ManipulatorLayer.translationFactor";
    public static final String PROPERTY_SCALE_FACTOR = "oracle.maps.layer.ui.ManipulatorLayer.scaleFactor";
    public static final String PROPERTY_ROTATION_FACTOR = "oracle.maps.layer.ui.ManipulatorLayer.rotationFactor";
    public static final String PROPERTY_HIDE_WHEN_OBSTRUCTED = "oracle.maps.layer.ui.ManipulatorLayer.hideWhenObstructed";
    public static final String HANDLE_TRANSLATE = "translateHandle";
    public static final String HANDLE_ROTATE = "rotateHandle";
    public static final String HANDLE_SNAP = "snapHandle";
    public static final String HANDLE_RESIZE_NW = "nwHandle";
    public static final String HANDLE_RESIZE_N = "nHandle";
    public static final String HANDLE_RESIZE_NE = "neHandle";
    public static final String HANDLE_RESIZE_E = "eHandle";
    public static final String HANDLE_RESIZE_SE = "seHandle";
    public static final String HANDLE_RESIZE_S = "sHandle";
    public static final String HANDLE_RESIZE_SW = "swHandle";
    public static final String HANDLE_RESIZE_W = "wHandle";
    private EventListenerList listenerList = new EventListenerList();
    private int snapTolerance = 5;
    private int gap = 0;
    private AnimatedStroke animeStroke = new AnimatedStroke();
    private Stroke stroke = new BasicStroke(1.0f);
    private boolean isSinglePoint = false;
    private double[] orientation = null;
    private boolean enabled = false;
    private Rectangle2D shapeMBR;
    private Hashtable<String, Handle> allHandles = new Hashtable(11);
    private Hashtable<String, Handle> resizeHandles = new Hashtable(8);
    private Handle moveHandle;
    private Handle rotateHandle;
    private Handle snapHandle;
    private boolean snapped = false;
    private boolean anchorMoved = false;
    private List<GeoObject> selectedFeatures = new ArrayList<GeoObject>();
    private AffineTransform transitTransform = new AffineTransform();
    private AffineTransform finalTransform = new AffineTransform();
    private Handle opMode = null;
    private Handle lastOpMode = null;
    private Handle placingHandle = null;
    private boolean shiftPressed = false;
    private boolean supressSC = false;
    private ManipulatorFirstChange firstEditChange = null;

    public ManipulatorLayer(MapCanvas canvas) {
        super(canvas);
        this.properties.setDefaultProperty("oracle.maps.core.Layer.name", "Manipulator Layer");
        this.properties.setDefaultProperty(PROPERTY_COLOR, StyleUtils.getHexidecimalString((Color)new Color(255, 0, 128)));
        this.properties.setDefaultProperty(PROPERTY_SNAP_POINT_COLOR, StyleUtils.getHexidecimalString((Color)Color.BLUE));
        this.properties.setDefaultProperty(PROPERTY_CHANGED_FEATURE_COLOR, StyleUtils.getHexidecimalString((Color)Color.MAGENTA));
        this.properties.setDefaultProperty(PROPERTY_HANDLE_SIZE, Integer.toString(8));
        this.properties.setDefaultProperty(PROPERTY_TRANSLATION_FACTOR, Double.toString(1.0));
        this.properties.setDefaultProperty(PROPERTY_SCALE_FACTOR, Double.toString(0.01));
        this.properties.setDefaultProperty(PROPERTY_ROTATION_FACTOR, Double.toString(0.1));
        this.properties.setDefaultProperty(PROPERTY_HIDE_WHEN_OBSTRUCTED, Boolean.toString(false));
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if (name.equals(ManipulatorLayer.PROPERTY_HIDE_WHEN_OBSTRUCTED)) {
                    ManipulatorLayer.this.checkBoundary();
                } else if (name.equals(ManipulatorLayer.PROPERTY_HANDLE_SIZE)) {
                    ManipulatorLayer.this.setupDragHandles();
                }
            }
        });
    }

    @Override
    public void added(Object src) {
        super.added(src);
        if (src instanceof MapCanvas) {
            ((MapCanvas)src).getLayerManager().addSelectionListener(this);
            ((MapCanvas)src).getLayerManager().addEditChangeListener(this);
        }
    }

    @Override
    public void removed(Object src) {
        super.removed(src);
        if (src instanceof MapCanvas) {
            ((MapCanvas)src).getLayerManager().removeSelectionListener(this);
            ((MapCanvas)src).getLayerManager().removeEditChangeListener(this);
        }
    }

    @Override
    public boolean handleEvent(EventObject evt) {
        if (!this.isEnabled() || !this.isVisible()) {
            return true;
        }
        boolean propagateEvent = true;
        if (evt instanceof MouseEvent && !(evt instanceof MouseWheelEvent)) {
            int id;
            MouseEvent e = (MouseEvent)evt;
            Handle handle = null;
            GeoObject[] hits = this.hitTest(e.getX(), e.getY());
            if (hits.length > 0) {
                handle = (Handle)hits[0];
            }
            boolean snapClicked = false;
            boolean anchorClicked = false;
            Handle rzHandle = null;
            for (GeoObject h : hits) {
                if (h == this.snapHandle) {
                    snapClicked = true;
                    continue;
                }
                if (h == this.moveHandle) {
                    anchorClicked = true;
                    continue;
                }
                if (rzHandle == null || !this.resizeHandles.containsKey(h.getKey().toString())) continue;
                rzHandle = (Handle)h;
            }
            JPopupMenu popup = this.canvas.getPopupMenu();
            if (popup != null) {
                if (popup.getComponentCount() > 0) {
                    popup.addSeparator();
                }
                XYListener al = new XYListener(e, null);
                JMenuItem mi = new JMenuItem("Place anchor point");
                mi.addActionListener(new XYListener(e, snapClicked ? this.snapHandle : handle));
                mi.setActionCommand("placeAnchor");
                popup.add(mi);
                mi = new JMenuItem("Reset anchor point");
                mi.addActionListener(al);
                mi.setActionCommand("resetAnchor");
                mi.setEnabled(this.anchorMoved);
                popup.add(mi);
                mi = new JMenuItem("Place snap point");
                mi.addActionListener(new XYListener(e, anchorClicked ? this.moveHandle : handle));
                mi.setActionCommand("placeSnapPoint");
                popup.add(mi);
                mi = new JMenuItem("Remove snap point");
                mi.addActionListener(al);
                mi.setActionCommand("removeSnapPoint");
                mi.setEnabled(this.snapHandle != null);
                popup.add(mi);
                mi = new JMenuItem("Commit changes");
                mi.addActionListener(al);
                mi.setActionCommand("commitChanges");
                mi.setIcon(Icons.getIcon("resizegraph_ena.png"));
                mi.setEnabled(!this.isReallyIdentity(this.finalTransform));
                popup.add(mi);
                mi = new JMenuItem("Discard changes");
                mi.addActionListener(al);
                mi.setActionCommand("discardChanges");
                mi.setIcon(Icons.getIcon("ora_trashempty.png"));
                mi.setEnabled(!this.isReallyIdentity(this.finalTransform));
                popup.add(mi);
            }
            if (this.placingHandle != null) {
                id = e.getID();
                Point2D.Double c = new Point2D.Double(e.getX(), e.getY());
                double wcTolerance = 0.0;
                try {
                    AffineTransform inv = this.getVisualTransform().createInverse();
                    wcTolerance = TransformUtils.transformMagnitude(this.snapTolerance, inv);
                    inv.transform(c, c);
                }
                catch (NoninvertibleTransformException ex) {
                    ex.printStackTrace();
                }
                this.snapped = false;
                for (GeoObject feat : this.selectedFeatures) {
                    JGeometrySegmentPoint segPt = null;
                    try {
                        if (feat.getLayer() instanceof AbstractDataSetLayer) {
                            AbstractDataSetLayer dl = (AbstractDataSetLayer)feat.getLayer();
                            segPt = ((IndexedGeometrySet)dl.getIndexedDataSet()).getSegmentPoint(feat.getKey().toString(), c, wcTolerance, true, true, true, true);
                        } else if (feat.getLayer() instanceof TopologyPrimitiveLayer) {
                            JGeometry geom = ((GeometryFeature)feat).getSpatialAttribute();
                            segPt = JGeometrySegmentUtil.getSegmentPoint(geom, c, wcTolerance, true, true, true, true, null, feat.getKey().toString());
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (segPt == null) continue;
                    this.snapped = true;
                    c.setLocation(segPt.getPoint());
                    break;
                }
                switch (id) {
                    case 500: {
                        if (e.getButton() != 1) break;
                        this.getVisualTransform().transform(c, c);
                        if (this.placingHandle == this.snapHandle) {
                            this.placeSnapHandle(c, null);
                        } else {
                            this.placeAnchor(c, null);
                        }
                        this.placingHandle = null;
                        this.snapped = false;
                        propagateEvent = false;
                        break;
                    }
                    case 503: 
                    case 506: {
                        if (this.placingHandle == null) break;
                        this.placingHandle.setCenter(c);
                    }
                }
            } else if (this.opMode != null || handle != null) {
                Handle cursorHandle;
                id = e.getID();
                switch (id) {
                    case 501: {
                        if (e.getButton() != 1) break;
                        Handle handle2 = this.opMode = rzHandle != null ? rzHandle : handle;
                        if (this.opMode == this.snapHandle) {
                            this.opMode = null;
                        } else {
                            this.lastOpMode = this.opMode;
                        }
                        propagateEvent = false;
                        break;
                    }
                    case 506: {
                        this.mouseDragged(e);
                        propagateEvent = false;
                        break;
                    }
                    case 502: {
                        if (e.getButton() != 1) break;
                        this.applyTransitChanges(null, true);
                        this.opMode = null;
                        propagateEvent = false;
                    }
                }
                Handle handle3 = cursorHandle = handle != null ? handle : this.opMode;
                if (cursorHandle != null) {
                    if (cursorHandle.getCursor() != null) {
                        this.canvas.setCursor(cursorHandle.getCursor());
                        propagateEvent = false;
                    } else {
                        ImageIcon icon = Icons.getIcon("resize_h.png");
                        Point2D center = cursorHandle.getCenter(this.getVisualTransform());
                        Point2D anchor = cursorHandle.getAnchor(this.getVisualTransform());
                        double angle = Math.atan2(center.getY() - anchor.getY(), center.getX() - anchor.getX());
                        AffineTransform at = new AffineTransform();
                        at.rotate(angle, (double)icon.getIconWidth() / 2.0, (double)icon.getIconHeight() / 2.0);
                        BufferedImage bi = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
                        Graphics2D bg = bi.createGraphics();
                        bg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        bg.drawImage(icon.getImage(), at, null);
                        this.canvas.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(bi, new Point(15, 15), "Cursor"));
                        propagateEvent = false;
                    }
                }
            }
        }
        if (evt instanceof KeyEvent && this.shapeMBR != null) {
            this.handleKeyEvent(evt);
            propagateEvent = false;
        }
        return propagateEvent;
    }

    private void handleKeyEvent(EventObject evt) {
        KeyEvent e = (KeyEvent)evt;
        int id = e.getID();
        switch (id) {
            case 401: {
                if (e.getKeyCode() == 27) {
                    this.clear();
                    break;
                }
                if (e.getKeyCode() == 10) {
                    this.commitChanges();
                    break;
                }
                if (e.getKeyCode() == 16) {
                    if (this.shiftPressed) break;
                    this.shiftPressed = true;
                    this.applyTransitChanges(null, true);
                    break;
                }
                int x = 0;
                int y = 0;
                if (e.getKeyCode() == 38) {
                    y = 1;
                } else if (e.getKeyCode() == 40) {
                    y = -1;
                } else if (e.getKeyCode() == 37) {
                    x = -1;
                } else if (e.getKeyCode() == 39) {
                    x = 1;
                }
                if (this.lastOpMode == null) {
                    this.lastOpMode = this.moveHandle;
                }
                if (this.lastOpMode == null) {
                    return;
                }
                this.snapped = false;
                this.opMode = this.lastOpMode;
                if (this.lastOpMode == this.moveHandle) {
                    double tx = this.getTranslationFactor() * (double)x;
                    double ty = this.getTranslationFactor() * (double)y;
                    this.translate(tx, ty, false);
                    break;
                }
                if (this.lastOpMode == this.rotateHandle) {
                    double theta = -1.0 * this.getRotationFactor() * (double)x * (Math.PI / 180);
                    this.rotate(theta, false);
                    break;
                }
                Point2D newAnchor = this.anchorMoved ? this.moveHandle.getAnchor() : this.lastOpMode.getAnchor(this.finalTransform);
                double sx = 1.0 + this.getScaleFactor() * (double)x;
                double sy = 1.0 + this.getScaleFactor() * (double)y;
                this.scale(sx, sy, newAnchor.getX(), newAnchor.getY(), false);
                break;
            }
            case 402: {
                if (e.getKeyCode() != 38 && e.getKeyCode() != 40 && e.getKeyCode() != 37 && e.getKeyCode() != 39 && e.getKeyCode() != 16) break;
                this.applyTransitChanges(null, true);
                if (e.getKeyCode() == 16) {
                    if (!this.shiftPressed) break;
                    this.shiftPressed = false;
                    break;
                }
                this.opMode = null;
            }
        }
    }

    private Point2D getSnapPoint() {
        if (this.snapHandle == null) {
            return null;
        }
        double wcTolerance = 0.0;
        try {
            wcTolerance = TransformUtils.transformMagnitude(this.snapTolerance, this.canvas.getViewportTransform().createInverse());
        }
        catch (NoninvertibleTransformException ex) {
            ex.printStackTrace();
        }
        Iterator<Layer> snapIterator = this.canvas.getLayerManager().filterSetByTags(new String[]{"snapLayer"}).layerIterator();
        Point2D p = null;
        while (snapIterator.hasNext()) {
            SnappableLayer snapLayer = (SnappableLayer)snapIterator.next();
            p = snapLayer.snapTo(this.snapHandle.getAnchor(this.getEditTransform()), wcTolerance, 0);
            if (p == null) continue;
            this.snapped = true;
            break;
        }
        return p;
    }

    private void mouseDragged(MouseEvent e) {
        if (this.opMode == null) {
            return;
        }
        this.transitTransform.setToIdentity();
        Point2D anchor = this.opMode.getAnchor(this.finalTransform);
        Point2D center = this.opMode.getCenter(this.finalTransform);
        Point2D.Double mouse = new Point2D.Double(e.getX(), e.getY());
        try {
            this.canvas.getViewportTransform().inverseTransform(mouse, mouse);
        }
        catch (NoninvertibleTransformException ex) {
            ex.printStackTrace();
        }
        this.snapped = false;
        if (this.opMode == this.moveHandle) {
            double tx = ((Point2D)mouse).getX() - anchor.getX();
            double ty = ((Point2D)mouse).getY() - anchor.getY();
            if (e.isShiftDown()) {
                double angle = Math.atan2(ty, tx);
                if (Math.abs(angle) > 0.7853981633974483 && Math.abs(angle) < 2.356194490192345) {
                    tx = 0.0;
                } else {
                    ty = 0.0;
                }
            }
            this.translate(tx, ty, false);
            Point2D snapPoint = this.getSnapPoint();
            if (snapPoint != null) {
                Point2D snapAnchor = this.snapHandle.getAnchor(this.getEditTransform());
                this.translate(snapPoint.getX() - snapAnchor.getX(), snapPoint.getY() - snapAnchor.getY(), false);
            }
        } else if (this.opMode == this.rotateHandle) {
            double ax = center.getX() - anchor.getX();
            double ay = center.getY() - anchor.getY();
            double bx = ((Point2D)mouse).getX() - anchor.getX();
            double by = ((Point2D)mouse).getY() - anchor.getY();
            double theta = Math.atan2(by, bx) - Math.atan2(ay, ax);
            this.rotate(theta, false);
            Point2D snapPoint = this.getSnapPoint();
            if (snapPoint != null) {
                Point2D sa = this.snapHandle.getAnchor(this.getEditTransform());
                double sax = sa.getX() - anchor.getX();
                double say = sa.getY() - anchor.getY();
                double sbx = snapPoint.getX() - anchor.getX();
                double sby = snapPoint.getY() - anchor.getY();
                double stheta = Math.atan2(sby, sbx) - Math.atan2(say, sax);
                this.rotate(stheta, false);
            }
        } else if (this.opMode == this.snapHandle) {
            this.placeSnapHandle(new Point2D.Double(e.getX(), e.getY()), null);
        } else {
            double sx = 1.0;
            double sy = 1.0;
            Point2D myAnchor = this.anchorMoved ? this.moveHandle.getAnchor(this.finalTransform) : anchor;
            Point2D.Double newMouse = new Point2D.Double(((Point2D)mouse).getX(), ((Point2D)mouse).getY());
            if (!this.opMode.isCorner() || e.isShiftDown()) {
                double f = ShapeUtil.projection((double)((Point2D)mouse).getX(), (double)((Point2D)mouse).getY(), (double)anchor.getX(), (double)anchor.getY(), (double)center.getX(), (double)center.getY(), (Point2D)newMouse);
            }
            AffineTransform tAT = new AffineTransform();
            tAT.setToRotation(-this.getAngle(this.getEditTransform()), myAnchor.getX(), myAnchor.getY());
            tAT.transform(center, center);
            tAT.transform(newMouse, newMouse);
            sx = (((Point2D)newMouse).getX() - myAnchor.getX()) / (center.getX() - myAnchor.getX());
            sy = (((Point2D)newMouse).getY() - myAnchor.getY()) / (center.getY() - myAnchor.getY());
            if (((String)this.opMode.getKey()).equals(HANDLE_RESIZE_N) || ((String)this.opMode.getKey()).equals(HANDLE_RESIZE_S)) {
                sx = e.isShiftDown() ? sy : 1.0;
            } else if (((String)this.opMode.getKey()).equals(HANDLE_RESIZE_W) || ((String)this.opMode.getKey()).equals(HANDLE_RESIZE_E)) {
                sy = e.isShiftDown() ? sx : 1.0;
            }
            this.scale(sx, sy, myAnchor.getX(), myAnchor.getY(), false);
            Point2D snapPoint = null;
            snapPoint = this.getSnapPoint();
            if (snapPoint != null) {
                Point2D sa = this.snapHandle.getAnchor(this.getEditTransform());
                tAT.transform(snapPoint, snapPoint);
                tAT.transform(sa, sa);
                double ssx = (snapPoint.getX() - myAnchor.getX()) / (sa.getX() - myAnchor.getX());
                double ssy = (snapPoint.getY() - myAnchor.getY()) / (sa.getY() - myAnchor.getY());
                if (ssx > 0.0 && ssx <= 2.0 && ssy > 0.0 && ssy <= 2.0) {
                    this.scale(ssx, ssy, myAnchor.getX(), myAnchor.getY(), false);
                } else {
                    this.snapped = false;
                }
            }
        }
    }

    @Override
    public void clear() {
        if (this.firstEditChange != null) {
            this.canvas.getUndoManager().trimEdits((UndoableEdit)this.firstEditChange, this.firstEditChange.getLastChange());
            this.firstEditChange = null;
        }
        this.selectedFeatures.clear();
        this.isSinglePoint = false;
        this.orientation = null;
        this.shapeMBR = null;
        this.allHandles.clear();
        this.resizeHandles.clear();
        this.moveHandle = null;
        this.rotateHandle = null;
        this.snapHandle = null;
        this.snapped = false;
        this.anchorMoved = false;
        this.transitTransform.setToIdentity();
        this.finalTransform.setToIdentity();
        this.opMode = null;
        this.lastOpMode = null;
        this.setEnabled(false);
    }

    @Override
    public void selectionChanged(SelectionEvent evt) {
        if (!this.supressSC) {
            this.updateHandles();
        }
    }

    @Override
    public void mapRegionChanged(MapRegionEvent e) {
        this.checkBoundary();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (e instanceof LayerManagerEvent) {
            LayerManagerEvent evt = (LayerManagerEvent)e;
            if (evt.getType() == 4 || evt.getType() == 3) {
                if (evt.getTags().contains("snapLayer")) {
                    this.snapped = false;
                }
            } else if (evt.getType() == 1 && evt.getLayer() instanceof SelectableLayer && ((SelectableLayer)evt.getLayer()).numSelected() > 0) {
                this.selectionChanged(null);
            }
        }
    }

    @Override
    public void editStateChanged(ChangeEvent e) {
        if (e.getSource() instanceof EditableLayer && !this.supressSC) {
            this.clear();
            this.selectionChanged(null);
        }
    }

    public void setToTransform(double sx, double sy, double tx, double ty, double theta) {
        try {
            AffineTransform at = new AffineTransform(this.transitTransform.createInverse());
            if (this.canvas.getViewportTransform().getScaleY() < 0.0 && theta != 0.0) {
                theta *= -1.0;
            }
            double cx = this.shapeMBR.getCenterX();
            double cy = this.shapeMBR.getCenterY();
            at.translate(tx + cx, ty + cy);
            at.rotate(theta);
            at.scale(sx, sy);
            at.translate(-cx, -cy);
            at.concatenate(this.finalTransform.createInverse());
            this.applyTransitChanges(at, true);
        }
        catch (NoninvertibleTransformException ex) {
            ex.printStackTrace();
        }
    }

    public void rotate(double angle) {
        this.rotate(angle, true);
    }

    public void rotate(double angle, double anchorX, double anchorY) {
        this.rotate(angle, anchorX, anchorY, true);
    }

    public void rotate(double angle, boolean applyImmediately) {
        if (this.rotateHandle == null || this.rotateHandle.getAnchor() == null) {
            return;
        }
        Point2D newAnchor = this.rotateHandle.getAnchor(this.getEditTransform());
        this.rotate(angle, newAnchor.getX(), newAnchor.getY(), applyImmediately);
    }

    public void rotate(double angle, double anchorX, double anchorY, boolean applyImmediately) {
        AffineTransform at = new AffineTransform();
        at.rotate(angle, anchorX, anchorY);
        this.applyTransitChanges(at, applyImmediately);
    }

    public void scale(double sx, double sy) {
        this.scale(sx, sy, true);
    }

    public void scale(double sx, double sy, double anchorX, double anchorY) {
        this.scale(sx, sy, anchorX, anchorY, true);
    }

    public void scale(double sx, double sy, boolean applyImmediately) {
        if (this.moveHandle == null || this.moveHandle.getAnchor() == null) {
            return;
        }
        Point2D newAnchor = this.moveHandle.getAnchor(this.finalTransform);
        this.scale(sx, sy, newAnchor.getX(), newAnchor.getY(), applyImmediately);
    }

    public void scale(double sx, double sy, double anchorX, double anchorY, boolean applyImmediately) {
        AffineTransform at = new AffineTransform();
        at.rotate(this.getAngle(this.finalTransform), anchorX, anchorY);
        at.translate(anchorX, anchorY);
        at.scale(sx, sy);
        at.translate(-anchorX, -anchorY);
        at.rotate(-this.getAngle(this.finalTransform), anchorX, anchorY);
        this.applyTransitChanges(at, applyImmediately);
    }

    public void translate(double tx, double ty) {
        this.translate(tx, ty, true);
    }

    public void translate(double tx, double ty, boolean applyImmediately) {
        AffineTransform at = new AffineTransform();
        at.translate(tx, ty);
        this.applyTransitChanges(at, applyImmediately);
    }

    private double[] getTransformationParameters(AffineTransform at, Rectangle2D mbr) {
        if (at == null || mbr == null || this.isReallyIdentity(at)) {
            return new double[]{1.0, 1.0, 0.0, 0.0, 0.0};
        }
        Point2D.Double ul = new Point2D.Double(mbr.getMinX(), mbr.getMinY());
        Point2D.Double ur = new Point2D.Double(mbr.getMaxX(), mbr.getMinY());
        Point2D.Double dl = new Point2D.Double(mbr.getMinX(), mbr.getMaxY());
        Point2D.Double c = new Point2D.Double(mbr.getCenterX(), mbr.getCenterY());
        Point2D.Double tul = new Point2D.Double();
        Point2D.Double tur = new Point2D.Double();
        Point2D.Double tdl = new Point2D.Double();
        Point2D.Double tc = new Point2D.Double();
        at.transform(ul, tul);
        at.transform(ur, tur);
        at.transform(dl, tdl);
        at.transform(c, tc);
        double d1x = ul.distance(ur);
        double d2x = tul.distance(tur);
        double sX = d2x / d1x;
        if (d1x == 0.0 && d2x == 0.0) {
            sX = 1.0;
        }
        double d1y = ul.distance(dl);
        double d2y = tul.distance(tdl);
        double sY = d2y / d1y;
        if (d1y == 0.0 && d2y == 0.0) {
            sY = 1.0;
        }
        double tX = ((Point2D)tc).getX() - ((Point2D)c).getX();
        double tY = ((Point2D)tc).getY() - ((Point2D)c).getY();
        Point2D.Double trp = new Point2D.Double();
        at.transform(new Point2D.Double(mbr.getMinX() + 1.0, mbr.getMinY()), trp);
        double angle = Math.atan2(((Point2D)trp).getY() - ((Point2D)tul).getY(), ((Point2D)trp).getX() - ((Point2D)tul).getX());
        return new double[]{sX, sY, tX, tY, angle};
    }

    public double[] getTranformationParameters() {
        double[] res = this.getTransformationParameters(this.getEditTransform(), this.shapeMBR);
        if (this.canvas.getViewportTransform().getScaleY() < 0.0 && res[4] != 0.0) {
            res[4] = res[4] * -1.0;
        }
        return res;
    }

    private AffineTransform getEditTransform() {
        AffineTransform result = new AffineTransform(this.finalTransform);
        if (this.opMode == null || this.opMode == this.snapHandle) {
            return result;
        }
        result.preConcatenate(this.transitTransform);
        return result;
    }

    private AffineTransform getVisualTransform() {
        AffineTransform result = new AffineTransform(this.getEditTransform());
        result.preConcatenate(this.canvas.getViewportTransform());
        return result;
    }

    private double getAngle(AffineTransform at) {
        return this.getTransformationParameters(at, this.shapeMBR)[4];
    }

    private double getVisualAngle() {
        return this.getTranformationParameters()[4];
    }

    private boolean isReallyIdentity(AffineTransform at) {
        if (at.isIdentity()) {
            return true;
        }
        return at.getTranslateX() == 0.0 && at.getTranslateY() == 0.0 && at.getScaleX() == 1.0 && at.getScaleY() == 1.0 && at.getShearX() == 0.0 && at.getShearY() == 0.0;
    }

    public void commitChanges() {
        this.commitChanges(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitChanges(boolean showConfirmation, boolean commitAllSelected) {
        if (!this.isReallyIdentity(this.finalTransform) && this.isEnabled()) {
            int confirmDialog;
            if (showConfirmation && (confirmDialog = JOptionPane.showConfirmDialog(this.canvas.getFrameForDialog(), "Do you want to save your changes?", "Geometry Transformation", 0)) != 0) {
                return;
            }
            Layer targetLayer = this.canvas.getLayerManager().getLayerByTag("targetLayer");
            HashMap<Layer, ArrayList<GeoObject>> targetFeatures = new HashMap<Layer, ArrayList<GeoObject>>();
            for (GeoObject obj : this.selectedFeatures) {
                if (!commitAllSelected && !obj.getLayer().equals(targetLayer)) continue;
                if (obj.getLayer() instanceof TopologyPrimitiveLayer) {
                    JOptionPane.showMessageDialog(this.canvas.getFrameForDialog(), MessagesBundle.getMessage("Transformation_not_supported_for_layer"), MessagesBundle.getMessage("Warning"), 0);
                    return;
                }
                ArrayList<GeoObject> f = (ArrayList<GeoObject>)targetFeatures.get(obj.getLayer());
                if (f == null) {
                    f = new ArrayList<GeoObject>(1);
                    targetFeatures.put(obj.getLayer(), f);
                }
                f.add(obj);
            }
            String changeName = MessagesBundle.getMessage("Change_transform_features");
            this.supressSC = true;
            try {
                this.canvas.getUndoManager().startChangeBlock(changeName);
                for (Map.Entry e : targetFeatures.entrySet()) {
                    Layer layer = (Layer)e.getKey();
                    if (!((EditableLayer)layer).isEditable()) continue;
                    ArrayList feats = (ArrayList)e.getValue();
                    GeoObject[] featsArr = feats.toArray(new GeoObject[feats.size()]);
                    ((AbstractDataSetLayer)layer).transformFeatures(featsArr, this.finalTransform);
                }
                this.canvas.getLayerManager().clearAllSelections();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                this.canvas.getUndoManager().endChangeBlock(changeName);
                this.supressSC = false;
                this.clear();
            }
        }
    }

    public List<GeoObject> getSelectedFeatures() {
        return this.selectedFeatures;
    }

    private void updateHandles() {
        this.commitChanges();
        this.clear();
        this.selectedFeatures = this.canvas.getLayerManager().getAllSelections();
        ArrayList<GeoObject> nonEditableFeatures = new ArrayList<GeoObject>();
        if (this.selectedFeatures.size() > 0) {
            this.isSinglePoint = true;
            for (GeoObject selected : this.selectedFeatures) {
                if (!(selected.getLayer() instanceof EditableLayer) || !((EditableLayer)selected.getLayer()).isEditable()) {
                    nonEditableFeatures.add(selected);
                    continue;
                }
                for (Drawable tDraw = selected.getDrawable(new AffineTransform()); tDraw != null; tDraw = tDraw.getNext()) {
                    if (tDraw.isShape()) {
                        this.isSinglePoint = false;
                        if (this.shapeMBR == null) {
                            this.shapeMBR = tDraw.getShape().getBounds2D();
                            continue;
                        }
                        this.shapeMBR.add(tDraw.getShape().getBounds2D());
                        continue;
                    }
                    if (this.shapeMBR == null) {
                        this.shapeMBR = new Rectangle2D.Double(tDraw.getPoint().getX(), tDraw.getPoint().getY(), 0.0, 0.0);
                        if (tDraw.getType() != 4) continue;
                        this.orientation = new double[]{tDraw.getVectorX(), tDraw.getVectorY()};
                        continue;
                    }
                    this.isSinglePoint = false;
                    this.shapeMBR.add(tDraw.getPoint());
                }
            }
            this.selectedFeatures.removeAll(nonEditableFeatures);
            if (!this.isSinglePoint || this.orientation == null) {
                this.orientation = new double[]{1.0, 0.0};
            }
        }
        if (this.shapeMBR != null) {
            this.setupDragHandles();
        }
        this.checkBoundary();
    }

    private void checkBoundary() {
        AffineTransform at = this.getVisualTransform();
        if (this.shapeMBR == null || this.isHideWhenObstructed() && !ManipulatorLayer.contains(this.canvas.getBounds(), at.createTransformedShape(this.shapeMBR).getBounds2D())) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    private static boolean contains(Rectangle2D a, Rectangle2D b) {
        Point2D.Double ul = new Point2D.Double(b.getMinX(), b.getMinY());
        Point2D.Double ur = new Point2D.Double(b.getMaxX(), b.getMinY());
        Point2D.Double dl = new Point2D.Double(b.getMinX(), b.getMaxY());
        Point2D.Double dr = new Point2D.Double(b.getMaxX(), b.getMaxY());
        return a.contains(ul) && a.contains(ur) && a.contains(dl) && a.contains(dr);
    }

    private void placeSnapHandle(Point2D point, Handle handle) {
        if (this.snapHandle == null) {
            this.snapHandle = new Handle(HANDLE_SNAP, this);
            this.snapHandle.setShape(new Ellipse2D.Double(-this.snapTolerance, -this.snapTolerance, this.snapTolerance * 2, this.snapTolerance * 2));
            this.snapHandle.setCursor(Cursor.getPredefinedCursor(12));
            this.allHandles.put((String)this.snapHandle.getKey(), this.snapHandle);
        }
        Point2D newPoint = null;
        if (handle != null) {
            newPoint = handle.getCenter();
        } else {
            try {
                newPoint = new Point2D.Double();
                this.getVisualTransform().inverseTransform(point, newPoint);
            }
            catch (NoninvertibleTransformException ex) {
                ex.printStackTrace();
                return;
            }
        }
        this.snapped = false;
        this.snapHandle.setAnchor(newPoint);
        this.snapHandle.setCenter(newPoint);
    }

    private void removeSnapPoint() {
        this.allHandles.remove((String)this.snapHandle.getKey());
        this.snapHandle = null;
    }

    private void placeAnchor(Point2D point, Handle handle) {
        Point2D newPoint = null;
        if (handle != null) {
            newPoint = handle.getCenter();
            this.anchorMoved = true;
        } else if (point == null) {
            newPoint = new Point2D.Double(this.shapeMBR.getCenterX(), this.shapeMBR.getCenterY());
            this.anchorMoved = false;
        } else {
            try {
                newPoint = new Point2D.Double();
                this.getVisualTransform().inverseTransform(point, newPoint);
                this.anchorMoved = true;
            }
            catch (NoninvertibleTransformException ex) {
                ex.printStackTrace();
                return;
            }
        }
        if (this.moveHandle == null) {
            this.moveHandle = new Handle(HANDLE_TRANSLATE, this);
            this.moveHandle.setShape(new Rectangle2D.Double(-this.getHandleSize() / 2, -this.getHandleSize() / 2, this.getHandleSize(), this.getHandleSize()));
            this.moveHandle.setCursor(Cursor.getPredefinedCursor(13));
            this.allHandles.put((String)this.moveHandle.getKey(), this.moveHandle);
        }
        this.moveHandle.setCenter(newPoint);
        this.moveHandle.setAnchor(newPoint);
        if (this.rotateHandle == null) {
            this.rotateHandle = new Handle(HANDLE_ROTATE, this);
            this.rotateHandle.setShape(new Ellipse2D.Double(-this.getHandleSize() / 2, -this.getHandleSize() / 2, this.getHandleSize(), this.getHandleSize()));
            this.rotateHandle.setCursor(Cursor.getPredefinedCursor(12));
            this.allHandles.put((String)this.rotateHandle.getKey(), this.rotateHandle);
        }
        double pointSpan = 0.0;
        try {
            pointSpan = TransformUtils.transformMagnitude(this.getHandleSize() * 6, this.canvas.getViewportTransform().createInverse());
        }
        catch (NoninvertibleTransformException ex) {
            ex.printStackTrace();
        }
        double span = this.isSinglePoint ? pointSpan : this.shapeMBR.getWidth() / 4.0;
        double rot = Math.atan2(this.orientation[1], this.orientation[0]);
        this.rotateHandle.setAnchor(newPoint);
        this.rotateHandle.setCenter(new Point2D.Double(newPoint.getX() + span * Math.cos(rot), newPoint.getY() + span * Math.sin(rot)));
        if (this.resizeHandles.size() > 0) {
            AffineTransform vsTFM = this.getVisualTransform();
            vsTFM.preConcatenate(AffineTransform.getRotateInstance(-this.getVisualAngle()));
            Point2D.Double vsNewPoint = new Point2D.Double();
            vsTFM.transform(newPoint, vsNewPoint);
            double tolerance = 0.56;
            for (Handle h : this.resizeHandles.values()) {
                Point2D vsAnchor = h.getAnchor(vsTFM);
                Point2D vsCenter = h.getCenter(vsTFM);
                if (!h.isCorner()) {
                    Point2D.Double o = new Point2D.Double();
                    ShapeUtil.projection((double)((Point2D)vsNewPoint).getX(), (double)((Point2D)vsNewPoint).getY(), (double)vsAnchor.getX(), (double)vsAnchor.getY(), (double)vsCenter.getX(), (double)vsCenter.getY(), (Point2D)o);
                    h.setEnabled(vsCenter.distance(o) > tolerance);
                    continue;
                }
                double dx = Math.abs(vsCenter.getX() - ((Point2D)vsNewPoint).getX());
                double dy = Math.abs(vsCenter.getY() - ((Point2D)vsNewPoint).getY());
                h.setEnabled(dx > tolerance && dy > tolerance);
            }
        }
    }

    private boolean applyTransitChanges(AffineTransform at, boolean apply) {
        boolean res = true;
        if (at != null && !this.isReallyIdentity(at)) {
            this.transitTransform.concatenate(at);
        }
        if (apply) {
            AffineTransform saveFinalTFM = new AffineTransform(this.finalTransform);
            this.finalTransform.preConcatenate(this.transitTransform);
            double sx = this.finalTransform.getScaleX();
            double sy = this.finalTransform.getScaleY();
            if (Double.isNaN(sx) || Double.isNaN(sy) || Double.isInfinite(sx) || Double.isInfinite(sy) || Math.abs(sx) > 5000.0 || Math.abs(sy) > 5000.0) {
                this.finalTransform = saveFinalTFM;
                res = false;
            } else {
                ChangeCacheEntry edit = new ChangeCacheEntry(this.transitTransform);
                if (this.firstEditChange == null) {
                    edit.setSignificant(false);
                    this.firstEditChange = new ManipulatorFirstChange();
                    this.canvas.getUndoManager().undoableEditHappened(new UndoableEditEvent(this, this.firstEditChange));
                }
                this.canvas.getUndoManager().undoableEditHappened(new UndoableEditEvent(this, edit));
                this.firstEditChange.setLastChange(edit);
                this.transitTransform.setToIdentity();
                this.checkBoundary();
            }
        }
        this.fireStateChanged();
        return res;
    }

    private void setupDragHandles() {
        if (this.shapeMBR == null) {
            return;
        }
        this.moveHandle = null;
        this.rotateHandle = null;
        this.allHandles.clear();
        this.resizeHandles.clear();
        if (!this.isSinglePoint) {
            double cx = this.shapeMBR.getCenterX();
            double cy = this.shapeMBR.getCenterY();
            double x = this.shapeMBR.getMinX() - (double)this.gap;
            double y = this.shapeMBR.getMinY() - (double)this.gap;
            double w = this.shapeMBR.getWidth() + (double)(this.gap * 2);
            double h = this.shapeMBR.getHeight() + (double)(this.gap * 2);
            this.shapeMBR = new Rectangle2D.Double(x, y, w, h);
            double[] xs = new double[]{x, cx, x + w, x + w, x + w, cx, x, x};
            double[] ys = new double[]{y, y, y, cy, y + h, y + h, y + h, cy};
            String[] names = new String[]{HANDLE_RESIZE_NW, HANDLE_RESIZE_N, HANDLE_RESIZE_NE, HANDLE_RESIZE_E, HANDLE_RESIZE_SE, HANDLE_RESIZE_S, HANDLE_RESIZE_SW, HANDLE_RESIZE_W};
            for (int i = 0; i < xs.length; ++i) {
                Point2D.Double anchor = i < 4 ? new Point2D.Double(xs[i + 4], ys[i + 4]) : new Point2D.Double(xs[i - 4], ys[i - 4]);
                Handle handle = new Handle(names[i], this);
                handle.setShape(new Rectangle2D.Double(-this.getHandleSize() / 2, -this.getHandleSize() / 2, this.getHandleSize(), this.getHandleSize()));
                handle.setAnchor(anchor);
                handle.setCenter(new Point2D.Double(xs[i], ys[i]));
                handle.setCorner(i % 2 == 0);
                this.resizeHandles.put((String)handle.getKey(), handle);
                this.allHandles.put((String)handle.getKey(), handle);
            }
        }
        this.placeAnchor(null, null);
    }

    private boolean extendLineToRectangle(Point2D p1, Point2D p2, Rectangle2D rec) {
        double[] lineOut;
        double dist = p1.distance(p2);
        if (dist == 0.0) {
            return false;
        }
        double dx = (p2.getX() - p1.getX()) / dist;
        double dy = (p2.getY() - p1.getY()) / dist;
        double maxExtent = Math.sqrt(rec.getWidth() * rec.getWidth() + rec.getHeight() * rec.getHeight());
        double[] lineIn = new double[]{p1.getX() - dx * maxExtent, p1.getY() - dy * maxExtent, p2.getX() + dx * maxExtent, p2.getY() + dy * maxExtent};
        if (!ShapeUtil.clipLineSegment((double[])lineIn, (Rectangle2D)rec, (double[])(lineOut = new double[4]))) {
            return false;
        }
        p1.setLocation(lineOut[0], lineOut[1]);
        p2.setLocation(lineOut[2], lineOut[3]);
        return true;
    }

    @Override
    public long render(Graphics2D g) {
        if (!this.isEnabled() || this.shapeMBR == null || this.selectedFeatures.size() == 0) {
            return 0L;
        }
        long t0 = System.currentTimeMillis();
        AffineTransform at = this.getVisualTransform();
        Object oldHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.getColorProperty(PROPERTY_CHANGED_FEATURE_COLOR));
        g.setStroke(this.animeStroke.getStroke());
        if (!this.isReallyIdentity(this.getEditTransform())) {
            for (GeoObject selected : this.selectedFeatures) {
                for (Drawable tDraw = selected.getDrawable(at); tDraw != null; tDraw = tDraw.getNext()) {
                    if (tDraw.isShape()) {
                        g.draw(tDraw.getShape());
                        continue;
                    }
                    if (tDraw.isPoint()) {
                        Point2D tp = tDraw.getPoint();
                        Ellipse2D.Double ellipse = new Ellipse2D.Double(tp.getX() - (double)(this.getHandleSize() / 2), tp.getY() - (double)(this.getHandleSize() / 2), this.getHandleSize(), this.getHandleSize());
                        g.draw(ellipse);
                        if (tDraw.getType() != 4) continue;
                        double rot = Math.atan2(tDraw.getVectorY(), tDraw.getVectorX());
                        g.drawLine((int)tp.getX(), (int)tp.getY(), (int)(tp.getX() + (double)(this.getHandleSize() / 2 * 5) * Math.cos(rot)), (int)(tp.getY() + (double)(this.getHandleSize() / 2 * 5) * Math.sin(rot)));
                        continue;
                    }
                    throw new UnsupportedOperationException("unsupported drawable type");
                }
            }
        }
        g.setStroke(this.stroke);
        double editAngle = this.getVisualAngle();
        Point2D p1 = null;
        Point2D p2 = null;
        for (Handle handle : this.allHandles.values()) {
            boolean snappingHandle;
            if (!handle.isEnabled()) continue;
            Shape shp = handle.getShape(at, editAngle);
            boolean bl = snappingHandle = handle == this.placingHandle || this.placingHandle == null && handle == this.snapHandle;
            if (this.snapped && snappingHandle) {
                Rectangle2D mbr = shp.getBounds2D();
                int cx = (int)mbr.getCenterX();
                int cy = (int)mbr.getCenterY();
                int minx = (int)mbr.getMinX();
                int miny = (int)mbr.getMinY();
                int maxx = (int)mbr.getMaxX();
                int maxy = (int)mbr.getMaxY();
                g.setColor(this.getColorProperty(PROPERTY_SNAP_POINT_COLOR));
                Composite origComposite = g.getComposite();
                g.setComposite(AlphaComposite.getInstance(3, 0.3f));
                g.fill(shp);
                g.setComposite(origComposite);
                g.drawLine(cx, miny, cx, maxy);
                g.drawLine(minx, cy, maxx, cy);
            }
            Color rc = this.getColorProperty(PROPERTY_COLOR);
            if (handle == this.lastOpMode || this.snapped && snappingHandle) {
                rc = this.getColorProperty(PROPERTY_SNAP_POINT_COLOR);
            }
            g.setColor(rc);
            g.draw(shp);
            if (handle == this.moveHandle) {
                p1 = handle.getCenter(at);
                continue;
            }
            if (handle != this.rotateHandle) continue;
            p2 = handle.getCenter(at);
        }
        if (p1 != null && p2 != null) {
            Color lc = this.getColorProperty(PROPERTY_COLOR);
            if (this.rotateHandle == this.lastOpMode) {
                lc = this.getColorProperty(PROPERTY_SNAP_POINT_COLOR);
            }
            g.setColor(lc);
            g.drawLine((int)p1.getX(), (int)p1.getY(), (int)p2.getX(), (int)p2.getY());
        }
        if (!this.isSinglePoint) {
            g.setColor(this.getColorProperty(PROPERTY_COLOR));
            g.draw(at.createTransformedShape(this.shapeMBR));
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
        return System.currentTimeMillis() - t0;
    }

    @Override
    public void setCanvas(MapCanvas canvas) {
        this.canvas = canvas;
        if (canvas != null) {
            this.canvas.getLayerManager().addChangeListener(this);
        }
    }

    @Override
    public void update(long elapsedTime) {
        this.animeStroke.update(elapsedTime);
    }

    public GeoObject[] hitTest(int x, int y) {
        ArrayList<Handle> hits = new ArrayList<Handle>();
        if (this.isEnabled()) {
            AffineTransform at = this.getVisualTransform();
            double angle = this.getVisualAngle();
            for (Handle handle : this.allHandles.values()) {
                Shape shp;
                if (!handle.isEnabled() || !(shp = handle.getShape(at, angle)).contains(x, y)) continue;
                hits.add(handle);
            }
        }
        return hits.toArray(new GeoObject[hits.size()]);
    }

    public GeoObject[] hitTestWithBox(Rectangle2D box) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    private void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent changeEvent = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(changeEvent);
        }
    }

    private void setEnabled(boolean enabled) {
        if (enabled != this.enabled) {
            this.enabled = enabled;
            this.fireStateChanged();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setTranslationFactor(double translationDelta) {
        this.setProperty(PROPERTY_TRANSLATION_FACTOR, Double.toString(translationDelta));
    }

    public double getTranslationFactor() {
        return Double.parseDouble(this.getProperty(PROPERTY_TRANSLATION_FACTOR));
    }

    public void setScaleFactor(double scaleDelta) {
        this.setProperty(PROPERTY_SCALE_FACTOR, Double.toString(scaleDelta));
    }

    public double getScaleFactor() {
        return Double.parseDouble(this.getProperty(PROPERTY_SCALE_FACTOR));
    }

    public void setRotationFactor(double rotationDelta) {
        this.setProperty(PROPERTY_ROTATION_FACTOR, Double.toString(rotationDelta * (Math.PI / 180)));
    }

    public double getRotationFactor() {
        return Double.parseDouble(this.getProperty(PROPERTY_ROTATION_FACTOR)) / (Math.PI / 180);
    }

    public void setHandleSize(int handleSize) {
        this.setProperty(PROPERTY_HANDLE_SIZE, Integer.toString(handleSize));
    }

    public int getHandleSize() {
        return Integer.parseInt(this.getProperty(PROPERTY_HANDLE_SIZE));
    }

    public void setHideWhenObstructed(boolean hideWhenObstructed) {
        this.setProperty(PROPERTY_HIDE_WHEN_OBSTRUCTED, Boolean.toString(hideWhenObstructed));
    }

    public boolean isHideWhenObstructed() {
        return Boolean.parseBoolean(this.getProperty(PROPERTY_HIDE_WHEN_OBSTRUCTED));
    }

    public Handle getHandle(String name) {
        return this.allHandles.get(name);
    }

    public void disableAllHandles() {
        Enumeration<Handle> e = this.allHandles.elements();
        while (e.hasMoreElements()) {
            Handle hd = e.nextElement();
            hd.setEnabled(false);
        }
    }

    private void setColorProperty(String property, Color color) {
        this.setProperty(property, StyleUtils.getHexidecimalString((Color)color));
    }

    private Color getColorProperty(String property) {
        try {
            Integer i = Integer.decode(this.getProperty(property));
            return new Color(i);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void setAnimatedStroke(AnimatedStroke animatedStroke) {
        this.animeStroke = animatedStroke;
    }

    public AnimatedStroke getAnimatedStroke() {
        return this.animeStroke;
    }

    @Override
    public JPanel getConfigurationPanel(Component parent) {
        ManipulatorPreferencesPanel p = new ManipulatorPreferencesPanel(parent);
        return p;
    }

    private class ManipulatorPreferencesPanel
    extends JPanel {
        private Component parent = null;
        private Color propertyColor = null;
        private Color snapHighliteColor = null;
        private Color changedFeatureColor = null;
        private int handleSize = 8;
        private boolean hideWhenObstructed = false;

        public ManipulatorPreferencesPanel(Component parent) {
            this.parent = parent;
            this.propertyColor = ManipulatorLayer.this.getColorProperty(ManipulatorLayer.PROPERTY_COLOR);
            this.snapHighliteColor = ManipulatorLayer.this.getColorProperty(ManipulatorLayer.PROPERTY_SNAP_POINT_COLOR);
            this.changedFeatureColor = ManipulatorLayer.this.getColorProperty(ManipulatorLayer.PROPERTY_SNAP_POINT_COLOR);
            this.handleSize = ManipulatorLayer.this.getHandleSize();
            this.hideWhenObstructed = ManipulatorLayer.this.isHideWhenObstructed();
            try {
                this.jbInit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void jbInit() throws Exception {
            this.setLayout(new GridBagLayout());
            this.setSize(new Dimension(305, 154));
            JLabel colorLabel = new JLabel(MessagesBundle.getMessage("Label_color"));
            JButton colorButton = new JButton(new ColorIcon(32, 16, this.propertyColor));
            colorButton.addActionListener(new ColorIconButtonActionListener(this.parent){

                @Override
                public void colorChanged(Color color) {
                    ManipulatorPreferencesPanel.this.propertyColor = color;
                }
            });
            JLabel highLightLabel = new JLabel(MessagesBundle.getMessage("Label_snap_highlite_color"));
            JButton highLightButton = new JButton(new ColorIcon(32, 16, this.snapHighliteColor));
            highLightButton.addActionListener(new ColorIconButtonActionListener(this.parent){

                @Override
                public void colorChanged(Color color) {
                    ManipulatorPreferencesPanel.this.snapHighliteColor = color;
                }
            });
            JLabel featureLabel = new JLabel(MessagesBundle.getMessage("Label_changed_feature_color"));
            JButton featureButton = new JButton(new ColorIcon(32, 16, this.changedFeatureColor));
            featureButton.addActionListener(new ColorIconButtonActionListener(this.parent){

                @Override
                public void colorChanged(Color color) {
                    ManipulatorPreferencesPanel.this.changedFeatureColor = color;
                }
            });
            JLabel hsizeLabel = new JLabel(MessagesBundle.getMessage("Label_handle_size"));
            JSpinner hsizeSpinner = new JSpinner(new SpinnerNumberModel(this.handleSize, 2, 40, 1));
            hsizeSpinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JSpinner s = (JSpinner)e.getSource();
                    ManipulatorPreferencesPanel.this.handleSize = (Integer)s.getValue();
                }
            });
            JCheckBox hideCheckBox = new JCheckBox(MessagesBundle.getMessage("Checkbox_hide_when_obstructed"), this.hideWhenObstructed);
            hideCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JCheckBox cb = (JCheckBox)e.getSource();
                    ManipulatorPreferencesPanel.this.hideWhenObstructed = cb.isSelected();
                }
            });
            JButton applyButton = new JButton(MessagesBundle.getMessage("Button_apply"));
            applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ManipulatorLayer.this.setColorProperty(ManipulatorLayer.PROPERTY_COLOR, ManipulatorPreferencesPanel.this.propertyColor);
                    ManipulatorLayer.this.setColorProperty(ManipulatorLayer.PROPERTY_SNAP_POINT_COLOR, ManipulatorPreferencesPanel.this.snapHighliteColor);
                    ManipulatorLayer.this.setColorProperty(ManipulatorLayer.PROPERTY_CHANGED_FEATURE_COLOR, ManipulatorPreferencesPanel.this.changedFeatureColor);
                    ManipulatorLayer.this.setHandleSize(ManipulatorPreferencesPanel.this.handleSize);
                    ManipulatorLayer.this.setHideWhenObstructed(ManipulatorPreferencesPanel.this.hideWhenObstructed);
                }
            });
            int y = 0;
            this.add((Component)colorLabel, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 13, 0, new Insets(10, 0, 0, 0), 0, 0));
            this.add((Component)colorButton, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
            this.add((Component)highLightLabel, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)highLightButton, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)featureLabel, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)featureButton, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)hsizeLabel, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)hsizeSpinner, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)hideCheckBox, new GridBagConstraints(0, ++y, 2, 1, 1.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)applyButton, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 13, 0, new Insets(15, 0, 0, 0), 0, 0));
        }
    }

    private class SMA {
        private LinkedList values = new LinkedList();
        private int length;
        private double sum = 0.0;
        private double average = 0.0;

        public SMA(int length) {
            if (length <= 0) {
                throw new IllegalArgumentException("length must be greater than zero");
            }
            this.length = length;
        }

        public double currentAverage() {
            return this.average;
        }

        public synchronized double compute(double value) {
            if (this.values.size() == this.length && this.length > 0) {
                this.sum -= ((Double)this.values.getFirst()).doubleValue();
                this.values.removeFirst();
            }
            this.sum += value;
            this.values.addLast(new Double(value));
            this.average = this.sum / (double)this.values.size();
            return this.average;
        }
    }

    private class ChangeCacheEntry
    extends AbstractUndoableEdit {
        private AffineTransform affineTransform = null;
        private boolean significant = true;

        public ChangeCacheEntry(AffineTransform affineTransform) {
            this.affineTransform = new AffineTransform(affineTransform);
        }

        @Override
        public String getPresentationName() {
            return "Free transformation";
        }

        @Override
        public void undo() {
            super.undo();
            if (ManipulatorLayer.this.shapeMBR == null) {
                throw new CannotUndoException();
            }
            try {
                ManipulatorLayer.this.finalTransform.preConcatenate(this.affineTransform.createInverse());
                ManipulatorLayer.this.checkBoundary();
                ManipulatorLayer.this.fireStateChanged();
                ManipulatorLayer.this.snapped = false;
            }
            catch (NoninvertibleTransformException ex) {
                ex.printStackTrace();
                throw new CannotUndoException();
            }
        }

        @Override
        public void redo() {
            super.redo();
            if (ManipulatorLayer.this.shapeMBR == null) {
                throw new CannotRedoException();
            }
            ManipulatorLayer.this.finalTransform.preConcatenate(this.affineTransform);
            ManipulatorLayer.this.checkBoundary();
            ManipulatorLayer.this.fireStateChanged();
            ManipulatorLayer.this.snapped = false;
        }

        public void setSignificant(boolean significant) {
            this.significant = significant;
        }

        @Override
        public boolean isSignificant() {
            return this.significant;
        }
    }

    private class ManipulatorFirstChange
    extends AbstractUndoableEdit {
        private UndoableEdit lastChange = null;

        private ManipulatorFirstChange() {
        }

        @Override
        public void undo() {
            super.undo();
            if (this.lastChange == null) {
                throw new CannotUndoException();
            }
            ManipulatorLayer.this.clear();
        }

        @Override
        public void redo() {
            throw new CannotRedoException();
        }

        public void setLastChange(UndoableEdit lastChange) {
            this.lastChange = lastChange;
        }

        public UndoableEdit getLastChange() {
            return this.lastChange;
        }
    }

    private class Handle
    implements GeoObject {
        private Layer layer = null;
        private Cursor cursor = null;
        private Shape shape;
        private Point2D anchor;
        private Point2D center;
        private boolean corner = false;
        private boolean enabled = true;
        private String key = null;

        public Handle(String key, Layer layer) {
            this.key = key;
            this.layer = layer;
        }

        public Handle clone() {
            try {
                return (Handle)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new UnsupportedOperationException();
            }
        }

        @Override
        public boolean isSubElementOf(GeoObject obj) {
            return false;
        }

        @Override
        public List<GeoObject> substract(List<? extends GeoObject> obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public Object setKey(Object key) {
            String prev = this.key;
            this.key = (String)key;
            return prev;
        }

        @Override
        public Layer getLayer() {
            return this.layer;
        }

        @Override
        public void setLayer(Layer layer) {
            this.layer = layer;
        }

        @Override
        public Drawable getDrawable(AffineTransform transform) {
            return new Drawable(this.getShape(), 1);
        }

        @Override
        public Rectangle2D getMBR() {
            return this.getShape().getBounds2D();
        }

        public void setAnchor(Point2D anchor) {
            this.anchor = anchor;
        }

        public Point2D getAnchor() {
            return this.anchor;
        }

        public Point2D getAnchor(AffineTransform at) {
            Point2D.Double newAnchor = new Point2D.Double();
            at.transform(this.getAnchor(), newAnchor);
            return newAnchor;
        }

        public void setCorner(boolean corner) {
            this.corner = corner;
        }

        public boolean isCorner() {
            return this.corner;
        }

        public void setShape(Shape shape) {
            this.shape = shape;
        }

        private Shape getShape() {
            return this.shape;
        }

        public Shape getShape(AffineTransform at, double angle) {
            Point2D.Double newCenter = new Point2D.Double();
            at.transform(this.getCenter(), newCenter);
            AffineTransform nat = new AffineTransform();
            nat.setToTranslation(((Point2D)newCenter).getX(), ((Point2D)newCenter).getY());
            nat.rotate(angle);
            return nat.createTransformedShape(this.getShape());
        }

        public void setCenter(Point2D center) {
            this.center = center;
        }

        public Point2D getCenter() {
            return this.center;
        }

        public Point2D getCenter(AffineTransform at) {
            Point2D.Double newCenter = new Point2D.Double();
            at.transform(this.getCenter(), newCenter);
            return newCenter;
        }

        public void setCursor(Cursor cursor) {
            this.cursor = cursor;
        }

        public Cursor getCursor() {
            return this.cursor;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    private abstract class ColorIconButtonActionListener
    implements ActionListener {
        Component parent = null;

        public ColorIconButtonActionListener(Component parent) {
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton button = (JButton)e.getSource();
            ColorIcon ci = (ColorIcon)button.getIcon();
            Color c = JColorChooser.showDialog(this.parent, MessagesBundle.getMessage("Choose_color"), ci.getColor());
            if (c != null) {
                ci.setColor(c);
                this.colorChanged(c);
            }
        }

        public abstract void colorChanged(Color var1);
    }

    private class XYListener
    implements ActionListener {
        private MouseEvent me = null;
        private Handle handle = null;

        public XYListener(MouseEvent me, Handle handle) {
            this.me = me;
            this.handle = handle;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("placeSnapPoint")) {
                if (ManipulatorLayer.this.snapHandle == null) {
                    ManipulatorLayer.this.snapHandle = new Handle(ManipulatorLayer.HANDLE_SNAP, ManipulatorLayer.this);
                    ManipulatorLayer.this.snapHandle.setShape(new Ellipse2D.Double(-ManipulatorLayer.this.snapTolerance, -ManipulatorLayer.this.snapTolerance, ManipulatorLayer.this.snapTolerance * 2, ManipulatorLayer.this.snapTolerance * 2));
                    ManipulatorLayer.this.snapHandle.setCursor(Cursor.getPredefinedCursor(12));
                    ManipulatorLayer.this.snapHandle.setAnchor(new Point2D.Double(0.0, 0.0));
                    ManipulatorLayer.this.snapHandle.setCenter(new Point2D.Double(0.0, 0.0));
                    ManipulatorLayer.this.allHandles.put((String)ManipulatorLayer.this.snapHandle.getKey(), ManipulatorLayer.this.snapHandle);
                }
                ManipulatorLayer.this.placingHandle = ManipulatorLayer.this.snapHandle;
            } else if (e.getActionCommand().equals("placeAnchor")) {
                ManipulatorLayer.this.placingHandle = ManipulatorLayer.this.moveHandle;
            } else if (e.getActionCommand().equals("removeSnapPoint")) {
                ManipulatorLayer.this.removeSnapPoint();
            } else if (e.getActionCommand().equals("resetAnchor")) {
                ManipulatorLayer.this.placeAnchor(null, null);
            } else if (e.getActionCommand().equals("commitChanges")) {
                ManipulatorLayer.this.commitChanges();
            } else if (e.getActionCommand().equals("discardChanges")) {
                ManipulatorLayer.this.setToTransform(1.0, 1.0, 0.0, 0.0, 0.0);
            }
        }
    }
}

