/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.layer;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.lbs.mapclient.ThemeDescriptor;
import oracle.maps.core.MVThemeLayer;
import oracle.maps.core.MapCanvas;
import oracle.maps.core.MapRegionEvent;
import oracle.maps.core.TileLayerConfig;
import oracle.maps.geoobject.ImageObject;
import oracle.maps.layer.BasicLayer;
import oracle.maps.producer.MVImageProducer;
import oracle.maps.util.TileLayerUtils;
import oracle.mapviewer.share.MVThemeMetadata;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.ui.resources.MessagesBundle;
import org.w3c.dom.Element;

public class MVImageLayer
extends BasicLayer
implements MVThemeLayer,
PropertyChangeListener {
    public static final String PROPERTY_SERVERURL = "oracle.lbs.mapviewer.serverURL";
    public static final String PROPERTY_DATASOURCE = "oracle.lbs.mapviewer.dataSource";
    protected TileLayerConfig tileConfig = null;
    protected Vector<MVThemeMetadata> themes = null;
    protected MVImageProducer producer = null;
    protected Image img = null;
    protected AffineTransform lastViewXFM = null;

    public MVImageLayer(MapCanvas mapCanvas) {
        super(mapCanvas);
        this.properties.setDefaultProperty("oracle.maps.core.Layer.name", "MapViewer image layer");
        this.properties.setDefaultProperty("oracle.mdeditor.session.layer.WorkspaceLayer.workspacename", "LIVE");
        this.addPropertyChangeListener(this);
    }

    @Override
    public void fromXMLElement(Element element) {
        super.fromXMLElement(element);
        this.updateProducer();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("oracle.maps.core.Layer.visible")) {
            if (Boolean.parseBoolean(evt.getNewValue().toString()) && this.tileConfig != null) {
                this.canvas.getMapRegion().setDataWindow(this.canvas.getMapRegion().getDataWindow());
            }
        } else if (evt.getPropertyName().equals(PROPERTY_SERVERURL) || evt.getPropertyName().equals(PROPERTY_DATASOURCE) || evt.getPropertyName().equals("oracle.mdeditor.session.layer.WorkspaceLayer.workspacename")) {
            this.updateProducer();
        }
    }

    private void updateProducer() {
        String tileName;
        String mapViewerURL = this.getProperty(PROPERTY_SERVERURL);
        String dataSourceName = this.getProperty(PROPERTY_DATASOURCE);
        if (mapViewerURL == null || mapViewerURL.trim().isEmpty() || dataSourceName == null || dataSourceName.trim().isEmpty()) {
            return;
        }
        this.producer = new MVImageProducer(this, mapViewerURL, dataSourceName);
        this.producer.addMVThemeLayer(this);
        if (this.tileConfig == null && (tileName = this.getProperty("tileName")) != null && !tileName.trim().isEmpty()) {
            try {
                this.tileConfig = TileLayerUtils.getTileLayerConfig(mapViewerURL, dataSourceName, tileName);
            }
            catch (Exception ex) {
                System.err.println(MessagesBundle.getMessage("Unable_toget_tilelayer_config"));
            }
        }
    }

    @Override
    public void added(Object src) {
        super.added(src);
        if (src instanceof MapCanvas && this.tileConfig != null) {
            Rectangle2D window = this.canvas.getMapRegion().getDataWindow();
            if (window == null) {
                window = this.getFullExtent();
            }
            this.canvas.getMapRegion().setDataWindow(this.canvas.getMapRegion().getDataWindow());
        }
    }

    @Override
    public Rectangle2D getFullExtent() {
        Iterator<MVThemeMetadata> i$;
        double xmin = Double.NEGATIVE_INFINITY;
        double ymin = Double.NEGATIVE_INFINITY;
        double xmax = Double.POSITIVE_INFINITY;
        double ymax = Double.POSITIVE_INFINITY;
        int type = this.getThemeDescriptor().type;
        if (type == 1 || type == 9) {
            xmin = Double.parseDouble(this.getProperty("xmin"));
            ymin = Double.parseDouble(this.getProperty("ymin"));
            xmax = Double.parseDouble(this.getProperty("xmax"));
            ymax = Double.parseDouble(this.getProperty("ymax"));
        } else if (type == 0 && this.themes != null && (i$ = this.themes.iterator()).hasNext()) {
            MVThemeMetadata mvmeta = i$.next();
            xmin = mvmeta.getXMin();
            ymin = mvmeta.getYMin();
            xmax = mvmeta.getXMax();
            ymax = mvmeta.getYMax();
        }
        RectangularShape extent = null;
        if (xmin != Double.NEGATIVE_INFINITY && ymin != Double.NEGATIVE_INFINITY && xmax != Double.POSITIVE_INFINITY && ymax != Double.POSITIVE_INFINITY) {
            extent = new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
        }
        AffineTransform at = new AffineTransform();
        if (this.getSRID() == 8307) {
            at.translate(-extent.getWidth() / 3.5, extent.getHeight() / 3.5);
        }
        at.scale(0.3f, 0.3f);
        return at.createTransformedShape(extent).getBounds2D();
    }

    public void setBaseMapThemes(Vector<MVThemeMetadata> themes) {
        this.themes = themes;
    }

    @Override
    public Icon getIcon() {
        ImageIcon icon = null;
        int type = this.getThemeDescriptor().type;
        if (type == 1) {
            icon = Icons.getIcon("theme.gif");
        } else if (type == 9) {
            icon = Icons.getIcon("image_theme.png");
        } else if (type == 0) {
            icon = Icons.getIcon("basemap.png");
        }
        return icon;
    }

    @Override
    public long render(Graphics2D g) {
        long t1 = System.currentTimeMillis();
        if (this.img != null) {
            AffineTransform xfm = this.canvas.getViewportTransform();
            AffineTransform diff = null;
            if (this.lastViewXFM != null && !xfm.equals(this.lastViewXFM)) {
                try {
                    diff = new AffineTransform(this.lastViewXFM.createInverse());
                    diff.preConcatenate(xfm);
                }
                catch (NoninvertibleTransformException ex) {
                    // empty catch block
                }
            }
            if (diff == null) {
                int x = (this.canvas.getWidth() - this.img.getWidth(null)) / 2;
                int y = (this.canvas.getHeight() - this.img.getHeight(null)) / 2;
                diff = AffineTransform.getTranslateInstance(x, y);
            }
            g.drawImage(this.img, diff, null);
        }
        long t2 = System.currentTimeMillis();
        return t2 - t1;
    }

    @Override
    public void setCanvas(MapCanvas canvas) {
        super.setCanvas(canvas);
        if (canvas != null && this.isVisible() && canvas.getMapRegion().getDataWindow() != null) {
            this.mapRegionChanged(null);
        }
    }

    @Override
    public void mapRegionChanged(MapRegionEvent evt) {
        if (!this.isVisible()) {
            return;
        }
        if (this.canvas.getWidth() == 0 || this.canvas.getHeight() == 0) {
            return;
        }
        Rectangle2D dataWindow = this.canvas.getMapRegion().getDataWindow();
        if (dataWindow == null || dataWindow.isEmpty()) {
            return;
        }
        if (this.producer != null) {
            this.producer.abortLoad();
            this.producer.loadData(dataWindow, this.canvas.getMapRegion().getDataWindowSrid());
        }
    }

    @Override
    public ThemeDescriptor getThemeDescriptor() {
        ThemeDescriptor td = null;
        String name = null;
        name = this.getProperty("themeName");
        if (name != null) {
            td = new ThemeDescriptor();
            td.type = 1;
        } else {
            name = this.getProperty("baseMap");
            if (name != null) {
                td = new ThemeDescriptor();
                td.type = 0;
            } else {
                name = this.getProperty("tileName");
                if (name != null) {
                    td = new ThemeDescriptor();
                    td.type = 9;
                    td.cacheMapSource = name;
                }
            }
        }
        if (td != null) {
            td.name = name;
            td.SRID = this.getSRID();
            td.workspaceName = this.getProperty("oracle.mdeditor.session.layer.WorkspaceLayer.workspacename");
        }
        return td;
    }

    public void onDataException(Throwable exception) {
        exception.printStackTrace();
    }

    public void onDataReady() {
        this.img = ((ImageObject)this.producer.getData()[0]).getImage();
        this.lastViewXFM = new AffineTransform(this.canvas.getViewportTransform());
    }

    public void setTileLayerConfig(TileLayerConfig tileConfig) {
        this.tileConfig = tileConfig;
    }

    public TileLayerConfig getTileLayerConfig() {
        return this.tileConfig;
    }
}

