/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.geoobject;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.List;
import oracle.maps.core.Drawable;
import oracle.maps.core.GeoObject;
import oracle.maps.core.Layer;

public class ShapeObject
implements GeoObject {
    Shape shape;
    String key;
    Layer owner;

    public ShapeObject(Shape shp, Object key, Layer layer) {
        this.shape = shp;
        this.key = (String)key;
        this.owner = layer;
    }

    public ShapeObject clone() {
        try {
            return (ShapeObject)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean isSubElementOf(GeoObject obj) {
        return false;
    }

    @Override
    public List<GeoObject> substract(List<? extends GeoObject> obj) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public Layer getLayer() {
        return this.owner;
    }

    public Shape getShape() {
        return this.shape;
    }

    public Shape setShape(Shape value) {
        Shape old = this.shape;
        this.shape = value;
        return old;
    }

    @Override
    public Object setKey(Object key) {
        String old = this.key;
        this.key = (String)key;
        return old;
    }

    @Override
    public void setLayer(Layer layer) {
        this.owner = layer;
    }

    @Override
    public Drawable getDrawable(AffineTransform viewportTransform) {
        Shape shp = viewportTransform != null ? viewportTransform.createTransformedShape(this.shape) : this.shape;
        return new Drawable(shp, 2);
    }

    @Override
    public Rectangle2D getMBR() {
        return this.shape != null ? this.shape.getBounds2D() : null;
    }
}

