/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.geoobject;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import oracle.maps.core.Drawable;
import oracle.maps.core.GeoObject;
import oracle.maps.geoobject.AbstractFeature;
import oracle.spatial.geometry.JGeometry;

public class GeometryFeature
extends AbstractFeature {
    public JGeometry getSpatialAttribute() {
        return (JGeometry)this.spatialAttr;
    }

    @Override
    public void setSpatialAttribute(Object spatialAttr) {
        this.spatialAttr = (JGeometry)spatialAttr;
    }

    @Override
    public Rectangle2D getMBR() {
        if (this.spatialAttr == null) {
            return null;
        }
        double[] mbr = this.getSpatialAttribute().getMBR();
        if (mbr == null) {
            return null;
        }
        Rectangle2D.Double out = new Rectangle2D.Double(mbr[0], mbr[1], mbr[2] - mbr[0], mbr[3] - mbr[1]);
        return out;
    }

    @Override
    public int getSpatialDimension() {
        if (this.spatialAttr == null) {
            return -1;
        }
        return this.getSpatialAttribute().getDimensions();
    }

    public JGeometry getSpatialAttributeClone() {
        return (JGeometry)this.getSpatialAttribute().clone();
    }

    @Override
    public Point2D[] getSpatialJavaPoints() {
        if (this.spatialAttr == null) {
            return null;
        }
        return this.getSpatialAttribute().getJavaPoints();
    }

    @Override
    public Drawable getDrawable(AffineTransform viewportTransform) {
        return Drawable.createDrawable(this.getSpatialAttribute(), viewportTransform);
    }

    @Override
    public boolean isSubElementOf(GeoObject obj) {
        return false;
    }

    @Override
    public List<GeoObject> substract(List<? extends GeoObject> obj) {
        throw new UnsupportedOperationException();
    }
}

