/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.geoobject;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.maps.core.GeoObject;
import oracle.maps.core.Layer;
import oracle.mapviewer.share.Field;
import oracle.spatial.edit.layer.AbstractDataSetLayer;
import oracle.spatial.edit.layer.TopologyPrimitiveLayer;
import oracle.spatial.edit.model.AbstractDataSet;

public abstract class AbstractFeature
implements GeoObject {
    protected HashMap<String, Field> attributes = new HashMap();
    protected Layer layer;
    protected Object spatialAttr;

    public AbstractFeature clone() {
        try {
            return (AbstractFeature)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public AbstractFeature deepClone() {
        AbstractFeature obj = this.clone();
        if (obj != null) {
            obj.spatialAttr = this.getSpatialAttributeClone();
            obj.attributes = new HashMap();
            for (Map.Entry<String, Field> entry : this.attributes.entrySet()) {
                obj.attributes.put(entry.getKey() + "", (Field)entry.getValue().clone());
            }
        }
        return obj;
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        AbstractFeature other = (AbstractFeature)obj;
        if (!this.layer.equals(other.layer)) {
            return false;
        }
        if (!this.attributes.equals(other.attributes)) {
            return false;
        }
        return this.spatialAttr.equals(other.spatialAttr);
    }

    public Field getAttribute(String attrName) {
        if (attrName == null) {
            return null;
        }
        return this.attributes.get(attrName.toUpperCase());
    }

    public Set<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    public boolean setAttribute(String attrName, Field value) {
        if (attrName == null) {
            return false;
        }
        if (value == null) {
            return this.removeAttribute(attrName);
        }
        value.setName(attrName);
        this.attributes.put(attrName.toUpperCase(), value);
        return true;
    }

    public boolean removeAttribute(String attrName) {
        if (attrName == null) {
            return false;
        }
        attrName = attrName.toUpperCase();
        this.attributes.remove(attrName);
        return true;
    }

    @Override
    public Object getKey() {
        if (this.layer == null) {
            return null;
        }
        if (this.layer instanceof TopologyPrimitiveLayer) {
            int type = ((TopologyPrimitiveLayer)this.layer).getPrimitiveType();
            if (type == 0) {
                return null;
            }
            Field keyField = null;
            if (type == TopologyPrimitiveLayer.NODE_TYPE) {
                keyField = this.getAttribute("NODE_ID");
            } else if (type == TopologyPrimitiveLayer.EDGE_TYPE) {
                keyField = this.getAttribute("EDGE_ID");
            } else if (type == TopologyPrimitiveLayer.FACE_TYPE) {
                keyField = this.getAttribute("FACE_ID");
            }
            if (keyField != null) {
                return keyField.getValue();
            }
        } else {
            String keyColumn = this.layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keyColumn");
            Field keyField = this.getAttribute(keyColumn);
            if (keyField != null) {
                return keyField.getValue();
            }
        }
        return null;
    }

    @Override
    public Object setKey(Object key) {
        Object old = this.getKey();
        if (this.layer instanceof AbstractDataSetLayer) {
            String keyColumn = this.layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keyColumn");
            if (key == null) {
                this.removeAttribute(keyColumn);
            } else {
                AbstractDataSet dset = ((AbstractDataSetLayer)this.layer).getDataSet();
                String keyType = dset.getAttributeJavaType(keyColumn);
                this.setAttribute(keyColumn, Field.createField((String)key.toString(), (String)keyType));
            }
        }
        return old;
    }

    public Field[] getAttributes() {
        if (this.attributes.isEmpty()) {
            return null;
        }
        return this.attributes.values().toArray(new Field[this.attributes.size()]);
    }

    public Field[] getAttributes(String[] names) {
        if (names == null || names.length == 0) {
            return null;
        }
        Field[] fields = new Field[names.length];
        for (int i = 0; i < names.length; ++i) {
            fields[i] = this.getAttribute(names[i]);
        }
        return fields;
    }

    public void setAttributes(Field[] fields) {
        if (fields == null || fields.length == 0) {
            return;
        }
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i] == null) continue;
            this.attributes.put(fields[i].getName().toUpperCase(), fields[i]);
        }
    }

    @Override
    public Layer getLayer() {
        return this.layer;
    }

    @Override
    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    public Object getSpatialAttribute() {
        return this.spatialAttr;
    }

    public void setSpatialAttribute(Object spatialAttr) {
        this.spatialAttr = spatialAttr;
    }

    public abstract Object getSpatialAttributeClone();

    @Override
    public abstract Rectangle2D getMBR();

    public abstract int getSpatialDimension();

    public abstract Point2D[] getSpatialJavaPoints();
}

