/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.cs;

import java.awt.geom.Point2D;
import oracle.maps.cs.CSUtils;

public class CS8307_54004 {
    static final double[] mercParams = new double[]{0.0, 0.0, 1.0, 0.0, 0.0};
    static final double[] geodParams = new double[]{6378137.0, 298.257223563};
    static final double mdFE = mercParams[3];
    static final double mdFN = mercParams[4];
    static final double k0 = mercParams[2];
    static final double lon0 = mercParams[1];
    static final double a = geodParams[0];
    static final double f = 1.0 / geodParams[1];
    static final double e = Math.sqrt(2.0 * f - f * f);
    static final double pow4 = Math.pow(e, 4.0);
    static final double pow6 = Math.pow(e, 6.0);
    static final double pow8 = Math.pow(e, 8.0);

    public static boolean transform(double[] pointsIn, int dim, int[] sridFromTo, double[] pointsOut) {
        int from = sridFromTo[0];
        int to = sridFromTo[1];
        if (from == 54004 && to == 8307) {
            CS8307_54004.mercatorToGeodetic(pointsIn, dim, pointsOut);
            return true;
        }
        if (from == 8307 && to == 54004) {
            CS8307_54004.geodeticToMercator(pointsIn, dim, pointsOut);
            return true;
        }
        return false;
    }

    static void geodeticToMercator(double[] pointsIn, int dim, double[] pointsOut) {
        if (pointsOut == null) {
            pointsOut = pointsIn;
        }
        Point2D.Double llPoint = new Point2D.Double(0.0, 0.0);
        Point2D.Double radians = new Point2D.Double();
        for (int i = 0; i < pointsIn.length / dim; ++i) {
            int idx = i * dim;
            double lon = pointsIn[idx];
            double lat = pointsIn[idx + 1];
            ((Point2D)llPoint).setLocation(lon, lat);
            CSUtils.getRadiansFromLatLon(llPoint, radians);
            lon = ((Point2D)radians).getX();
            lat = ((Point2D)radians).getY();
            double rx = mdFE + a * k0 * (lon - lon0);
            double sin = Math.sin(lat);
            double tan = Math.tan(0.7853981633974483 + lat / 2.0);
            double powParam1 = (1.0 - e * sin) / (1.0 + e * sin);
            double powParam2 = e / 2.0;
            double pow = Math.pow(powParam1, powParam2);
            double ry = mdFN + a * k0 * Math.log(tan * pow);
            pointsOut[idx] = rx;
            pointsOut[idx + 1] = ry;
        }
    }

    static void mercatorToGeodetic(double[] pointsIn, int dim, double[] pointsOut) {
        if (pointsOut == null) {
            pointsOut = pointsIn;
        }
        Point2D.Double llPoint = new Point2D.Double();
        Point2D.Double radians = new Point2D.Double();
        for (int i = 0; i < pointsIn.length / dim; ++i) {
            int idx = i * dim;
            double N = pointsIn[idx + 1];
            double E = pointsIn[idx];
            double B = Math.E;
            double t = Math.pow(B, (mdFN - N) / (a * k0));
            double chi = 1.5707963267948966 - 2.0 * Math.atan2(t, 1.0);
            double p1 = e * e / 2.0;
            double p2 = 5.0 * pow4 / 24.0;
            double p3 = pow6 / 12.0;
            double p4 = 13.0 * pow8 / 360.0;
            double p5 = Math.sin(2.0 * chi);
            double p6 = 7.0 * pow4 / 48.0;
            double p7 = 29.0 * pow6 / 240.0;
            double p8 = 811.0 * pow8 / 11520.0;
            double p9 = Math.sin(2.0 * chi);
            double p10 = 7.0 * pow6 / 120.0;
            double p11 = 81.0 * pow8 / 1120.0;
            double p12 = Math.sin(6.0 * chi);
            double p13 = 4279.0 * pow8 / 161280.0;
            double p14 = Math.sin(8.0 * chi);
            double lat = chi + (p1 + p2 + p3 + p4) * p5 + (p6 + p7 + p8) * p9 + (p10 + p11) * p12 + p13 * p14;
            double lon = (E - mdFE) / (a * k0) + lon0;
            ((Point2D)radians).setLocation(lon, lat);
            CSUtils.getLatLonFromRadians(radians, llPoint);
            pointsOut[idx] = ((Point2D)llPoint).getX();
            pointsOut[idx + 1] = ((Point2D)llPoint).getY();
        }
    }
}

