/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.postgresql;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PostgreSQLOfflineUtils {
    private static String m_encoding = null;

    private PostgreSQLOfflineUtils() {
    }

    public static ArrayList<String> getViews(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            FileReader fileReader = new FileReader(new File(string));
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string2 = "";
            String string3 = bufferedReader.readLine();
            while ((string2 = string3) != null) {
                if (string2.startsWith("TABLE_SCHEMA")) {
                    String string4 = "";
                    while ((string4 = bufferedReader.readLine()) != null) {
                        int n = string4.indexOf("/* ALGORITHM=UNDEFINED */");
                        if (n == -1) continue;
                        StringTokenizer stringTokenizer = new StringTokenizer(string4, "\t");
                        while (stringTokenizer.hasMoreElements()) {
                            arrayList.add(stringTokenizer.nextToken());
                        }
                    }
                }
                string3 = bufferedReader.readLine();
            }
            fileReader.close();
        }
        catch (Exception exception) {
            Logger.getLogger(PostgreSQLOfflineUtils.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return arrayList;
    }

    public static HashMap<String, String> getRoutines(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            String string2 = PostgreSQLOfflineUtils.getEncoding();
            InputStreamReader inputStreamReader = null;
            inputStreamReader = string2 == null ? new InputStreamReader(new FileInputStream(new File(string))) : new InputStreamReader((InputStream)new FileInputStream(new File(string)), string2);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string3 = "";
            String string4 = bufferedReader.readLine();
            while ((string3 = string4) != null) {
                if (string3.startsWith("SCHEMA")) {
                    bufferedReader.readLine();
                    String string5 = bufferedReader.readLine();
                    int n = string5.indexOf("CREATE DEFINER");
                    if (n != -1) {
                        StringBuffer stringBuffer = new StringBuffer(string5.substring(n, string5.length()));
                        if (string5.endsWith("\\nEND")) {
                            hashMap.put(string3, stringBuffer.toString());
                        } else {
                            PostgreSQLOfflineUtils.getStoredProcName(bufferedReader, stringBuffer);
                            hashMap.put(string3, stringBuffer.toString());
                        }
                    }
                }
                string4 = bufferedReader.readLine();
            }
            inputStreamReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger(PostgreSQLOfflineUtils.class.getClass().getName()).log(Level.WARNING, "File Not Found :" + fileNotFoundException.getMessage(), fileNotFoundException);
        }
        catch (IOException iOException) {
            Logger.getLogger(PostgreSQLOfflineUtils.class.getClass().getName()).log(Level.WARNING, "Cannot open file :" + iOException.getMessage(), iOException);
        }
        return hashMap;
    }

    private static void getStoredProcName(BufferedReader bufferedReader, StringBuffer stringBuffer) {
        try {
            String string = "";
            string = bufferedReader.readLine();
            if (string != null) {
                if (string.startsWith("\\nEND")) {
                    stringBuffer.append(string);
                    return;
                }
                stringBuffer.append(string);
                PostgreSQLOfflineUtils.getStoredProcName(bufferedReader, stringBuffer);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(PostgreSQLOfflineUtils.class.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    public static HashMap<String, Integer> getMaxOfColumn(String string) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        try {
            String string2 = PostgreSQLOfflineUtils.getEncoding();
            InputStreamReader inputStreamReader = null;
            inputStreamReader = string2 == null ? new InputStreamReader(new FileInputStream(new File(string))) : new InputStreamReader((InputStream)new FileInputStream(new File(string)), string2);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string3 = "";
            String string4 = bufferedReader.readLine();
            while ((string3 = string4) != null) {
                if (string3.startsWith("`")) {
                    Object object = bufferedReader.readLine();
                    if (object == null) {
                        bufferedReader.readLine();
                    }
                    if (object != null && ((String)object).startsWith("MAX")) {
                        String string5 = bufferedReader.readLine();
                        try {
                            int n = 0;
                            n = string5.equals("NULL") ? 0 : new Integer(string5);
                            object = ((String)object).substring(((String)object).indexOf("(") + 1, ((String)object).indexOf(")"));
                            object = ((String)object).startsWith("`") && ((String)object).endsWith("`") ? string3.trim() + "." + (String)object : string3.trim() + ".`" + (String)object + "`";
                            hashMap.put((String)object, n);
                        }
                        catch (NumberFormatException numberFormatException) {
                            string4 = string5;
                        }
                        continue;
                    }
                    string4 = object;
                    continue;
                }
                string4 = bufferedReader.readLine();
            }
            inputStreamReader.close();
        }
        catch (Exception exception) {
            Logger.getLogger(PostgreSQLOfflineUtils.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return hashMap;
    }

    public static HashMap<String, String> getConstraints(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            String string2 = PostgreSQLOfflineUtils.getEncoding();
            InputStreamReader inputStreamReader = null;
            inputStreamReader = string2 == null ? new InputStreamReader(new FileInputStream(new File(string))) : new InputStreamReader((InputStream)new FileInputStream(new File(string)), string2);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string3 = "";
            while ((string3 = bufferedReader.readLine()) != null) {
                String string4;
                int n;
                String string5;
                if (!string3.startsWith("`") || !(string5 = bufferedReader.readLine()).startsWith("Table") || (n = (string4 = bufferedReader.readLine()).indexOf("CREATE TABLE")) == -1) continue;
                String string6 = string4.substring(n, string4.length());
                string6 = string6.replace("\\n", "\n");
                hashMap.put(string3, string6);
            }
            inputStreamReader.close();
        }
        catch (Exception exception) {
            Logger.getLogger(PostgreSQLOfflineUtils.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return hashMap;
    }

    public static HashMap<String, ArrayList<String>> getSchemaAndTables(String string) {
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        try {
            String string2 = PostgreSQLOfflineUtils.getEncoding();
            InputStreamReader inputStreamReader = null;
            inputStreamReader = string2 == null ? new InputStreamReader(new FileInputStream(new File(string))) : new InputStreamReader((InputStream)new FileInputStream(new File(string)), string2);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string3 = "";
            ArrayList<String> arrayList = new ArrayList<String>();
            String string4 = "";
            boolean bl = false;
            while (bl || (string3 = bufferedReader.readLine()) != null) {
                bl = false;
                if ((string3 = string3.trim()).startsWith("`")) {
                    string4 = string3.substring(1, string3.length() - 1);
                    String string5 = bufferedReader.readLine();
                    if (string5.startsWith("Tables_in_")) {
                        String string6 = bufferedReader.readLine();
                        if (!hashMap.containsKey(string4)) {
                            arrayList = new ArrayList();
                        }
                        arrayList.add(string6);
                        hashMap.put(string4, arrayList);
                        continue;
                    }
                    if (!hashMap.containsKey(string4)) {
                        arrayList = new ArrayList();
                    }
                    hashMap.put(string4, arrayList);
                    bl = true;
                    string3 = string5;
                    continue;
                }
                arrayList.add(string3);
                hashMap.put(string4, arrayList);
            }
            inputStreamReader.close();
        }
        catch (Exception exception) {
            Logger.getLogger(PostgreSQLOfflineUtils.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return hashMap;
    }

    public static HashMap<String, ArrayList<String>> getColumns(String string) {
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        try {
            String string2 = PostgreSQLOfflineUtils.getEncoding();
            InputStreamReader inputStreamReader = null;
            inputStreamReader = string2 == null ? new InputStreamReader(new FileInputStream(new File(string))) : new InputStreamReader((InputStream)new FileInputStream(new File(string)), string2);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string3 = "";
            ArrayList<String> arrayList = new ArrayList<String>();
            String string4 = "";
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.startsWith("`")) {
                    string4 = string3.replace("`", "");
                    String string5 = bufferedReader.readLine();
                    if (!string5.startsWith("Field")) continue;
                    String string6 = bufferedReader.readLine();
                    if (!hashMap.containsKey(string4)) {
                        arrayList = new ArrayList();
                    }
                    string6 = string6.trim();
                    arrayList.add(PostgreSQLOfflineUtils.getColumnTokenized(string6));
                    hashMap.put(string4, arrayList);
                    continue;
                }
                string3 = string3.trim();
                arrayList.add(PostgreSQLOfflineUtils.getColumnTokenized(string3));
                hashMap.put(string4, arrayList);
            }
            inputStreamReader.close();
        }
        catch (Exception exception) {
            Logger.getLogger(PostgreSQLOfflineUtils.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return hashMap;
    }

    private static String getColumnTokenized(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            stringBuffer.append(string2);
            stringBuffer.append(";");
        }
        return stringBuffer.toString().substring(0, stringBuffer.length() - 1);
    }

    public static HashMap<String, ArrayList<String>> getIndexes(String string) {
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        try {
            String string2 = PostgreSQLOfflineUtils.getEncoding();
            InputStreamReader inputStreamReader = null;
            inputStreamReader = string2 == null ? new InputStreamReader(new FileInputStream(new File(string))) : new InputStreamReader((InputStream)new FileInputStream(new File(string)), string2);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string3 = "";
            ArrayList<String> arrayList = new ArrayList<String>();
            String string4 = "";
            String string5 = bufferedReader.readLine();
            while ((string3 = string5) != null) {
                if (string3.startsWith("`")) {
                    string4 = string3.replace("`", "");
                    String string6 = bufferedReader.readLine();
                    if (string6.startsWith("Table")) {
                        String string7 = bufferedReader.readLine();
                        if (!hashMap.containsKey(string4)) {
                            arrayList = new ArrayList();
                        }
                        string7 = string7.trim();
                        arrayList.add(PostgreSQLOfflineUtils.getColumnTokenized(string7));
                        hashMap.put(string4, arrayList);
                        string5 = bufferedReader.readLine();
                        continue;
                    }
                    if (!string6.startsWith("`")) continue;
                    string5 = string6;
                    continue;
                }
                string3 = string3.trim();
                arrayList.add(PostgreSQLOfflineUtils.getColumnTokenized(string3));
                hashMap.put(string4, arrayList);
                string5 = bufferedReader.readLine();
            }
            inputStreamReader.close();
        }
        catch (Exception exception) {
            Logger.getLogger(PostgreSQLOfflineUtils.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return hashMap;
    }

    public static int getMinorVersion(String string) {
        int n = 0;
        try {
            String string2 = PostgreSQLOfflineUtils.getEncoding();
            InputStreamReader inputStreamReader = null;
            inputStreamReader = string2 == null ? new InputStreamReader(new FileInputStream(new File(string))) : new InputStreamReader((InputStream)new FileInputStream(new File(string)), string2);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string3 = "";
            while ((string3 = bufferedReader.readLine()) != null) {
                if (!string3.toLowerCase().startsWith("version")) continue;
                String string4 = bufferedReader.readLine();
                String string5 = string4.substring(string4.indexOf(".") + 1, string4.lastIndexOf("."));
                n = new Integer(string5);
            }
            inputStreamReader.close();
        }
        catch (Exception exception) {
            Logger.getLogger(PostgreSQLOfflineUtils.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return n;
    }

    public static void setEncoding(String string) {
        m_encoding = string;
    }

    public static String getEncoding() {
        return m_encoding;
    }
}

